/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.hibernate.crud;

import myencyclopedia.model.Entity;
import myencyclopedia.model.Relation;
import myencyclopedia.model.RelationCollection;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityUtil {
    static final Logger logger = LoggerFactory.getLogger(EntityUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long create(Session s, Entity entity) {
        s.beginTransaction();
        try {
            s.save((Object)entity);
            s.getTransaction().commit();
            Long l = entity.getId();
            return l;
        }
        catch (Exception ex) {
            s.getTransaction().rollback();
            logger.error("", (Throwable)ex);
            Long l = null;
            return l;
        }
        finally {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createEntityWithRelated(Session s, Entity entity) {
        s.beginTransaction();
        try {
            Relation[] relations;
            for (Relation r : relations = entity.getEffectiveRelations()) {
                if (r instanceof RelationCollection) {
                    RelationCollection rc = (RelationCollection)r;
                    for (Entity en : rc.getTarget()) {
                        s.save((Object)en);
                    }
                    continue;
                }
                if (!(r instanceof Relation)) continue;
                Entity en = (Entity)r.getTarget();
                s.save((Object)en);
            }
            s.save((Object)entity);
            s.getTransaction().commit();
        }
        catch (Exception ex) {
            s.getTransaction().rollback();
            logger.error("", (Throwable)ex);
        }
        finally {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteEntityWithRelated(Session s, Entity entity) {
        s.beginTransaction();
        try {
            Relation[] relations;
            s.update((Object)entity);
            for (Relation r : relations = entity.getEffectiveRelations()) {
                if (r instanceof RelationCollection) {
                    RelationCollection rc = (RelationCollection)r;
                    for (Entity en : rc.getTarget()) {
                        s.update((Object)en);
                        s.delete((Object)en);
                    }
                    continue;
                }
                if (!(r instanceof Relation)) continue;
                Entity en = (Entity)r.getTarget();
                s.update((Object)en);
                s.delete((Object)en);
            }
            s.delete((Object)entity);
            s.getTransaction().commit();
        }
        catch (Exception ex) {
            s.getTransaction().rollback();
            logger.error("", (Throwable)ex);
        }
        finally {
            s.close();
        }
    }

    public static void delete(Session s, Entity entity) {
        s.beginTransaction();
        try {
            s.update((Object)entity);
            s.delete((Object)entity);
            s.getTransaction().commit();
        }
        catch (Exception ex) {
            s.getTransaction().rollback();
            logger.error("", (Throwable)ex);
        }
        finally {
            s.close();
        }
    }

    public static void deleteNoclose(Session s, Entity entity) {
        s.beginTransaction();
        try {
            s.update((Object)entity);
            s.delete((Object)entity);
            s.getTransaction().commit();
        }
        catch (Exception ex) {
            s.getTransaction().rollback();
            logger.error("", (Throwable)ex);
        }
    }

    public static void update(Session s, Entity entity) {
        s.beginTransaction();
        try {
            s.update((Object)entity);
            s.getTransaction().commit();
        }
        catch (Exception ex) {
            s.getTransaction().rollback();
            logger.error("", (Throwable)ex);
        }
        finally {
            s.close();
        }
    }
}

