/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.hibernate.common;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import myencyclopedia.hibernate.common.OperationException;
import myencyclopedia.model.Entity;
import myencyclopedia.model.Relation;
import myencyclopedia.model.hbn.RelationField;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ParentChildrenManager<T extends Entity> {
    protected List<T> listAll;
    protected List<T> listTop;
    protected Map<T, List<T>> mapChildren;
    protected String parentRelationName;
    protected String parentFieldName;
    protected Class cls;
    protected T[] EMPTY_ARRAY;
    protected SessionFactory sf;
    protected int version = 0;
    private static final Logger logger = LoggerFactory.getLogger(ParentChildrenManager.class);

    protected ParentChildrenManager(Class<? extends Entity> cls, String parentRelationName, SessionFactory factory) {
        this.sf = factory;
        this.EMPTY_ARRAY = (Entity[])Array.newInstance(cls, 0);
        this.cls = cls;
        this.parentRelationName = parentRelationName;
        for (Field f : cls.getDeclaredFields()) {
            RelationField field = f.getDeclaredAnnotation(RelationField.class);
            if (field == null || !parentRelationName.equals(field.name())) continue;
            this.parentFieldName = f.getName();
            break;
        }
    }

    public int getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reload() {
        try (Session s = this.sf.openSession();){
            List list = s.createCriteria(this.cls).list();
            this.listAll = new LinkedList<T>();
            this.listTop = new LinkedList<T>();
            this.mapChildren = new HashMap<T, List<T>>();
            for (Entity entity : list) {
                this.listAll.add(entity);
                Relation parentR = entity.getRelation(this.parentRelationName);
                if (parentR.getTarget() == null) {
                    this.listTop.add(entity);
                    continue;
                }
                Entity parent = (Entity)parentR.getTarget();
                List<T> children = this.mapChildren.get(parent);
                if (children == null) {
                    children = new LinkedList<T>();
                    this.mapChildren.put(parent, children);
                }
                children.add(entity);
            }
        }
    }

    public synchronized int getSize() {
        return this.listAll.size();
    }

    public synchronized T[] getAll() {
        return (Entity[])this.listAll.toArray(this.EMPTY_ARRAY);
    }

    public synchronized T[] getTop() {
        return (Entity[])this.listTop.toArray(this.EMPTY_ARRAY);
    }

    public T[] getChildren(T parent) {
        List<T> children = this.mapChildren.get(parent);
        if (children == null) {
            return this.EMPTY_ARRAY;
        }
        return (Entity[])children.toArray(this.EMPTY_ARRAY);
    }

    protected void addChild(T parent, T child) {
        List<T> children = this.mapChildren.get(parent);
        if (children == null) {
            children = new LinkedList<T>();
            this.mapChildren.put(parent, children);
        }
        children.add(child);
    }

    protected void deleteChild(T parent, T child) {
        List<T> children = this.mapChildren.get(parent);
        if (children != null) {
            children.remove(child);
        }
    }

    public List<T> loadTopList(Session session) {
        Criteria criteria = session.createCriteria(this.cls);
        criteria.add(Restrictions.isNull((String)this.parentFieldName));
        List parentCategories = criteria.list();
        return parentCategories;
    }

    public List<T> loadChildrenFor(Session session, Entity parent) {
        List<T> subfiles = null;
        if (parent != null) {
            String queryStr = "select entity from " + this.cls.getSimpleName() + " as entity\n" + "  left join entity." + this.parentFieldName + " as r\n" + "left join r.targetEntity as p\n" + "where p = :parent";
            Query query = session.createQuery(queryStr);
            query.setParameter("parent", (Object)parent);
            List result = query.list();
            return result;
        }
        subfiles = this.loadTopList(session);
        return subfiles;
    }

    protected void preDelete(T t) throws OperationException {
    }

    protected T postDelete(T t) {
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(T element) throws OperationException {
        if (element == null) {
            throw new OperationException("Element is null in delete()");
        }
        if (this.getChildren((Entity)element).length != 0) {
            throw new OperationException("Element contains subs");
        }
        this.preDelete(element);
        Entity parentElement = (Entity)element.getRelation(this.parentRelationName).getTarget();
        if (parentElement == null) {
            this.listTop.remove(element);
        } else {
            this.deleteChild(parentElement, element);
        }
        this.listAll.remove(element);
        Session s = this.sf.openSession();
        s.beginTransaction();
        try {
            s.update(element);
            s.delete(element);
            s.getTransaction().commit();
            ++this.version;
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            s.getTransaction().rollback();
        }
        finally {
            s.close();
        }
        this.postDelete(element);
    }

    protected abstract T preCreate(String var1, T var2) throws OperationException;

    protected void postCreate(T newInstance) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T create(T parentElement, String name) throws OperationException {
        T t = this.preCreate(name, parentElement);
        if (t == null) {
            return null;
        }
        Session s = this.sf.openSession();
        s.beginTransaction();
        if (!this.isValid(parentElement, null, t)) {
            throw new OperationException("Element name " + name + " exists for " + parentElement);
        }
        try {
            if (t == null) {
                T t2 = null;
                return t2;
            }
            if (parentElement != null) {
                t.getRelation(this.parentRelationName).setTarget(parentElement);
            }
            if (parentElement == null) {
                this.listTop.add(t);
            } else {
                this.addChild(parentElement, t);
            }
            this.listAll.add(t);
            s.save(t);
            s.getTransaction().commit();
            ++this.version;
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            s.getTransaction().rollback();
            t = null;
        }
        finally {
            s.close();
        }
        this.postCreate(t);
        return t;
    }

    protected abstract void preRename(T var1, String var2) throws OperationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(T element, String newName) throws OperationException {
        if (element == null) {
            throw new OperationException("Element is null in rename()");
        }
        this.preRename(element, newName);
        if (!this.isValid((Entity)element.getRelation(this.parentRelationName).getTarget(), element, element)) {
            throw new OperationException("Element name " + newName + " exists ");
        }
        Session s = this.sf.openSession();
        s.beginTransaction();
        try {
            s.update(element);
            s.getTransaction().commit();
            ++this.version;
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            s.getTransaction().rollback();
        }
        finally {
            s.close();
        }
    }

    protected void preMove(T t, T newParent) throws OperationException {
    }

    protected T postMove(T t) {
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(T newParent, T element) throws OperationException {
        if (element == null) {
            throw new OperationException("Element is null in move()");
        }
        this.preMove(element, newParent);
        if (!this.isValid(newParent, null, element)) {
            throw new OperationException("Element name exists ");
        }
        Entity oldParent = (Entity)element.getRelation(this.parentRelationName).getTarget();
        if (oldParent == null) {
            this.listTop.remove(element);
        } else {
            this.deleteChild(oldParent, element);
        }
        element.getRelation(this.parentRelationName).setTarget(newParent);
        if (newParent == null) {
            this.listTop.add(element);
        } else {
            this.addChild(newParent, element);
        }
        try (Session s = this.sf.openSession();){
            s.beginTransaction();
            s.update(element);
            s.getTransaction().commit();
            ++this.version;
        }
        this.postMove(element);
    }

    public abstract boolean isValid(T var1, T var2, T var3);
}

