/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.query;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import myencyclopedia.common.utils.CancelFlagHolder;
import myencyclopedia.hibernate.AsyncListReceiver;
import myencyclopedia.logic.mydoc.ConfigMydoc;
import myencyclopedia.logic.mydoc.tag.TagManager;
import myencyclopedia.logic.query.EntityQueryUtil;
import myencyclopedia.logic.query.MECriterion;
import myencyclopedia.logic.query.METagCriterion;
import myencyclopedia.model.Entity;
import myencyclopedia.model.common.entity.Tag;
import myencyclopedia.model.ebook.Ebook;
import myencyclopedia.model.mydoc.Code;
import myencyclopedia.model.mydoc.Doc;
import myencyclopedia.model.mydoc.Note;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.search.FullTextQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MECriteria {
    private static final Logger logger = LoggerFactory.getLogger(MECriteria.class);
    private HashMap<Class<? extends Entity>, List<MECriterion>> map = new HashMap();
    public final AsyncListReceiver receiver;
    private Class<? extends Entity> targetCls;
    private List<Class<? extends Entity>> potentialTargetList;
    private boolean isValid = true;
    public List<METagCriterion> tagList = new LinkedList<METagCriterion>();
    private static final List<MECriterion> EMPTY_LIST = new ArrayList<MECriterion>();
    private String contentQuery;
    public static final String CONTENT = "contents";
    public static final String TYPE = "classtype";
    public static final String ID = "id";
    public static final String MEMBER_TAGS = "tags";
    public static final String MEMBER_FAVOURITE = "is_favourite";
    public static final String MEMBER_EBOOK_DESCRIPTION = "description";
    public static final String MEMBER_NOTE_TITLE = "title";
    public static final String MEMBER_DOC_TITLE = "title";
    public static final String MEMBER_CODE_TITLE = "title";
    public static final String MEMBER_HBCOLLECTION_TARGET = "targetEntity";
    public static final String MEMBER_TAG_NAME = "name";

    public MECriteria(AsyncListReceiver r, Class<? extends Entity> ... allowedClasses) {
        this.receiver = r;
        this.potentialTargetList = new ArrayList<Class<? extends Entity>>();
        for (Class<? extends Entity> cls : allowedClasses) {
            this.potentialTargetList.add(cls);
        }
    }

    public MECriteria dup(AsyncListReceiver r) {
        MECriteria newCriteria = new MECriteria(r, Tag.class);
        newCriteria.contentQuery = this.contentQuery;
        newCriteria.isValid = this.isValid;
        for (METagCriterion mETagCriterion : this.tagList) {
            newCriteria.tagList.add(mETagCriterion);
        }
        for (Map.Entry entry : this.map.entrySet()) {
            newCriteria.map.put((Class<? extends Entity>)entry.getKey(), (List<MECriterion>)entry.getValue());
        }
        return newCriteria;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public Class<? extends Entity> getTargetClass() {
        return this.targetCls;
    }

    public void addDefaultCriteronForAll(String value) throws ParseException {
        if (this.targetCls != null) {
            this.addCriterionList(MECriteria.constructDefault(this.targetCls, value), false);
        } else {
            for (Class<? extends Entity> cls : this.potentialTargetList) {
                this.addCriterionList(MECriteria.constructDefault(cls, value), true);
            }
        }
    }

    public void addContentCriteronForAll(String value) throws ParseException {
        if (this.contentQuery != null) {
            throw new ParseException("Multiple content", 0);
        }
        if (this.targetCls != null) {
            MECriterion c = new MECriterion(this.targetCls, CONTENT, value);
            this.addCriterionList(c, false);
        } else {
            for (Class<? extends Entity> cls : this.potentialTargetList) {
                MECriterion c = new MECriterion(cls, CONTENT, value);
                this.addCriterionList(c, true);
            }
        }
        this.contentQuery = value;
    }

    public void addContentCriteronForAll(Class<? extends Entity> cls, String value) throws ParseException {
        if (this.contentQuery != null) {
            throw new ParseException("Multiple content", 0);
        }
        if (this.targetCls != null && !this.targetCls.equals(cls)) {
            throw new ParseException("Multiple target classes", 0);
        }
        MECriterion c = new MECriterion(cls, CONTENT, value);
        this.addCriterionList(c, false);
        this.contentQuery = value;
    }

    public List<MECriterion> getCriterionList(Class<? extends Entity> cls) {
        List<MECriterion> ret = this.map.get(cls);
        if (ret == null) {
            return EMPTY_LIST;
        }
        return ret;
    }

    public String getContentQuery() {
        return this.contentQuery;
    }

    public void addFavouriteCriterionForAll() {
        for (Class<? extends Entity> cls : this.potentialTargetList) {
            MECriterion c = new MECriterion(cls);
            c.setField(MEMBER_FAVOURITE);
            c.setValue(1);
            try {
                this.addCriterionList(c, true);
            }
            catch (ParseException parseException) {}
        }
    }

    public void addCriterion(Class<? extends Entity> targetClass, String fieldName, String Value) throws ParseException {
        MECriterion criterion = new MECriterion(targetClass);
        criterion.setField(fieldName);
        criterion.setValue(Value);
        this.addCriterionList(criterion, false);
    }

    public void addCriterionList(MECriterion criterion, boolean ignoreClass) throws ParseException {
        List<MECriterion> criterionList;
        Class cls = criterion.getEntityClass();
        if (!ignoreClass && cls != Tag.class) {
            if (this.targetCls != null && this.targetCls != cls) {
                this.isValid = false;
                throw new ParseException("Multiple targets", 0);
            }
            this.targetCls = cls;
            Iterator<Class<? extends Entity>> it = this.map.keySet().iterator();
            while (it.hasNext()) {
                Class<? extends Entity> c = it.next();
                if (c.equals(cls) || c.equals(Tag.class)) continue;
                it.remove();
            }
        }
        if ((criterionList = this.map.get(cls)) == null) {
            criterionList = new ArrayList<MECriterion>();
            this.map.put(cls, criterionList);
        }
        criterionList.add(criterion);
    }

    public void addTagCriterion(Tag tag, boolean recursive) {
        METagCriterion c = new METagCriterion(tag.getId());
        this.tagList.add(c);
        if (recursive) {
            Tag[] children;
            TagManager mgr = TagManager.getInstance();
            for (Tag child : children = (Tag[])mgr.getChildren((Entity)tag)) {
                this.addTagCriterion(child, true);
            }
        }
    }

    public void addNoneTagCriterion() {
        METagCriterion c = new METagCriterion(null);
        this.tagList.add(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCriteria(AsyncListReceiver target, Session s, CancelFlagHolder cancelFlag) {
        this.receiver.beginLoading();
        if (!this.getCriterionList(Tag.class).isEmpty()) {
            TagManager tm = TagManager.getInstance();
            for (Tag tag : (Tag[])tm.getAll()) {
                boolean matched = true;
                for (MECriterion tagC : this.map.get(Tag.class)) {
                    String lowerCaseOfTagC = ((String)tagC.getValue()).toLowerCase();
                    if (tag.getName().toLowerCase().contains(lowerCaseOfTagC)) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                this.tagList.add(new METagCriterion(tag.getId()));
            }
            if (this.tagList.isEmpty()) {
                this.receiver.endLoading();
                return;
            }
        }
        ArrayList<Class<? extends Entity>> targetClsList = new ArrayList<Class<? extends Entity>>();
        if (this.targetCls != null) {
            targetClsList.add(this.targetCls);
        } else {
            targetClsList.addAll(this.potentialTargetList);
        }
        try {
            METagCriterion tc = null;
            int idx = 0;
            if (!this.tagList.isEmpty()) {
                tc = this.tagList.get(0);
            }
            while (true) {
                for (Class clazz : targetClsList) {
                    Criteria cri = EntityQueryUtil.generateCriteria(s, clazz, this.getCriterionList(clazz), tc);
                    List result = new ArrayList();
                    if (this.contentQuery != null && ConfigMydoc.getInstance().getIndexEnabled()) {
                        if (clazz.equals(Code.class)) continue;
                        FullTextQuery q = EntityQueryUtil.wrapCriteria(s, cri, clazz, this.contentQuery);
                        if (q != null) {
                            result = q.list();
                        } else if (cri != null) {
                            result = cri.list();
                        }
                    } else {
                        result = cri.list();
                    }
                    this.receiver.appendList(result);
                    if (!cancelFlag.get()) continue;
                    return;
                }
                if (++idx >= this.tagList.size()) break;
                tc = this.tagList.get(idx);
            }
            this.receiver.endLoading();
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
        finally {
            s.close();
        }
    }

    private static MECriterion constructDefault(Class<? extends Entity> cls, String value) {
        MECriterion c = new MECriterion(cls);
        c.setField(MECriteria.getDefaultFieldFor(cls));
        c.setValue(value);
        return c;
    }

    public static String getDefaultFieldFor(Class<? extends Entity> cls) {
        if (cls == Ebook.class) {
            return MEMBER_EBOOK_DESCRIPTION;
        }
        if (cls == Note.class) {
            return "title";
        }
        if (cls == Doc.class) {
            return "title";
        }
        if (cls == Code.class) {
            return "title";
        }
        if (cls == Tag.class) {
            return MEMBER_TAG_NAME;
        }
        return "";
    }
}

