/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.mydoc.tag;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import myencyclopedia.hibernate.common.OperationException;
import myencyclopedia.hibernate.common.ParentChildrenManager;
import myencyclopedia.logic.query.EntityQueryUtil;
import myencyclopedia.model.Entity;
import myencyclopedia.model.common.entity.Tag;
import myencyclopedia.model.ebook.Discipline;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class TagManager
extends ParentChildrenManager<Tag> {
    private static TagManager theInstance;
    private static final Logger logger;
    private Map<Integer, Tag> mapExtId = new HashMap<Integer, Tag>();
    private static final Tag[] EMPTY_TAGS;
    public static Tag TAG_Ebook;
    public static Tag TAG_PL;
    public static Tag TAG_JAVA;
    public static final int EXT_ID_USER = 500;
    private static Integer nextId;
    private boolean creatingPredefined;
    public static final int ROOT_EBOOK = 1;
    public static final int ROOT_EBOOK_COMPUTER = 2;
    public static final int ROOT_EBOOK_LITERATURE = 3;
    public static final int ROOT_EBOOK_TECH = 4;
    public static final int ROOT_EBOOK_ART = 5;
    public static final int ROOT_EBOOK_SOCIAL = 6;
    public static final int ROOT_EBOOK_NATURE = 7;
    public static final int ROOT_EBOOK_DICT = 8;
    public static final int ROOT_EBOOK_HISTORY = 9;
    public static final int ROOT_EBOOK_PHILOSOPHY = 10;
    public static final int ROOT_PROGRAMMING_LANG = 11;
    public static final int PL_JAVA = 12;
    public static final int PL_C = 13;
    public static final int PL_CPP = 14;
    public static final int PL_CSHARP = 15;
    public static final int PL_OBJC = 16;
    public static final int PL_PYTHON = 17;
    public static final int PL_SHELL = 18;
    public static final int PL_HTML = 19;
    public static final int PL_JAVASCRIPT = 20;
    public static final int PL_SQL = 21;
    public static final int PL_PERL = 22;
    public static final int PL_PHP = 23;
    public static final int PL_RUBY = 24;
    public static final String KEY_ROOT_EBOOK = "ROOT_EBOOK";
    public static final String KEY_ROOT_PROGRAMMING_LANG = "ROOT_PROGRAMMING_LANG";
    private static final ResourceBundle rb;

    private TagManager(SessionFactory sf) {
        super(Tag.class, "parent", sf);
    }

    static void reinit(SessionFactory factory) {
        theInstance = new TagManager(factory);
    }

    public static void init(SessionFactory factory) {
        if (theInstance != null) {
            throw new RuntimeException("TagManager.init() has been called");
        }
        theInstance = new TagManager(factory);
    }

    public static synchronized TagManager getInstance() {
        if (theInstance == null) {
            throw new RuntimeException("TagManager.init() should be called first");
        }
        return theInstance;
    }

    public static String getPredefinedLocalizedName(String key) {
        return rb.getString(key);
    }

    public synchronized void reload() {
        super.reload();
        for (Entity entity : this.listAll) {
            Tag tag = (Tag)entity;
            Integer extid = (Integer)tag.getPropertyValue("extid");
            this.mapExtId.put(extid, tag);
            if (extid < nextId) continue;
            nextId = extid + 1;
        }
        Iterator it = this.listTop.iterator();
        TAG_Ebook = this.getTagFromExtId(1);
        TAG_PL = this.getTagFromExtId(11);
        TAG_JAVA = this.getTagFromExtId(12);
        while (it.hasNext()) {
            Tag t = (Tag)it.next();
            if (t.getId().equals(TAG_Ebook.getId())) {
                it.remove();
                continue;
            }
            if (!t.getId().equals(TAG_PL.getId())) continue;
            it.remove();
        }
        if (TAG_PL != null) {
            this.listTop.add(0, TAG_PL);
        }
        if (TAG_Ebook != null) {
            this.listTop.add(0, TAG_Ebook);
        }
    }

    private boolean isTagInList(Tag tag) {
        for (Entity entity : this.listAll) {
            Tag oneTag = (Tag)entity;
            if (!oneTag.getId().equals(tag.getId())) continue;
            return true;
        }
        return false;
    }

    public Discipline getDiscipline(Tag t) {
        switch (t.getExtID()) {
            case 2: {
                return Discipline.COMPUTER;
            }
            case 3: {
                return Discipline.LITERATURE;
            }
            case 4: {
                return Discipline.TECHNOLOGY;
            }
            case 5: {
                return Discipline.ART;
            }
            case 6: {
                return Discipline.SOCIAL;
            }
            case 7: {
                return Discipline.NATURE;
            }
            case 8: {
                return Discipline.MISC;
            }
            case 9: {
                return Discipline.HISTORY;
            }
            case 10: {
                return Discipline.PHILOSIPHY;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag createPreDefined(Tag parent, String name, int extId) {
        try {
            this.creatingPredefined = true;
            Tag t = (Tag)this.create((Entity)parent, name);
            t.setIsPredefined(Boolean.TRUE);
            t.setPropertyValue("extid", (Object)extId);
            Session s = this.sf.openSession();
            s.beginTransaction();
            try {
                s.update((Object)t);
                s.getTransaction().commit();
            }
            finally {
                this.creatingPredefined = false;
                s.close();
            }
            return t;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            System.exit(-1);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFullName(Tag tag) {
        String ret = tag.getName();
        try (Session s = this.sf.openSession();){
            s.update((Object)tag);
            for (tag = tag.getParentTag(); tag != null; tag = tag.getParentTag()) {
                ret = tag.getName() + "/" + ret;
            }
        }
        return ret;
    }

    public synchronized int getSize() {
        return this.listAll.size();
    }

    public synchronized boolean isTagUsed(Tag tag) {
        return true;
    }

    public synchronized Tag getTagFromExtId(Integer id) {
        return this.mapExtId.get(id);
    }

    protected Tag postDelete(Tag t) {
        this.mapExtId.remove(t.getPropertyValue("extid"));
        return t;
    }

    protected Tag preCreate(String name, Tag parent) {
        Tag newTag = new Tag();
        newTag.setName(name);
        newTag.setParentTag(parent);
        if (!this.creatingPredefined) {
            newTag.setPropertyValue("extid", (Object)nextId);
            Integer n = nextId;
            Integer n2 = nextId = Integer.valueOf(nextId + 1);
        }
        return newTag;
    }

    protected void postCreate(Tag newInstance) {
        this.mapExtId.put(newInstance.getExtID(), newInstance);
    }

    protected void preRename(Tag t, String name) throws OperationException {
        t.setName(name);
    }

    protected Tag postMove(Tag t) {
        return t;
    }

    public boolean isValid(Tag parentElement, Tag currentElement, Tag newElement) {
        String name = newElement.getName();
        Tag[] childTags = parentElement == null ? this.listTop.toArray(new Tag[0]) : (Tag[])this.getChildren((Entity)parentElement);
        for (Tag child : childTags) {
            if (currentElement != null && currentElement.getId().equals(child.getId()) || !child.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    protected void preDelete(Tag t) throws OperationException {
        if (Boolean.TRUE.equals(t.getIsPredefined())) {
            throw new OperationException("Cannot delete pre-defined tag");
        }
        Class<? extends Entity> cls = EntityQueryUtil.hasTaggedEntity(t, this.sf.openSession());
        if (cls != null) {
            throw new OperationException("At least one" + cls.getSimpleName() + " has the tag [" + t.toString() + "]");
        }
    }

    static {
        logger = Logger.getLogger(TagManager.class);
        EMPTY_TAGS = new Tag[0];
        nextId = 500;
        rb = ResourceBundle.getBundle("properties.logic-mydoc-tags", Locale.getDefault());
    }
}

