/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.mydoc;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import myencyclopedia.logic.mydoc.ConfigMydoc;
import myencyclopedia.logic.mydoc.DayContentChangedEvent;
import myencyclopedia.logic.mydoc.DayContentChangedListener;
import myencyclopedia.model.Entity;
import myencyclopedia.model.RelationCollection;
import myencyclopedia.model.common.DateMarker;
import myencyclopedia.model.common.DateMarkerUtils;
import myencyclopedia.model.common.entity.Tag;
import myencyclopedia.model.mydoc.Note;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoteManager {
    private static SessionFactory sf;
    private static NoteManager theInstance;
    private static List<DayContentChangedListener> dayContentChangedListeners;
    private static Path pathTrash;
    private static Path pathNote;
    private ConfigMydoc config = ConfigMydoc.getInstance();
    private static final Logger logger;

    private NoteManager() {
        pathNote = this.config.getAsPath("/myencyclopedia/mydoc/note/path");
        pathTrash = this.config.getAsPath("/myencyclopedia/mydoc/trash/path");
    }

    public static NoteManager getInstance(SessionFactory factory) {
        sf = factory;
        return theInstance;
    }

    public static NoteManager getInstance() {
        return theInstance;
    }

    public Path getPath(Note note) {
        String filePath = note.getFilePath();
        Path path = Paths.get(NoteManager.getInstance().getNoteFolder().toString(), filePath);
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file, long startOffset, long endOffset) throws IOException {
        try (RandomAccessFile randomFile = new RandomAccessFile(file, "r");){
            String s;
            randomFile.seek(startOffset);
            int length = (int)(endOffset - startOffset + 1L);
            byte[] bytes = new byte[length];
            randomFile.readFully(bytes);
            String encoding = "utf-8";
            String string = s = new String(bytes, encoding);
            return string;
        }
    }

    public Path getNoteFolder() {
        return pathNote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Note createNote(Tag tag) throws IOException {
        Calendar calendar = Calendar.getInstance();
        Date candidateTime = calendar.getTime();
        calendar.setTime(candidateTime);
        Path newFile = null;
        while (true) {
            Path parentFolder = Paths.get(pathNote.toString(), String.valueOf(calendar.get(1)), String.format("%02d", calendar.get(2) + 1));
            newFile = Paths.get(parentFolder.toString(), NoteManager.generateNoteFileName(calendar));
            if (!Files.exists(parentFolder, new LinkOption[0])) {
                Files.createDirectories(parentFolder, new FileAttribute[0]);
                newFile = Paths.get(parentFolder.toString(), NoteManager.generateNoteFileName(calendar));
                break;
            }
            if (!Files.exists(newFile, new LinkOption[0])) break;
            calendar.add(13, 1);
        }
        newFile.toFile().createNewFile();
        Session s = sf.openSession();
        s.beginTransaction();
        Note note = new Note();
        DateMarker dm = DateMarkerUtils.createDateMarker((Calendar)calendar);
        note.setPropertyValue("datemarker", (Object)dm);
        note.setPropertyValue("filepath", (Object)pathNote.relativize(newFile).toString());
        note.setPropertyValue("title", (Object)dm.toString());
        note.setInfo(dm.toString());
        if (tag != null) {
            RelationCollection r = (RelationCollection)note.getRelation("tags");
            Tag[] tags = new Tag[]{tag};
            r.setTargets((Entity[])tags);
        }
        try {
            s.save((Object)note);
            s.getTransaction().commit();
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
        finally {
            s.close();
        }
        DayContentChangedEvent event = new DayContentChangedEvent(note, dm, DayContentChangedEvent.Type.Created);
        this.fireDayContentChanged(event);
        return note;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Note note, boolean moveToTrash) throws IOException {
        Path noteFile = Paths.get(pathNote.toString(), note.getFilePath());
        Path target = Paths.get(pathTrash.toString(), noteFile.getFileName().toString());
        try {
            if (moveToTrash) {
                Files.move(noteFile, target, new CopyOption[0]);
            } else {
                Files.delete(noteFile);
            }
        }
        catch (NoSuchFileException noEx) {
            logger.error("Deleting note error:" + note, (Throwable)noEx);
        }
        catch (IOException ex) {
            logger.error("Deleting note error:" + note, (Throwable)ex);
            throw ex;
        }
        try (Session s = sf.openSession();){
            s.beginTransaction();
            s.update((Object)note);
            s.delete((Object)note);
            s.getTransaction().commit();
        }
        DayContentChangedEvent event = new DayContentChangedEvent(note, note.getDateMarker(), DayContentChangedEvent.Type.Deleted);
        this.fireDayContentChanged(event);
    }

    public void addDayContentChangedListener(DayContentChangedListener listener) {
        dayContentChangedListeners.add(listener);
    }

    public void removeDayContentChangedListener(DayContentChangedListener listener) {
        dayContentChangedListeners.remove(listener);
    }

    private void fireDayContentChanged(DayContentChangedEvent event) {
        Iterator<DayContentChangedListener> iterator = dayContentChangedListeners.iterator();
        while (iterator.hasNext()) {
            DayContentChangedListener listener;
            DayContentChangedListener dayContentChangedListener = listener = iterator.next();
            dayContentChangedListener.changed(event);
        }
    }

    public static String generateNoteFileName(Calendar calendar) {
        StringBuilder ret = new StringBuilder();
        ret.append(String.format("%02d", calendar.get(5))).append("_").append(String.format("%02d", calendar.get(11))).append("_").append(String.format("%02d", calendar.get(12))).append("_").append(String.format("%02d", calendar.get(13))).append(".").append("html");
        return ret.toString();
    }

    static {
        theInstance = new NoteManager();
        dayContentChangedListeners = new ArrayList<DayContentChangedListener>();
        logger = LoggerFactory.getLogger(NoteManager.class);
    }
}

