/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.ebook.progress;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import myencyclopedia.common.progress.Logic;
import myencyclopedia.common.progress.LogicEvent;
import myencyclopedia.common.utils.HashUtil;
import myencyclopedia.common.utils.TraverseDir;
import myencyclopedia.logic.ebook.progress.DetectSameMD5Result;
import myencyclopedia.model.ebook.Ebook;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectSameMD5Logic
extends Logic {
    private final File folder;
    private final Session session;
    private long totalNumber;
    private long fileExamined;
    private TraverseDir.CallBack callback;
    private TraverseDir traverseDir;
    private DetectSameMD5Result deleteFilesResult;
    private boolean hasNext;
    private static final Logger logger = LoggerFactory.getLogger(DetectSameMD5Result.class);

    public DetectSameMD5Logic(File folder, Session session) {
        this.folder = folder;
        this.session = session;
    }

    public boolean doPrepare() {
        this.totalNumber = TraverseDir.getFileExcludingDirNumberInFolder((File)this.folder);
        if (this.totalNumber == 0L) {
            return false;
        }
        this.fileExamined = 0L;
        this.callback = new TraverseDir.CallBack(){

            public void visitFile(File file) {
                if (file.isDirectory()) {
                    DetectSameMD5Logic.this.deleteFilesResult = new DetectSameMD5Result(true, file, null);
                    return;
                }
                String md5 = null;
                try {
                    md5 = HashUtil.computeMD5((File)file);
                }
                catch (IOException ex) {
                    logger.error("", (Throwable)ex);
                }
                catch (NoSuchAlgorithmException ex) {
                    logger.error("", (Throwable)ex);
                }
                Ebook ebook = DetectSameMD5Logic.this.getIdenticalEbook(md5);
                if (ebook == null) {
                    DetectSameMD5Logic.this.deleteFilesResult = new DetectSameMD5Result(true, file, null);
                } else {
                    DetectSameMD5Logic.this.deleteFilesResult = new DetectSameMD5Result(false, file, ebook);
                }
            }
        };
        this.traverseDir = new TraverseDir(this.folder, this.callback);
        this.hasNext = true;
        return true;
    }

    public void doStep() {
        this.hasNext = this.traverseDir.oneStep();
        ++this.fileExamined;
    }

    public boolean hasNextStep() {
        return this.hasNext;
    }

    public void doCleanUp() {
        this.session.close();
    }

    public boolean isSuccess() {
        return true;
    }

    public int getProgressPercent() {
        float perc = (float)this.fileExamined / (float)this.totalNumber;
        return (int)(perc * 100.0f);
    }

    public boolean isProgressSupported() {
        return true;
    }

    public LogicEvent constructStartOneStepEvent() {
        LogicEvent event = new LogicEvent("StartOneStep", (Object)this.deleteFilesResult);
        return event;
    }

    public LogicEvent constructFinishOneStepEvent() {
        LogicEvent event = new LogicEvent("FinishOneStep", (Object)this.deleteFilesResult);
        return event;
    }

    private Ebook getIdenticalEbook(String md5) {
        if (md5 == null) {
            return null;
        }
        String queryStr = "from EbookFileInfo ebookFileInfo where ebookFileInfo.md5=:md5";
        Query q = this.session.createQuery(queryStr);
        q.setString("md5", md5);
        List fileList = q.list();
        Object ebookWithSameMD5 = null;
        if (!fileList.isEmpty()) {
            // empty if block
        }
        return null;
    }

    public boolean onException(Exception ex) {
        logger.error("", (Throwable)ex);
        return true;
    }
}

