/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.ebook;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import myencyclopedia.common.utils.FileCopyUtil;
import myencyclopedia.common.utils.FileNameUtils;
import myencyclopedia.hibernate.crud.QueryUtil;
import myencyclopedia.logic.mydoc.ConfigMydoc;
import myencyclopedia.model.Entity;
import myencyclopedia.model.RelationCollection;
import myencyclopedia.model.common.entity.FileObject;
import myencyclopedia.model.ebook.Ebook;
import myencyclopedia.model.ebook.EbookAuthor;
import myencyclopedia.model.ebook.EbookFileInfo;
import myencyclopedia.model.ebook.Producer;
import myencyclopedia.model.ebook.Publisher;
import myencyclopedia.model.ebook.TitleI18N;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EbookDAO {
    private static Integer offset = null;
    private static final Logger logger = LoggerFactory.getLogger(EbookDAO.class);

    public static void newEbook(Session session, Ebook ebook) throws Exception {
        EbookFileInfo efi;
        ArrayList<Path> origFileList = new ArrayList<Path>();
        String title = ebook.getDefaultTitleI18n().getTitle();
        title = EbookDAO.stripSpecialChars(title);
        ebook.setDescription(EbookDAO.formEbookDescription(ebook.getDefaultTitleI18n()));
        if (offset == null) {
            offset = EbookDAO.getNextDisciplineOffset(session);
        }
        RelationCollection r = (RelationCollection)ebook.getRelation("file_info");
        String exts = "";
        try {
            for (Entity target : r.getTarget()) {
                efi = (EbookFileInfo)target;
                Path pathSrc = Paths.get(efi.getFileName(), new String[0]);
                origFileList.add(pathSrc);
                String relativePath = String.valueOf((offset / 100 + 1) * 100);
                String newNamePrefix = EbookDAO.formEbookFileName(title, offset);
                efi.setRelativePath(relativePath);
                efi.setDisciplineOffset(offset.intValue());
                Integer n = offset;
                Integer n2 = offset = Integer.valueOf(offset + 1);
                String ext = FileNameUtils.getSuffixPart((String)efi.getFileName());
                exts = exts + ext + ",";
                String newFileName = newNamePrefix + "." + ext;
                efi.setFileName(newFileName);
                Path pathTarget = Paths.get(ConfigMydoc.getInstance().getBookShelfPath().toString(), relativePath, newFileName);
                if (!Files.exists(pathTarget.getParent(), new LinkOption[0])) {
                    Files.createDirectories(pathTarget.getParent(), new FileAttribute[0]);
                }
                FileCopyUtil.copy((Path)pathSrc, (Path)pathTarget);
            }
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
        }
        ebook.setFileExtInfo(exts);
        session.beginTransaction();
        for (Entity target : r.getTarget()) {
            efi = (EbookFileInfo)target;
            session.save((Object)efi);
        }
        session.save((Object)ebook);
        session.getTransaction().commit();
        for (Path orig : origFileList) {
            Files.delete(orig);
        }
    }

    private static String stripSpecialChars(String title) {
        title = title.replace('/', '_');
        title = title.replace('\\', '_');
        title = title.replace('*', '_');
        title = title.replace(':', '_');
        title = title.replace('\"', '_');
        title = title.replace('?', '_');
        title = title.replace('>', '_');
        title = title.replace('<', '_');
        title = title.replace('|', '_');
        return title;
    }

    public static void delete(Session s, Ebook book) throws Exception {
        s.update((Object)book);
        RelationCollection rEFI = (RelationCollection)book.getRelation("file_info");
        for (EbookFileInfo efi : (EbookFileInfo[])rEFI.getTarget()) {
            Path ebookFile = Paths.get(ConfigMydoc.getInstance().getBookShelfPath().toString(), efi.getRelativePath(), efi.getFileName());
            if (ConfigMydoc.getInstance().getMoveToTrash()) {
                Files.move(ebookFile, ConfigMydoc.getInstance().getAsPath("/myencyclopedia/mydoc/trash/path"), new CopyOption[0]);
                continue;
            }
            Files.delete(ebookFile);
        }
        s.beginTransaction();
        RelationCollection rEA = (RelationCollection)book.getRelation("authors");
        for (EbookAuthor ea : (EbookAuthor[])rEA.getTarget()) {
            s.delete((Object)ea);
        }
        s.delete((Object)book);
        s.getTransaction().commit();
    }

    public static List<Ebook> searchForMD5(Session s, String md5) {
        String querySelectFile = "select f.id from EbookFileInfo as f where f.md5 = :md5";
        Query query = s.createQuery(querySelectFile);
        query.setParameter("md5", (Object)md5);
        List idList = query.list();
        List result = s.createCriteria(Ebook.class).createCriteria("fileinfos").createCriteria("targetEntity").add(Restrictions.in((String)"id", (Collection)idList)).list();
        return result;
    }

    public static String formEbookDescription(TitleI18N titleI18n) {
        String description = titleI18n.getTitle();
        if (titleI18n.getSubtitle() != null) {
            description = description + "[[" + titleI18n.getSubtitle() + "]]";
        }
        return description;
    }

    public static String getFileFullPath(EbookFileInfo fileInfo) {
        String fileFullPath = ConfigMydoc.getInstance().getBookShelfPath() + File.separator + fileInfo.getRelativePath() + File.separator + fileInfo.getFileName();
        return fileFullPath;
    }

    public static int getNextDisciplineOffset(Session session) {
        String SQL_QUERY = "select max(offset) from EbookFileInfo";
        Integer max = null;
        Query query = session.createQuery(SQL_QUERY);
        Iterator it = query.iterate();
        while (it.hasNext()) {
            max = (Integer)it.next();
        }
        if (max == null) {
            return 1;
        }
        return max + 1;
    }

    public static String formEbookFileName(String title, int offset) {
        StringBuilder ret = new StringBuilder(String.valueOf(offset));
        ret.append("_");
        title = title.replaceAll(" ", "_");
        ret.append(title);
        return ret.toString();
    }

    public static String formAttachmentPath(Ebook ebook) {
        StringBuilder ret = null;
        return ret.toString();
    }

    public static String getAttachmentFullPath(FileObject attachmentFileObj) {
        String fileFullPath = ConfigMydoc.getInstance().getBookShelfPath() + File.separator + "attachment" + File.separator + attachmentFileObj.getRelativePath() + File.separator + attachmentFileObj.getFileName();
        return fileFullPath;
    }

    public static List<Publisher> loadPublishers(SessionFactory sf) {
        return QueryUtil.loadAll((SessionFactory)sf, Publisher.class);
    }

    public static List<Producer> loadProducers(SessionFactory sf) {
        return QueryUtil.loadAll((SessionFactory)sf, Producer.class);
    }
}

