/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static void main(String[] args) throws Exception {
        File inFile = new File("C:\\oss\\lua-5.2.0");
        File outFile = new File("C:\\test.zip");
        ZipUtil.zipFolder(inFile, outFile, "ver");
    }

    public static void zipFolder(File folder, File outFile, String dir) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(outFile));
        if (folder.isDirectory()) {
            File[] files;
            for (File file : files = folder.listFiles()) {
                ZipUtil.zipFile(file, zos, dir);
            }
        }
        zos.close();
    }

    public static void zipFile(File inFile, File outFile, String dir) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(outFile));
        ZipUtil.zipFile(inFile, zos, dir);
        zos.close();
    }

    public static void zipFile(File inFile, File outFile) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(outFile));
        ZipUtil.zipFile(inFile, zos, null);
        zos.close();
    }

    private static void zipFile(File inFile, ZipOutputStream zos, String dir) throws IOException {
        if (inFile.isDirectory()) {
            File[] files;
            for (File file : files = inFile.listFiles()) {
                if (dir != null) {
                    ZipUtil.zipFile(file, zos, dir + "\\" + inFile.getName());
                    continue;
                }
                ZipUtil.zipFile(file, zos, inFile.getName());
            }
        } else {
            String entryName = null;
            entryName = dir != null ? dir + "\\" + inFile.getName() : inFile.getName();
            ZipEntry entry = new ZipEntry(entryName);
            zos.putNextEntry(entry);
            FileInputStream is = new FileInputStream(inFile);
            int len = 0;
            while ((len = ((InputStream)is).read()) != -1) {
                zos.write(len);
            }
            ((InputStream)is).close();
        }
    }
}

