/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.utils;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;

public class TraverseDir {
    private Queue<File> filesQueue = new LinkedList<File>();
    private final File startFolder;
    private final CallBack callback;

    public TraverseDir(File folder, CallBack callback) {
        this.startFolder = folder;
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.callback = callback;
        for (File subfile : this.startFolder.listFiles()) {
            this.filesQueue.add(subfile);
        }
    }

    public File nextFile() {
        return this.filesQueue.peek();
    }

    public boolean oneStep() {
        File[] children;
        if (this.filesQueue.peek() == null) {
            return false;
        }
        File subfile = this.filesQueue.remove();
        this.callback.visitFile(subfile);
        if (subfile.isDirectory() && (children = subfile.listFiles()) != null) {
            this.filesQueue.addAll(Arrays.asList(children));
        }
        return this.filesQueue.peek() != null;
    }

    public static long getFileNumberInFolder(File folder, final boolean excludeDir) {
        final MutableLong number = new MutableLong(0L);
        CallBack callBack = new CallBack(){

            @Override
            public void visitFile(File file) {
                if (file.isDirectory() && excludeDir) {
                    return;
                }
                ++number.value;
            }
        };
        TraverseDir traverseDir = new TraverseDir(folder, callBack);
        while (traverseDir.oneStep()) {
        }
        return number.value;
    }

    public static long getFileExcludingDirNumberInFolder(File folder) {
        return TraverseDir.getFileNumberInFolder(folder, true);
    }

    public static long getFileExcludingDirNumberInFolder(String folderPath) {
        File folder = new File(folderPath);
        return TraverseDir.getFileNumberInFolder(folder, true);
    }

    public static long getFileNumberInFolder(String folderPath, boolean excludeDir) {
        File folder = new File(folderPath);
        return TraverseDir.getFileNumberInFolder(folder, excludeDir);
    }

    public static long getSizeForFolder(File folder) {
        final MutableLong totalSize = new MutableLong(0L);
        CallBack callBack = new CallBack(){

            @Override
            public void visitFile(File file) {
                if (file.isFile()) {
                    totalSize.value += file.length();
                }
            }
        };
        TraverseDir traverseDir = new TraverseDir(folder, callBack);
        while (traverseDir.oneStep()) {
        }
        return totalSize.value;
    }

    public static long getSizeForFolder(String folderPath) {
        File folder = new File(folderPath);
        return TraverseDir.getSizeForFolder(folder);
    }

    private static class MutableLong {
        public long value;

        public MutableLong(long initialValue) {
            this.value = initialValue;
        }
    }

    public static abstract class CallBack {
        public abstract void visitFile(File var1);
    }
}

