/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.progress.filewalker;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.HashMap;
import myencyclopedia.common.progress.filewalker.FileLogicEvent;
import myencyclopedia.common.progress.filewalker.FileTreeWalker;
import myencyclopedia.common.progress.filewalker.FileWalkerLogic;
import myencyclopedia.common.progress.filewalker.ZipListener;
import myencyclopedia.common.progress.filewalker.ZipWalkerEvent;
import myencyclopedia.common.utils.FileDeleteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipWalkerLogic
extends FileWalkerLogic {
    protected Path zip;
    protected String saveDir;
    private ZipWalkerEvent event;
    private ZipWalkerLogic subLogic;
    private ZipListener ziplistener;
    private static final Logger logger = LoggerFactory.getLogger(ZipWalkerLogic.class);
    private STAGE stage;
    private boolean recursize;

    public ZipWalkerLogic(Path zip, final String saveDir, final boolean recursize) {
        this.zip = zip;
        this.saveDir = saveDir;
        this.recursize = recursize;
        this.event = new ZipWalkerEvent();
        this.stage = STAGE.PREPARE;
        this.walker = new FileTreeWalker(EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE);
        this.visitor = new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path newDir = Paths.get(saveDir, dir.toString());
                if (!dir.toString().equals("/")) {
                    Files.createDirectory(newDir, new FileAttribute[0]);
                }
                ((ZipWalkerLogic)ZipWalkerLogic.this).event.type = ZipWalkerEvent.TYPE.preVisitDirectory;
                ((ZipWalkerLogic)ZipWalkerLogic.this).event.zipPath = dir;
                ((ZipWalkerLogic)ZipWalkerLogic.this).event.zippedPath = newDir;
                ZipWalkerLogic.this.ziplistener.dispatch(ZipWalkerLogic.this.event);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path local = Paths.get(saveDir, file.toString());
                Files.copy(file, local, StandardCopyOption.REPLACE_EXISTING);
                ((ZipWalkerLogic)ZipWalkerLogic.this).event.type = ZipWalkerEvent.TYPE.visitFile;
                ((ZipWalkerLogic)ZipWalkerLogic.this).event.zipPath = file;
                ((ZipWalkerLogic)ZipWalkerLogic.this).event.zippedPath = local;
                ZipWalkerLogic.this.ziplistener.dispatch(ZipWalkerLogic.this.event);
                if (recursize && (local.getFileName().toString().endsWith(".jar") || local.getFileName().toString().endsWith(".zip"))) {
                    Path tempPath = null;
                    try {
                        tempPath = Files.createTempDirectory("mefiles", new FileAttribute[0]);
                    }
                    catch (IOException ex) {
                        logger.error("", (Throwable)ex);
                        System.exit(-1);
                    }
                    ZipWalkerLogic.this.subLogic = new ZipWalkerLogic(local, tempPath.toString(), true);
                    ZipWalkerLogic.this.subLogic.setZipListener(ZipWalkerLogic.this.ziplistener.cloneChild());
                    ZipWalkerLogic.this.stage = STAGE.SUB;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                logger.error("", (Throwable)exc);
                return FileVisitResult.TERMINATE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc != null) {
                    logger.error("", (Throwable)exc);
                    return FileVisitResult.TERMINATE;
                }
                Path newDir = Paths.get(saveDir, dir.toString());
                ((ZipWalkerLogic)ZipWalkerLogic.this).event.type = ZipWalkerEvent.TYPE.postVisitDirectory;
                ((ZipWalkerLogic)ZipWalkerLogic.this).event.zipPath = dir;
                ((ZipWalkerLogic)ZipWalkerLogic.this).event.zippedPath = newDir;
                ZipWalkerLogic.this.ziplistener.dispatch(ZipWalkerLogic.this.event);
                return FileVisitResult.CONTINUE;
            }
        };
    }

    public void setZipListener(ZipListener ziplistener) {
        this.ziplistener = ziplistener;
    }

    @Override
    public boolean hasNextStep() {
        return this.stage != STAGE.DONE;
    }

    @Override
    public FileLogicEvent constructStartOneStepEvent() {
        FileLogicEvent event = this.stage == STAGE.SUB ? this.subLogic.startStepEvent : super.constructStartOneStepEvent();
        event.setValue(this.zip.toString() + ">" + event.getValue());
        return event;
    }

    @Override
    public void doStep() {
        switch (this.stage) {
            case PREPARE: {
                this.zipPrepare();
                this.stage = STAGE.NORMAL;
                break;
            }
            case CLEANUP: {
                super.cleanUp();
                try {
                    this.deleteTempDir();
                }
                catch (Exception ex) {
                    logger.error("", (Throwable)ex);
                }
                this.stage = STAGE.DONE;
                break;
            }
            case NORMAL: {
                if (super.hasNextStep()) {
                    super.doStep();
                    break;
                }
                this.stage = STAGE.CLEANUP;
                break;
            }
            case SUB: {
                if (this.subLogic.hasNextStep()) {
                    try {
                        this.subLogic.step();
                    }
                    catch (Exception ex) {
                        logger.error("", (Throwable)ex);
                    }
                    break;
                }
                this.stage = STAGE.NORMAL;
            }
        }
    }

    private boolean zipPrepare() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "false");
        env.put("encoding", "ISO-8859-1");
        try {
            FileSystem fs = FileSystems.newFileSystem(this.zip, null);
            this.start = fs.getPath("/", new String[0]);
            this.ev = this.walker.walk(this.start);
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
            return false;
        }
        return true;
    }

    private void deleteTempDir() throws IOException {
        File rootDir = new File(this.saveDir);
        if (rootDir.exists()) {
            FileDeleteUtils.delete(rootDir);
        }
        rootDir.mkdir();
    }

    private static enum STAGE {
        PREPARE,
        SUB,
        NORMAL,
        CLEANUP,
        DONE;

    }
}

