/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.progress;

import java.util.ArrayList;
import java.util.List;
import myencyclopedia.common.progress.LogicEvent;
import myencyclopedia.common.progress.LogicListener;

public abstract class Logic {
    public static final String EVENT_ADDITIONAL = "Additional";
    public static final String EVENT_START_ONESTEP = "StartOneStep";
    public static final String EVENT_FINISH_ONESTEP = "FinishOneStep";
    public static final String EVENT_START_PREPARING = "StartPreparing";
    public static final String EVENT_FINISH_PREPARING = "FinishPreparing";
    public static final String EVENT_START_CLEANUP = "StartCleanup";
    public static final String EVENT_FINISH_CLEANUP = "FinishCleanup";
    public static final String EVENT_PROGRESS_UPDATE = "ProgressUpdate";
    protected List<LogicListener> listeners = new ArrayList<LogicListener>();

    public abstract boolean doPrepare();

    public final boolean prepare() {
        LogicEvent event = this.constructStartPreparingEvent();
        this.dispatchEvent(event);
        boolean ret = this.doPrepare();
        event = this.constructFinishPreparingEvent();
        this.dispatchEvent(event);
        return ret;
    }

    public abstract boolean hasNextStep();

    public abstract void doStep() throws Exception;

    public final void step() throws Exception {
        LogicEvent event = this.constructStartOneStepEvent();
        this.dispatchEvent(event);
        this.doStep();
        event = this.constructFinishOneStepEvent();
        this.dispatchEvent(event);
    }

    public abstract void doCleanUp();

    public final void cleanUp() {
        LogicEvent event = this.constructStartCleanupEvent();
        this.dispatchEvent(event);
        this.doCleanUp();
        event = this.constructFinishCleanupEvent();
        this.dispatchEvent(event);
    }

    public abstract boolean onException(Exception var1);

    public abstract boolean isSuccess();

    public abstract boolean isProgressSupported();

    public abstract int getProgressPercent();

    public void dispatchProgressEvent() {
        if (this.isProgressSupported()) {
            LogicEvent progressEvent = new LogicEvent(EVENT_PROGRESS_UPDATE, this.getProgressPercent());
            this.dispatchEvent(progressEvent);
        }
    }

    public void run() {
        boolean success = this.prepare();
        this.dispatchProgressEvent();
        if (success) {
            while (this.hasNextStep()) {
                try {
                    this.step();
                }
                catch (Exception ex) {
                    if (!this.onException(ex)) break;
                }
                this.dispatchProgressEvent();
            }
        }
        this.cleanUp();
        this.dispatchProgressEvent();
    }

    protected final void dispatchEvent(LogicEvent event) {
        if (event != null) {
            for (LogicListener listener : this.listeners) {
                listener.dispatch(event);
            }
        }
    }

    public void addIEventNotifier(LogicListener eventNotifier) {
        this.listeners.add(eventNotifier);
    }

    protected LogicEvent constructStartPreparingEvent() {
        LogicEvent event = new LogicEvent(EVENT_START_PREPARING, null);
        return event;
    }

    protected LogicEvent constructFinishPreparingEvent() {
        LogicEvent event = new LogicEvent(EVENT_FINISH_PREPARING, null);
        return event;
    }

    protected LogicEvent constructStartOneStepEvent() {
        return null;
    }

    protected LogicEvent constructFinishOneStepEvent() {
        return null;
    }

    protected LogicEvent constructFinishCleanupEvent() {
        LogicEvent event = new LogicEvent(EVENT_FINISH_CLEANUP, null);
        return event;
    }

    protected LogicEvent constructStartCleanupEvent() {
        LogicEvent event = new LogicEvent(EVENT_START_CLEANUP, null);
        return event;
    }
}

