/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.config;

import java.io.PrintStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import myencyclopedia.common.config.DirItem;
import myencyclopedia.common.config.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLConfigFile {
    static final Logger logger = LoggerFactory.getLogger(XMLConfigFile.class);
    protected Stack<Element> stack;
    protected Path fileToRead;
    protected String fileName;
    protected Map<String, Element> map;
    protected Element rootElement;
    protected List<Item> itemList;

    protected XMLConfigFile(String fileInClassPath) throws ConfigMismatchException {
        this.fileName = fileInClassPath;
        Path temp = Paths.get(fileInClassPath, new String[0]);
        String filename = temp.getFileName().toString();
        Path parentFolder = Paths.get(".", new String[0]);
        this.fileToRead = Paths.get(parentFolder.toString(), filename);
        InputSource is = null;
        try {
            ClassLoader cl = XMLConfigFile.class.getClassLoader();
            URL url = cl.getResource(fileInClassPath);
            if (url == null) {
                logger.error("Error reading config file from classpath" + this.fileToRead);
                System.exit(-1);
            }
            InputSource isTemplate = new InputSource(url.openStream());
            int verTemplate = this.parseVersion(isTemplate);
            if (Files.exists(this.fileToRead, new LinkOption[0])) {
                is = new InputSource(Files.newInputStream(this.fileToRead, new OpenOption[0]));
                int verLocal = this.parse(is);
                if (verLocal != verTemplate) {
                    throw new ConfigMismatchException(verTemplate, verLocal);
                }
            } else {
                this.parse(new InputSource(url.openStream()));
            }
        }
        catch (Exception ex) {
            if (ex instanceof ConfigMismatchException) {
                throw (ConfigMismatchException)ex;
            }
            logger.error("Error loading config file:" + fileInClassPath, (Throwable)ex);
        }
        logger.warn(this.fileToRead.toAbsolutePath().normalize().toString());
    }

    public boolean exists() {
        return Files.exists(this.fileToRead, new LinkOption[0]);
    }

    public void writeToFile() {
        try {
            DOMSource source = new DOMSource(this.rootElement);
            PrintStream ps = new PrintStream(this.fileName);
            StreamResult result = new StreamResult(ps);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            logger.error("Error writing config file:" + this.fileName, (Throwable)ex);
            System.exit(-1);
        }
    }

    protected int parseVersion(InputSource is) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(is);
        this.rootElement = doc.getDocumentElement();
        String versionStr = this.rootElement.getAttribute("version");
        int ver = Integer.parseInt(versionStr);
        return ver;
    }

    protected int parse(InputSource is) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(is);
        this.rootElement = doc.getDocumentElement();
        String versionStr = this.rootElement.getAttribute("version");
        int ver = Integer.parseInt(versionStr);
        this.stack = new Stack();
        this.map = new HashMap<String, Element>();
        this.itemList = new LinkedList<Item>();
        this.walkElementNode(this.rootElement);
        return ver;
    }

    private void walkElementNode(Element node) {
        this.stack.push(node);
        NodeList list = node.getChildNodes();
        boolean isTerminalElement = true;
        for (int i = 0; i < list.getLength(); ++i) {
            Node childNode = list.item(i);
            if (childNode.getNodeType() != 1) continue;
            isTerminalElement = false;
            this.walkElementNode((Element)childNode);
        }
        if (isTerminalElement) {
            StringBuilder sb = new StringBuilder();
            for (Element el : this.stack) {
                sb.append("/").append(el.getNodeName());
            }
            NamedNodeMap nodeMap = node.getAttributes();
            Item item = null;
            int length = nodeMap.getLength();
            block20: for (int i = 0; i < length; ++i) {
                Node attribNode = nodeMap.item(i);
                switch (attribNode.getNodeName()) {
                    case "conf": {
                        switch (attribNode.getNodeValue()) {
                            case "dir": {
                                item = new DirItem(sb.toString(), node);
                                continue block20;
                            }
                        }
                        item = new Item(sb.toString(), node);
                        continue block20;
                    }
                    case "default": {
                        item.defaultValue = attribNode.getNodeValue();
                        continue block20;
                    }
                    case "title": {
                        item.title = attribNode.getNodeValue();
                        continue block20;
                    }
                    case "major": {
                        item.major = true;
                    }
                }
            }
            this.map.put(sb.toString(), node);
            this.itemList.add(item);
        }
        this.stack.pop();
    }

    public synchronized String getNodeValue(String xpath) {
        Element el = this.map.get(xpath);
        if (el != null) {
            return el.getTextContent();
        }
        return null;
    }

    public synchronized void setNodeValue(String xpath, String value) {
        Element el = this.map.get(xpath);
        el.setTextContent(value);
    }

    public Path getAsPath(String item) {
        String str = this.getNodeValue(item);
        if (str == null || str.isEmpty()) {
            return null;
        }
        return Paths.get(str, new String[0]).toAbsolutePath().normalize();
    }

    public Item[] getItems() {
        return this.itemList.toArray(new Item[0]);
    }

    public static class ConfigMismatchException
    extends Exception {
        private int allowed;
        private int existing;

        public ConfigMismatchException(int allowed, int existing) {
            this.allowed = allowed;
            this.existing = existing;
        }

        @Override
        public String toString() {
            return "Local version " + this.existing + " but needs to be " + this.allowed;
        }
    }
}

