	var noImage = new Image();
	noImage.src = "img/dummy.png";
	
//all main menu items
  var allCategories = new Array ("----","Clefs","Key","Notes","Accidentals","Rests","Staff","----","TimeSignature","BarLines","Rhythm","Beams","----","Intervals","Chords","Voices","----","Templates","SystemChange","----","Tempo","Dynamics","ArticulationPhrasing","Abbreviation","Embellishments","----","Text","Lyrics","AnnotationText","AnnotationGraphics","----","ScaleAndMargin","----","SchenkerGraphs","Miscellaneous");

//category and code snippets clefs
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   var arrayLength = 9;
   var myClefs = new Array(arrayLength);
   for (var i = 0; i < myClefs.length; i++) {
    myClefs[i] = new Array(arrayLength);
  }

	myClefs[0]=['Basic Clefs','X:1\nT: Treble clef\nM:none\nL:mcm_default\nK:C clef=treble\nC1\n\nX:2\nT: Bass clef\nM:none\nL:mcm_default\nK:C clef=bass\nC1\n'];
	myClefs[1]=['All Clefs','X:1\nT: All clefs\nM: C\nL: mcm_default\nK: C bass\n%%freegchord 1\n"^bass"G,4C4E4G4|\\\n[K:bass3]"^bass3"G,4C4E4G4|\\\n[K:alto4]"^alto4"G,4C4E4G4|\\\n[K:alto]"^alto"G,4C4E4G4|\\\n[K:alto2]"^alto2"G,4C4E4G4|\\\n[K:alto1]"^alto1"G,4C4E4G4|\\\n[K:treble]"^treble"G,4C4E4G4|\\\n[K:treble1]"^treble1"G,4C4E4G4|\\\n[K:treble-8]"^treble-8"G,4C4E4G4|\\\n[K:treble+8]"^treble+8"G,4C4E4G4|']; 		
	myClefs[2]=['Clef For Percussion','X: 1\nT: Clef for percussion\nM: none\nL: mcm_default\nK: C perc stafflines=1\nB8B8 B8B16B8 | B8B8 B16B16B8 | B16B16B16B8 | B8B16B8 |]'];
	myClefs[3]=['Special Bass Notes How To Avoid Commas','%%titleleft 1\n%%vocalfont Helvetica 14\n\nX:1\nT: Method 1 (with commas and clef=bass)\nM:none\nL:mcm_default\nK:C clef=bass\nC,,4 D,,4 C,4 D,4 [K:treble] C4 D4 | c4 d4 |]\nw:~\nw: C,,4 D,,4 C,4 C,4 C4 D4 c4 d4\n\nX:2\nT: Method 2 (without commas and clef=f octave=-2)\nM:none\nL:mcm_default\nK:C clef=f octave=-2\nC4 D4 c4 d4 |]\nw:~\nw: C4 D4 c4 d4'];
	myClefs[4]=['No Clefs','X:1\nT:No clef\nM:3/4\nL:mcm_default\nK:C clef=none\n.c4 .c4 .c4 | !tenuto!c2 .c4 |.c4 !tenuto!c2 | !tenuto!c2 .c4 | \n\nX:2\nT:No clef and one staffline\nM:3/4\nL:mcm_default\nK:C clef=none stafflines=1\n.B4 .B4 .B4 | !tenuto!B2 .B4 |.B4 !tenuto!B2 | !tenuto!B2 .B4 | \n\nX:3\nT:No clef and no staff\nM:3/4\nL:mcm_default\nK:C clef=none stafflines=0\n.c4 .c4 .c4 | !tenuto!c2 .c4 |.c4 !tenuto!c2 | !tenuto!c2 .c4 |'];
	myClefs[5]=['No Automatic Clefs','%%stretchlast 1\nX:1\nT:\nM:3/8\nL:mcm_default\n%%MIDI program 2 24\n%%MIDI program 1 24\nK:Amin\nV:1 cleff=treble\nV:2 cleff=treble\n%%staves (1 2)\n%\nV:1\nG8.G8. | f8f8e8 | c8c8B8 | c4. |\nV:2\nF,8F,8E,8 | G8.G8. |G8.G8. | C4. | \n\n%%autoclef 0\nX:1\nT: No automatic clefs via \%\%autoclef 0\nM:3/8\nL:mcm_default\n%%MIDI program 2 24\n%%MIDI program 1 24\nK:Amin\nV:1 cleff=treble\nV:2 cleff=treble\n%%staves (1 2)\n%\nV:1\nG8.G8. | f8f8e8 | c8c8B8 | c4. |\nV:2\nF,8F,8E,8 | G8.G8. |G8.G8. | C4. |'];
	myClefs[6]=['Clef Change','X: 1\nT:Clef Changes Within Tune\nM:C\nL: mcm_default\nK:C\n[K: treble]\nc8d8e8f8 g8a8b8c\'8 [K:bass] | C,8D,8E,8F,8 G,8A,8B,8C8 [K:D treble] | c8d8e8f8 g8a8b8c\'8 |'];
	myClefs[7]=['Keys','X: 1\nT: Examples major scales\nM: none\nL: mcm_default\nK: C\n"^C major"C1 | "^G major" [K: G] C1\n\nX: 2\nT: Examples minor scales\nM: none\nL: mcm_default\nK: C\n"^B minor"[K: Bm]C1 | "^F# minor"[K: F#m] C1\n\nX: 3\nT: Examples church modes\nM: none\nL: mcm_default\nK: C\n"^D Phrygian"[K: DPhr]C1 | "^Db Dorian"[K: Dbdor] C1'];
	myClefs[8]=['Key Change','X: 1\nT: Key change\nM: 4/4\nL: mcm_default\nK: D\n[K: treble]\nA,4 B,4 C4 D4 |[K: Bb] A,4 B,4 C4 D4 |'];
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   var arrayLength = 2;
   var myKey = new Array(arrayLength);
   for (var i = 0; i < myKey.length; i++) {
    myKey[i] = new Array(arrayLength);
  }
	myKey[0]=['Keys','X: 1\nT: Examples major scales\nM: none\nL: mcm_default\nK: C\n"^C major"C1 | "^G major" [K: G] C1\n\nX: 2\nT: Examples minor scales\nM: none\nL: mcm_default\nK: C\n"^B minor"[K: Bm]C1 | "^F# minor"[K: F#m] C1\n\nX: 3\nT: Examples church modes\nM: none\nL: mcm_default\nK: C\n"^D Phrygian"[K: DPhr]C1 | "^Db Dorian"[K: Dbdor] C1'];
	myKey[1]=['Key Change','X: 1\nT: Key change\nM: 4/4\nL: mcm_default\nK: D\n[K: treble]\nA,4 B,4 C4 D4 |[K: Bb] A,4 B,4 C4 D4 |'];
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   var arrayLength = 18;
   var myNotes = new Array(arrayLength);
   for (var i = 0; i < myNotes.length; i++) {
    myNotes[i] = new Array(arrayLength);
  }
  myNotes[0]=['Notes and pitch','X:1\nM:none\nL:mcm_default\nK:C clef=treble\nA,1 B,1 C1 D1 E1 F1 G1 A1 B1 c1 d1 e1 f1 g1 b1 c\'1 \n\nX:2\nM:none\nL:mcm_default\nK:C clef=bass\nC,,1 D,,1 E,,1 F,,1 G,,1 A,,1 B,,1 C,1 D,1 E,1 F,1 G,1 A,1 B,1 C1 D1 E1'];
  myNotes[1]=['Notes and duration','X: 1\nT: Notes and duration\nM: none\nL: mcm_default\nK: C\n[K: treble]\nC1 D2 E4 F8 G16 A32 || C1. D2. E4. F8. G16. A32. ||'];
  myNotes[2]=['Short notation','X: 1\nT: Short notation of sixteenth notes and thirty-second notes\nM: 2/4\nL: mcm_default\nK: C clef=treble\n"^Default coding"G16G16G16G16 E16E16E16E16 | D32D32D32D32!beambr1!D32D32D32D32 C16D16E8 |]\n"^Short coding"GGGG EEEE | D/D/D/D/!beambr1!D/D/D/D/ CDE8 |]'];  
  myNotes[3]=['Longa and brevis','X: 1\nT: Longa and brevis\nT: Longa =1111 as a representation of the duration of four whole notes\nT: Brevis =11 as a representation of the duration of two whole notes\nM: none\nL: mcm_default\nK: C\n[K: treble]\nD1111 D11 E1 C1 E11 D1111 |] '];
  myNotes[4]=['Brevis in square format','%%squarebreve 1\nX: 1\nT: Brevis in square format\nM: none\nL: mcm_default\nK: C\n[K: treble]\nD1111 D11 E1 C1 E11 D1111 |]'];
  myNotes[5]=['Tie between notes','X:1\nM:2/4\nL:mcm_default\nK:C clef=treble\nD4. - D8 | D8D8 - D8D8 - | D8D8 D4 |]\nD4. .- D8 | D8D8 .- D8D8 .- | D8D8 D4 |] '];
  myNotes[6]=['Cross staff stems','X: 1\nT: Cross staff stems\nM: none\nL: mcm_default\nK: C\n[K: treble]\n%%staves [1 2]\nV:1\nc4              c4               c16  c16             d16\nV:2 bass\nC,4 !xstem!C,4 C,16 !xstem!C,16!xstem!D,16'];
  myNotes[7]=['Stem direction','X: 1\nT: Stem direction\nM: 3/4\nL: mcm_default\nK: C\n[K: treble]\n[V: 1 stem=auto] "_normal"c4 d4 e4 | \\\n[V: 1 stem=up] "_up"c4 d4 e4 | \\\n[V: 1 stem=down] "_down"c4 d4 e4 |]'];
  myNotes[8]=['Stemless notes','X: 1\nT: Stemless notes\nM: none\nL: mcm_default\nK: C\n[K: treble]\nA0 (A0 G0) A0 c0 B0 A0 G0 [A0A0] A0 G0 F0 D0 [E0E0] E0 G0 A0 D0 E0 G0 F0 E0 F0 D0 [D0D0] |\nw: Ky-ri-- e ********** e-------- le- i- son'];
  myNotes[9]=['Invisible notes','X: 1\nT:Invisible notes, method 1\nM:C|\nL: mcm_default\nK:C\nV:1 clef=treble\nV:2 clef=bass\n%%staves [1 2]\nV:1\nC2 D2	| C1	|| x2 x2	 | C1 |]\nV:2\nC,2 G,2	| C,1	|| C,2 G,2	| x1 |]\n\nX: 2\nT:Invisible notes, method 2\nM:C|\nL: mcm_default\nK:C\nV:1 clef=treble\nV:2 clef=bass\n%%staves [1 2]\nU:u=!invisible!\nV:1\nC2 D2	| C1	|| uC2 uD2	| C1 |]\nV:2\nC,2 G,2	| C,1	|| C,2 G,2	| uC,1 |]'];
  myNotes[10]=['Colored notes','X: 1\nT: Colored notes\nM: 2/4\nL: mcm_default\nK: C\n!head-red!C8B,8 !head-blue!D8^D8 | !head-green!_E8F8 !head-red!G8_A8 | c2 |]\n\nShort notation\n\nX: 1\nT: Colored notes\nM: 2/4\nL: mcm_default\nU:r=!head-red!\nU:s=!head-blue!\nU:t=!head-green!\nK: C\nrC8B,8 sD8^D8 | t_E8F8 rG8_A8 | c2 |]'];
  myNotes[11]=['Circles and notes','X: 1\nT: Circles & notes\nM: none\nL: mcm_default\nK: C\n[K: treble]\n%available radius circle 10 - 15\n!arc10!C1 !arc11!C1 !arc12!C1 !arc13!C1 !arc14!C1 !arc15!C1'];
  myNotes[12]=['Grace notes','X: 1\nT: Grace notes: note the unexpected coding!\nM: C\nL: mcm_default\nK: C\n%%graceslurs 0\n{B8}A4 {B16}A4 {B32}A4 {B64}A4 | {/B}A1 |]\n\nX: 2\nT: Grace notes (coding is what we expect)\nM: C\nL: mcm_default\nK: C\n%%graceslurs 0\n{c8B8}A4 {c16B16}A4 {c32B32}A4 |\\\n%\n{a8g8f8 e8d8c8B4}A1 | {(A16B16)}c4 z4 {(G16A16B16}c4) z4 |\ \\n%\n(c2{B16A16)G16} {(G32A32B32) (G32A32B32)}c2 |]'];
  myNotes[13]=['Ambitus','X: 1\nT: Ambitus: example 1\nM: none\nL: mcm_default\nK: C clef=none\n%%staves (1 2)\nV: 1\ng0 \\\n%%staffbreak 0.3cm\n[K: C treble] [M: 4/4]C4 D4 E4 G4 | c4 d4 e4 g4 | e2 d2 | c1 |]\nV: 2\nB,0 \\\n%%staffbreak 0.3cm\n[K: C treble] [M: 4/4]C4 B,4 C4 D4 | E4 F4 G4 E4 | F2 G2 | C1 |]\n\nX: 2\nT: Ambitus: example 2\nM: none\nL: mcm_default\nK: C clef=none\n%%staves 1 2\nV: 1\n[C0g0] \\\n%%staffbreak 0.3cm\n[K: C treble] [M: 4/4]C4 D4 E4 G4 | c4 d4 e4 g4 | e2 d2 | c1 |]\nV: 2\n[B,0G0] \\\n%%staffbreak 0.3cm\n[K: C treble] [M: 4/4]C4 B,4 C4 D4 | E4 F4 G4 E4 | F2 G2 | C1 |]'];
  myNotes[14]=['Chant psalm notation','X: 1\nT: Chant or psalms notation\nM: none\nL: mcm_default\nK: Bb\n[K: treble]\nA11 B0 G0 A2 || A11 G0 A0 F2 || A11 G2 || '];
  myNotes[15]=['Sprechgesang','X: 1\nT: Sprechgesang\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\nz2 !sg!C8 !sg!E8 !sg!G4 | !sg!c2 z2 |]'];
  myNotes[16]=['PercussionNotes','X:1\nM:4/4\nL:mcm_default\nK:C clef=perc\nz4^A,,4 z4^A,,4 | z4^A,,4 z4^A,,4 |]'];
  myNotes[17]=['Sticky rhythm','X:1\nT:Sticky rhythm\nM:none\nL:mcm_default\nK:C clef=treble\nC2C2C2C2 | (CCCC)2\nC4C4C4 | (CCC)4\nC8C8C8C8 | (CCCC)8\nC8C8C16C16C16C16C16 | (CC)8(CCCCC)16\nC8C8 C16C16 C16C16C16 | (CC)8 (CC CCC)16\n'];
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   var arrayLength = 3;
   var myAccidentals = new Array(arrayLength);
   for (var i = 0; i < myAccidentals.length; i++) {
    myAccidentals[i] = new Array(arrayLength);
  }
	myAccidentals[0]=['Accidentals','X: 1\nT: Accidentals\nM: none\nL: mcm_default\nK: C\n[K: treble]\n^C1 =C1 _E1 =E1 ^^F1 =F1 __B1 =B1'];
	myAccidentals[1]=['Microtones','X: 1\nT: Microtones\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\n^/G4 ^G4 ^3/2G4 ^^G4 |\\\n_/G4 _G4 _3/2G4 __G4||'];
	myAccidentals[2]=['Musica ficta','X: 1\nT: Musica ficta (dorian mode)\nM: C|\nL: mcm_default\nK: C\n%%staves 1 2\nV: 1 clef=treble\nD4 A4 "^\\b"B4 A4 | c4 "^\\="B4 A4 G4 | A4 d2 "^\\#"c4 | d1 |]\n%\nV: 2 clef=bass\nD,1 | E,2 F,4 G,4 | F,2 E,2 | D,1 |] '];	
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   var arrayLength = 3;
   var myRests = new Array(arrayLength);
   for (var i = 0; i < myRests.length; i++) {
    myRests[i] = new Array(arrayLength);
  }
	myRests[0]=['Rests and duration','X: 1\nT: Rests and duration\nM: none\nL: mcm_default\nK: C\n[K: treble]\nz1 z2 z4 z8 z16 z32 || z1. z2. z4. z8. z16. z32. || '];
	myRests[1]=['Rests longa and brevis','X: 1\nT: Rests for longa and brevis\nM: none\nL: mcm_default\nK: C\n[K: treble]\nz1111 z11 ||'];
	myRests[2]=['Multimeasure rest','X: 1\nT: Multimeasure rests\nM: none\nL: mcm_default\nK: C\n[K: treble]\nZ2 | Z4 | Z6 | Z8 | Z10 | Z20 | Z30 || '];	
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   var arrayLength = 1;
   var myStaff = new Array(arrayLength);
   for (var i = 0; i < myStaff.length; i++) {
    myStaff[i] = new Array(arrayLength);
  }
	myStaff[0]=['Staff and duration','X:0\nT: no staffline\nM:none\nL:mcm_default\nK:none clef=none stafflines=0\nG11 G1 G2 G4 G8 G16 G32\n\nX: 1\nT: 1 staffline\nM: none\nL: mcm_default\nK: C perc stafflines=1\nB8B8 B8B16B8 | B8B8 B16B16B8 | B16B16B16B8 | B8B16B8 |]\n\nX: 2\nT: 2 stafflines\nM: none\nL: mcm_default\nK: C perc stafflines=2\nB8B8 B8B16B8 | B8B8 B16B16B8 | B16B16B16B8 | B8B16B8 |]'];
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

   var arrayLength = 4;
   var myTimeSignature = new Array(arrayLength);
   for (var i = 0; i < myTimeSignature.length; i++) {
    myTimeSignature[i] = new Array(arrayLength);
  }
	myTimeSignature[0]=['Metre change','X: 1\nT: Metre change\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\nC4 C4 D4 D4 | [M:3/4] E4 F4 G4 |[M:4/4] c4 B4 A4 B4 | G2 G2 |]'];
	myTimeSignature[1]=['Alla breve','X: 1\nT: Alla breve\nM: none\nL: mcm_default\nK: C clef=treble\n%\n[M: C|] F1 | [M: 2/2] G1 | [M: 2] A1 |] '];
	myTimeSignature[2]=['Compount time signatures','X: 1\nT: Compound time signatures\nM: 2/8+3/8\nL: mcm_default\nK: C\n[K: treble]\nC8D8 E8^F8^G8 | c8^F8 ^G8E8D8 | C8D8 E4 ^G8 | '];
	myTimeSignature[3]=['Polymetric time signatures','X: 1\nT: Polymetric\nM: none\nL: mcm_default\nK: C\n[K: treble]\n[M: 2/4]C4 D4 | [M: 3/4] E4 E4 E4 |[M: 5/8] F4 E8 D4| [M: 2/4] D2 | C2 |]'];		
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   var arrayLength = 2;
   var myBarLines = new Array(arrayLength);
   for (var i = 0; i < myBarLines.length; i++) {
    myBarLines[i] = new Array(arrayLength);
  }
	myBarLines[0]=['BarLines','X: 1\nT: Single and closing bar\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\nC4 C4 D4 D4 | E4 F4 G2 | c4 B4 A4 B4 | G2 G2 |]\n\nX: 2\nT: Other bars\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\nC4 C4 D4 D4 : E4 F4 G2 :: c4 B4 A4 B4 : G2 G2 :|] '];
	myBarLines[1]=['Half bar','%%titlefont Helvetica-Bold 20\n%%vocalfont  Helvetica 10\nX: 1\nT: Mit Fried und Freud ich fahr dahin\nC: Caspar Othmayr\nC: (1515 - 1553)\nM: C|\nL: mcm_default\nV:1 clef=treble\nV:2 clef=treble-8\n%%staves 1 2\nK: Gdor\nV: 1\nG2. (B4- !hbar1![] B4 A8G8 A4) F4  !hbar1![] (G4 A4) B2  !hbar1![] (A4 d2) "^\#"c4  !hbar1![]  d2 z2 !hbar1![]\nw: Mit Fried----- und Freud-- ich fahr-- da-hin\nV: 2\nG1  [] d2 d2  []  c2 g2  [] f2 e2  [] d2 z2 []\nw: Mit Fried und Freud ich fahr da-hin\n'];
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   var arrayLength = 3;
   var myRhythm = new Array(arrayLength);
   for (var i = 0; i < myRhythm.length; i++) {
    myRhythm[i] = new Array(arrayLength);
  }
	myRhythm[0]=['Syncopation','X: 1\nT: Syncopation (ties)\nM: 3/4\nL: mcm_default\nK: C\n[K: treble]\nC4 E4 G4- | G8F8 E8D8- D8G8 | C2. |] '];
	myRhythm[1]=['Tuplets','X: 1\nT: Tuplets\nM: none \nL: mcm_default\nK: C \n[K: treble]\n"^standard tuplet (shorthand)"(3A8A8A8 | (5A16A16A16A16A16 | (9A32A32A32A32A32A32A32A32A32 !\n"^tuplet exact code"(3:2:3 A8A8A8 | \\\n (3:2:2 A4B8 (3:2:2 A4B8 !\n\nX: 2\n M: none \nL: mcm_default\nK: C \n[K: treble]\n"^ratio"[I:tuplets 0 0 2](3A8A8A8 \\\n"^nested tuplets"[I:tuplets 2 0 2](7:8:8(3A8A8A8 A8A8A8A8A8'];
	myRhythm[2]=['Triplets','X: 1\nT: Beams, slurs, ties\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\nz16G,16(3:2:2z16E8\\\n%\n(G,16A,16(3B,16D,16E16) \\\n%\n(G,8A,8(3B,8D8)E8- |\\\n%\n[M:2/4]-(5E32(A,32B,32D32E32 A4.) |'];	
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 
  var arrayLength = 8;
   var myBeams = new Array(arrayLength);
   for (var i = 0; i < myBeams.length; i++) {
    myBeams[i] = new Array(arrayLength);
  }
	myBeams[0]=['Beam stub direction','X:1\nM:none\nL:mcm_default\nK:C clef=treble\n"_beam stub direction theoretically incorrect"A16A8.A16A8. y200 \\\n%\n"_beam stub direction correct" A16A8.!beambr1!A16A8. x1'];
	myBeams[1]=['Beam crossing a bar','X: 1\nT: Beam crossing a bar\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\nA4- A4 .(c4e8)d8"^beam;crossing;a bar"!beamon!|c8B8'];
	myBeams[2]=['Beam grouping','X: 1\nT: Beam grouping\nM: 7/8\nL: mcm_default\nK: C\n[K: treble]\nA8 A8 A8 A8 A8 A8 A8 | A8A8 A8A8A8 A8A8 | A8A8 A8A8 A8A8A8 |] \n\nX: 2\nT: Beam grouping\nM: 3/4\nL: mcm_default\nK: C\n[K: treble]\n"^1"c16d16e16d16 c16d16e16d16 c16d16e16d16 |\\\n"^2"c16d16 e16d16 c16d16 e16d16 c16d16 e16d16 |\n"^3"c16d16e16 d16c16 d16e16d16 c16d16e16d16 |\\\n"^4"c16 d16 e16 d16 c16 d16 e16 d16 c16 d16 e16 d16 ||'];
	myBeams[3]=['Beam subdivision','X: 1\nT: Beam subdivisions\nM: 4/4\nL:mcm_default\nK:C\n[K:treble]\n"^1"c32c32c32c32c32c32c32c32\\\n"^2"c32c32c32c32c32c32c32c32\\\n"^3"c32c32c32c32!beambr1!c32c32c32c32\\\n"^4"c32c32!beambr1!c32c32!beambr1!c32c32!beambr1!c32c32 ']; 
	myBeams[4]=['Beams different voices','X: 1\nT: Beams two voices\nM: 5/4\nL: mcm_default\nK: C\n[K: treble]\n%%staves (1 2)\nV: 1\nc8c8c8 c8c8c8c8 c8c8c8\nV: 2\nA8A8A8 A8A8A8 A8A8A8A8'];
	myBeams[5]=['Beams slurs ties','X: 1 \nT: Beams, slurs, ties\nM: 4/4 \nL: mcm_default\nK: C \n[K: treble]\nz16G,16(3:2:2z16E8\\\n%\n(G,16A,16(3B,16D,16E16) \\\n%\n(G,8A,8(3B,8D8)E8- |\\\n%\n[M:2/4]-(5E32(A,32B,32D32E32 A4.) |'];
	myBeams[6]=['Beams between staves','X: 1 \nT: Beams between staves\nM: 2/4 \nL: mcm_default \nK: none \n%%staves 1 2 \n[V:1] \nx4                       x4     | c8G8[I: staff 2]E,8C,8 |] \n[V:2]\nC,8E,8[I: staff 1]G8c8 | x4                     x4       |]'];
	myBeams[7]=['Beams over rests','X: 1\nT: Beams over rests\nM: 1/4\nL: mcm_default\nK: C\n[K: treble]\nC16C16 z16 C16 | C16C16z16C16 |]']; 
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   var arrayLength = 2;
   var myIntervals = new Array(arrayLength);
   for (var i = 0; i < myIntervals.length; i++) {
    myIntervals[i] = new Array(arrayLength);
  }
	myIntervals[0]=['Intervals 1','X:1\nT:Intervals I\nM:none\nL:mcm_default\nK:C clef=treble\n[C1C1] [C1D1] [C1E1] [C1F1] [C1G1] [C1A1] [C1B1] [C1c1] '];
	myIntervals[1]=['Intervals 2','X:1\nT:Intervals II\nM:none\nL:mcm_default\nK:C \nV: 1 clef=treble\nV: 2 clef=treble\n%%staves (1 2)\nV:1\nC1 D1 E1 F1 G1 A1 B1 c1\nV:2\nC1 C1 C1 C1 C1 C1 C1 C1'];
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

  var arrayLength = 7;
   var myChords = new Array(arrayLength);
   for (var i = 0; i < myChords.length; i++) {
    myChords[i] = new Array(arrayLength);
  }
	myChords[0]=['Chords','X: 1\nT: A. Basic chord\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\n[C1E1G1_B1] |]\n%You can also notate the short version [CEG_B]1 \n\nX: 2\nT: B. Chord connected to notes\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\nC1 - | [C1E1G1A1] - | [G1A1] - | A1 |] \n\nX: 3\nT: C. Chord with some annotation\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\n"^Dom7"[C1E1G1_B1] |]\n'];
	myChords[1]=['Melody and chords','X: 1\nT: A simple melody with chords\nC: Anonymous\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\n"C"C4 E4 G4. "F"F8 | "C"E4 "G"D4 "C"!breath!C2 |\\\n"G"D4 D4 G2 | F4 G4 "C"!breath!E2 |\\\n"C"C4 E4 G4. "F"F8 | "C"E4 "G"D4 "C"C2 |] '];
	myChords[2]=['Figured bass','X: 1\nT: Figured bass\nC: Anonymous\nM: none\nL: mcm_default\nK: F\n%%staves [1 2]\n[V: 1]\n[K: treble]\n[C2G2c2] | [C2F2A2][D2F2G2] | [C2F2A2] [B,2E2G2]|[A,1C1F1] |]\n[V: 2]\n[K: bass]\nE,2| F,2 B,,2 | C,2 C,,2 | F,,1 |]\nd: "_6" "" "_6;5" "_6;4" "_7" "" '];
	myChords[3]=['Chords I tie','X: 1\nT: Chords I: tie\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\n[F1A1c1f1]- | [F1A1c1f1] |]'];
	myChords[4]=['Chords II tie','X: 1\nT: Chords II: tie\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\n[F1A1d1f1]- | [F1A1e1g1] |]'];
	myChords[5]=['Chords III tie and slur','X: 1\nT: Chords: tie and slur\nM: 6/8\nL: mcm_default\nK: C\n(, [G,,4.G,4.]- !fermata![C,4.G,4.] )'];
	myChords[6]=['Chords IV ties in chords','X:1\nT:Ties in chords\nM:none\nL:mcm_default\nK:C\n[K:treble]\n"^tie lower and upper note" [D1F1A1] - [D1F1A1] |\\\n"^tie lower note" [D1- F1A1] [D1 F1A1] |\\\n"^tie upper note" [D1F1 A1-] [D1F1 A1] |\\\n"^change direction tie" [D1F1 A1-\'] [D1F1 A1] |]'];
 
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   var arrayLength = 2;
   var myVoices = new Array(arrayLength);
   for (var i = 0; i < myVoices.length; i++) {
    myVoices[i] = new Array(arrayLength);
  }
	myVoices[0]=['Overlapping voices','X: 1\nT: Overlapping voices\nM: 3/4\nL: mcm_default\nK: C\nV: 1 clef=treble\nV: 2 clef=treble\n%%staves (1 2)\nV: 1\n(E8A8) (D8B8) (F8^c8)\nV: 2\nE4 D4 ^C4'];
	myVoices[1]=['Voice splitting','X: 1\nT: Voice splitting with &\nM: 4/4\nL: mcm_default\nK: Dmin clef=treble\nD4 F4 E4 D8.C16 & A,1 | D2 B,2 & B,1 |]'];
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

  var arrayLength = 5;
   var myTemplates = new Array(arrayLength);
   for (var i = 0; i < myTemplates.length; i++) {
    myTemplates[i] = new Array(arrayLength);
  }
	myTemplates[0]=['Two part','X: 1 \nT: Two-part \nM: 4/4 \nL: mcm_default \n%%staves [1 2]\nK: C \n[V: 1] \n[K: treble] \nC2 D2 | C1 |] \n[V: 2] \n[K: bass]\n C,2 G,2 | C,1 |]\n\nX: 2\n T: Two-part (code better readable)\nM: 4/4 \nL: mcm_default \nK: C \nV: 1 name="top voice" clef=treble \nV: 2 name="bottom voice" clef=bass \n%%staves [1 2] \nV: 1 \nC2 D2 | E1 | E2 D2 | C1 |] \nV: 2 \nC,2 G,2 | C,1 | C,2 G,2 | C,1 |]'];
	myTemplates[1]=['Three part','X: 1\nT: Three-part [1 2 3]\nM: 4/4\nL: mcm_default\n%%staves [1 2 3]\nK: C\n[V: 1]\n[K: treble]\nE2 D2 | E1 |]\n[V: 2]\n[K: treble]\nC2 B,2 | C1 |]\n[V: 3]\n[K: bass]\n C,2 G,,2 | C,1 |]\n\nX: 2\n T: Three-part [(1 2) 3]\nM: 4/4\nL: mcm_default\nK: C\nV: 1 clef=treble\nV: 2 clef=treble\nV: 3 clef=bass\n%%staves [(1 2) 3]\nV: 1\nE2 D2 | E1 |]\nV: 2\nC2 B,2 | C1 |]\nV: 3\nC,2 G,,2 | C,1 |]'];
	myTemplates[2]=['Four part','X: 1\nT: Four-part [1 2 3 4]\nM: 4/4\nL: mcm_default\nV: 1 clef=treble\nV: 2 clef=treble\nV: 3 clef=treble-8\nV: 4 clef=bass\n%%staves [1 2 3 4]\nK: C\nV: 1\nE2 D2 | E1 |]\nV: 2\nC2 B,2 | C1 |]\nV: 3\nG2 G2 | G1 |]\nV: 4\nC,2 G,,2 | C,1 |]	\n\nX: 2\nT: Four-part [(1 2) (3 4)]\nM: 4/4\nL: mcm_default\nK: C\n%%staves [(1 2) (3 4)]\n[V: 1]\n[K: treble]\nE2 D2 | E1 |]\n[V: 2]\n[K: treble]\nC2 B,2 | C1 |]\n[V: 3]\n[K: bass]\nG,2 G,2 | G,1 |]\n[V: 4]\n[K: bass]\nC,2 G,,2 | C,1 |]	\n\nX: 3\nT: Four-part [(1 2 3) 4]\nM: 4/4\nL: mcm_default\nK: C\n%%staves [(1 2 3) 4]\n[V: 1]\n[K: treble]\nE2 D2 | E1 |]\n[V: 2]\n[K: treble]\nC2 B,2 | C1 |]\n[V: 3]\n[K: bass]\nG,2 G,2 | G,1 |]\n[V: 4]\n[K: bass]\nC,2 G,,2 | C,1 |]'];
	myTemplates[3]=['Solo + piano','X: 1\nT: Solo + piano\nM: 4/4\nL: mcm_default\nV: 1 clef=treble\nV: 2 clef=treble\nV: 3 clef=treble\nV: 4 clef=bass\n%%staves 1 {(2 3) 4}\nK: C\nV: 1\n g2 g4. a8 | g2 c2 |]\nV: 2\n E2 D2 | E4. F8 G2 |]\nV: 3\n C2 B,2 | C4. D8 E2 |] \nV: 4\n C,2 G,,2 | C,1 |]'];
	myTemplates[4]=['Four part choir organ','X: 1\nT: 4-part choir + organ\nM: 4/4\nL: mcm_default\n%%staves [(1 2) (3 4)] {(5 6) (7 8)}\nK: C\nV: 1 clef=treble name="Soprano"\nV: 2 clef=treble name="Alto"\nV: 3 clef=bass name="Tenor"\nV: 4 clef=bass name="Bass"\nV: 5 clef=treble name="Organ"\nV: 6 clef=treble\nV: 7 clef=bass\nV: 8 clef=bass\n%\nV: 1 c1 |]\nV: 2 G1 |]\nV: 3 E1 |]\nV: 4 C,1 |]\nV: 5 E1 |]\nV: 6 C1 |]\nV: 7 G,1 |]\nV: 8 C,,1 |]'];
	

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   var arrayLength = 3;
   var mySystemChange = new Array(arrayLength);
   for (var i = 0; i < mySystemChange.length; i++) {
    mySystemChange[i] = new Array(arrayLength);
  }
	mySystemChange[0]=['System change','X: 1\nT: Solist and choir\nM: none\nL: mcm_default\nK: Ddor\n%%staves 3\nV: 3 clef=treble-8\n[V: 3] "^cantor"A0 G0 A0 [D0D0] A0 G0 F0 E0 G0 A0 D0 F0 G0 E0 [D0D0] |\n%\n% system change: choir\n%%staves [1 2 3 4]\nV: 1 clef=treble \nV: 2 clef=treble\nV: 3 clef=treble-8\nV: 4 clef=bass\n[V: 1]"^choir" c1 | c1 |]\n[V: 2] E1 | F1 |]\n[V: 3] G1 | A1 |]\n[V: 4] C,1 | F,,1 |]\n%\n%%staves 3\nV: 3 clef=treble-8\n[V: 3] "^cantor" A0 G0 A0 [D0D0] A0 G0 F0 E0 G0 A0 D0 F0 G0 E0 [D0D0] |'];
	mySystemChange[1]=['System change 2','X:1\nT:Alternating treble and bass clef\nM:none\nL:mcm_default\nK:C\n%\n%first staff, treble clef\n%\n%%staves [(1 2)] \nV:1 clef=treble\nV:2 clef=treble\n[V:1] \nG1 | A1 | B1 | c1 |\n[V:2] \nE1 | F1 | D1 | C1 |\n%.........................................................................\n%second staff, bass clef\n%.........................................................................\n%%staves [(1 2)]\nV:1 clef=bass\nV:2 clef=bass\n[V:1]\nG,1 | A,1 | B,1 | C1 |\n[V:2]\nE,1 | F,1 | D,1 | C,1 |\n%.........................................................................\n%third staff, treble clef\n%.........................................................................\n%%staves [(1 2)]\nV:1 clef=treble\nV:2 clef=treble\n[V:1] \nc1 | B1 | A1 | G1 |\n[V:2] \nC1 | G1 | F1 | E1 |\n%.........................................................................\n%third staff, bass clef\n%.........................................................................\n%%staves [(1 2)]\nV:1 clef=bass\nV:2 clef=bass\n[V:1]\nC1 | B,1 | A,1 | G,1 |\n[V:2] \nC,1 | G,1 | F,1 | E,1 |\n%.........................................................................\n%and so on'];
	mySystemChange[2]=['System change 3','X: 1\nM: 4/4\nL: mcm_default\n%%staves [S A T]\nV: S name="Soprano" sname="S"\nV: A name="Alto" sname="A"\nV: T name="Tenor" sname="T"\nK: G\n%%staffnonote 0\n[V: S] G4 A4 B4 c4 |d4 c4 B4 A4 |G4 A4 B4 c4 |A2.z4 |\n[V: A] G4 G4 G4 A4 |B4 A4 G4 F4 |G4 F4 G4 A4 |F2.z4 |\n[V: T] G4 D4 G4 D4 |G4 D4 G4 D4 |G4 G4 D4 D4 |G2.z4 |\n%\n[V: S] G4 A4 B4 c4 |G4 A4 B4 c4 |G4 A4 B4 c4 |d2.z4 |\n[V: A] z1 |z1 |z1 |z1 |\n[V: T] z1 |z1 |z1 |z1 |\n%[V: S] G4 A4 B4 c4 |d4 c4 B4 A4 |G4 A4 B4 c4 |A2.z4 |\n[V: A] G4 G4 G4 A4 |B4 A4 G4 F4 |G4 F4 G4 A4 |F2.z4 |\n[V: T] G4 D4 G4 D4 |G4 D4 G4 D4 |G4 G4 D4 D4 |G2.z4 |\n%\n[V: S] G4 A4 B4 c4 |G4 A4 B4 c4|G4 A4 B4 c4 |d2.z4 |\n[V: A] z1 |z1 |z1 |z1 |\n[V: T] z1 |z1 |z1 |z1 |\n'];
	
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   var arrayLength = 3;
   var myTempo = new Array(arrayLength);
   for (var i = 0; i < myTempo.length; i++) {
    myTempo[i] = new Array(arrayLength);
  }
	myTempo[0]=['Metronome marks','X: 1\nT: Metronome marks, example 1\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\n[Q: 1/8 =60] F,8f8G,8f8 A,8f8B,8f8 C8e8 z4 | \\n[Q: 1/4 =120] c4 d4 c2 | \\n[Q: 1/2 =60] C2 D2 | C1 |] \n\nX: 2\nT: Metronome marks, example 2\nM: 6/8\nL: mcm_default\nK: C\n[K: treble]\n[Q: 3/8 =60] F,4. G4. | \\n[M: 6/4][Q: 3/4 =60] C2. D2. | C1. |]'];
	myTempo[1]=['Tempo marks','X:1\nM:4/4\nL:mcm_default\nQ: "Allegro" 1/4=120\nK:C\n[K:treble]\nc1 | d1 | e1 |]'];
	myTempo[2]=['Simulating ritardando','X:1\nM:4/4\nL:mcm_default\nQ:1/4=120\nK:C clef=treble\nC4 D4 E4 F4 | G4 [Q:1/4=110]A4  [Q:1/4=100]B4 [Q:1/4=90] G4 | c1 |]\n\n%%printtempo 0\nX:2\nT:hiding tempo marks with tag \%\%printtempo 0\nM:4/4\nL:mcm_default\nQ:1/4=120\nK:C clef=treble\nC4 D4 E4 F4 | G4 [Q:1/4=110]A4  [Q:1/4=100]B4 [Q:1/4=90] G4 | c1 |]'];
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    var arrayLength = 2;
   var myDynamics = new Array(arrayLength);
   for (var i = 0; i < myDynamics.length; i++) {
    myDynamics[i] = new Array(arrayLength);
  }
	myDynamics[0]=['Crescendo decrescendo','X: 1\nT: Dynamics (de)crescendo\nM: 3/2\nL: mcm_default\nK: C\n[K: treble]\n%Comment crescendo: !<(! before first note; !<)! before last note etc.\n%Comment decrescendo: !>(! before first note; !>)! before last note etc.\n%\n!<(!C2 D2 !<)!E2 | G2 G2 G2 | !>(!E2 D2 !>)!C2 |] '];
	myDynamics[1]=['Dynamics marks','X: 1 \nT: Dynamic marks \nM: none \nL: mcm_default \nK: C \n[K: treble] \n!pppp!c4 !ppp!c4 !pp!c4 !mp!c4 !p!c4 !mf!c4 !f!c4 !ff!c4 !fff!c4 !ffff!c4 ! \nw: !pppp! !ppp! !pp! !mp! !p! !mf! !f! !ff! !fff! !ffff! \n%\n!sfz!c4 ! !accent!c4 !\nw: !sfz! !accent!\n% \n!crescendo(!c4 !crescendo)!d4 \ \nw: !crescendo(!yourbeginnote !crescendo)!yourendnote \n%\n!diminuendo(!d4 !diminuendo)!c4 \nw: !diminuendo(!yourbeginnote !diminuendo)!yourendnote '];
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

  var arrayLength = 7;
   var myArticulationPhrasing = new Array(arrayLength);
   for (var i = 0; i < myArticulationPhrasing.length; i++) {
    myArticulationPhrasing[i] = new Array(arrayLength);
  }

	myArticulationPhrasing[0]=['Marks for phrasing','X: 1\nT: Marks for phrasing \nM: none \nL: mcm_default \nK: C \n[K: treble] \n!breath!c4 !shortphrase!c4 !mediumphrase!c4 !longphrase!c4 \nw: !breath! !shortphrase! !mediumphrase! !longphrase!'];
	myArticulationPhrasing[1]=['Marks for articulation','X:1\nT:Staccato and tenuto\nM:3/4\nL:mcm_default\nK:C clef=none stafflines=0\n.c4 .c4 .c4 | !tenuto!c2 .c4 |.c4 !tenuto!c2 | !tenuto!c2 .c4 | \n\nX:2\nT:Portato\nM:6/8\nL:mcm_default\nK:C clef=none stafflines=0\n(.c8" ".c8" ".c8) (.c8" ".c8" ".c8) |[M:4/4] .!tenuto!c4 .!tenuto!c4 .!tenuto!c4 .!tenuto!c4 | \n\nX:3\nT:Staccatissimo\nM:2/4\nL:mcm_default\nK:C clef=none stafflines=0\n!wedge!c4 !wedge!c4 | !wedge!c4 !wedge!c4 | \n\nX:4\nT:Accent\nM:4/4\nL:mcm_default\nK:C clef=none stafflines=0\n!wedge!c2 !wedge!c2 | !wedge!!accent!c4 !wedge!!accent!c4 !wedge!!accent!c4 !wedge!!accent!c4 | !accent!c2. z4 |'];
	myArticulationPhrasing[2]=['Slurs 1','X: 1\nT: Slurs\nM: none \nL: mcm_default\nK: C \n[K: treble]\nz8 ( C8E8F8 ) G2 || ( C4 (D8E8F8) G4 ) || (C8D8(E8)F8G8) A4 || '];
	myArticulationPhrasing[3]=['Slurs 2','X: 1\nT: Articulation\nM: 3/4 \nL: mcm_default \nK: D \n[K: treble] \n( F2A4) | (A,2D4) | (E4F4E4 | D2) z4 |]	\n\nX: 2 \nT: Phrasing \nM: 3/4 \nL: mcm_default \nK: D\n[K: treble] \n( F2A4 | A,2D4 | E4F4E4 | D2) z4 |]'];
	myArticulationPhrasing[4]=['Dashed slur','X: 1\nT: Dashed slur\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\n.(C4D4E4D4) '];
	myArticulationPhrasing[5]=['Dashed tie and slur','X: 1\nT: Dashed tie and slur\nM: 2/4\nL: mcm_default\nK: C\n[K: treble]\nA4 .- A4 | .(c4e8)d8|c1 |] '];
	myArticulationPhrasing[6]=['Position slur','X: 1\nT: 1. Position slur above (phrasing)\nM: 3/4\nL: mcm_default\nK: D\n[K: treble]\n%comment: force default position slur above with: (\'\n(\' F2A4 | A,2D4 | E4F4E4 | D2) z4 |]	\n\nX: 2\nT: 2. Position slur default (phrasing)\nM: 3/4\nL: mcm_default\nK: D\n[K: treble]\n(F2A4 | A,2D4 | E4F4E4 | D2) z4 |]'];

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

  var arrayLength = 6;
   var myAbbreviation = new Array(arrayLength);
   for (var i = 0; i < myAbbreviation.length; i++) {
    myAbbreviation[i] = new Array(arrayLength);
  }

	myAbbreviation[0]=['Octava Octava bassa','X: 1\nT: Octava\nM: none\nL: mcm_default\nK: C\n[K: treble]\nC4 D4 E4 F4 G4 A4 B4 !begin_8va!C4 D4 E4 F4 G4 A4 !end_8va!B4 |] \n\nX: 2\nT: Octava bassa\nM: none\nL: mcm_default\nK: C\n[K: bass]\nC4 B,4 A,4 G,4 F,4 E,4 D,4 !begin_8vabassa!C4 B,4 A,4 G,4 F,4 E,4 !end_8vabassa! D,4 |] '];
	myAbbreviation[1]=['Repetition','X: 1\nT: Repetition\nM: C\nL: mcm_default\nK: C\n|: G4 G4 E4 E4 | C4 F4 E4 D4 |[1 C2 A2 :|2 C2 G2|| c2. z4 |] '];
	myAbbreviation[2]=['Repeat measure','X: 1\nT: Repeat measure\nM: none\nL: mcm_default\nK: C clef=treble\n%\n[M: 4/4] G4 A4 B4 c4 | G4 A4 B4 c4 | G4 A4 B4 c4 | !\n[M: 4/4] G4 A4 B4 c4 | [I:repeat 1] G4 A4 B4 c4 | [I:repeat 1] G4 A4 B4 c4 |] !\n%\n[M: 4/4] G2 d2 | B2 d2 | G2 d2 | B2 d2 | c1 || !\n[M: 4/4] G2 d2 | B2 d2 | [I:repeat 2] G2 d2 | B2 d2 | c1 |] '];
	myAbbreviation[3]=['Repeat melodic pattern','X: 1\nT: Repeat melodic pattern\nM: 4/2\nL: mcm_default\nK: C clef=bass\n%\nC,8E,8G,8E,8 [I:repeat 4 3] C,8E,8G,8E,8 C,8E,8G,8E,8 C,8E,8G,8E,8 | \\\n%\nC,8F,8A,8F,8 [I:repeat 4 3] C,8F,8A,8F,8 C,8F,8A,8F,8 C,8F,8A,8F,8 '];
	myAbbreviation[4]=['Tremolo one note','X: 1\nT: Tremolo one note\nM: C\nL: mcm_default\nK: C\n[K: treble]\n"^1"z4 C16!/!c16 c16!/!C16 C8!/!c8 C8!/!c8 | \\\n%\n"^2"z4 C16!//!c16 c16!//!C16 C8!//!C8 C8!//!C8 |\n%\n"^3"z4 !/!C8 !/!C8 !/!C4 !/!c4 | !/!C2 !/!c2 | \\\n%\n"^4"z4 !//!C8 !//!C8 !//!C4 !//!c4 | !//!C2 !//!c2 |\n%\n"^5"!/!C1 | !/!c1 | !//!C1 | !//!c1 '];
	myAbbreviation[5]=['Tremolo two notes','X: 1\nT: Tremolo\nM: none\nL: mcm_default\nK: C\n[K: treble]\nC8!trem1!c8 C4!trem2!c4 C2!trem3!c2 C4!trem4!c4 '];


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

 var arrayLength = 4;
   var myEmbellishments = new Array(arrayLength);
   for (var i = 0; i < myEmbellishments.length; i++) {
    myEmbellishments[i] = new Array(arrayLength);
  }

	myEmbellishments[0]=['Arpeggio','X: 1\nT: Arpeggio\nM: none\nL: mcm_default\nK: C\n[K: treble]\n!arpeggio![C4E4G4c4]\nw: !arpeggio!'];
	myEmbellishments[1]=['Mordent','X: 1\nT: Ornament mordent\nM: none\nL: mcm_default\nK: C\n[K: treble]\n!lowermordent!c4 !mordent!c4 !pralltriller!c4 !uppermordent!c4 !\nw: !lowermordent! !mordent! !pralltriller! !uppermordent!'];
	myEmbellishments[2]=['Grace notes','X: 1\nT: Grace notes: note the unexpected coding!\nM: C\nL: mcm_default\nK: C\n%%graceslurs 0\n{B8}A4 {B16}A4 {B32}A4 {B64}A4 | {/B}A1 |]	\n\nX: 2\n T: Grace notes (coding is what we expect)\nM: C\nL: mcm_default\nK: C\n%%graceslurs 0\n{c8B8}A4 {c16B16}A4 {c32B32}A4 |\ \\n%\n{a8g8f8 e8d8c8B4}A1 | {(A16B16)}c4 z4 {(G16A16B16}c4) z4 |\\n%\n(c2{B16A16)G16} {(G32A32B32) (G32A32B32)}c2 |]'];
	myEmbellishments[3]=['Turns and trills','X: 1\nT: Turns and trills\nM: none\nL: mcm_default\nK: C\n[K: treble]\n!turn!c4 !turnx!c4 !invertedturn!c4 !invertedturnx!c4 !trill!c4 !trill(!c4 | !trill)!c2|] !\nw: !turn! !turnx! !invertedturn! !invertedturnx! !trill! !trill(! !trill)!'];

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


 var arrayLength = 10;
   var myText = new Array(arrayLength);
   for (var i = 0; i < myText.length; i++) {
    myText[i] = new Array(arrayLength);
  }

	myText[0]=['Text formatting 1','X:1\nM:none\nL:mcm_default\nK:C clef=treble\n%%textfont Helvetica 16\n%%begintext obeylines\n\'%%begintext [option] .... %%endtext\'\nCode font: \'%%textfont Helvetica size\'\nExample 1: option \'obeylines\': keep lines as they are (default)\n\nMC Musiceditor is a very user friendly, script based music notation editor which makes professional\nscores without requiring specific knowledge (other than musical basics)! It is simple to use and can\ncreate music scores from basic melodies to a complex symphony score. For a first impression read\na starting tutorial (PDF) on the free MC Musiceditor.\n%%endtext'];
	myText[1]=['Text formatting 2','X:1\nM:none\nL:mcm_default\nK:C clef=treble\n%%textfont Helvetica 14\n%%begintext align\n\nExample 2: option \'align\' or \'justify\': justify the lines\n\nMC Musiceditor is a very user friendly, script based music notation editor which makes professional\nscores without requiring specific knowledge (other than musical basics)! It is simple to use and can\ncreate music scores from basic melodies to a complex symphony score. For a first impression read\na starting tutorial (PDF) on the free MC Musiceditor.\n%%endtext'];
	myText[2]=['Text formatting 3','X:1\nM:none\nL:mcm_default\nK:C clef=treble\n%%textfont Times-Roman 12\n%%begintext fill\n\nExample 3: option \'ragged\' or \'fill\': fill the lines\n\nMC Musiceditor is a very user friendly, script based music notation editor which makes professional\nscores without requiring specific knowledge (other than musical basics)! It is simple to use and can\ncreate music scores from basic melodies to a complex symphony score. For a first impression read\na starting tutorial (PDF) on the free MC Musiceditor.\n%%endtext'];
	myText[3]=['Text formatting 4','X:1\nM:none\nL:mcm_default\nK:C clef=treble\n%%textfont Helvetica 10\n%%begintext center\n\nExample 4: option \'center\': center the lines\n\nMC Musiceditor is a very user friendly, script based music notation editor which makes professional\nscores without requiring specific knowledge (other than musical basics)! It is simple to use and can\ncreate music scores from basic melodies to a complex symphony score. For a first impression read\na starting tutorial (PDF) on the free MC Musiceditor.\n%%endtext'];
	myText[4]=['Text formatting 5','X:1\nM:none\nL:mcm_default\nK:C clef=treble\n%%textfont Bookman-Light 12\n%%begintext right\n\nExample 5: option \'right\': align the right side\n\nMC Musiceditor is a very user friendly, script based music notation editor which makes professional\nscores without requiring specific knowledge (other than musical basics)! It is simple to use and can\ncreate music scores from basic melodies to a complex symphony score. For a first impression read\na starting tutorial (PDF) on the free MC Musiceditor.\n%%endtext'];
	myText[5]=['Notes in document','%%textfont Helvetica-Bold 20\n\n%%begintext align\nMissed-beat syncopation (notes in a text)\n%%endtext\n\n%%textfont Helvetica 14\n%%begintext align\nSyncopation itself may look as simple as follows, involving the addition of a rest:\n%%endtext\n\nX:1\nM:4/4\nL:mcm_default\nK:C clef=perc stafflines=1\nV: 1 stem=up\nB4 B4 z4 B4\n\n%%begintext align\n\nThis is an example of the missed beat type of syncopation, in which a rest (silence) is substituted for an expected note. This can occur on any beat in a measure. The natural stress of the meter has been disrupted ONE-two-(three)-FOUR, which is strange, because we want to keep hearing that nonexistent quarter note that would carry the downbeat in the middle of the measure. This type of syncopation creates tension in a musical piece (source: http://en.wikipedia.org/wiki/Syncopation).\n%%endtext'];
	myText[6]=['Defining fonts and using short cuts','%%setfont-1 Times-Roman 20\n%%setfont-2 Times-Italic 26\n%%setfont-3 Helvetica-Bold 18\n%%setfont-4 AvantGarde-Demi 24\nX: 1\nL: mcm_default\nM: 2/4\nK: C\n%%text Hello. This is the default font,\n%%text $1this is font 1,\n%%text $2this is font 2,\n%%text $3this is font 3,\n%%text $4this is font 4,\n%%text $4and now\n%%text $0let\'s go back to default font.\n%\n%\n%\nC8D8 E8F8 | G8A8 B8c8 | c8d8 e8f8 | g8a8 b8c\'8 |] W: It also works in $3W: fields!\nW: Its useful to emphasise $0some parts.\n%\n%%begintext align\n\n\n$2...insert here your text...\n%%endtext'];
	myText[7]=['Equal sign in music example','%%titlefont Helvetica 20\n%%textfont Helvetica 14\nX:1\nT: \'=\' sign in a music example\nM:none\nL:mcm_default\nK:C clef=none stafflines=0\nV: 1 stem=up\n%\n%%begintext align\nUse\n to notate a \'=\' sign in a music example.\n must be followed by two numbers X and Y, separated by\na comma. The annotation will be printed from the centre of the note head (the lowest note, if in a chord),\nwith an offset of X horizontal and Y vertical points.\n\n%%endtext\n%\nc1 "\n-70,-1.7="(3c2c2c2 |\\n%\nc2 "\n-60,-1.7="(3c4c4c4\n%\nc4 "\n-70,-1.7="(3c8c8c8 |\\n%\nc4. "\n-50,-1.7="(2c8c8 "\n-40,-1.7="(2:3:4c16c16!beambr1!c16c16\n%\nc1 "\n-70,-1.7="(10c8c8c8c8c8c8c8c8c8c8 "\n-15,-1.7="(5c8c8c8c8c8 (5c8c8c8c8c8'];
	myText[8]=['Worksheet','%%titlefont Helvetica-Bold 20\n%%textfont Helvetica 14\n%%pagewidth 21cm\n%%leftmargin 1cm\n%%rightmargin 1cm\nX: 1\nT:Exercises 1.10: rhythmic notation\nL: mcm_default\nM:none\nK: C clef=none stafflines=1\n%%text Task: notate the rhythm in 3/4 on the left, in 3/2 in the middle column and 3/8 in the right column.\n%%sep 0.5 0.5 19cm\n%%multicol start\n%%rightmargin 15cm\n%%begintext justify\nTime signature 3/4\n%%endtext\n"1"B4. B8B8B8\n"2"B4. B16B16 B8B8\n"3"B4. (3B16B16B16 B8B8\n%\n%\n%%multicol new\n%%leftmargin 8cm\n%%rightmargin 9cm\n%%begintext justify\nTime signature 3/2\n%%endtext\n"1"x4 x4 x4\n"2"x4 x4 x4\n"3"x4 x4 x4\n%\n%%multicol new\n%%leftmargin 15cm\n%%rightmargin 2cm\n%%begintext justify\nTime signature 3/8\n%%endtext\n"1"x4 x4 x4\n"2"x4 x4 x4\n"3"x4 x4 x4\n%%multicol end'];
	myText[9]=['Tutorial','%%titlefont Helvetica-Bold 20\n%%textfont Helvetica 14\n%%pagewidth 21cm\n%%leftmargin 1cm\n%%rightmargin 1cm\nX: 1\nT:Tutorial: scale\nL: mcm_default\nM:none\nK: C\n%%text Question: what is a musical scale?\n%%text Answer: a series of notes differing in pitch according to a specific scheme (usually within an octave)\n%%text\n%%text Example: scale of C major\nC1 D1 E1 F1 G1 A1 B1 c1\n%\n%%begintext justify\nC major is an example of a so called diatonic scale - a scale with eight notes in an octave; all but two are\nseparated by whole tones. A major scale may be seen as two identical tetrachords separated by a whole\ntone. Each tetrachord consists of two whole steps followed by a half step.\n%%endtext\n%\n%\n%%sep 0.5 0.5 19cm\n%%multicol start\n%%rightmargin 12cm\n%%begintext justify\n%%First tetrachord\n%%endtext\nC1 "\n-50,-10whole" D1 "\n-50,-13whole"E1 "\n-50,-16half"F1\n%\n%\n%%multicol new\n%%leftmargin 12cm\n%%rightmargin 1cm\n%%begintext justify\n%%Second tetrachord\n%%endtext\nG1 "\n-45,-22\2 "A1 "\n-37,-25\2 "B1 "\n-35,-28\1 "c1\n%%multicol end\n%%sep 0.5 0.5 19cm\n%\n%%text As we already said, a major scale may be seen as two identical tetrachords separated by a whole tone.\n!begin_hbr!C1 D1 E1 !end_hbr!F1 "\n-70,-38whole step"!begin_hbr!G1 A1 B1 !end_hbr!c1'];
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 
   var arrayLength = 7;
   var myLyrics = new Array(arrayLength);
   for (var i = 0; i < myLyrics.length; i++) {
    myLyrics[i] = new Array(arrayLength);
  }

	myLyrics[0]=['Lyrics','X: 1\nT: Lyrics (syllabic)\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\nC2 D2 | E1 |]\nw: Hel-lo world!	 	\n\nX: 2\nT: Lyrics (melismatic)\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\nC4 A4 G4 F4 | E1 |]\nw: Hel---lo world!	 	\n\n%%vocalfont Helvetica 14\nX: 3\nT: Lyrics, textfont Helvetica (melismatic)\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\nC4 A4 G4 F4 | E1 |]\nw: Hel---lo world!'];
	myLyrics[1]=['Skip in lyric mode','X: 1\nT: Skips in lyric mode\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\nA1 | A1 || A4 B4 c4 d4 |]\nw: * bla A * * gap '];
	myLyrics[2]=['Skip a measure','X:1\nT:Lyrics:skipping a measure with the character |\nM:C|\nL:mcm_default\nK:C\n[K:treble]\nC1 | z1 | D1 | z1 | E1 | z1 | G1 |]\nw:This | is | a | song '];
	myLyrics[3]=['Show no lyrics','%%musiconly 1\nX: 1\nT: Show no lyrics\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\nC2 D2 | E1 |]\nw: Hel-lo world!'];
	myLyrics[4]=['Couplets','%%vocalfont Times-Bold 14\n%%wordsfont Times-Bold 12\nX: 1\nT: Couplets\nM: none\nL: mcm_default\nK: D\n[K: treble]\nF4 D4 A4 B4 G4. F8 F2 d4 c4 B4 c4 d4 c4 B4. A8 A2 |\nw: Mor-gen-glanz der E-wig-keit, Licht vom un-er-schpf-ten Lich--te,\nF4 D4 A4 B4 G4. F8 F2 d4 c4 B4 c4 d4 c4 B4. A8 A2 |\nw: Schick uns die-se Mor-gen-zeit Dei-ne Strah-len zu Ge-sich--te\nA4 A4 B4 A4 G4 F8E8 E2 F4E4 D1 |]\nw: Und ver-treib durch dei-ne-- Macht Uns-re Nacht!\n%\nW: %comment: break\nW: 2. Die bewlkte Finsternis Me deinem Glanz entfliehen,\nW: Die durch Adams Apfelbi ber uns sich mte ziehen,\nW: Da wir, Herr, durch deinen Schein Selig sein.\nW: %comment: break\nW: 3. Deiner Gte Morgentau Fall\' auf unser matt Gewien,\nW: La die drre Lebensau Lauter sen Trost genieen\nW: Und erquick uns, deine Schar, Immerdar!'];
	myLyrics[5]=['Character tilde','%%titlefont Helvetica 20\n%%vocalfont Helvetica 10\n%%measurefont Helvetica-Oblique 10\n%%textfont Helvetica 12\nX:1\nT:Use of character ~ and insertion of blank text line\nM:none\nL:mcm_default\nK:C\n[K:treble]\n%%text\n%%text Some seventh chords (roman numerals)\n%%endtext\n%%barnumbers 1\n[^G1A1^c1e1] x1 | [D1E1^G1B1] x1 |]\nw:~\nw:E:~IV2 A:~V2 E:~VI7'];
	myLyrics[6]=['Special characters','%%titleleft 1\nX:1\nT: Special characters\nM:2/2\nL:mcm_default\nK:C clef=treble\nC1 | D1 | E1 | F1 |]\nw: \`a \`e \'a \'e\nw: \"U \"u \"e \"o\nw: \\~N \\~n * *\nw: \ss \/o \/O \aa \AA\nw: \^O \^o \cc \cC\nw: \AE \OE \ae \oe\nw: \\\\*a\\\\* | \\-b | \100(ASCII~100) | \041(ASCII~041) |'];	

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   var arrayLength = 5;
   var myAnnotationText = new Array(arrayLength);
   for (var i = 0; i < myAnnotationText.length; i++) {
    myAnnotationText[i] = new Array(arrayLength);
  }

	myAnnotationText[0]=['Annotated chords','X: 1\nT: Annotated chords\nM: none\nL: mcm_default\nK: C\n%%staves [1 2]\n[V: 1]\n[K: treble]\n"^Dom7"[G1B1d1f1] | "_Dom7"[G1B1d1f1] | [B1f1] | [D1G1] | "new label" [D1G1] |]\n[V: 2]\n[K: bass]\nx1 |x1 | "_V7"[G,1D1] |"_V6"[B,,1G,1] |"_V;3"[B,,1G,1] |] '];
	myAnnotationText[1]=['Annotated melody','X:1\nT: Annotated melody\nM: none\nL: mcm_default\nK: C\n[K: treble]\n^C1 ^D1 ^E1 ^F1 ^G1 ^A1 ^B1 !\nw: cis dis eis fis gis ais bis\n"_c#"^C1 "_d#"^D1 "_e#"^E1 "_f#"^F1 "_g#"^G1 "_a#"^A1 "_b#"^B1'];
	myAnnotationText[2]=['Musica ficta','X: 1\nT: Musica ficta (dorian mode)\nM: C|\nL: mcm_default\nK: C\n%%staves 1 2\nV: 1 clef=treble\nD4 A4 "^\\b"B4 A4 | c4 "^\\="B4 A4 G4 | A4 d2 "^\\#"c4 | d1 |]\n%\nV: 2 clef=bass\nD,1 | E,2 F,4 G,4 | F,2 E,2 | D,1 |] '];
	myAnnotationText[3]=['Metronome marks','X: 1\nT: Metronome marks, example 1\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\n[Q: 1/8 =60] F,8f8G,8f8 A,8f8B,8f8 C8e8 z4 | \\n[Q: 1/4 =120] c4 d4 c2 | \\n[Q: 1/2 =60] C2 D2 | C1 |] \n\nX: 2\nT: Metronome marks, example 2\nM: 6/8\nL: mcm_default\nK: C\n[K: treble]\n[Q: 3/8 =60] F,4. G4. | \\n[M: 6/4][Q: 3/4 =60] C2. D2. | C1. |]'];	
	myAnnotationText[4]=['Fingerings to a score','X: 1\nT: Fingerings to a score\nM: none\nL: mcm_default\nK: C\n"^1"c1 x4 "^2"d1 x4 "^3"e1 | \\\n%\n%chords\n"^5;3;1"[C1E1G1] | \\\n%\n%fingering below and above chords\n"_2;1""^5;3"[C1E1G1B1] |'];
 /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 
   var arrayLength = 8;
   var myAnnotationGraphics = new Array(arrayLength);
   for (var i = 0; i < myAnnotationGraphics.length; i++) {
    myAnnotationGraphics[i] = new Array(arrayLength);
  }

	myAnnotationGraphics[0]=['Insert an EPS-image','X: 1\nT: Insertion of EPS-image\nM: 2/2\nL: mcm_default\nK: Cmin\n[K: alto]\nC2 E2 | G2 A2 | =B,2 z4 G4 | ^F2 =F2 |=E2 _E2 - | E4 D4 _D4 C4 | =B,4 =A,8G,8 C4 F4 | E2 !trill!D2 |\n%the imagefile Bachs_Seal.eps should be saved in the directory of MCMusiceditor\n%%EPS Bachs_Seal.eps \n%\n%You can make EPS-files with the paint programm DRAW of the free office suite OpenOffice.org\n%Visit www.openoffice.org '];
	myAnnotationGraphics[1]=['Annotated musical example','%%begintext justify\nExample: music example annotated\n\nDuring his anticipated visit to Frederick\'s palace in Potsdam, Bach, who was well known for his skill at improvising, received from Frederick a long and complex musical figure to improvise a three-voice fugue. Frederick, then, challenged Bach to make that into a six-voice fugue. The public present thought that just a malicious caprice by the king, intent upon humiliating philosophers and artists. Bach answered he would need to work the score and send it to the king afterwards. He then returned to Leipzig to write out the Thema Regium ("theme of the king"):\n%%endtext\n%\nX: 1\nM: 2/2\nL: mcm_default\nK: Cmin\n[K: alto]\nC2 E2 | G2 A2 | =B,2 z4 G4 | ^F2 =F2 |=E2 _E2 - | E4 D4 _D4 C4 | =B,4 =A,8G,8 C4 F4 | E2 !trill!D2 |\n%\n%%begintext justify\n\nTwo months after the meeting, Bach published a set of pieces based on this theme which we now know as The Musical Offering. Bach inscribed the piece "Regis Iussu Cantio Et Reliqua Canonica Arte Resoluta" (the theme given by the king, with additions, resolved in the canonic style), the first letters of which spell out the word ricercar (an older name for fugue).\n%%endtext'];
	myAnnotationGraphics[2]=['Position marks','X: 1\nT: Position marks\nM: none\nL: mcm_default\nK: C\n[K: treble]\n%Comment: pmA...pmZ and pmRA...pmRZ\n!pmA!y y !pmB!y y !pmC!y y \\\n%\n!pmRA!y y !pmRB!y y !pmRC!y y  '];
	myAnnotationGraphics[3]=['Colored notes','X: 1\nT: Colored notes\nM: 2/4\nL: mcm_default\nK: C\n!head-red!C8B,8 !head-blue!D8^D8 | !head-green!_E8F8 !head-red!G8_A8 | c2 |]\n\nShort notation\n\nX: 1\nT: Colored notes\nM: 2/4\nL: mcm_default\nU:r=!head-red!\nU:s=!head-blue!\nU:t=!head-green!\nK: C\nrC8B,8 sD8^D8 | t_E8F8 rG8_A8 | c2 |]'];
	myAnnotationGraphics[4]=['Circles and notes','X: 1\nT: Circles & notes\nM: none\nL: mcm_default\nK: C\n[K: treble]\n%available radius circle 10 - 15\n!arc10!C1 !arc11!C1 !arc12!C1 !arc13!C1 !arc14!C1 !arc15!C1'];
	myAnnotationGraphics[5]=['Vertical bracket','X: 1\nT: Bracket (vertical)\nM: none\nL: mcm_default\nK: C\n[K: treble]\n!v_br!C1 !v_br![C1e1] !v_br![C1G1e1c\'1] x1 [K: bass] !v_br![C,,1G,,1E,1C1]'];
	myAnnotationGraphics[6]=['Horizontal bracket','X: 1\nT: Bracket (horizontal)\nM: none\nL: mcm_default\nK: C\n[K: treble]\n%!begin_hbr! before the first note and !end_hbr! before the last note\n!begin_hbr!C4 D4 E4 F4 !end_hbr!G4 c4 d4 e4 f4 g4 |]'];
	myAnnotationGraphics[7]=['Dashed horizontal bracket','X: 1\nT: Bracket dashed (horizontal)\nM: none\nL: mcm_default\nK: C\n[K: treble]\n%!begin_hbr_d! before the first note and !end_hbr_d! before the last note\n!begin_hbr_d!C4 D4 E4 F4 !end_hbr_d!G4 c4 d4 e4 f4 g4 |]'];	

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   var arrayLength = 1;
   var myScaleAndMargin = new Array(arrayLength);
   for (var i = 0; i < myScaleAndMargin.length; i++) {
    myScaleAndMargin[i] = new Array(arrayLength);
  }
	myScaleAndMargin[0]=['Scale and margin','X: 1\nT: Scale and margin\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\nC2D2 E2F2 | !\n%\n%%scale 0.6\n%%leftmargin 7cm\n%%rightmargin 11cm\nC2D2 E2F2 | !\n%\n%%scale 1.2\n%%leftmargin 11cm\n%%rightmargin 4cm\nC2D2 E2F2| '];

 /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 
   var arrayLength = 7;
   var mySchenkerGraphs = new Array(arrayLength);
   for (var i = 0; i < mySchenkerGraphs.length; i++) {
    mySchenkerGraphs[i] = new Array(arrayLength);
  }

	mySchenkerGraphs[0]=['Schenker Form','X:1\nT:Schenker musical form\nM:none\nL:mcm_default\nK:C \n%%staves (1 2)\n%%begintext\nA\' A\'\' B\' B\'\' (= A\', A\'\')\n%%endtext\nV: 1 clef=bass stem=down\n!head-open!C,8y75!head-open!G,8-!beamon!:||:x8!head-open!C,8!head-open!G,8!head-open!C,8\n%\nd: "_C:I" "_V.............." "_I" "_V" "_I"\n%\n%stemless note G\nV: 2 clef=bass\nx8x8G,0x8x8'];
	mySchenkerGraphs[1]=['Schenker Ursatz','X:1\nT:Schenker Ursatz 1\nM:none\nL:mcm_default\nK:C \n%%staves 1 2\nV: 1 stem=up\n"\^;3"!head-open!e8"\^;2"!head-open!d8"\^;1"!head-open!c8\nV: 2 clef=bass\n!head-open!C,8!head-open!G,8!head-open!C,8\nd: "_I" "_V" "_I"\n\nX:2\nT:Schenker Ursatz 2\nM:none\nL:mcm_default\nK:C \n%%staves 1 2\n%a userdefined abbreviation U:one letter head-open\nU:O head-open\nV: 1 stem=up\n"\^;3"Oe8"\^;2"Od8"\^;1"Oc8\nV: 2 clef=bass\nOC,8OG,8OC,8\nd: "_I" "_V" "_I"'];
	mySchenkerGraphs[2]=['Schenker Reduction1','X:1\nT:Schenkerian analysis Oswald Jonas\nT:Nocturne op. 9/2 Chopin\nM:none\nL:mcm_default\nK:Cmin \nV:1 clef=treble\nV:2 clef=treble\nV:3 clef=bass\n%%staves [(1 2) 3]\nV:1\ng8x8x8!beamon!|y100!beamon!|f8x8x8!beamon!|x8e8\nV:2\ng8f8e8	 |y100 |f8e8x8!beamon!|d8x8\nV:3\nE,,8x8x8!beamon!|y100!beamon!|B,,,8x8x8!beamon!|x8E,,8	 	 \n\nX:2\nT:Schenkerian analysis Oswald Jonas\nT: Nocturne op. 9/2 Chopin\nM:none\nL:mcm_default\nK:Cmin \nV:1 clef=treble\nV:2 clef=treble\nV:3 clef=treble\nV:4 clef=bass\n%%staves [(1 2 3) 4]\nV:1\ng8x8x8x0x0 a8x8x8x8x8x8e8\nV:2 \nx8x8x8 g0 [=e0b0] x8 g0 f0 - f0 x8e0 -e0x8x8\nV:3 \ng8f8e8 x0 x0 f8x8x8x0e8x8d8x8\nV:4 \nE,,0x8x8x0 D,,0 C,,0 F,,0 x8B,,0 =B,,0 x0 x0C,0 =A,,0 x0 x0_B,,0 E,,0'];
  mySchenkerGraphs[3]=['Schenker Reduction2','X:1\nT:Schenker: reduction 2\nT: Haydn Symphony in D major, III first 8 bars (Forte/Gilbert)\nM:none\nL: mcm_default\nK:D\nV:1 clef=treble\nV:2 clef=treble\n%%staves 1 2\nV:1\n(d0 f0 (a4) ("N"b0) (a4) ("N"^g0) (a4) ("N"b0) a4)\\\n(d0 (f0 "P"g4)) "P"f4 (e4 b0) (\' "N"c0 x8x16d4) |]\nV:2\nx0 x0 D4-x0x4x0x4x0D4x0x0 B,4 A,4 (G,4 E,0) A,4 D4 |]'];		
	mySchenkerGraphs[4]=['Schenker Reduction3','X:1\nT:Schenker: reduction 3\nT: Mozart Piano Sonata, K. 457 first 4 bars (Salzer)\nM:none\nL: mcm_default\nK:Cmin\nV:1 clef=treble stem=up\nV:2 clef=treble\n%%staves [1 2]\nV:1\n(g2 e0 c0) (=B0 "N"a4) .(\'g4 f0 (e0 g2)) |]\nV:2\n!begin_hbr![C2E2] x0 x0 "_N"[D4F4] x0 "_N"[=B,4D4] x0 !end_hbr![C2G2] x0|]\n%%begintext\nI\n%%endtext'];
	mySchenkerGraphs[5]=['Schenker Reduction4','X:1\nT:Schenker: reduction 4 by Felix Salzer\nT:Byrd: Sacerdotis Domini\nM:none\nL: mcm_default\nK:C\nV:1 clef=treble stem=up\nV:2 clef=treble\nV:3 clef=bass stem=down\n%%staves [(1 2) 3]\nV:1\nB2 d4 - d0 c4 - c0 B4 - B0 (\'^F0 G0 [^F2A2]) G2 |]\nV:2\nD1\nV:3\nG,2 - "5"G,4 "8"D,0 "5"F,4 "8"C,0 "5"E,4 "8"B,,0 D,0 - D,2 x0 G,,2 |]\nw:I_______V I'];
	mySchenkerGraphs[6]=['Schenker Reduction5','X:1\nT: Schenker: reduction 5\nT: Mozart, Symphony g-minor \nM:none\nL: mcm_default\nK:C\nV:1 clef=treble\nV:2 clef=treble\nV:3 clef=treble\n%%staves [(1 2 3)]\nV:1\n"m. 1"d1 - "44"d1 - "153"d1 - "166 Reprise"d1\nV:2\n[G0B0]x4x4x4x8x16 [F0B0]x4x4x4x8x16 ^F0x4x4x4x8x16 [G0B0]\nV:3\nG,1 B,1 D1 G,1\nw: I III V I'];
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////	

   var arrayLength = 14;
   var myMiscellaneous = new Array(arrayLength);
   for (var i = 0; i < myMiscellaneous.length; i++) {
    myMiscellaneous[i] = new Array(arrayLength);
  }

	myMiscellaneous[0]=['Spacing','X: 1\nT: No extra spacing (default)\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\nC4 D4 E4 F4 | G2 C2 |]	\n\nX: 2\nT: Spacing with y points\nM: 4/4\nL: mcm_default\nK: C\n[K: treble]\n%The character y represents spacing:\n%y10 denotes a width of 10 points. The default is 20 points.\nC4 y10 D4 y20 E4 y30 F4 | G2 y40 C2 |]'];
	myMiscellaneous[1]=['Invisible rests','X: 1\nT: No invisible rests (theoretically correct score)\nM: 4/4\nL: mcm_default\nK: C\n%%staves [(1 2)]\n[V: 1]\n[K: treble]\nC4 D4 E4 F4 | G4. A8 G2 |]\n[V: 2]\n[K: treble]\nC4 D4 E4 F4 | G4. F8 E2 |]	\n\nX: 2\nT: Invisible rests (the same score with a better look)\nM: 4/4\nL: mcm_default\nK: C\n%%staves [(1 2)]\n[V: 1]\n[K: treble]\nC4 D4 E4 F4 | G4. A8 G2 |]\n[V: 2]\n[K: treble]\n%x1 denotes an invisible rest of the length of a whole note\nx1 | G4. F8 E2 |]'];
	myMiscellaneous[2]=['Barnumbers each bar','X: 1\nT: Barnumbers (each bar)\nM: 4/4\nL: mcm_default\nK: C\n%%measurenb 1\n[K: treble]\nC4 C4 D4 D4 | E4 F4 G2 | ! c4 B4 A4 B4 | G2 G2 | !\nC4 C4 D4 D4 | E4 F4 G2 | ! F4 E4 D4 E4 | C2 C2 |]'];
	myMiscellaneous[3]=['Barnumbers each system','X: 1\nT: Barnumbers (each system)\nM: 4/4\nL: mcm_default\nK: C\n%%measurenb 0\n[K: treble]\nC4 C4 D4 D4 | E4 F4 G2 | ! c4 B4 A4 B4 | G2 G2 | !\nC4 C4 D4 D4 | E4 F4 G2 | ! F4 E4 D4 E4 | C2 C2 |]'];
	myMiscellaneous[4]=['Musical signs','X: 1\nT: Musical signs\nM: none\nL: mcm_default\nK: C\n[K: treble]\n!segno!c4 !fine!c4 !coda!c4 !\nw: !segno! !fine! !coda!\n%\n!roll!c4 !snap!c4 !thumb!c4 !open!c4 !plus!c4\nw: !roll! !snap! !thumb! !open! !plus!\n%\n!downbow!c4 !upbow!c4\nw: !downbow! !upbow!'];				
	myMiscellaneous[5]=['Comments','X: 1\nT: Use the \% symbol for comments\nM: 4/4\nL: mcm_default\nK: C\n% after the character % you can include some invisible comment\n% comment 1\n% comment 2\nC1 | D1 | E1 |]'];
	myMiscellaneous[6]=['Linebreak','X: 1\nT: Linebreak\nM: 4/4\nL: mcm_default\nK: C\n% linebreak with exclamation mark\nC1 | D1 | E1 !\nE1 | D1 | C1'];
	myMiscellaneous[7]=['Avoid linebreak','X: 1\nT: Avoid linebreak\nM: 4/4\nL: mcm_default\nK: C\n% avoid a linebreak with backslash \\\nC1 | D1 | E1 \\\nE1 | D1 | C1'];
	myMiscellaneous[8]=['Align title and composername','%%titleleft 1\n%Description: output the title on the left (instead of centered: default 0).\n%\n%%aligncomposer -1\n%Description: tell where to display the composer field. A negative value means \'on the left\', 0 means \'center\', and a positive value (default) means \'on the right\'.\n%\nX:1\nT:Dux of fugue BWV 545\nC:J.S. Bach\nM:C|\nL: mcm_default\nK:C clef=treble\nC2 D2 | E2 F2 - | F4 E4 D4 G4 | E4 D8E8 C4 c4-| '];
	myMiscellaneous[9]=['Header and footer','%%headerfont Times-Italic 8\n%%header "My header	 $D"\n%%footerfont Times-Roman 8\n%%footer "$D	 $P"\n%%begintext obeylines\n\nCode to use in header or footer\n- \'$d\' is the date and time of the last modification of the current ABC input file,\n- \'$D\' is the current date and time,\n- \'$P\' is the current page number,\n- \'$P0\' and \'$P1\' are also the page number, but only when this one is even (\'0\') or odd (\'1\').\n\nUse TABs between the fields of header and footer.\n%%endtext\n%\n%\nX:1\nT:My tune\n%C:composer\nM:none\nL:mcm_default\nK:C clef=treble\nc1 D1'];
	myMiscellaneous[10]=['Sustaining Pedal','X:1\nM:3/4\nL:mcm_default\nK:C clef=bass\n!ped!G,4[CE]4!ped-end![CE]4 |!ped!G,4[CE]4!ped-end![CE]4 |\n'];
	myMiscellaneous[11]=['Drum section1','X:1\nM:4/4\nL:mcm_default\nK:C\n%%staves (1 2)\nV:1 clef=perc stem=up\n^e8^e8 ^e8^e8 ^e8^e8 ^e8^e8\nV:2 clef=perc stem=down\nF4 c4 F4 c4\n']; 
  myMiscellaneous[12]=['Drum section2','X:1\nT: Drumsection in MCM\nM:2/4\nL: mcm_default\nK:C\n%%MIDI drummap ^g 42 %Closed Hi Hat\n%%MIDI drummap F 36  %Bass Drum 1\n%%MIDI drummap c 38  %Acoustic Snare\nV:1 clef=perc\nV:2 clef=perc\nV:3 clef=perc\n%%staves {1 (2 3)]\nV:1\n%hi-hat\n%%MIDI channel 10\n^g8^g8^g8^g8 | ^g8^g8^g8^g8 | ^g8^g8^g8^g8 | ^g8^g8^g8^g8 :|]\nV:2\n%basdrum\n%%MIDI channel 10\nF4 x4 | F4 x4 | F4 x4 | F4 x4 :|]\nV:3\n%snaredrum\n%%MIDI channel 10\nx4 c4 | x4 c4 | x4 c4 | x4 c4 :|]\n'];
  myMiscellaneous[13]=['Mute voice','%%begintext obeylines\nX:1\nT: Muting Voice 2\nM:4/4\nL: mcm_default\nV:1 clef=treble\nV:2 clef=bass\n%%MIDI control 7 0\n%%staves [1 2]\nK:C\nV:1\nC2 D2 | C1 |]\nV:2\nC,2 G,2 | C,1 |]\n\nNow only Voice 1 will be heard due to %%MIDI control 7 0 after V:2 clef=bass\n\nX:2\nT:Muting Voice 1\nM:4/4\nL: mcm_default\nV:1 clef=treble\n%%MIDI control 7 0\nV:2 clef=bass\n%%staves [1 2]\nK:C\nV:1\nC2 D2 | C1 |]\nV:2\nC,2 G,2 | C,1 |]\n\nNow only Voice 2 will be heard due to %%MIDI control 7 0 after V:1 clef=treble\n%%endtext'];	

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		
function addOption_list(selectbox){
	for (var i=0; i < allCategories.length; i++){
		addOption(document.drop_list.allCategories_list, allCategories[i], allCategories[i]);
	}
}

function SelectSubCat(selectbox){

	removeAllOptions(document.drop_list.SubCat);
	addOption(document.drop_list.SubCat, "Select Code Snippet", "", "");

	var help = window["my" + document.drop_list.allCategories_list.value];	
	
	for (var i=0; i < help.length; i++){
			addOption(document.drop_list.SubCat, help[i][0], help[i][0]);
	}
	
}

function addOption(selectbox, text, value) {
	var optn = document.createElement("OPTION");
		optn.text = text;
		optn.value = value;
			selectbox.options.add(optn);
}

function insertTxt() {

	var help = window["my" + document.drop_list.allCategories_list.value];

	for (var i=0; i < help.length; i++){
		if (document.drop_list.SubCat.value == help[i][0]) 
		{
		 	 document.drop_list.outputtext.value = help[i][1];
			 imgName = help[i][0].replace(/\s+/gi, "-");
			 imgName = imgName.toLowerCase();
		 	 document["loadImage"].src = "img/" + imgName + ".png";			 
		}
	}	
		
}

		//clears all inputdata
function removeAllOptions(selectbox) {		
		//clears the textarea
	document.drop_list.outputtext.value = '';
		//removes the image shown
	document["loadImage"].src = noImage.src
		//removes all items from the "select code snippet menu"
	for (var i = selectbox.options.length - 1; i >= 0; i--) {
		selectbox.remove(i);
	}
}
