/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot;

import com.group_finity.mascot.Main;
import com.group_finity.mascot.Manager;
import com.group_finity.mascot.NativeFactory;
import com.group_finity.mascot.behavior.Behavior;
import com.group_finity.mascot.environment.MascotEnvironment;
import com.group_finity.mascot.exception.CantBeAliveException;
import com.group_finity.mascot.image.MascotImage;
import com.group_finity.mascot.image.TranslucentWindow;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class Mascot {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(Mascot.class.getName());
    private static AtomicInteger lastId = new AtomicInteger();
    private static boolean showSystemTrayMenu = false;
    private final int id;
    private final TranslucentWindow window = NativeFactory.getInstance().newTransparentWindow();
    private Manager manager = null;
    private Point anchor = new Point(0, 0);
    private MascotImage image = null;
    private boolean lookRight = false;
    private Behavior behavior = null;
    private int time = 0;
    private boolean animating = true;
    private MascotEnvironment environment = new MascotEnvironment(this);

    public static void setShowSystemTrayMenu(boolean showSystemTrayMenu) {
        Mascot.showSystemTrayMenu = showSystemTrayMenu;
    }

    public static boolean isShowSystemTrayMenu() {
        return showSystemTrayMenu;
    }

    public Mascot() {
        this.id = lastId.incrementAndGet();
        log.log(Level.INFO, "\u30de\u30b9\u30b3\u30c3\u30c8\u751f\u6210({0})", this);
        this.getWindow().asJWindow().setAlwaysOnTop(true);
        this.getWindow().asJWindow().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Mascot.this.mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Mascot.this.mouseReleased(e);
            }
        });
    }

    public String toString() {
        return "\u30de\u30b9\u30b3\u30c3\u30c8" + this.id;
    }

    private void mousePressed(MouseEvent event) {
        if (this.getBehavior() != null) {
            try {
                this.getBehavior().mousePressed(event);
            }
            catch (CantBeAliveException e) {
                log.log(Level.SEVERE, "\u884c\u304d\u7d9a\u3051\u308b\u3053\u3068\u304c\u51fa\u6765\u306a\u3044\u72b6\u6cc1", e);
                this.dispose();
            }
        }
    }

    private void mouseReleased(final MouseEvent event) {
        if (event.isPopupTrigger()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Mascot.this.showPopup(event.getX(), event.getY());
                }
            });
        } else if (this.getBehavior() != null) {
            try {
                this.getBehavior().mouseReleased(event);
            }
            catch (CantBeAliveException e) {
                log.log(Level.SEVERE, "\u884c\u304d\u7d9a\u3051\u308b\u3053\u3068\u304c\u51fa\u6765\u306a\u3044\u72b6\u6cc1", e);
                this.dispose();
            }
        }
    }

    private void showPopup(int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                Mascot.this.setAnimating(true);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Mascot.this.setAnimating(false);
            }
        });
        JMenuItem disposeMenu = new JMenuItem("\u3070\u3044\u3070\u3044");
        disposeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Mascot.this.dispose();
            }
        });
        popup.add(disposeMenu);
        if (Mascot.isShowSystemTrayMenu()) {
            popup.add(new JSeparator());
            JMenuItem increaseMenu = new JMenuItem("\u5897\u3084\u3059");
            increaseMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Main.getInstance().createMascot();
                }
            });
            JMenuItem gatherMenu = new JMenuItem("\u3042\u3064\u307e\u308c\uff01");
            gatherMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Mascot.this.getManager().setBehaviorAll(Main.getInstance().getConfiguration(), "\u30de\u30a6\u30b9\u306e\u5468\u308a\u306b\u96c6\u307e\u308b");
                }
            });
            JMenuItem oneMenu = new JMenuItem("\u4e00\u5339\u3060\u3051\u6b8b\u3059");
            oneMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Mascot.this.getManager().remainOne();
                }
            });
            JMenuItem restoreMenu = new JMenuItem("IE\u3092\u5143\u306b\u623b\u3059");
            restoreMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    NativeFactory.getInstance().getEnvironment().restoreIE();
                }
            });
            JMenuItem closeMenu = new JMenuItem("\u5168\u90e8\u3070\u3044\u3070\u3044");
            closeMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.getInstance().exit();
                }
            });
            popup.add(increaseMenu);
            popup.add(gatherMenu);
            popup.add(oneMenu);
            popup.add(restoreMenu);
            popup.add(new JSeparator());
            popup.add(closeMenu);
        }
        this.getWindow().asJWindow().requestFocus();
        popup.show(this.getWindow().asJWindow(), x, y);
    }

    void tick() {
        if (this.isAnimating() && this.getBehavior() != null) {
            try {
                this.getBehavior().next();
            }
            catch (CantBeAliveException e) {
                log.log(Level.SEVERE, "\u884c\u304d\u7d9a\u3051\u308b\u3053\u3068\u304c\u51fa\u6765\u306a\u3044\u72b6\u6cc1", e);
                this.dispose();
            }
            this.setTime(this.getTime() + 1);
        }
    }

    public void apply() {
        if (this.isAnimating()) {
            if (this.getImage() != null) {
                this.getWindow().asJWindow().setBounds(this.getBounds());
                this.getWindow().setImage(this.getImage().getImage());
                if (!this.getWindow().asJWindow().isVisible()) {
                    this.getWindow().asJWindow().setVisible(true);
                }
                this.getWindow().updateImage();
            } else if (this.getWindow().asJWindow().isVisible()) {
                this.getWindow().asJWindow().setVisible(false);
            }
        }
    }

    public void dispose() {
        log.log(Level.INFO, "\u30de\u30b9\u30b3\u30c3\u30c8\u7834\u68c4({0})", this);
        this.getWindow().asJWindow().dispose();
        if (this.getManager() != null) {
            this.getManager().remove(this);
        }
    }

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public Point getAnchor() {
        return this.anchor;
    }

    public void setAnchor(Point anchor) {
        this.anchor = anchor;
    }

    public MascotImage getImage() {
        return this.image;
    }

    public void setImage(MascotImage image) {
        this.image = image;
    }

    public boolean isLookRight() {
        return this.lookRight;
    }

    public void setLookRight(boolean lookRight) {
        this.lookRight = lookRight;
    }

    public Rectangle getBounds() {
        int top = this.getAnchor().y - this.getImage().getCenter().y;
        int left = this.getAnchor().x - this.getImage().getCenter().x;
        Rectangle result = new Rectangle(left, top, this.getImage().getSize().width, this.getImage().getSize().height);
        return result;
    }

    public int getTime() {
        return this.time;
    }

    private void setTime(int time) {
        this.time = time;
    }

    public Behavior getBehavior() {
        return this.behavior;
    }

    public void setBehavior(Behavior behavior) throws CantBeAliveException {
        this.behavior = behavior;
        this.behavior.init(this);
    }

    public int getTotalCount() {
        return this.getManager().getCount();
    }

    private boolean isAnimating() {
        return this.animating;
    }

    private void setAnimating(boolean animating) {
        this.animating = animating;
    }

    private TranslucentWindow getWindow() {
        return this.window;
    }

    public MascotEnvironment getEnvironment() {
        return this.environment;
    }
}

