/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.imageio.ImageIO;

public class FixPngImage {
    public static void main(String[] args) throws IOException {
        File[] files;
        if (args.length < 2) {
            System.out.println("usage: java -jar FixPngImage.jar dir todir");
            return;
        }
        File dir = new File(args[0]);
        File todir = new File(args[1]);
        todir.mkdirs();
        File[] fileArray = files = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".png");
            }
        });
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            System.out.println("read:" + file.getAbsolutePath());
            BufferedImage image = ImageIO.read(file);
            int y = 0;
            while (y < image.getHeight()) {
                int x = 0;
                while (x < image.getWidth()) {
                    int rgb = image.getRGB(x, y);
                    if (rgb >>> 24 < 2) {
                        rgb = 0;
                    } else if (rgb >>> 24 != 255) {
                        Color c = new Color(rgb, true);
                        int a = c.getAlpha();
                        int g = (c.getRed() + c.getGreen() + c.getBlue()) / 3;
                        int A = a * (255 - g) / 255;
                        rgb = A << 24;
                    }
                    image.setRGB(x, y, rgb);
                    ++x;
                }
                ++y;
            }
            System.out.println("write:" + new File(todir, file.getName()).getAbsolutePath());
            ImageIO.write((RenderedImage)image, "png", new File(todir, file.getName()));
            ++n2;
        }
    }
}

