﻿<%@ Page Language="VB" %>

<%@ Import Namespace="System" %>
<%@ Import Namespace="System.Drawing" %>
<%@ Import Namespace="System.Drawing.Text" %>
<%@ Import Namespace="System.Drawing.Drawing2D" %>
<%@ Import Namespace="System.Drawing.Imaging" %>
<%@ Import Namespace="System.IO" %>
<script runat="server">
    Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs)
        '在此处放置初始化页的用户代码
        Response.Clear()
        Dim sText As String = generateVCode(4)
        Session("vcode") = sText
        DrawImage(sText)
        'Response.Flush()
        Response.End()
    End Sub

    Private Function generateVCode(ByVal CodeLength As Integer) As String
        Dim VCode As String = String.Empty
        Dim randObj As New Random
        Dim c As Integer = 63
        Dim theChar As String
        For i As Byte = 1 To CodeLength
            c = randObj.Next(35)
            If c >= 10 Then
                c += 7
            End If
            c += 48
            theChar = Chr(c)
            If theChar = "0" Or theChar = "1" Or theChar.ToLower = "o" Or theChar.ToLower = "l" Then
                i -= 1
            Else
                VCode += theChar
            End If
        Next
        Return VCode
    End Function

    Sub DrawImage(ByVal sText As String)
        Dim iWidth As Integer = CInt(sText.Length * 12) + 2
        Using image As Bitmap = New Bitmap(iWidth, 20)
            Using g As Graphics = Graphics.FromImage(image)
                g.Clear(Color.White)
                Dim c As Color() = {Color.Black, Color.Red, Color.DarkBlue, Color.Green, Color.Orange, Color.Brown, Color.DarkCyan, Color.Purple}
                Dim font As String() = {"Verdana", "Microsoft Sans Serif", "Comic Sans MS", "Arial", "宋体"}
                Dim rand As New Random
                '随机输出噪点
                Dim x, y As Integer
                For i As Integer = 0 To 49
                    x = rand.Next(image.Width)
                    y = rand.Next(image.Height)
                    g.DrawRectangle(New Pen(Color.LightGray, 0), x, y, 1, 1)
                Next
                '输出不同字体和颜色的验证码字符
                For i As Integer = 0 To sText.Length - 1
                    x = rand.Next(7)
                    y = rand.Next(5)
                    Dim f As New Font(font(y), 12, FontStyle.Bold)
                    Dim b As Brush = New SolidBrush(c(x))
                    Dim ii As Integer = 2
                    If (i + 1) Mod 2 = 0 Then ii = 0
                    g.DrawString(sText.Substring(i, 1), f, b, i * 12, ii)
                Next
                '画一个边框
                'g.DrawRectangle(New Pen(Color.Black, 0), 0, 0, image.Width - 1, image.Height - 1)
                '输出到浏览器
                Using ms As New MemoryStream
                    image.Save(ms, System.Drawing.Imaging.ImageFormat.Jpeg)
                    Response.ClearContent()
                    Response.ContentType = "image/Jpeg"
                    Response.BinaryWrite(ms.ToArray())
                End Using
            End Using
        End Using
    End Sub
</script>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
</head>
<body>
</body>
</html>
