﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.web.reg, ims.web" trace="false" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" id="reg">
<head runat="server">
    <title><%= ViewState["title"] %></title>
</head>
<body>
    <form id="form1" runat="server">
    <asp:ScriptManager ID="s1" runat="server">
        <Scripts><asp:ScriptReference Name="MicrosoftAjax.js" ScriptMode="Auto" Path="~/js/MsAjax.js"/><asp:ScriptReference Name="MicrosoftAjaxWebForms.js" ScriptMode="Auto" Path="~/js/MsAjax.js"/></Scripts>
    </asp:ScriptManager>
    <asp:validationsummary id="ValSum" runat="server" ShowMessageBox="True" ShowSummary="False"></asp:validationsummary>
      <div class="pageTitle"><%= ViewState["title"] %></div>
      <table cellspacing="1" class="normal mbottom_s" id="regTable">
        <tr runat="server" id="tr_UserName">
          <td style="width:350px"><dl><dt>用户名：</dt><dd>注册用户名长度限制为1－50字。</dd></dl></td>
          <td valign="bottom">
            <asp:UpdatePanel ID="up1" RenderMode="inline" runat="server">
            <ContentTemplate>
                <asp:TextBox runat="server" ID="userName" OnTextChanged="chkName" AutoPostBack="true" MaxLength="50" Width="150"></asp:TextBox>
            </ContentTemplate>
            </asp:UpdatePanel>
          <span class="required">*</span>
          <asp:RequiredFieldValidator SetFocusOnError="true"
                  ID="RequiredVal_userName" ControlToValidate="userName" runat="server" Display="None" ErrorMessage="请输入用户名！"></asp:RequiredFieldValidator></td>
        </tr>
        <tr runat="server" id="tr_realName">
          <td><dl><dt>真实姓名：</dt></dl></td>
          <td valign="bottom">
                <asp:TextBox runat="server" ID="realName" MaxLength="50" Width="150"></asp:TextBox><span class="required" runat="server" id="required_realName">*</span>
                <asp:RequiredFieldValidator ID="RequiredVal_realName" runat="server" ControlToValidate="realName" ErrorMessage="请输入真实姓名！" Display="None"></asp:RequiredFieldValidator>
                <asp:RegularExpressionValidator ID="RegularVal_realName" runat="server" SetFocusOnError="true" ValidationExpression=".{2,50}" ControlToValidate="realName" Display="None" ErrorMessage="姓名长度必须介于2到50之间！"></asp:RegularExpressionValidator>
            </td>
        </tr>
         <tr runat="server" id="tr_Sex">
          <td><dl><dt>性别：</dt><dd>请选择您的性别。</dd></dl></td>
          <td valign="bottom"><asp:RadioButtonList runat="server" ID="sex" RepeatDirection="Horizontal" RepeatLayout="Flow"><asp:ListItem Text="男　" Value="true" Selected="True" /><asp:ListItem Text="女" Value="false" /></asp:RadioButtonList></td>
        </tr>
        <tr runat="server" id="tr_PassWord">
          <td><dl><dt>登录密码：</dt><dd runat="server" id="PwdComment">请输入密码，区分大小写。</dd></dl></td>
          <td valign="bottom"><asp:TextBox runat="server" Width="150" TextMode="Password" ID="passWord" MaxLength="128"></asp:TextBox><span class="required">*</span>
            <asp:RequiredFieldValidator ID="RequiredVal_passWord" runat="server" ControlToValidate="passWord" ErrorMessage="请输入密码！" Display="None"></asp:RequiredFieldValidator>
          <asp:RegularExpressionValidator ID="RegularVal_passWord" runat="server" SetFocusOnError="true" ValidationExpression="^\S{3,128}$" ControlToValidate="passWord" Display="None" ErrorMessage="输入的密码不符合要求！"></asp:RegularExpressionValidator></td>
        </tr>
        <tr runat="server" id="tr_rePassWord">
              <td>
                  <dl>
                      <dt>确认密码：</dt><dd>请再输入一次密码，以确认输入是正确的。</dd></dl>
              </td>
              <td valign="bottom">
                  <asp:TextBox ID="rePassWord" Width="150" TextMode="Password" runat="server" MaxLength="128"></asp:TextBox><span class="required">*</span>
                <asp:RequiredFieldValidator ID="RequiredVal_rePassWord" runat="server" ControlToValidate="rePassWord" ErrorMessage="请输入确认密码！" Display="None"></asp:RequiredFieldValidator>
                  <asp:CompareValidator ID="CompareVal_rePassWord" runat="server" ControlToCompare="passWord"
                      ControlToValidate="rePassWord" Display="None" ErrorMessage="两次密码输入不一致！"></asp:CompareValidator></td>
          </tr>
        <tr runat="server" id="tr_Phone">
          <td><dl><dt>电话号码：</dt></dl></td>
          <td valign="bottom"><asp:TextBox runat="server" Width="150" ID="phone"></asp:TextBox><span class="required" runat="server" id="required_phone">*</span>
              <asp:RequiredFieldValidator ID="RequiredVal_phone" runat="server" ControlToValidate="phone" ErrorMessage="请输入电话号码！" Display="None"></asp:RequiredFieldValidator>
            <asp:RegularExpressionValidator ID="RegularVal_phone" runat="server" SetFocusOnError="true" ValidationExpression=".{7,}" ControlToValidate="phone" Display="None" ErrorMessage="请输入有效的电话号码！"></asp:RegularExpressionValidator>
          </td>
        </tr>
        <tr runat="server" id="tr_Address">
          <td><dl><dt>地址：</dt><dd>请输入详细的联系地址，以便必要时提供递送服务。</dd></dl></td>
          <td valign="bottom"><asp:TextBox runat="server" ID="address" Width="280"></asp:TextBox><span class="required" runat="server" id="required_address">*</span>
              <asp:RequiredFieldValidator ID="RequiredVal_address" runat="server" ControlToValidate="address"
                  Display="None" ErrorMessage="请输入地址！"></asp:RequiredFieldValidator>
              <asp:RegularExpressionValidator ID="RegularVal_address" runat="server" ControlToValidate="address"
                  Display="None" ErrorMessage="请输入有效的联系地址！" SetFocusOnError="true" ValidationExpression=".{2,}"></asp:RegularExpressionValidator>
          </td>
        </tr>
        <tr runat="server" id="tr_Zip">
          <td><dl><dt>邮编：</dt><dd>请输入与联系地址对应的邮政编码。</dd></dl></td>
          <td valign="bottom"><asp:TextBox runat="server" ID="zip" Width="150"></asp:TextBox><span class="required" runat="server" id="required_zip">*</span>
              <asp:RequiredFieldValidator ID="RequiredVal_zip" runat="server" ControlToValidate="zip"
                  Display="None" ErrorMessage="请输入邮编！"></asp:RequiredFieldValidator>
              <asp:RegularExpressionValidator ID="RegularVal_zip" runat="server" ControlToValidate="zip"
                  Display="None" ErrorMessage="请输入有效的邮政编码！" SetFocusOnError="true" ValidationExpression="\d{6}"></asp:RegularExpressionValidator>
          </td>
        </tr>
        
        <tr runat="server" id="tr_Question">
          <td><dl><dt>密码问题：</dt><dd>取回密码的提示问题。</dd></dl></td>
          <td valign="bottom"><asp:TextBox runat="server" ID="question" Width="150"></asp:TextBox><span class="required" runat="server" id="required_question">*</span>
              <asp:RequiredFieldValidator ID="RequiredVal_question" runat="server" ControlToValidate="question"
                  Display="None" ErrorMessage="请输入密码问题！"></asp:RequiredFieldValidator>
              <asp:RegularExpressionValidator ID="RegularVal_question" runat="server" ControlToValidate="question"
                  Display="None" ErrorMessage="密码问题字数太少！" SetFocusOnError="true" ValidationExpression="\S.*"></asp:RegularExpressionValidator>
          </td>
        </tr>
        <tr runat="server" id="tr_Answer">
          <td><dl><dt>问题答案：</dt><dd>取回密码的问题答案。</dd></dl></td>
          <td valign="bottom"><asp:TextBox runat="server" ID="answer" Width="150"></asp:TextBox><span class="required" runat="server" id="required_answer">*</span>
              <asp:RequiredFieldValidator ID="RequiredVal_answer" runat="server" ControlToValidate="answer"
                  Display="None" ErrorMessage="请输入问题答案！"></asp:RequiredFieldValidator>
              <asp:RegularExpressionValidator ID="RegularVal_answer" runat="server" ControlToValidate="answer"
                  Display="None" ErrorMessage="问题答案字数太少！" SetFocusOnError="true" ValidationExpression="\S.*"></asp:RegularExpressionValidator>
          </td>
        </tr>

        <tr runat="server" id="tr_Email">
          <td><dl><dt>电子邮箱：</dt><dd>请输入有效的邮箱地址，以便今后联系或忘记密码时发回密码。</dd></dl></td>
          <td valign="bottom"><asp:TextBox runat="server" ID="email" Width="150"></asp:TextBox><span class="required" runat="server" id="required_email">*</span>
              <asp:RequiredFieldValidator ID="RequiredVal_email" runat="server" ControlToValidate="email"
                  Display="None" ErrorMessage="请输入电子邮箱！"></asp:RequiredFieldValidator>
              <asp:RegularExpressionValidator ID="RegularVal_email" runat="server" ControlToValidate="email"
                  Display="None" ErrorMessage="请输入有效的电子邮箱！" SetFocusOnError="true" ValidationExpression="^\w[\w\.-]*@\w[\w\.-]*\.[a-zA-Z]{2,4}"></asp:RegularExpressionValidator>
          </td>
        </tr>
        <tr runat="server" id="tr_Vcode">
          <td><dl><dt>验证码：</dt><dd>请输入验证码（右边图片中显示的字符）。</dd></dl></td>
          <td><asp:TextBox runat="server" ID="vcode" Width="150"></asp:TextBox><img src="vcode.aspx" title="验证码。若看不清楚，请点击以刷新。" style="cursor:pointer;height:19px;vertical-align:top" onclick="this.src='vcode.aspx?time='+new Date().getTime();" /></td>
        </tr>
     </table>
     <asp:CheckBox runat="server" ID="AutoLogin" Checked="true" Text="注册成功后自动登录系统" />
    <asp:UpdatePanel ID="footup" RenderMode="inline" runat="server">
    <ContentTemplate>
         <div class="footBtnArea">
             <input class="btn" type="button" id="btnSubmit" value="注 册" runat="server" onserverclick="submit" />
             <input type="button" onclick="back();" value="返回" class="btn" />
         </div>
    </ContentTemplate>
    </asp:UpdatePanel>
    <script src="js/comm.js"></script>
    </form>
</body>
</html>
