﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.web.OrderAdmin, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" id="OrderAdmin">
<head runat="server">
    <title>订单管理</title>
</head>
<body>
    <form id="form1" runat="server">
        <asp:HiddenField ID="curOrderID" runat="server" />
        <asp:ScriptManager ID="s1" runat="server">
            <Scripts><asp:ScriptReference Name="MicrosoftAjax.js" ScriptMode="Auto" Path="~/js/MsAjax.js"/><asp:ScriptReference Name="MicrosoftAjaxWebForms.js" ScriptMode="Auto" Path="~/js/MsAjax.js"/></Scripts>
        </asp:ScriptManager>
        <div class="pageTitle" runat="server" id="pageTitle">订单管理</div>
		<div class="block" style="margin-top:-8px">
		    <div class="titleRow"><div class="title">订单搜索</div><div class="verb"><img src="images/u.gif" onclick="toggle(this);" title="隐藏" /></div></div>
		    <div class="content">
		        <table cellspacing="0" cellpadding="0">
		            <tr>
		                <td>
	                        <asp:CheckBox ID="cbOrderID" runat="server" Text="订单号：" /><asp:TextBox ID="tbOrderID" runat="server" Width="185"></asp:TextBox><br />
	                        <asp:CheckBox ID="cbSubmiter" runat="server" Text="下单人：" /><asp:TextBox ID="tbSubmiter" runat="server" Width="185"></asp:TextBox><br />
                            <asp:CheckBox ID="cbOthers" runat="server" Text="订单其它信息包含关键字：" /><asp:TextBox ID="tbKey" runat="server" Width="90"></asp:TextBox>
		                </td>
                        <td>
	                        <asp:CheckBox ID="cbSubmitTime" runat="server" Text="下单时间：" /><asp:TextBox ID="tbTime1" runat="server"></asp:TextBox>～<asp:TextBox ID="tbTime2" runat="server"></asp:TextBox><br />
	                        <asp:CheckBox ID="cbTotalPrice" runat="server" Text="订单金额：" /><asp:TextBox ID="tbTotalPrice1" runat="server"></asp:TextBox>～<asp:TextBox ID="tbTotalPrice2" runat="server"></asp:TextBox><br />
	                        <asp:CheckBox ID="cbStatus" runat="server" Text="订单状态：" /><asp:DropDownList ID="ddlStatus" runat="server"></asp:DropDownList>
                        </td>
                        <td align="right">
                            <asp:ImageButton ID="ibSearch" ToolTip="搜索订单" ImageUrl="images/dosearch.gif" OnClick="DoSearch" runat="server" />
                        </td>
                    </tr>
		        </table>
		    </div>
		</div>
        
        <asp:UpdatePanel ID="mainup" runat="server" RenderMode="Inline" ChildrenAsTriggers="true" UpdateMode="Conditional">
        <ContentTemplate>
        <div runat="server" id="OrderList">
        <div style="margin:12px auto 3px">
        <asp:GridView ID="GvOrders" runat="server"
        ShowHeader="true"
        DataKeyNames="ID"
        AutoGenerateColumns="False"
        GridLines="none"
        CellSpacing="1"
        CellPadding="0"
        BorderWidth="0"
        AllowPaging="false"
        PageSize="15"
        AllowSorting="true"
        CssClass="normal"
        RowStyle-HorizontalAlign="center"
        OnRowDataBound="GvRowBound"
        OnRowDeleting="GvRowDeleting"
        OnDataBound="GvDataBound"
        OnSorting="GvSorting">
        <Columns>
            <asp:TemplateField HeaderText="订单号" HeaderStyle-Width="128" ItemStyle-HorizontalAlign="left">
                <ItemTemplate><a href="#" onclick="return ShowDetail('<%# Eval("ID") %>');"><%# Eval("ID") %></a></ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField HeaderText="订单金额" DataField="TotalPrice" DataFormatString="{0:F2}" HtmlEncode="False" SortExpression="TotalPrice" HeaderStyle-Width="80" />
            <asp:TemplateField HeaderText="下单人" HeaderStyle-Width="72" HeaderStyle-Wrap="false">
                <ItemTemplate><%# ims.Users.getDisplayName(Eval("Submiter") as string) %></ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="送货地址" ItemStyle-HorizontalAlign="Left">
                <ItemTemplate><%# ims.Util.TrimStr((string)ims.Util.ToNotNull(Eval("Address"),""),15) %></ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="下单时间" SortExpression="SubmitTime" ItemStyle-HorizontalAlign="Center" HeaderStyle-Width="68">
                <ItemTemplate><span title="<%# ((DateTime)Eval("SubmitTime")).ToString() %>"><%# ((DateTime)Eval("SubmitTime")).ToString("yyyy-MM-dd") %></span></ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField  HeaderText="状态" HeaderStyle-Width="64" />
            <asp:TemplateField HeaderText="操作记录" HeaderStyle-Width="52">
                <ItemTemplate><a href="#" onclick="return ShowLogs('<%# Eval("ID") %>');">查看</a></ItemTemplate>
            </asp:TemplateField>
            <asp:CommandField ButtonType="Link" ShowDeleteButton="true" HeaderText="删除" DeleteText="删除" HeaderStyle-Width="32" />
            <asp:TemplateField HeaderText="操作" HeaderStyle-Width="52" Visible="false">
                <ItemTemplate>
                    <asp:LinkButton ID="lbCanel" runat="server" OnClick="CanelOrder">取消订单</asp:LinkButton>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
        </asp:GridView>
        </div>
        <div class="box">
        <table runat="server" id="pager" cellpadding="0" cellspacing="0"><tr>
            <td class="pagertd">
                <asp:LinkButton ID="lbFirst" runat="server" CommandArgument="First" CommandName="Page" OnClick="jumpToPage" Text="<<首页"></asp:LinkButton>&nbsp;
                <asp:LinkButton ID="lbPrev" runat="server" CommandArgument="Prev" CommandName="Page" OnClick="jumpToPage" Text="<上一页"></asp:LinkButton>&nbsp;
                <asp:LinkButton ID="lbNext" runat="server" CommandArgument="Next" CommandName="Page" OnClick="jumpToPage" Text="下一页>"></asp:LinkButton>&nbsp;
                <asp:LinkButton ID="lbLast" runat="server" CommandArgument="Last" CommandName="Page" OnClick="jumpToPage" Text="尾页>>"></asp:LinkButton>
            </td>
            <td align="center">
                <asp:Label ID="recordCount" runat="server" CssClass="gray"></asp:Label>
            </td>
            <td align="right" valign="middle">
                <asp:DropDownList runat="server" id="ddlPager" AutoPostBack="True" OnSelectedIndexChanged="jumpToPage" />
            </td>
        </tr></table>
        </div>
        </div>
        <div class="footBtnArea" runat="server" id="promNoOrders"><asp:Label ID="lblProm" runat="server" Text="暂无订单！" Font-Bold="true" ForeColor="red"></asp:Label></div>
        </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="ibSearch" EventName="Click" />
        </Triggers>
        </asp:UpdatePanel>
        
    <input id="btnInitDetail" type="button" value="" runat="server" onserverclick="ShowDetail" class="hide" />
    <ims:Pop runat="server" ID="popDetail" Width="600" OnOkClick="SaveOrder" CustomButtonB_Text="打印" CanelButtonText="关闭" CustomButtonB_OnClick="$('#popDetail_Body').printIt({pageTitle:$('#popDetail_popup .head .title').text()});" CustomButtonA_Text="导出" CustomButtonA_OnClick="toExportAs('#popDetail_Body',800,$('#popDetail_popup .head .title').text());" ShowProgress="false" CustomCss="noline">
    <ContentTemplate>
        <table class="normal" cellspacing="1">
        <asp:Repeater ID="rptOrderItems" runat="server" OnItemDataBound="rptOrderItems_ItemBound">
        <HeaderTemplate><tr><th style="width:28px">序号</th><th style="width:160px">商品</th><th style="width:60px">单价(<%= (string)ViewState["OrderUnit"] %>)</th><th style="width:40px">数量</th><th style="width:60px">金额(<%= (string)ViewState["OrderUnit"] %>)</th><th>备注</th></tr></HeaderTemplate>
        <ItemTemplate>
        <tr runat="server" id="ItemTr"><td runat="server" align="center"></td><td runat="server"></td><td runat="server" align="center"></td><td runat="server" align="center"></td><td runat="server" align="center"></td><td runat="server"></td></tr>
        </ItemTemplate>
        </asp:Repeater>
        </table>
        <div runat="server" id="phPriceCompute" class="detail"></div>
        <div class="dashed"></div>
        <div class="detail">
            付款方式：<asp:Label ID="lblPayWay" runat="server"></asp:Label><br />
            需要发票：<asp:Label ID="lblNeedInvoice" runat="server"></asp:Label><br />
            <div runat="server" id="InvoiceTitle">发票抬头：<asp:Label ID="lblInvoiceTitle" runat="server"></asp:Label></div>
            送货方式：<asp:Label ID="lblSendWay" runat="server"></asp:Label><br />
            送货地址：<asp:Label ID="lblAddress" runat="server"></asp:Label><br />
            　联系人：<asp:Label ID="lblContact" runat="server"></asp:Label><br />
            联系电话：<asp:Label ID="lblPhone" runat="server"></asp:Label><br />
            联系邮箱：<asp:Label ID="lblEmail" runat="server"></asp:Label><br />
            　下单人：<asp:Label ID="lblSubmiter" runat="server"></asp:Label><br />
            <div runat="server" id="divCustomComment">客户备注：<asp:Label runat="server" id="customComment" /></div>
            <div class="dashed"></div>
        </div>
        <div class="detail">
            管理员备注：<asp:Label runat="server" ID="adminMsg"></asp:Label><br />
            <asp:TextBox ID="tbAdminComment" runat="server" TextMode="MultiLine" Rows="4" Width="99%"></asp:TextBox>
            订单状态：<asp:DropDownList ID="ddlCurOrderStatus" runat="server"></asp:DropDownList><br />
        </div>
    </ContentTemplate>
    </ims:Pop>
    
    <input id="btnShowLogs" type="button" value="" runat="server" onserverclick="ShowLogs" class="hide" />        
    <ims:Pop runat="server" ID="popLogs" ShowOkButton="false" CanelButtonText="确定" ShowProgress="false" CustomCss="noline">
    <ContentTemplate>
        <div runat="server" id="logsContent"></div>
    </ContentTemplate>
    </ims:Pop>
    
    <script src="js/comm.js"></script><script src="js/OrderAdmin.js"></script>
    </form>
</body>
</html>
