﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.web.help, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>系统帮助</title>
    <meta http-equiv="X-UA-Compatible" content="IE=7" />
	<style type="text/css" media="all" runat="server" id="css">
	    * {margin:0;padding:0;font-size:9.5pt;font-family:微软雅黑,Arial,宋体;line-height: 1.6}
	    body{background:#ebf0fa;overflow:hidden}
	    a:visited{color:#008}
        a:hover{color:#f50;text-decoration:none}
	    a#aHome{padding-left:18px;background:url(images/data_home.gif) no-repeat 0 50%}
	    #mainTable{width:100%;border:none;table-layout:fixed;}
	    a#aBack{padding-left:14px;background:url(images/back.gif) no-repeat 0 40%;margin-left:6px}
	    #titleTd{vertical-align:bottom;height:24px;}
	    #helpTitle{background:url(images/help1.gif) no-repeat 1px bottom;padding-left: 50px;font-weight: bold;line-height:normal;}
	    #mainDiv{height:100%;overflow:auto;background:#fff;border-top: #ccd5df 1px solid;border-bottom: #ccd5df 1px solid; padding:0 3px 5px 2px}
	    #tools{width:120px;text-align:right;vertical-align:bottom}
	    #msg{text-align:center;color:Red;position:absolute;bottom:45%;left:35%}
        .blockTitle{color:#f14c04;font-size:11pt;font-weight:bold;padding-bottom:2px;margin:15px 1em 6px;border-bottom:1px #f14c04 solid}
        .blockContent{margin:0 1em 0 3em}
        .blockContent a{text-decoration:none;color:#03d}
        .blockContent a:hover{color:#f50}
	    p{text-indent:2em;margin:3px 0 6px;color:#222}
	    dl{margin-left:6px}
        dt{font-size:11pt;padding-left: 12px;font-weight:bold;color:#00a;margin:8px 0 1px; background:url(images/dot.gif) no-repeat 0 50%;}
        dd{color:#222;line-height: 1.6;}
	    dd ul {margin-left:16px; list-style-type:none}
	    dd ul.decoration{margin-left:24px}
	    dd ul.decoration li{list-style-type:disc;margin-bottom:3px}
	    dd li img{vertical-align:middle}
	    dd.related{padding-left:16px}
	    dd.related a{margin-right:0.5em}
	    dd dl{margin-left:16px}
	    dd dl.listdefine dt{list-style-type:square;padding-left:12px;background:url(images/li.gif) no-repeat 0 50%;color:#008000;font-weight:normal}
	    dd dl.listdefine dd{margin-left:12px;}
	    dd dl.define dt{color:#008000;font-weight:bold;margin-right:0.5em;background:none;padding:0}
	    dd dl.inlinedefine dt{font-weight:bold;background:none;padding:0;display:inline;font-size:15pt;color:#f14c04}
	    dd dl.inlinedefine dd{display:inline;margin:0}
        .normal{border-width:2px 1px 1px 2px !important;border:0;border-collapse:separate;color:#000042;background:#CCD6E6;table-layout:fixed;margin:2px 0 12px}
        .normal tr{background:#fff}
        .normal th{background:#ebedf3;padding:1px 4px;font-weight:normal;text-align:left}
        .normal td{padding:2px 3px 1px}
        .red{color:red}
        .green{color:green}
	    .key{font-weight:bold}
	    .term{font-weight:bold;margin-right:10px;color:#080}
        .comment{color:#080}
	    .pictComment{color:#e20;margin-bottom:0.5em;text-align:center}
	    #footer input{height:25px;width:40px}
        #sysAbout{text-align:right;padding-right:6px}
        .path{display:none;margin:4px 1px 3px 6px;padding:1px 1px 2px 22px;border:1px #fd6 dotted;background:#fffaf0 url(images/info.gif) no-repeat 3px 5px;border-radius:4px}
	</style>
	<base target="_self" />
</head>
<body>
    <form id="form1" runat="server">
    <asp:ScriptManager ID="s1" runat="server">
        <Scripts><asp:ScriptReference Name="MicrosoftAjax.js" ScriptMode="Auto" Path="~/js/MsAjax.js"/><asp:ScriptReference Name="MicrosoftAjaxWebForms.js" ScriptMode="Auto" Path="~/js/MsAjax.js"/></Scripts>
    </asp:ScriptManager>
		<table id="mainTable">
			<tr id="header">
			    <td id="titleTd"><span ID="helpTitle" runat="server"></span></td>
			    <td id="tools"><a href="help.aspx?subject=index" runat="server" id="aHome">首页</a><a href="javascript:history.back();" id="aBack">后退</a></td>
			</tr>
			<tr>
				<td id="content" colspan="2">
				<div id="mainDiv">
				    <asp:Panel ID="index" runat="server" Visible="False">
				        <dl><dt>系统简介</dt>
				            <dd>
				                <p>本系统是一个通用的管理软件平台，可用于任意数据信息和工作流的管理。系统以“<a href="help.aspx?subject=templets">模板</a>”概念为基础，实现了高度灵活和便捷的可自定义特性，并能以最简化的方式录入、管理和共享数据信息，高效沟通和协作。配合简单方便的权限设计，可通过网络，让分布在不同地方的人员用浏览器登录来进行授权范围内的信息管理、查询或事务处理。</p>
                                <p>系统从不同角度为数据和流程管理提供了强大支持，以缩略视图、表格视图、自由版式等提供了不同的数据展现方式；以图表视图、报表视图提供了直观灵活的统计分析功能；可随时备份或恢复数据，以及导入导出Excel数据；提供“信息中心”栏目，可用于发布通知、文档、新闻，或用作论坛进行内部交流；提供“事务中心”模块，待办事项、工作流管理一目了然；提供“消息、邮件、短信、评论、提醒”等功能，使得内部沟通再无障碍。</p>
                                <p>系统支持鼠标右键操作和拖动操作，支持模板导入/导出、皮肤切换，兼容所有主流Windows版本、兼容多种数据库和主流浏览器，具备条形码/二维码、电子商务等功能，并可作为一个网站或集成在现有网站中。</p>
                                <p runat="server" id="sysAbout" class="landian"><a href="http://landian.cc" target="_blank">检查新版本</a></p>
                            </dd>
				            <dt>技术特性</dt>
				            <dd>
				                <p>安装运行环境：Windows系列操作系统，安装.Net 2.0以上版本；</p>
                                <p>支持的数据库：Access、SQL Server 2000/2005/2008/2012/2014/Express；</p>
                                <p>支持的浏览器：IE 6.0+、Firefox 3.0+、Chrome 1.0+等；推荐使用：<a href="http://windows.microsoft.com/zh-cn/internet-explorer/download-ie" target="_blank">IE9/10/11</a>、<a href="http://firefox.com.cn" target="_blank">Firefox</a>、<a href="https://www.google.com/chrome?hl=zh-CN" target="_blank">Chrome</a>；<br />
                                   　　　　　　　　　平板电脑、智能手机，推荐使用Chrome；</p>
                                <p>客户端分辨率：推荐采用1024×768或更高显示分辨率；</p>
                                <p class="landian">软件官方网站：<a href="http://landian.cc" target="_blank">http://landian.cc</a>。</p>
                            </dd>
                            <dt class="write" runat="server">主要术语</dt>
                            <dd class="write" runat="server">
                                <dl class="define">
                                    <dt>模板</dt>
                                    <dd>
                                        <p>任何要管理的事物都是以模板为基础的。模板定义了其各种属性，如名称、规格、重量之类，这些属性被称为“字段”。模板通常用于可用相同指标来描述的一类事物，如产品技术档案、产品出入库明细等。</p>
                                        <p>系统所管理的数据都是依存于特定模板的，其中的每一条信息称为一条“记录”。如下图所示：<br /><img src="images/help/glossary.png" /></p>
                                    </dd>
                                    <dt>目录</dt>
                                    <dd>
                                        <p>目录是一种对数据记录进行分类存放的组织形式。同一模板的记录可能分布在不同的目录中，也可以不放到任何目录中。</p>
                                    </dd>
                                    <dt>视图</dt>
                                    <dd><p>视图，是对正在浏览的一批数据的一种表现形式。不同的视图可以从不同的角度和方式来对同一批记录进行查看或统计。</p></dd>
                                </dl>
                            </dd>
                            <dt>系统应用基本流程：<a href="#" onclick="to('templets.aspx');">设计模板</a> - <a href="#" onclick="to('select.aspx');">录入数据</a> - <a href="#" onclick="to('templets.aspx?mode=data');">浏览和数据管理</a></dt>
                            <dt>如何使用帮助</dt>
                            <dd>
                                <p>随时可点击左侧栏的“实时帮助”或操作界面的帮助按钮来查看相关指导信息。</p>
                                <p runat="server" id="pPopHelp">
                                    初次使用本系统时，会自动弹出与当前操作相关的气泡式操作指南，这些信息最多会显示两次。
                                    <asp:UpdatePanel runat="server" ID="up1" UpdateMode="Conditional" RenderMode="Inline">
                                        <ContentTemplate>
                                            <asp:LinkButton runat="server" ID="resetPopHelp" OnClick="ResetPopHelp" Text="点击此处将已显示次数归零"></asp:LinkButton>&nbsp;
                                            <asp:LinkButton runat="server" ID="switchPopHelp" OnClick="SwitchPopHelp"></asp:LinkButton>
                                        </ContentTemplate>
                                    </asp:UpdatePanel>
                                </p>
                            </dd>
				            <dt>相关主题</dt>
				            <dd class="related">
                                <a href="?subject=indexnav">索引</a>
                                <a runat="server" class="admin" href="?subject=three">三分钟入门</a>
                                <a href="?subject=faq">常见问题解答</a>
                                <a runat="server" class="admin" href="?subject=power&showpath=1">用户及权限</a>
                                <a runat="server" class="admin" href="?subject=admin&showpath=1">系统设置</a>
				                <a href="#" onclick="to('guide.aspx');" runat="server" class="write" id="guide">操作向导</a>
				                <a href="#" onclick="to('adminHome.aspx?tab=about');" runat="server" id="about" class="admin">关于本系统</a>
                            </dd>
				        </dl>
                    </asp:Panel>

                    <asp:Panel ID="indexNav" Visible="false" runat="server">
                        <div class="blockTitle">开始了解</div>
                        <div class="blockContent">
                            <a href="?subject=index">简介、技术特性、主要术语、如何使用帮助</a>、 <a href="?subject=three">三分钟入门</a>、<a href="#" onclick="to('guide.aspx');">向导</a>、<a href="?subject=faq">常见问题解答</a>
                        </div>
                        <div class="blockTitle">系统设计</div>
                        <div class="blockContent">
                            <a href="?subject=templets">设计中心</a>、<a href="?subject=templet">模板设计</a>、<a href="?subject=masterSlave">主从模板</a>、<a href="?subject=flow">流程设计</a>、<a href="?subject=templetattrs">模板属性</a>、<a href="?subject=findtemplet">查找模板</a>、<a href="?subject=power">用户、角色及权限</a>、<a href="?subject=users">用户管理</a>、<a href="?subject=roles">角色管理</a>、<a href="?subject=admin">系统设置</a>、<a href="?subject=HomeLayout">自定义首页</a>、<a href="?subject=sidebar">自定义左侧栏</a>、<a href="?subject=jsplugin">外挂脚本</a>
                        </div>
                        <div class="blockTitle">系统应用</div>
                        <div class="blockContent">
                            <a href="?subject=dataadmin"><%= ims.Comm.Vars.DataCenterText %></a>、<a href="?subject=dir">目录</a>、<a href="?subject=edit">数据录入</a>、<a href="?subject=rows">多行录入模式</a>、<a href="?subject=editlayout">录入界面版式管理</a>、<a href="?subject=thumb">缩略视图</a>、<a href="?subject=table">表格视图</a>、<a href="?subject=condformat">表格视图条件格式</a>、<a href="?subject=summary">概要视图</a>、<a href="?subject=detail">详情视图</a>、<a href="?subject=detaillayout">详细视图排版</a>、<a href="?subject=chart">图表视图</a>、<a href="?subject=report">报表视图</a>、<a href="?subject=datahome">搜索-快捷方式-收藏</a>、<a href="?subject=filters">过滤器</a>、<a href="?subject=fastfilter">数据筛选</a>、<a href="?subject=advsearch">高级搜索</a>、<a href="?subject=infoEdit"><%= ims.Comm.Vars.InfoType %>发布</a>
                        </div>
                        <div class="blockTitle">其它主题</div>
                        <div class="blockContent">
                            <a href="?subject=maint">系统维护</a>、<a href="?subject=autoBackup">系统自动备份</a>、<a href="?subject=editor">编辑器</a>、<a href="?subject=eshopsetting">电子商务选项设置</a>、<a href="?subject=cart">购物车</a>、<a href="?subject=orderadmin">订单管理</a>、<a href="?subject=myorder">我的订单</a>、<a href="?subject=access">Access数据库常用函数</a>、<a href="?subject=sqlserver">SQL Server数据库常用函数</a>、<a href="?subject=selectUser">选取用户</a>
                        </div>                        
                    </asp:Panel>
					
                    <asp:Panel ID="HomeLayout" Visible="false" runat="server">
                        <div class="path">操作路径： 首页，点击右上角 <img src="Images/gear.png" /> 图标</div>
                        <dl>
                            <dt>如何为首页添加新的版块？</dt>
                            <dd>
                                <p>点击右上方的 <img src="images/gear.png" align="absMiddle" /> 图标，弹出“设置我的首页”对话框后，以下三个按钮可用于添加版块：</p>
                                <ul>
                                    <li><span class="term">添加自定义版块</span>添加一个自定义内容的版块，其中可添加录入、浏览、搜索等链接元素，或任意的内容；</li>
                                    <li><span class="term">添加RSS版块</span>添加一个RSS订阅版块，以显示指定的RSS源的最新内容；</li>
                                    <li><span class="term">添加网页版块</span>添加一个嵌入指定网页内容的版块。</li>
                                </ul>
                            </dd>
                            <dt>如何隐藏或显示版块？</dt>
                            <dd>
                                <p>鼠标移到任一个版块左上方，版块图标会变成 <img src="images/hideblock.gif" align="absMiddle" /> ，点击即可隐藏该版块；隐藏的版块可在“设置我的首页”对话框的“可用的版块”中看到，点击其右侧的 <img src='images/data_add.gif' align="absMiddle" /> 图标可将其添加到页面中显示出来。</p>
                            </dd>
                            <dt>如何编辑或删除版块？</dt>
                            <dd><p>系统预置版块只能隐藏，不能编辑或删除；自己添加的版块可以在“设置我的首页”对话框的“可用的版块”中，点击其右侧的编辑或删除图标进行相应操作。</p></dd>
                            <dt>如何调整页面区域布局和各版块位置？</dt>
                            <dd><p>在“设置我的首页”对话框中，点击“切换页面布局”，可选择新的区域布局形式；在页面上拖动版块标题可将版块移动到另一区域，或区域中的另一位置。以上操作的结果，系统将自动记忆存储。</p></dd>
                            <dt>什么是RSS？</dt>
                            <dd><p>RSS是一种网站内容聚合格式，一些新闻或博客等类型的站点，会将他们更新的内容生成为一个描述文件，即RSS源。首页添加的RSS版块，就相当于是订阅这些RSS所提供的内容。</p></dd>
                            <dt>技巧</dt>
                            <dd>
                                <ul class="decoration">
                                    <li>通过添加网页版块，可以使用系统中的页面地址作为网址，来直接在版块中显示系统中的数据或页面。如“view.aspx?tid=1”，可显示ID为1的模板的数据。</li>
                                    <li>如何获得系统内部的页面地址？在系统中找到进入该目标页面的链接，点鼠标右键，复制快捷方式，将得到的地址中，取最后一个“/”后面的部分；或在页面中点右键，查看源代码，取form元素的action值。</li>
                                </ul>
                            </dd>
                        </dl>
                    </asp:Panel>

                    <asp:Panel ID="admin" runat="server" Visible="False">
                    <div class="path">操作路径： 点顶部“系统管理”图标，再点“系统设置”图标</div>
                    <dl>
                        <dt>部分设置选项说明：</dt>
                        <dd>
                            <ul>
                                <li><span class="term">单位名称</span>使用本系统的公司或机构的全称或简称。</li>
                                <li><span class="term">系统名称</span>对该软件系统的自定义的名称。</li>
                                <li><span class="term">允许用户注册</span>设置是否允许用户通过注册页面自行注册。</li>
                                <li><span class="term">允许找回密码</span>若选中，则用户在遗忘密码后可通过找回密码功能来获得系统用电子邮件发送的随机新密码。</li>
                                <li><span class="term">禁止匿名用户访问</span>若勾选该项，则任何人必须登录后才能访问系统；否则，可以在未登录的情况下以匿名用户身份访问系统，并进行授权范围内的操作。</li>
                                <li><span class="term">用户登录方式</span>设置当用户登录时是从用户列表中选择自己的用户名，还是在文本框中输入用户名。如果用户数量多于100，则忽略此设置而强行采用输入用户名的方式。</li>
                                <li><span class="term">新用户默认角色</span>指定新创建或注册的用户默认属于哪个<asp:HyperLink ID="HyperLink4" runat="server" NavigateUrl="help.aspx?subject=roles">角色</asp:HyperLink>。</li>
                                <li><span class="term">禁止自动弹出气泡式帮助</span>勾选以禁用针对新用户的弹出式操作指导。</li>
                                <li><span class="term">在线编辑器模式</span>指定在数据录入或编辑时，<asp:HyperLink ID="HyperLink5" runat="server" NavigateUrl="help.aspx?subject=editor">编辑器</asp:HyperLink>的工作模式。不同模式间的区别在于可用的工具按钮的数量不同。</li>
                                <li><span class="term">限制上传的图片尺寸</span>设置“图片”类型字段中上传的图片的最大尺寸，以像素为单位。当所上传的图片的宽度或高度大于该尺寸时，程序会自动同比例缩小到该尺寸。设为0表示不限制尺寸。</li>
                                <li><span class="term">允许上传的文件类型</span>在这里设置允许在编辑数据时在“文件”类型字段中上传的文件的扩展名列表。只有具有列出的扩展名之一的文件才能上传。扩展名不带句点符号，以逗号作为分隔。留空表示不限制上传的文件类型，由于理论上这会存在安全漏洞，所以应该仅在完全信任录入人员的情况下设置为空。</li>
                                <li><span class="term">常用链接设置</span>可设置最多四个链接。这些链接将显示在系统主界面的右上角。外部链接请使用带有“http://”之类的完整的链接地址；内部链接可直接输入页面文件及参数（示例：dir.aspx?id=2）。</li>
                            </ul>
                        </dd>
                        <dt>功能选项说明：</dt>
                        <dd>
                            <ul>
                                <li><span class="term">启用工作流功能</span>勾选该项，则可以为模板设计流程，规定流程的发起和流转过程中的人员和权限等。</li>
                                <li><span class="term">启用目录权限控制</span>勾选该项，则可以对目录的创建、删除等权限进行设置和控制，否则，只要用户可以添加记录，就可以操作目录。</li>
                                <li><span class="term">启用电子商务功能</span>设置是否启用电子商务功能。如果勾选了该项，则可以对每一个模板设置是否启用电子商务功能，启用了的，用户在浏览时就可以将其加入购物车并提交订单。</li>
                                <li><span class="term">启用短信发送功能</span>勾选该项，则可以在系统中使用短信功能发送手机短信。</li>
                                <li><span class="term">启用消息功能</span>勾选该项，则可以使用系统内部消息功能，用户之间可收发消息。</li>
                                <li><span class="term">启用收藏功能</span>如果启用，则用户可以将感兴趣的信息加入到自己的收藏夹中。</li>
                            </ul>
                        </dd>
                        <dt>用户信息选项说明：</dt>
                        <dd><p>切换到“用户信息”标签，可分别设置每个项目是否启用，以及是否为必填项。只有启用了的项目，才会在用户注册及其个人信息维护页面显示出来供填写。</p></dd>
                        <dt>邮件发送设置说明：</dt>
                        <dd><p>
                            在这里设置用于发送邮件所必须的一些信息。“发件邮箱地址”及“发送者的名称”分别填写发送邮件所用的邮箱及发送方的名称，其余选项可向该邮箱的服务提供商咨询，或查阅其在线文档中关于SMTP设置的部份。</p></dd>
                            <p>注：如果使用QQ邮箱，需要确保您的邮箱账户开启了SMTP服务。开启方法：登录QQ邮箱，点“设置”-“账户”，勾选“开启POP3/SMTP服务”，保存。</p>
                    </dl>
                    </asp:Panel>
                    
                    <asp:Panel ID="eshopsetting" Visible="false" runat="server">
                        <div class="path">操作路径： 系统管理 &rsaquo; 系统设置 &rsaquo; 功能选项，勾选“启用电子商务功能”，点“电子商务选项设置”</div>
                        <dl>
                            <dt>“订单计费规则说明”标签页</dt>
                            <dd><p>在这里填写对订单计费规则的说明。这些规则通常包括一些优惠及促销方面的措施，例如，“购物满100元，返现10元”、“在5.1～5.7期间购物免运费”之类。</p></dd>
                            <dt>“订单计费规则管理”标签页</dt>
                            <dd><p>在这里添加或维护订单的计费规则。订单计费规则是指在订单正常计价之后，对订单总金额的一些调整规则。</p></dd>
                            <dt>“送货方式管理”标签页</dt>
                            <dd><p>在这里添加或删除可用的送货方式。例如，邮政平邮、快递之类。</p></dd>
                            <dt>“付款方式管理”标签页</dt>
                            <dd><p>在这里添加或删除可用的付款方式。例如，邮政汇款、银行转帐之类。</p></dd>
                            <dt>“邮件通知设置”标签页</dt>
                            <dd><p>在这里设置当一个订单提交之后，是否给系统管理人员或客户本人发送邮件通知，以及邮件的内容模板。</p></dd>
                        </dl>
                    </asp:Panel>
                    
                    <asp:Panel ID="maint" Visible="false" runat="server">
                        <div class="path">操作路径： 点顶部“系统管理”图标，再点“系统维护”图标</div>
                        <dl>
                            <dt>系统清理</dt>
                            <dd><p>执行选定的系统清理工作。其中，勾选“缩略图缓存”，将删除缓存的缩略图文件，以迫使在需要显示缩略图时进行重新生成。通常不需要执行此项清理工作；勾选“匿名用户”，将删除所有未登录系统的情况下访问系统所产生的用户个性化数据，包括：收藏夹、界面风格设置等等。</p></dd>
                            <dt>系统备份和还原</dt>
                            <dd>
                                <p><span class="term">备份</span>点击“备份”按钮，系统会将整个系统所有数据和文件打包为一个压缩文件供下载保存。</p>
                                <p><span class="term">自动备份</span>点击“自动备份”按钮，可设置按指定周期自动将系统备份到指定的位置。</p>
                                <p><span class="term">还原</span>点击“还原”按钮，指定备份文件，系统会将其上传并还原到系统。</p>
                                <p>注：如果系统中图片和文件太多，备份或还原功能可能会超时而失败，可在服务器上手工操作，直接将系统安装目录进行备份或还原（若使用SQL Server数据库，还需使用SQL Server管理工具将两个数据库文件进行备份或还原）。</p>
                            </dd>
                            <dt>其它操作</dt>
                            <dd>
                                <dl class="listdefine">
                                    <dt>关闭系统</dt>
                                    <dd><p>停止系统的运行。关闭系统之后，对任何访问请求，将会提示“系统维护中…”，直到在服务器上移除系统根目录下的app_offline.htm文件，才会恢复运行。</p></dd>
                                    <dt>重新启动系统</dt>
                                    <dd><p>重新启动系统的运行环境，类似于服务器重新启动的效果，可回收系统占用的内存和缓存空间。</p></dd>
                                    <dt>切换数据库</dt>
                                    <dd><p>将当前系统切换到其它的数据库。这意味着将切换到以另一套数据库为基础的完全独立的系统，将会导致当前所有用户、设置等完全失效。如果以后再切换回当前数据库，系统会恢复到当前的状态。尽管这在技术上是可行的，但仍然建议从一而终地使用同一个数据库。另外需要说明的是，注册码是保存在数据库中的，并且不同数据库对应的注册码是不同的。</p></dd>
                                    <dt>压缩数据库</dt>
                                    <dd><p>清理数据库占用的无用空间。不建议频繁使用该功能。</p></dd>
                                    <dt>编辑外挂脚本</dt>
                                    <dd><p>参见<a href="?subject=jsplugin">外挂脚本</a>。</p></dd>
                                    <dt>下载调试数据</dt>
                                    <dd><p>调试数据包含了系统的数据库文件及相关信息，用于软件开发商调试解决软件故障。该功能也可用来单独备份数据库文件。</p></dd>
                                </dl>
                            </dd>
                        </dl>
                    </asp:Panel>
                    
                    <asp:Panel ID="power" Visible="false" runat="server">
                        <div class="path">操作路径： 系统管理 &rsaquo; 角色管理/用户管理，可设置用户的角色及角色的系统级权限</div>
                        <dl>
                            <dt>概述</dt>
                            <dd>
                                <p>用户，包括管理员建立的用户和自行注册的用户（如果允许注册）。角色，是一类用户的统称，如公司领导、员工、供应商、客户等。权限是设置给角色的，用户归属于某个角色就拥有了这个角色的权限。</p>
                            </dd>
                            <dt>系统权限</dt>
                            <dd>
                                <p>系统权限包括：<span class="key">系统管理权</span>（最高的权限，可执行包括系统设置、用户和角色管理等在内的许多操作，不受下面的权限规则所限）、<span class="key">模板创建权</span>、<span class="key">订单管理权</span>（如果启用了电子商务功能）。</p>
                                <p>由于与数据相关的权限是在模板级别进行设置的，所以即使多个角色的系统级权限完全相同，也不宜合并到一个角色中，因为对于具体的某个模板而言，可能需要为它们授予不同的权限。</p>
                            </dd>
                            <dt>沟通权限</dt>
                            <dd>
                                <ul class="decoration">
                                    <li runat="server" id="aboutInfoPower"><span class="term"><%= ims.Comm.Vars.InfoCenterText %></span>指定对<%= ims.Comm.Vars.InfoCenterText %>的权限。“浏览权限级别”用以控制只能浏览保密级别不高于该级别的<%= ims.Comm.Vars.InfoType %>；勾选“评论”则允许发表评论；勾选“管理”则允许进行删除等管理操作。</li>
                                    <li><span class="term">邮件权限</span>指定发送电子邮件的权限。</li>
                                    <li runat="server" id="aboutSmsPower"><span class="term">短信权限</span>指定发送手机短信的权限。</li>
                                    <li runat="server" id="aboutMsgPower"><span class="term">消息权限</span>指定发送系统消息的权限。</li>
                                </ul>
                            </dd>
				            <dt>模板权限</dt>
                            <dd>
                                <div class="path">操作路径： 设计中心，模板图标上点右键 - 权限。</div>
                                <p>在模板的权限设置对话框中，可分别设定每个角色对该模板的权限：</p>
                                    <ul class="decoration">
                                        <li><span class="term">浏览权限</span>即查看该模板类型的数据的权限。具体又分为0～10共11个级别，这些级别是与数据的保密级别对应的，只有浏览权限大于或等于保密级别，才能查看。
                                            在此基础上，还可以勾选“仅允许浏览符合条件的记录”，来进一步限定可浏览的范围。
                                        </li>
                                        <li><span class="term">编辑权限</span>指定是否允许录入或编辑此模板类型的数据，以及对模板中哪些字段有编辑权限。</li>
                                        <li><span class="term">评论权限</span>查看、发表和删除评论的权限。</li>
                                    </ul>
                                <p>注1：如果有系统管理权，或者在权限设置中勾选了“完全控制”，则可对模板和数据进行任何操作，如修改模板设计、备份和清除数据等。以下说明均不考虑这两种情况。</p>
                                <p>注2：如果对一条记录有编辑权限，则无条件地具有浏览权限。如果浏览权限级别低于字段的保密级别，则浏览时无法看到该字段内容，但对该字段有编辑权限则例外。</p>
                                <p>注3：模板在创建后默认仅管理员和其创建者有完全控制权，其它用户没有任何权限，直到明确指定了他们所属角色的权限。</p>
                            </dd>
                            <dt>权限引用</dt>
                            <dd>
                                <p>引用某模板的权限设置，意味着用户对当前模板和指定的模板具有相同的权限。但引用的权限将忽略涉及具体字段的选项。若源模板允许编辑部分字段，则将允许编辑所有字段；若浏览或编辑条件涉及具体的字段（非“创建人”等属性字段），将忽略之。</p>
                            </dd>
                            <dt>模板权限示意图</dt>
                            <dd style="padding-left:1em;color:red;font-weight:bold">
                                <div>设置用户角色：</div>
                                <img src="images/help/power.png" />
                                <div>设置角色权限：</div>
                                <img src="images/help/power_1.png" />
                                <div>权限控制效果：</div>
                                <img src="images/help/power_2.png" />
                            </dd>
                            <dt runat="server" id="dtFlowPower">流程权限</dt>
                            <dd runat="server" id="ddFlowPower">
                                <div class="path">操作路径： 设计中心，模板上点右键 - 属性 - 流程，点击创建流程或修改流程的链接</div>
                                <p>流程权限在流程设计中指定。流程“开始”步骤指定的“处理者”，才能发起该流程。</p>
                            </dd>
                            <dt runat="server" id="dtDirPower">目录权限</dt>
                            <dd runat="server" id="ddDirPower">
                                <div class="path">操作路径： 从左侧栏打开目录，再在右边子目录上点右键 - 权限（或空白处右键 - 权限，设置当前目录）</div>
                                <p>在系统设置中“启用目录权限控制”的前提下，可以按以下规则对与目录相关的操作进行权限控制。若未启用该选项，则只有可以添加记录者能进行目录相关的操作。</p>
                                <p>与目录相关的权限，包括：浏览权限、写入权限、完全控制权限。要在目录中添加记录或子目录，需要写入权限；要对目录设定权限，或删除、重命名该目录，需要完全控制权限。</p>
                                <p>目录权限其实只是控制用户是否可在其中添加数据或建立子目录而已，至于对目录中的数据有什么权限，是由这些数据的模板权限来决定的。</p>
                                <p>在根目录下新建的一级目录，除系统管理员外默认只有目录创建者有权限，其它人是没有权限的；在一级目录下建立的子目录，默认继承了其父目录的权限设置。</p>
                            </dd>
				            <dt>如何对某些人隐藏某个字段？</dt>
				            <dd><p>如果希望让部份用户看不到某个字段的内容，可以在模板设计中修改这个字段的保密级别，适当调高一些，如调至五级；再将这些用户归属到一个特定的角色，并设置该角色对该模板的浏览权限级别低于这个字段的保密级别，如四级。这样，这些用户将看不到该字段的内容——除非具有对这个字段的编辑权限（编辑权限优先于浏览权限）。</p></dd>
				            <dt>说明</dt>
				            <dd><p>修改了角色的权限后，当前已登录的用户仅在以下情况下才会应用新的权限：重新登录、会话过期，或应用程序重新启动。</p></dd>
				            <dt>相关主题</dt>
				            <dd class="related"><a href="?subject=users">用户管理</a><a href="?subject=roles">角色管理</a><a href="?subject=templets">模板管理</a></dd>
                        </dl>
                    </asp:Panel>
                    
                    <asp:Panel ID="users" Visible="false" runat="server">
                        <div class="path">操作路径： 系统管理 &rsaquo; 用户管理</div>
                        <dl>
                            <dt>相关术语</dt>
                            <dd>
                                <p><span class="term">机构</span>就是指像部门、科室、小组、分公司等这样的组织单元。</p>
                                <p><span class="term">分管的机构</span>指机构中非负责人用户所直接管辖的下级机构。例如部门经理的助理，其不是负责人，但仍可能管理部分下级机构。</p>
                            </dd>
                            <dt>如何建立组织机构？</dt>
                            <dd>
                                <p>在页面右侧主窗口中点右键，可以添加下级机构，就像在Windows中建立文件夹一样，可以建立起无限层次的组织机构树。</p>
                                <p>应根据实际的组织结构来建立组织机构树，并在每个机构中添加相应的用户，以及用户是否负责人，是否分管了下级机构等属性。</p>
                            </dd>
                            <dt>如何添加用户？</dt>
                            <dd><p>在右侧空白区域点击右键，从弹出菜单中选择“添加新用户”，输入用户名即可。如果系统中尚未设置默认用户信息，则必须先设置之后才能建立用户。默认用户信息包括用户初始密码等内容。</p></dd>
                            <dt>如何删除用户？</dt>
                            <dd><p>右键点击要删除的用户，选择“删除”即可。</p></dd>
                            <dt>如何设定用户角色？</dt>
                            <dd><p>右键点击要设置的用户，选择“属性”，在弹出的对话框中“角色”处勾选要设置的角色，点击确定即可。</p></dd>
                            <dt>用户管辖级别的确定</dt>
                            <dd>
                                <p>机构中的的普通成员，虽然与负责人位于同一机构，但他们是负责人的下级；</p>
                                <p>下级机构的负责人，是否作为本机构的直接成员，取决于系统设置中的设置。</p>
                            </dd>
				            <dt>相关主题</dt>
				            <dd class="related"><a href="?subject=roles">角色管理</a><a href="?subject=power&showpath=1">用户、角色及权限</a></dd>
                        </dl>
                    </asp:Panel>

                    <asp:Panel ID="roles" Visible="false" runat="server">
                        <div class="path">操作路径： 系统管理 &rsaquo; 角色管理</div>
                        <dl>
                            <dt>如何添加角色？</dt>
                            <dd><p>在空白区域点击右键，在弹出菜单中选择“添加新角色”，输入角色名即可。</p></dd>
                            <dt>如何删除角色？</dt>
                            <dd><p>右键点击要删除的角色，选择“删除”即可。仅在没有任何用户属于该角色的情况下，方可删除角色。</p></dd>
                            <dt>如何为角色设定权限？</dt>
                            <dd>
                                <p>点击要设置的角色，在弹出的对话框中即可设置角色的权限。具体请参考<a href="?subject=power&showpath=1">用户、角色及权限</a>。</p>
                            </dd>
				            <dt>相关主题</dt>
				            <dd class="related"><a href="?subject=users">用户管理</a><a href="?subject=power&showpath=1">用户、角色及权限</a></dd>
                        </dl>
                    </asp:Panel>

                    <asp:Panel ID="advsearch" Visible="false" runat="server">
                        <div class="path">操作路径： 鼠标移到导航区“<%= ims.Comm.Vars.DataCenterText %>”处，点“搜索”；或点顶部“搜索”图标，再点下面“高级搜索”链接；或在左仙栏导航区，鼠标移到 <img src="images/data_find.gif" /> 标签下，点击要搜索的项</div>
                        <dl>
                            <dt>概述</dt>
                            <dd><p>高级搜索是在指定的模板中以一个或多个字段作为搜索条件的一种搜索方式。由于能根据任一字段来指定条件，并可设置多个条件来进行组合，因此提供了很大的搜索灵活性。</p></dd>
                            <dt>如何设置搜索条件？</dt>
                            <dd>
                                <p>在高级搜索中，最多可以同时设定五个搜索条件，并按一定的逻辑关系进行组合。对于每一个条件，首先需要选择一个字段，然后选择“等于”、“包含”等逻辑运算符，最后设定条件的值。例如，可以设置“年龄”“大于”“18”来搜索所有的成年人。除第一个条件外，每一个条件上面都有一组单选按钮“并且”和“或者”，可以用来确定这个条件与上面的所有条件之间的组合关系。注意，“并且”和“或者”之前的所有条件是作为一个整体来进行组合的。</p>
                                <p>还可以将所设置的搜索条件保存为快捷方式，用于以后直接打开执行该搜索。</p>
                            </dd>
                            <dt>高级搜索示例</dt>
                            <dd>
                                <p>假定要在一个“通讯录”中搜索姓“张”或姓“王”的成年人，那么可以如下设置：</p>
                                <p>条件一（“姓名”“始于”“张”）<span class="key">“或者”</span>条件二（“姓名”“始于”“王”）<span class="key">“并且”</span>条件三（“年龄”“大于”“18”）。</p>
                            </dd>
                            <dt>说明</dt>
                            <dd>
                                <ul class="decoration">
                                    <li><span class="term">无关键字搜索</span>如果不输入关键字，表示搜索该字段内容为空的记录。</li>
                                    <li><span class="term">日期字段搜索</span>对于日期时间类型字段，可使用“在上（月/周/季/年/日）”之类的模式进行快速搜索。</li>
                                    <li><span class="term">"介于"模式</span>使用“介于”模式，表示搜索指定字段介于这两个值之间（并包含这两个值）的记录。</li>
                                    <li><span class="term">"始于"、"止于"模式</span>对于日期时间和数字类型，"始于"、"止于"可理解为大于等于和小于等于（如“生日”始于1980，表示搜索1980年1月1日后出生的人员）；对其它类型，则表示以指定的关键字开头或结尾（如“姓名”始于“李”，表示搜索所有姓李的人员）。</li>
                                </ul>
                                <p>提示：对于使用了输入提示之“允许多项输入”的字段，包含/不包含模式将执行完整匹配。如“abc，def”，不会认为包含“ab”。</p>
                            </dd>

                        </dl>
                    </asp:Panel>
                    
                    <asp:Panel ID="filters" Visible="false" runat="server">
                        <div class="path">操作路径： <%= ims.Comm.Vars.DataCenterText %>，模板上点右键 - 过滤器</div>
                        <dl>
                            <dt>什么是过滤器？</dt>
                            <dd><p>过滤器隶属于特定的模板，是对基于该模板的记录进行筛选的一组条件逻辑。设置过滤器的方法和效果均与针对该模板的高级搜索一致，只不过它将这种高级搜索的条件设置进行了命名并保存下来而已。</p></dd>
                            <dt>如何设置过滤器？</dt>
                            <dd><p>设置过滤器条件的方法与在<asp:HyperLink ID="HyperLink17" runat="server" NavigateUrl="help.aspx?subject=advsearch">高级搜索</asp:HyperLink>
                                中设置搜索条件完全相同。在设置完成后需要输入一个名称来保存该过滤器。选项“对访问者隐藏该过滤器”勾选后，在模板的右键菜单项”打开“中将看不到该过滤器。</p></dd>
                            <dt>在条件中使用变量</dt>
                            <dd>在条件中填写的变量，执行搜索时会替换为当时情况下合适的值。比如，设置条件“[创建人]”等于“$UserName$”，并保存为过滤器，那么当某个用户打开该过滤器时，将只能看到由他自己添加的记录。</dd>
                        </dl>
                    </asp:Panel>

                    <asp:Panel ID="datahome" Visible="false" runat="server">
                        <div class="path">操作路径： 点顶部“搜索”图标</div>
                        <dl>
                            <dt>如何搜索？</dt>
                            <dd>
                                <p>在搜索框上方设定搜索范围后，输入关键字并回车或点击“搜索”按钮，即可执行搜索。搜索设置会自动记忆。请熟悉以下的搜索规则和技巧：</p>
                                <ul class="decoration">
                                    <li><span class="term">指定搜索范围</span>指定一个具体的搜索范围，不但可以让搜索更准确快速，而且会有自动完成功能可以给予帮助。</li>
                                    <li><span class="term">无关键字搜索</span>如果不输入关键字直接点搜索按钮，那么：若搜索范围指定为“<%= ims.Comm.Vars.DataCenterText %>”或“<%= ims.Comm.Vars.InfoCenterText %>”，将会进入<%= ims.Comm.Vars.DataCenterText %>或<%= ims.Comm.Vars.InfoCenterText %>；若指定了某个模板，则会打开这个模板的数据；若同时还指定了字段，关键字留空则表示搜索该字段内容为空的记录。</li>
                                    <li><span class="term">多关键字搜索</span>如果搜索范围为“<%= ims.Comm.Vars.DataCenterText %>”或某个模板，输入以空格分隔的多个关键字，如“A B”，则当搜索模式为“包含”等模式，表示包含A或B；若是“包含全部”模式，表示既包含A又包含B；若是“不等于”或“不包含”，表示既不等于（或包含）A也不等于（或包含）B。</li>
                                    <li><span class="term">日期字段搜索</span>对于日期时间类型字段，关键字"2012-2-8"匹配当天24小时内这一时间段，"2012-2"匹配整月，"2012"匹配整年。如，可以输入"2012-2"来搜索2月份的订单。可点击输入框上面的日历图标选择日期，或从自动完成列表（其中包含当天、当月第一天等特殊日期）中选择。如需指定精确的时间，可按“<span class="red">2014-03-21 12:53:00</span>”这种格式手工输入。</li>
                                    <li><span class="term">是/否型字段搜索</span>对于“是/否”类型字段，可以输入"是"，"Yes"，"1"，"True"搜索肯定状态的记录；"否"，"No"，"0"，"False"搜索否定状态的记录。</li>
                                    <li><span class="term">"介于"模式</span>使用“介于”模式，可输入以空格分隔的两个关键字，表示搜索指定字段介于这两个值之间的记录。如，可输入“18 50”来搜索年龄在18到50岁的人员；输入“2010 2012”来搜索2010年初到2012年底之间签订的合同。</li>
                                    <li><span class="term">"始于"、"止于"模式</span>对于日期时间和数字类型，"始于"、"止于"可理解为大于等于和小于等于（如“生日”始于1980，表示搜索1980年1月1日后出生的人员）；对其它类型，则表示以指定的关键字开头或结尾（如“姓名”始于“李”，表示搜索所有姓李的人员）。</li>
                                    <li><span class="term">限定目录</span>若勾选“限定目录”，则仅在指定的目录中搜索符合条件的记录。</li>
                                </ul>
                                <p>提示：对于使用了输入提示之“允许多项输入”的字段，包含/不包含模式将执行完整匹配。如“abc，def”，不会认为包含“ab”。</p>
                            </dd>
                            <dt>快捷方式相关</dt>
                            <dd>
                                <ul class="decoration">
                                    <li>直接点击快捷方式名称，可打开该快捷方式。</li>
                                    <li>快捷方式的不同图标，表明了快捷方式的类型。如，目录、特定模板、筛选条件等。</li>
                                    <li>点击快捷方式右边的删除图标，可删除该快捷方式。</li>
                                </ul>
                                <p>说明：快捷方式保存的是当时的浏览条件，其结果可能会随数据的更改或权限的变化而不同。</p>
                            </dd>
                            <dt>收藏夹相关</dt>
                            <dd>
                                <ul class="decoration">
                                    <li>直接点击收藏夹中的任一项，可以打开其详细内容页面。</li>
                                    <li>可以一次性选中多项，再点击“打开选中项”来查看，或点击“删除选中项”来从收藏夹中删除。</li>
                                </ul>
                            </dd>
                        </dl>
                    </asp:Panel>

                    <asp:Panel ID="chart" Visible="false" runat="server">
                        <div class="path">操作路径： 鼠标移到左侧导航区“切换视图”（或显示为“最近浏览的数据”）处，点“图表视图”</div>
                        <dl>
                            <dt>概述</dt>
                            <dd>
                                <p>图表视图，是对当前所浏览的一系列记录的图表表现方式，能对事物的同一属性按给定指标直观地反映出统计结果。该视图的初始图表是程序自动选择统计项目和统计指标来生成的，要生成符合自己需要的统计图表，请设置好图表选项后点击“生成”按钮。</p>
                                <p>图表视图仅在所有记录基于同一模板的情况下可用。</p>
                            </dd>
                            <dt>示例</dt>
                            <dd>
                                <p>假设要以图表方式表现出所有员工不同学历的工资水平，可以这样设置图表选项：</p>
                                <p>图表类型：柱状图；统计项目：学历；统计指标：月薪；统计方法：平均值；排序方式：大→小。</p>
                            </dd>
                            <dt>技巧</dt>
                            <dd>
                                <dl class="listdefine">
                                    <dt>如何自己指定统计项目的分段区间？</dt>
                                    <dd><p>
                                        在选择了可以自定义区间分隔值的字段（如，数字类型、日期时间类型）后，会出现“区间分隔点”选项，在这个文本框中输入作为分隔点的值即可。例如，要以五年为一个单位来统计销售收入情况，假设所有数据是介于1997～2008年之间的，那么可以输入“2000-1-1,2005-1-1”，表示将2000年1月1日以前的作为一段，到2005年1月1日之间的作为一段，最后的作为一段。</p></dd>
                                    <dt>如何保存生成的图表？</dt>
                                    <dd><p>所生成的图表实际上是一个图片，所以可以直接在上面点右键，选“图片另存为…”来保存到磁盘上。</p></dd>
                                </dl>
                            </dd>
                        </dl>
                    </asp:Panel>

                    <asp:Panel ID="cart" Visible="false" runat="server">
                        <div class="path">操作路径： 首页，点“我的购物车”图标</div>
                        <dl>
                            <dt>概述</dt>
                            <dd><p>购物车中以表格形式列出了已选购而尚未提交订单的商品。在这里可以修改商品的订购数量、删除某种或全部商品。以匿名方式所选购的商品同样会保存在购物车中，在提交订单时可以登录自己的帐户，或直接以匿名方式提交订单。提交之后，购物车将自动被清空。</p></dd>
                        </dl>
                    </asp:Panel>
                    
                    <asp:Panel ID="detaillayout" Visible="false" runat="server">
                        <div class="path">操作路径： 详情视图下，点下面的“版式”按钮。如果弹出菜单，点“版式管理”</div>
                        <dl runat="server" id="tableLayout">
                            <dt>如何进行表格版式排版？</dt>
                            <dd>
                                <p>详细内容页面的默认版面是程序自动生成的，通常需要以手工方式调整版面来使得版面更为美观。</p>
                                <p>表格式排版的版面分为A、B、C三个区，A区和B区是并列显示的，C区则在底部通栏显示（常用于放置内容较多的字段）。可以用鼠标拖动字段名称来调整其所在的区域或在区域中的顺序；拖动“➜|”标记可调整列的宽度。调整好之后点击“确定”按钮来将排版结果保存下来，在之后浏览相同模板的记录时，将会按所设置的版面来显示。最好在A、B两个区域中放置相同数量的字段，否则在显示时会出现空的单元格，影响美观。</p>
                                <p>不需要显示的字段，可拖入“回收站”区域。</p>
                            </dd>
                        </dl>
                        <dl runat="server" id="freeLayout">
                            <dt>如何进行自由排版？</dt>
                            <dd>
                                <p>使用自由排版，可以像在Word中那样按自己想要的样式编排内容和格式，其中可插入字段标记或变量标记，这些标记在浏览时会被替换为其对应的值。</p>
                                <p>字段的标记代码可以在右下方“代码速查”处查询。</p>
                                <p>技巧1：如果想将编辑器中的版面初始化为之前所保存的表格版式，只需清空编辑器并输入命令“Reset”，点击“确定”即可；也可输入命令“Auto”来自动生成版式。</p>
                                <p>技巧2：可在编辑器中点<img src="images/tabs.gif" />按钮插入多标签页（选项卡）组件来分区组织内容、插入分页符控制打印分页，详见<asp:HyperLink ID="HyperLink27" NavigateUrl="help.aspx?subject=editor" runat="server">编辑器</asp:HyperLink>。</p>
                            </dd>
                            <dt>如何使自由排版的页面支持就地编辑？</dt>
                            <dd>
                                <p>表格式排版的页面，在浏览时可以双击单元格进行就地编辑，自由排版要实现这种功能，需要如下处理：</p>
                                <p style="text-indent:0;padding-left:2em">
                                    在编辑框中点“源码”按钮切换到源代码视图，找到字段代码所在的HTML元素，如：<br />
                                    <span class="green">&lt;td&gt;姓名&lt;/td&gt;&lt;td&gt;[F929105C6q12837]&lt;/td&gt;</span><br />
                                    <span>在起始标签中添加fid属性，如：</span><br />
                                    <span class="green">&lt;td&gt;姓名&lt;/td&gt;&lt;td <span class="red">fid="35"</span>&gt;[F929105C6q12837]&lt;/td&gt;</span><br />
                                    <span>这儿的“35”是指字段的ID号，就是“代码速查”处显示在字段名后面括号中的数字。</span><br />
                                    <span>这样保存后，浏览时就可以双击所显示的字段值来编辑了。</span>
                                    </p>
                                <p>提示：不论字段代码放在什么地方，都可以通过在包含它的HTML标记中添加fid属性支持就地编辑。以表格形式显示的关联的明细记录，系统会自动添加就地编辑功能。</p>
                            </dd>
                            <dt>用自由排版来显示关联记录</dt>
                            <dd>
                                <p>自由排版时，可引用并显示任意模板的相关记录。方法如下：</p>
                                <p>先在页面左下方定义查询，用于指定如何匹配关联的记录。然后，用诸如“$D0.[F9N23D]”的形式在编辑器中引用，表示要在此处显示$D0查询结果中字段“F9N23D”的值。默认只显示第一条记录，可添加“.R”标记显示所有查询结果，如“$D0.[F9N23D].R”。 若想用表格来显示查询结果，有两种方法：</p>
                                <p>1. 使用代码<span class="red">$D0.Table</span>（$D0应替换为对应查询的引用标记。在查询设置界面可设置表格的字段和样式）。</p>
                                <p>2. 插入一个表格，并在表格标题行下一行每个单元格中引用该查询，如"$D0.[F9N23D].R"，这样将为每条查询记录生成一行(可用“$D0.No”显示序号)。建议右键设置表格属性：边框:0；间距:1；样式类:normal。</p>
                            </dd>
                            <dt>关于表格样式类</dt>
                            <dd>
                                <ul class="decoration" style="margin-left:42px">
                                    <li>normal：表格框线显示为细线条</li>
                                    <li>hr：仅显示每行的下边框线</li>
                                    <li>grayline：灰色表格框线</li>
                                    <li>blackline：黑色表格框线</li>
                                    <li>seprow：表格隔行变色</li>
                                    <li>样式类组合用法示例：<span class="red">normal seprow</span></li>
                                </ul>
                            </dd>
                            <dt>关于条形码和二维码</dt>
                            <dd>
                                <p>条形码（一维）和二维码统称为条码，是按照一定的规则编码产生的用以表达一组信息的图形标识符，是广泛应用于商业、邮政、物流等领域的一种自动识别技术，具有输入快、成本低、可靠性强等优点。以下介绍几种主要的条码类型：</p>
                                <p><span class="term">EAN码</span> 是国际通用的符号体系，表达一组固定长度的数字，主要应用于商品标识；</p>
                                <p><span class="term">CODE 39/128码</span> 为目前国内企业内部自定义码制，可编码不定长的数字和字母；</p>
                                <p><span class="term">QR Code（二维码）</span> QR Code是最常见的一种二维码，其信息容量大、可靠性高、可快速识别、保密防伪性强，可表示字母、数字和汉字。</p>
                                <p>注：不同的条码类型有不同的规则要求，不符合规则的文本将不会产生条码图形，或者会被程序自动纠正（如"1234567890123"，采用EAN-13编码，最后一位会被修改为8）。</p>
                                <p style="text-align:right"><a href="http://baike.baidu.cn/view/13740.htm" target="_blank">了解关于条码的更多知识…</a></p>
                            </dd>
				            <dt>相关主题</dt>
				            <dd class="related"><a href="?subject=editor">编辑器</a></dd>
                        </dl>
                    </asp:Panel>
                    
                    <asp:Panel ID="dir" Visible="false" runat="server">
                        <div class="path">操作路径： 左侧栏，在“目录”区，可点击打开某个目录。如果没有显示目录区，可能是由于对根目录没有浏览权限，或自定义左侧栏时隐藏了目录区</div>
                        <p>注：随权限的不同，以下所涉及到的某些菜单项可能不会在右键菜单中显示。</p>
                        <dl>
                            <dt>什么是目录？</dt>
                            <dd><p>目录是一种对数据记录进行分类查看的组织形式。数据本身是存储于<%= ims.Comm.Vars.DataCenterText %>的数据表中的，无论归属到哪个目录，都可以从这个表或其它非目录方式打开查看（只要有权限）。模板属性中可以设置数据是否关联到目录，在<%= ims.Comm.Vars.DataCenterText %>或表格视图，可以将数据从原来的目录移动到指定的目录（但并不会从数据表中移除）。</p></dd>
                            <dt>如何创建一个目录？</dt>
                            <dd><p>右键点击目录中的空白区域，点“新建目录”，输入目录名并回车即可。</p></dd>
                            <dt>如何打开一个目录？</dt>
                            <dd><p>有三种方式：一是直接单击要打开的目录；二是在目录上点右键，在弹出菜单中选“打开”；三是从左侧栏的目录树中找到并单击要打开的目录名。</p></dd>
                            <dt>如何为目录设置权限？</dt>
                            <dd><p>在启用了目录权限控制的情况下，系统管理员或对目录有完全控制权限的人可以设置目录权限。设置方法是：右键点击要设置的目录，在菜单中选“权限”，然后在弹出的对话框中分别为每个角色设置其对该目录的权限。关于角色和目录权限，请参考<a href="?subject=power&showpath=1" runat="server">用户、角色及权限</a>。</p></dd>
                            <dt>目录权限与模板权限有什么关系？</dt>
                            <dd><p>目录权限只是用来控制是否允许在其中添加记录或子目录的，至于对目录中已经存在的记录有什么权限，是由模板权限决定的。</p></dd>
                            <dt>如何在目录中添加记录？</dt>
                            <dd><p>右键点击目录中的空白区域，点“新建”，选择模板后，即可进入数据录入页面。也可直接在“新建”的下级菜单中选择一个模板来添加记录。</p></dd>
                            <dt>如何对目录中的内容进行排序？</dt>
                            <dd><p>
                                右键点击目录中的空白区域，在“排序”的下级菜单中点击要用作排序依据的字段即可。如果再次用同一字段来排序，则会以相反的顺序排序。在“排序”的下级菜单项中，带有图标<img src="images/asc.gif" />或<img src="images/desc.gif" />的项是当前的排序依据项，前一个图标表示顺序排序，后一个图标表示逆序排序。</p></dd>
                            <dt>小技巧</dt>
                            <dd>
                                <ul class="decoration">
                                    <li>在需要翻页浏览时，可以使用键盘进行快捷操作。方向键→或PageDown键可翻到下一页；方向键←或PageUp可翻到上一页；Home键到第一页；End键到最后一页。</li>
                                    <li>直接单击缩略图可打开其详细信息页面；单击缩略图中间的悬泘图标，可查看其较大尺寸的图片，并进入幻灯显示状态。</li>
                                    <li>可以拖动目录来调整目录的位置和顺序，系统管理员权限的用户的这种调整结果将作为系统默认的顺序，而其它用户的调整则仅应用于其本人。</li>
                                </ul>
                            </dd>
                        </dl>
                    </asp:Panel>
                    
                    <asp:Panel ID="edit" Visible="false" runat="server">
                        <div class="path">操作路径： 鼠标移到左侧栏导航区“<%= ims.Comm.Vars.DataCenterText %>”处，点“添加”；或鼠标移到导航区 <img src="images/data_add.gif" /> 标签处，点要添加的项；或打开“<%= ims.Comm.Vars.DataCenterText %>”，在模板上点右键 - 添加；或详情视图下，点“编辑”按钮；或表格视图下，在数据行的操作菜单中点“编辑”</div>
                        <dl>
                            <dt>如何进行编辑？</dt>
                            <dd>
                                <p>标注了红色星号<span style="color:Red">*</span>的字段是必填项。录入完毕之后，点击“保存”按钮保存数据，或点击“另存”按钮，将当前表单作为一条新的记录进行保存。可以在保存前指定“保存后的动作”（此选择会自动记忆）。</p>
                            </dd>
                            <dt>如何对编辑界面排版？</dt>
                            <dd>
                                <p>点击下面的“版式”按钮，会弹出菜单，可管理版式或切换到其它版式。点击“版式管理”，可添加或修改版式，或设置默认版式。</p>
                                <p>如果当前使用的是经典版式，则可直接拖动字段名称来调整位置进行排版，调整的结果将自动保存下来。</p>
                            </dd>
                            <dt>技巧和说明</dt>
                            <dd><ul class="decoration">
                                <li>经典版式中，可以使用键盘上下方向键来将光标移到上一行或下一行。在文本框中输入完毕后按回车键，将执行保存动作。</li>
                                <li>可点击右上角“导入”链接，来选择一条记录导入到表单中，再作适当修改后保存，以减轻录入工作量。</li>
                                <li>在输入链接类型字段值时，可将链接文字部份留空，这样在显示时将以链接地址来代替链接文字。</li>
                                <li>关于编辑器的使用，请参考“<a href="?subject=editor">编辑器</a>”。</li>
                            </ul></dd>
                        </dl>
                    </asp:Panel>
                    <asp:Panel ID="rows" Visible="false" runat="server">
                        <div class="path">操作路径： 编辑页面点“版式”按钮 - 多行录入。也可点“版式管理”，将“多行录入”设为默认版式</div>
                        <dl>
                            <dt>如何排版？</dt>
                            <dd>
                                <p>鼠标拖动列可调整其顺序；拖动列边界线可调整列宽度。调整结果会自动记忆。</p>
                                <p>也可点“版式”按钮，切换为其它版式进入数据录入。</p>
                            </dd>
                            <dt>表格基本操作</dt>
                            <dd><ul class="decoration">
                                <li>单击左下角"*"单元格可增加一行，右键点击可增加多行，或粘贴所复制的行；</li>
                                <li>单击行的序号单元格可选中该行，按住Ctrl键单击可实现多选，按住Shift键或用鼠标拖动可选择一个范围；</li>
                                <li>右键单击序号单元格可弹出操作菜单，实现复制、剪切、删除、清空、粘贴等操作；</li>
                                <li>可使用方向键或Tab键在单元格之间跳转。</li>
                            </ul></dd>
                        </dl>
                    </asp:Panel>
                    <asp:Panel ID="editlayout" Visible="false" runat="server">
                        <div class="path">操作路径： 编辑页面点“版式”按钮 - 版式管理</div>
                        <dl>
                            <dt>如何编排表单版式？</dt>
                            <dd>
                                <p>在左侧编辑框内，可以输入任意内容，类似于在Word中排版的方式。在需要放置字段或子表单编辑控件的地方，从右侧拖入即可。有两种排版模式：</p>
                                <p><span class="term">编辑模式</span>可输入和修改文字、图片、表格等内容；</p>
                                <p><span class="term">拖拽模式</span>可用鼠标拖动元素来调整其位置或尺寸，或设置字段的显示方式（勾选以"块元素"显示；反之按"行内元素"显示），及子表单的初始行数。</p>
                            </dd>
                            <dt>如何重置编辑控件的宽度和高度？</dt>
                            <dd>
                                <p>直接拖入版式区的字段或子表单控件，是自动确定宽度和高度的。在调整了宽度或高度后，如果想恢复默认尺寸，可在拖拽模式下将其拖入右侧候选区再重新拖回版式区。</p>
                            </dd>
                            <dt>使用表格进行排版</dt>
                            <dd>
                                <p>可在编辑模式下插入表格，并将字段或子表单控件拖入表格适当位置。在表格中右键，从“表格属性”对话框可设置表格样式。建议设置为：边框:0；间距:1，样式类：</p>
                                <ul class="decoration" style="margin-left:42px">
                                    <li>(无)：不显示边框线</li>
                                    <li>normal：表格框线显示为细线条</li>
                                    <li>hr：仅显示每行的下边框线</li>
                                    <li>grayline：灰色表格框线</li>
                                    <li>blackline：黑色表格框线</li>
                                </ul>
                                <p>提示： 将表格宽度设为百分比值，如100%，将按其所在位置宽度自动确定表格宽度；要确定各列宽度，应设置该列第一行的单元格宽度，此时建议至少留一列不设宽度，这样该列将自动占据剩余空间，而不会导致表格总宽度超出所在位置。</p>
                            </dd>
                            <dt>技巧</dt>
                            <dd>
                                <ul class="decoration" style="margin-left:42px">
                                    <li>双击版式区域，可快捷切换排版模式；编辑模式下，从右侧拖动字段将自动进入拖拽模式。</li>
                                    <li>如果希望子表单编辑区显示边框，可将其放置在一个单行单列的表格中，利用表格的边框作为它的边框。</li>
                                </ul>
                            </dd>
                        </dl>
                    </asp:Panel>
                    <asp:Panel ID="orderadmin" Visible="false" runat="server">
                        <div class="path">操作路径： 首页，点“订单管理”图标</div>
                        <dl>
                            <dt>如何搜索订单？</dt>
                            <dd>
                                <p>在订单搜索选项中，有“订单号”等六个搜索条件可供选择。勾选并设置一个或多个条件后，点击搜索图标即可执行订单搜索。如果不勾选任何条件，则表示列出全部订单。注：“订单号”和“下单人”两个条件均不支持模糊搜索，即必须指定准确的订单号或下单人。</p>
                            </dd>
                            <dt>如何处理订单？</dt>
                            <dd>
                                <p>点击订单号，可以查看该订单的详细信息；点击“删除”可以删除订单；点击“查看”可以看到该订单的处理记录；将鼠标移到订单的下单时间上，可以查看包含了时间部份的准确下单时间。</p>
                                <p>在订单的详细信息对话框中，可以在“管理员备注”中填写对该订单的处理说明，供下单人了解。如，商品缺货，可以在此注明。在该窗口中还可以修改订单的状态。</p>
                                <p>说明：点击列标题“订单金额”或“下单时间”可以按该列的值进行升序或降序排序。</p>
                            </dd>
                        </dl>
                    </asp:Panel>
                    
                    <asp:Panel ID="myorder" Visible="false" runat="server">
                        <div class="path">操作路径： 首页，点“我的订单”图标</div>
                        <dl>
                            <dt>如何查看自己的订单？</dt>
                            <dd>
                                <p>在进入该页面后，默认会列出自己所提交的所有订单，也可以通过在“订单搜索”中勾选并设置一个或多个条件来搜索特定的订单。</p>
                                <p>在订单列表中，点击订单号可以查看该订单的详细信息。对于待审核的订单，可以执行“取消订单”操作。</p>
                            </dd>
                        </dl>
                    </asp:Panel>

                    <asp:Panel ID="templet" Visible="false" runat="server">
                        <div class="path">操作路径： 设计中心，空白处右键 - 添加模板；或点击打开已有模板，即进入模板设计界面</div>
                        <dl>
                            <dt>概述</dt>
                            <dd>
                                <p>模板设计，是分析管理需求，规定要纳入管理的对象的各个属性的过程，就像要建立自己的通讯录，需要先确定它要包含姓名、电话、地址等哪些内容一样。这些要管理的属性，被称为“字段”，包括文本、数字、日期时间、单选或多选列表、图片和文件等类型。为了数据的录入和管理更方便，还可以指定这些字段的一些细节特性，如默认值、是否必须填写等。</p>
                            </dd>
                            <dt>数据类型</dt>
                            <dd>
                                <dl class="inlinedefine">
                                    <dt>文本：</dt>
                                    <dd>普通的文本数据。如，姓名、地址。
                                        <table class="normal" cellspacing="1" border="0">
		                                    <tr>
			                                    <th style="width:59%">输入界面示意：</th>
			                                    <th style="width:41%">显示效果：</th>
		                                    </tr>
		                                    <tr>
			                                    <td align="center"><img src="images/help/text.png" /></td>
			                                    <td align="center"><img src="images/help/text_1.png" /></td>
		                                    </tr>
                                        </table>
                                    </dd>
                                    <dt>数字：</dt>
                                    <dd>只允许输入数字值。如，年龄、身高。
                                        <table class="normal" cellspacing="1" border="0">
		                                    <tr>
                                                <th style="width:43%">字段设置示例：</th>
			                                    <th style="width:31%">输入界面示意：</th>
			                                    <th style="width:26%">显示效果：</th>
		                                    </tr>
		                                    <tr>
			                                    <td align="center" style="padding:0"><img src="images/help/numeric_2.png" /></td>
			                                    <td align="center"><img src="images/help/numeric.png" /></td>
			                                    <td align="center"><img src="images/help/numeric_1.png" /></td>
		                                    </tr>
                                        </table>
                                    </dd>
                                    <dt>日期时间：</dt>
                                    <dd>只允许输入日期和时间类型的值。如，生日。
                                        <table class="normal" cellspacing="1" border="0">
		                                    <tr>
			                                    <th style="width:59%">输入界面示意：</th>
			                                    <th style="width:41%">显示效果：</th>
		                                    </tr>
		                                    <tr>
			                                    <td align="center"><img src="images/help/datetime.png" /></td>
			                                    <td align="center"><img src="images/help/datetime_1.png" /></td>
		                                    </tr>
                                        </table>
                                    </dd>
                                    <dt>单选列表：</dt>
                                    <dd>从指定的多个选项中选择一项。该类型通常用于数据值都是某些已知的值之一的情况，如省份、联系人类别（好友、同事等）。需要在字段中预先设定好待选项。
                                        <table class="normal" cellspacing="1" border="0">
		                                    <tr>
			                                    <th style="width:59%">输入界面示意：</th>
			                                    <th style="width:41%">显示效果：</th>
		                                    </tr>
		                                    <tr>
			                                    <td align="center"><img src="images/help/singlelist.png" /></td>
			                                    <td align="center"><img src="images/help/singlelist_1.png" /></td>
		                                    </tr>
                                        </table>
                                    </dd>
                                    <dt>多选列表：</dt>
                                    <dd>从指定的多个选项中选择一项或多项。该类型通常用于数据值都是某些已知的值的其中一部份的情况，如兴趣爱好。需要在字段中预先设定好待选项。
                                        <table class="normal" cellspacing="1" border="0">
		                                    <tr>
			                                    <th style="width:59%">输入界面示意：</th>
			                                    <th style="width:41%">显示效果：</th>
		                                    </tr>
		                                    <tr>
			                                    <td align="center"><img src="images/help/multiplelist.png" /></td>
			                                    <td align="center"><img src="images/help/multiplelist_1.png" /></td>
		                                    </tr>
                                        </table>
                                    </dd>
                                    <dt>是/否：</dt>
                                    <dd>只有肯定和否定两种情况之一。如，考试是否通过、婚否。
                                        <table class="normal" cellspacing="1" border="0">
		                                    <tr>
			                                    <th style="width:59%">输入界面示意：</th>
			                                    <th style="width:41%">显示效果：</th>
		                                    </tr>
		                                    <tr>
			                                    <td align="center"><img src="images/help/yesno.png" /></td>
			                                    <td align="center"><img src="images/help/yesno_1.png" /></td>
		                                    </tr>
                                        </table>
                                    </dd>
                                    <dt>公式：</dt>
                                    <dd>对同一模板中的其它一个或多个字段进行某种计算来得到值。如，提成额＝销售额×0.15。
                                        <table class="normal" cellspacing="1" border="0">
		                                    <tr>
			                                    <th style="width:59%">字段设置示例：</th>
			                                    <th style="width:41%">显示效果：</th>
		                                    </tr>
		                                    <tr>
			                                    <td align="center" style="background:#f4f7fb"><img src="images/help/formula.png" /></td>
			                                    <td align="center"><img src="images/help/formula_1.png" /></td>
		                                    </tr>
                                            <tr><td colspan="2" class="comment">说明：公式字段不会出现在数据输入界面，它的值是在浏览时动态计算得到的。公式字段常用于对同一条记录中的一个或多个字段进行计算取值；而查询字段常用于对一批记录的同一个字段进行取值。</td></tr>
                                        </table>
                                    </dd>
                                    <dt>查询：</dt>
                                    <dd>从指定模板中根据指定条件和方法进行查询计算来得到值。如下图示意，订单模板中的“订单金额”字段，是从订单商品明细模板中根据订单编号来计算该编号下所有商品的金额合计。
                                        <table class="normal" cellspacing="1" border="0">
		                                    <tr>
			                                    <th style="width:51%">字段设置示例：</th>
			                                    <th style="width:49%">查询逻辑示意：</th>
		                                    </tr>
		                                    <tr>
			                                    <td align="center" style="padding:0;background:#f4f7fb"><img src="images/help/query_1.png" /></td>
			                                    <td align="center"><img src="images/help/query_2.png" /></td>
		                                    </tr>
                                            <tr><td colspan="2" class="comment">说明：查询字段不会出现在数据输入界面，它的值是在浏览时动态计算得到的，并随数据源变化而变化（若不希望这样，就应使用文本等类型，配合“输入提示”的“自动填充”功能，在录入时取值）。查询字段常用于对一批记录的同一个字段进行取值；而公式字段常用于对同一条记录中的一个或多个字段进行计算取值。</td></tr>
                                        </table>
                                    </dd>
                                    <dt>图片：</dt>
                                    <dd>用于存放图片。如，模板“人事档案”中的“照片”字段。支持以下图片格式：jpg，gif，png，bmp，tif，emf，wmf，ico。
                                        <table class="normal" cellspacing="1" border="0">
		                                    <tr>
			                                    <th style="width:59%">输入界面示意：</th>
			                                    <th style="width:41%">显示效果：</th>
		                                    </tr>
		                                    <tr>
			                                    <td align="center"><img src="images/help/photo.png" /></td>
			                                    <td align="center"><img src="images/help/photo_1.png" /></td>
		                                    </tr>
                                        </table>
                                    </dd>
                                    <dt>文件：</dt>
                                    <dd>用于存放文件。如，产品说明书。支持的文件类型取决于系统设置中“允许上传的文件类型”。
                                        <table class="normal" cellspacing="1" border="0">
		                                    <tr>
			                                    <th style="width:55%">输入界面示意：</th>
			                                    <th style="width:45%">显示效果：</th>
		                                    </tr>
		                                    <tr>
			                                    <td align="center"><img src="images/help/file.png" /></td>
			                                    <td align="center"><img src="images/help/file_1.png" /></td>
		                                    </tr>
                                        </table>
                                    </dd>
                                    <dt>链接：</dt>
                                    <dd>用于设置内部链接或外部链接。如，模板“供应商”中的“网站”字段。内部链接是指链接到系统内部某个页面的链接，其地址如：dir.aspx?id=1，表示链接到ID为1的目录。
                                        <table class="normal" cellspacing="1" border="0">
		                                    <tr>
			                                    <th style="width:55%">输入界面示意：</th>
			                                    <th style="width:45%">显示效果：</th>
		                                    </tr>
		                                    <tr>
			                                    <td align="center"><img src="images/help/hyperlink.png" /></td>
			                                    <td align="center"><img src="images/help/hyperlink_1.png" /></td>
		                                    </tr>
                                        </table>
                                    </dd>
                                    <dt>自动编号：</dt>
                                    <dd>用于自动生成一个编号。在录入数据时，系统会自动根据编号规则来生成编号，而不用手工输入。通常用于确保每条记录有个唯一的编号，并可通过该编号与其它模板间建立起某种关联。
                                        <table class="normal" cellspacing="1" border="0">
		                                    <tr>
			                                    <th style="width:55%">字段设置示例：</th>
			                                    <th style="width:45%">显示效果：</th>
		                                    </tr>
		                                    <tr>
			                                    <td align="center" style="background:#f4f7fb"><img src="images/help/autonumber.png" /></td>
			                                    <td align="center"><img src="images/help/autonumber_1.png" /></td>
		                                    </tr>
                                        </table>
                                    </dd>
                                    <dt>特殊文本：</dt>
                                    <dd>用于记录手机号码、邮箱地址、QQ号等特殊的文本类型。这种类型的字段值在录入时会有相应的验证，防止输入不符合规则的数据，在浏览时会呈现为链接，点击可执行发送手机短信、邮件、QQ消息等相应的任务。
                                        <table class="normal" cellspacing="1" border="0">
		                                    <tr>
			                                    <th style="width:55%">输入界面示意：</th>
			                                    <th style="width:45%">显示效果：</th>
		                                    </tr>
		                                    <tr>
			                                    <td align="center"><img src="images/help/specialtext.png" /></td>
			                                    <td align="center"><img src="images/help/specialtext_1.png" /></td>
		                                    </tr>
                                        </table>
                                    </dd>
                                    <dt>变量：</dt>
                                    <dd>变量类型的字段，在录入时不会出现，它的值是在保存时由系统自动根据当时的情况来确定的。比如，当时录入人员的用户名、时间之类。
                                        <table class="normal" cellspacing="1" border="0">
		                                    <tr>
			                                    <th style="width:55%">字段设置示例：</th>
			                                    <th style="width:45%">显示效果：</th>
		                                    </tr>
		                                    <tr>
			                                    <td align="center" style="background:#f4f7fb"><img src="images/help/variable.png" /></td>
			                                    <td align="center"><img src="images/help/variable_1.png" /></td>
		                                    </tr>
                                        </table>
                                    </dd>
                                </dl>
                            </dd>
                            <dt>如何添加一个字段？</dt>
                            <dd>
                                <p>点击“添加字段”，输入字段名称，选择好数据类型并设置其它选项后，点击“确定”即可。可用的选项根据数据类型的不同而不同，分别解释如下：</p>
                                <dl class="inlinedefine">
                                    <dt>默认值</dt>
                                    <dd>指定字段的默认值。在添加记录时，默认值会作为该字段的初始值。如，人事档案的“健康状况”字段的默认值可设为“健康”。<br />
                                    </dd>
                                    <dt>保密级别</dt>
                                    <dd>设定该字段的保密级别（数字越大，保密级别越高）。除了权限较高的管理人员外，只有浏览权限级别不低于指定的保密级别的人员才能查看该字段的内容。
                                        <table class="normal" cellspacing="1" border="0">
		                                    <tr>
			                                    <th style="width:33%">字段设置示例：</th>
			                                    <th style="width:67%">权限设置示例：</th>
		                                    </tr>
		                                    <tr style="background:#f4f7fb">
			                                    <td align="center"><img src="images/help/seclevel.png" /></td>
			                                    <td align="center"><img src="images/help/seclevel_1.png" /></td>
		                                    </tr>
                                            <tr><td colspan="2" class="comment">说明：按此示例的设置，员工角色的用户将看不到这个字段的内容。</td></tr>
                                        </table>
                                    </dd>
                                    <dt>必填字段</dt>
                                    <dd>设定在编辑时，是否必须为该字段指定一个值。如，人事档案的“姓名”字段通常应设为必填字段，而“特长”字段则相反，应该是可填可不填。<br /></dd>
                                    <dt>不允许重复值</dt>
                                    <dd>设定是否允许使用该模板的记录在该字段中存在相同的值。如，“学号”字段应勾选该选项，而“成绩”字段则不应该勾选。<br /></dd>
                                    <dt>内容长度</dt>
                                    <dd>指定该字段最多允许输入多少个字（中英文不论）。“0”或留空表示不限字数。建议设置为这个字段最大可能的内容长度值。这个值也决定了编辑界面生成的输入框的大小。<br /></dd>
                                    <dt>使用编辑器</dt>
                                    <dd>设定在编辑时是否使用<asp:HyperLink ID="HyperLink19" runat="server" NavigateUrl="help.aspx?subject=editor">编辑器</asp:HyperLink>，以便支持设置字体、颜色，插入图片等功能。
                                        <table class="normal" cellspacing="1" border="0">
                                            <tr><th>输入界面示意：</th></tr>
		                                    <tr>
			                                    <td><img src="images/help/editor.png" /></td>
		                                    </tr>
                                            <tr><th>显示效果：</th></tr>
		                                    <tr>
			                                    <td align="center"><img src="images/help/editor_1.png" /></td>
		                                    </tr>
                                        </table>
                                    </dd>
                                    <dt>链接</dt>
                                    <dd>如果勾选并设置了该选项，在浏览时该字段的文本将显示为一个链接，点击这个链接将显示符合所指定条件的记录。如，在“产品”模板的“产品代码”字段设置链接：
                                        <p>链接到：产品投诉记录，（产品投诉记录的）产品代码等于当前（产品模板的）“产品代码”。</p>
                                        <table class="normal" cellspacing="1" border="0">
                                            <tr><th>字段设置示例：</th></tr>
		                                    <tr>
			                                    <td align="center"><img src="images/help/innerlink.png" /></td>
		                                    </tr>
                                            <tr><th>链接效果示意：</th></tr>
		                                    <tr>
			                                    <td align="center"><img src="images/help/innerlink_1.png" /></td>
		                                    </tr>
                                        </table>
                                    </dd>
                                    <dt>输入提示</dt>
                                    <dd>设定在编辑时该字段是否具有输入提示（自动完成）功能。如，可以为“供货记录”模板的“供应商”字段设置输入提示功能，其“数据来源”设置为“供应商”，取前20项“公司名称”，这样，在录入供货记录时，在供应商字段中会用下拉列表列出与当前输入字符相关的供应商名称供选择。
                                        <table class="normal" cellspacing="1" border="0">
		                                    <tr>
			                                    <th style="width:58%">字段设置示例：</th>
			                                    <th style="width:42%">输入效果示意：</th>
		                                    </tr>
		                                    <tr>
			                                    <td style="padding:0;background:#f4f7fb"><img src="images/help/autocomplete.png" /></td>
			                                    <td style="padding:0"><img src="images/help/autocomplete_1.png" /></td>
		                                    </tr>
		                                    <tr>
			                                    <th>字段设置示例：</th>
			                                    <th>输入效果示意：</th>
		                                    </tr>
		                                    <tr>
			                                    <td style="padding:0;background:#f4f7fb"><img src="images/help/autocomplete_2.png" /></td>
			                                    <td style="padding:0"><img src="images/help/autocomplete_3.png" /><div style="padding:4px">说明：此处输入产品代码，系统就会自动填入相应的产品名称。</div></td>
		                                    </tr>
                                        </table>
                                        注：输入提示的取值会受到操作者对数据源浏览权限的限制。<br />
                                    </dd>
                                    <dt>数值显示格式</dt>
                                    <dd>设定数值类型的字段的显示格式。可设置数量单位、百分比显示、千分位显示等等。<br /></dd>
                                    <dt>时间格式</dt>
                                    <dd>为日期时间类型数据的显示格式。<br /></dd>
                                    <dt>选项设置</dt>
                                    <dd>为单选列表或多选列表类型预设待选项。在编辑记录时，可以从这些待选项中选择合适的项。<br /></dd>
                                    <dt>公式</dt>
                                    <dd>为公式类型字段设置公式。在公式中，可用“[字段编号]”的形式引用模板中的其它字段，字段编号可从“可引用字段”列表中选择。<br /></dd>
                                    <dt>查询设置</dt>
                                    <dd>为查询类型字段进行设置。设置过程可概括为：对指定模板类型的满足指定条件的数据，按指定的方法来获得一个值，这个值就作为此查询字段的值。如，模板“人事档案”中的查询类型字段“平均工资”，可设置为：
                                        <p>查询：工资发放记录；条件：（工资发放记录的）姓名“等于”当前（人事档案的）姓名；取值：对“工资”计算“平均值”。</p>
                                    </dd>
                                    <dt>编号规则设置</dt>
                                    <dd>为自动编号类型的字段设置编号规则。可使用前缀、时间、顺序号和后缀（可以只勾选其中的一项或几项）来构成一个编号。其中，时间部分可使用类似“yyyyMMddHHmmss”的格式字符，在生成编号时将用当时的时间按照指定的格式生成字符串，yyyy表示四位数的年份，MM表示两位数的月份，dd表示两位数的日期，HHmmss依次表示24小时制的时、分、秒（各两位）。
                                        <p>举例：编号规则设为：前缀“P”，时间格式“yyMMdd”，顺序号为3位，初始值和递增值都为1，那么如果当时时间为2010年9月10日，前面已经添加了10条记录，则新生成的编号将是：P20100910011。</p>
                                    </dd>
                                    <dt>隐藏</dt>
                                    <dd>指定该字段是否在浏览时不可见。无论是否隐藏，在模板设计时，以及录入数据时，都是可见的（如果有权限）。模板的标识字段不受此设置的影响。</dd>
                                </dl>
                            </dd>
                            <dt>小技巧</dt>
                            <dd>
                                <ul class="decoration">
                                    <li>可拖动字段名调整字段的上下顺序；双击字段所在行编辑该字段。</li>
                                    <li>日期时间类型的默认值可设置“Now”来代表添加记录时的当前时间；多选列表的默认值可用“|”来分隔多个项。</li>
                                    <li>链接类型的默认值可用“链接地址|链接文字”的格式来填写，如果只需要为链接地址或链接文字设置默认值，可将另一部份留空即可，如“|我的链接”。</li>
                                    <li>在没有使用编辑器的文本类型字段中，如果需要在录入时可以对内容进行换行，请把“内容长度”设为大于50的数字。</li>
                                    <li>公式类型字段的公式中，可以使用SQL语句中的函数，如，仅当已收到货款的情况下，才有提成，可设置为：iif([22], [10]*0.1, 0)，其中[22]为“已到款”字段，[10]为“总金额”字段，意为如果已到款就提总金额的10%，否则为0。注意：该语法仅适用于Access数据库。更多的SQL函数，请参考相应数据库文档。</li>
                                </ul>
                            </dd>
                        </dl>
                    </asp:Panel>

                    <asp:Panel ID="templetAttrs" Visible="false" runat="server">
                        <div class="path">操作路径： 设计中心，模板上点右键 - 属性</div>
                        <dl>
                            <dt>常规</dt>
                            <dd>
                                <p><span class="term">默认视图</span>指定浏览该模板类型的数据时默认使用哪种视图。如，对于“商品”模板，可设置默认视图为“缩略视图”。</p>
                                <p><span class="term">默认排序方式</span>指定浏览该模板类型的数据时，数据的默认排序方式。</p>
                                <p><span class="term">默认保存目录</span>指定在录入数据时，默认的“保存目录”是哪个目录。通常，如果模板用于管理诸如“商品”之类的实体，可将其关联到目录，便于使用目录进行分类管理和浏览；如果是管理“商品进出库记录”之类的流水账数据，则可设为“不关联到目录”（这种情况下，任意目录中都看不到这些记录，只能在直接打开或搜索该模板数据时，以及从实体记录页面链接而来才能看到）。</p>
                                <p><span class="term">标识字段</span>用于设置作为每条记录的代表属性（就像人的姓名）的字段。设置后，在缩略图下方等处将显示该字段的值。</p>
                                <p><span class="term">概要字段</span>指定构成记录概要信息的字段。通常用于缩略图上鼠标悬浮显示。</p>
                                <p><span class="term">联合主键字段</span>联合主键，是指两个以上的字段组合起来作为主键，唯一地识别一条记录。组合的值在数据表中不允许重复。如，一个城市的电话号码是不会重复的，而多个城市之间，则会有相同的号码，但加上区号后，就不会出现重复了。因此区号和电话号码就相当于是联合主键。</p>
                            </dd>
                            <dt>关系</dt>
                            <dd>
                                <p>在该标签页中，可查看和管理该模板与其它模板之间的关联关系。比如，对于“学生”模板与“学生成绩表”模板，可将后者设为前者的子模板，并通过“学号”字段进行关联。</p>
                                <p><span class="term">父模板</span>此处列出该模板的父模板及其关联关系。</p>
                                <p><span class="term">子模板</span>此处列出该模板的子模板及其关联关系。可点击<img src="images/del.gif" />图标删除对应的关联关系。</p>
                                <p><span class="term">添加子模板</span>此处可将某一模板设为当前模板的子模板。“关联”设置是指相互间通过哪个字段进行关联，如“订单”模板和“订单商品明细”模板之间，可通过订单编号来关联（即，某个订单所订购的商品清单，就是在“订单商品明细”中的订单编号等于其编号的那些记录）。</p>
                                <p><span class="term">关联选项</span></p>
                                <ul class="decoration" style="margin-left:3.5em">
                                    <li><span class="key">同步更新关联字段</span>　若选中，则在上例中修改订单的编号时，“订单商品明细”中它所对应的那些记录的订单编号也会作相应的变更；</li>
                                    <li><span class="key">同步删除关联记录</span>　若选中，则在删除某条记录时，子模板中相关联的记录也同时自动删除，如删除一个订单，它对应的订单商品明细记录也会同时删除；</li>
                                    <li><span class="key">同步添加关联记录</span>　该选项仅应当用于一对一的模板关系中，如“员工”与“配偶信息登记表”，若选中该项，则添加一条员工记录时，会同时在“配偶信息登记表”中添加一条记录（其关联字段为员工记录的关联字段值，其余字段为默认值）。</li>
                                </ul>
                                <p><span class="term">“同步”操作有什么用？</span></p>
                                <ul class="decoration" style="margin-left:3.5em">
                                    <li>对于设置了“同步删除关联记录”的关系，如订单模板和订单商品明细模板，“同步”操作可以从后者删除已经不存在的订单的明细记录；</li>
                                    <li>对于设置了“同步添加关联记录”的关系，如员工信息模板和员工配偶信息模板（属一对一关系），“同步”操作可参照前者每条记录，检查后者是否存在相对应的记录，没有的则自动添加，以确保每条员工记录都有一条对应的员工配偶记录。</li>
                                </ul>
                                <p><span class="term">说明</span></p>
                                <ul class="decoration" style="margin-left:3.5em">
                                    <li>关联字段的要求：必填字段、长度不超过255、不使用编辑器。主模板的关联字段还要求“不允许重复值”。满足这些条件的字段才会出现在关联设置中。</li>
                                    <li>像订单与订单商品明细表的关系是“一对多”的关系；像员工与员工配偶信息表的关系是“一对一”关系。通常，一对一关系才应该选中“同步添加关联记录”。</li>
                                    <li>同步操作具有很高的优先权，将会忽略数据保护设置，并且只要对子模板有任意编辑权限即可，即使对这些关联记录没有浏览或编辑权限。</li>
                                </ul>
                            </dd>
                            <dt>流程</dt>
                            <dd>
                                <p>在该标签页，可为该模板创建一个流程，或修改已有流程的设计。创建流程后，<span class="red">流程“开始”步骤指定的“处理者”将可以在<%= ims.Comm.Vars.TransCenterText %>发起该流程</span>。</p>
                                <p>为模板设计了流程之后，默认情况下将不能从<%= ims.Comm.Vars.DataCenterText %>等页面查看或编辑数据，而只能在流程中处理。但是，这可以通过<span class="red">模板权限中的“流程外操作表单数据”选项</span>来修改。</p>
                                <p>注意：在发起流程时，将保存当时的流程设计版本，并一直按这个版本的设计来运行。<span class="red">后续对流程设计的修改，不会影响已发起的流程</span>。</p>
                            </dd>
                            <dt>数据保护</dt>
                            <dd>
                                <p>该标签页用于设置对数据的保护选项，以便必要情况下禁止对数据的编辑或删除等操作。指定为“例外”的角色，则不受这些设置的影响。</p>
                            </dd>
                            <dt>提醒</dt>
                            <dd>
                                <p>提醒，是在满足某种条件时，通过指定的方式对指定的用户进行通知。添加提醒时，可指定提醒的方式、条件、对象和频率。</p>
                            </dd>
                            <dt>生成</dt>
                            <dd>
                                <p>生成，即利用已有的数据快速创建一批新记录，例如，将选中产品生成为报价单(产品明细记录)。</p>
                                <p>生成方法，用于确定源数据和新记录之间的字段对应（映射）关系。生成时，源数据每条记录将会分别生成一条目标模板的记录，并通过字段对应关系将值复制到新记录中。</p>
                                <p>添加生成方法后，源数据的表格视图“批量操作”对话框，将出现“生成”功能，可将指定的记录生成为目标模板的记录。</p>
                                <p>对于"报价单-报价产品明细"这类主从关系模板，为报价产品明细添加生成方法（源数据为产品）后，生成时将打开报价单录入界面，并自动将指定的产品添加到其产品明细中；也可将指定的产品添加到已有报价单的产品明细中。</p>
                                <p>注意：请慎用生成功能，因为它将忽略字段的一些设置，比如，字段的输入规范、必填要求，如果生成的源数据是同一模板，则相当于复制记录，这种情况下还会忽略"不允许重复值"选项和模板的联合主键约束。</p>
                            </dd>
                       </dl>
                    </asp:Panel>

                    <asp:Panel ID="templets" Visible="false" runat="server">
                        <div class="path">操作路径： 点左侧栏导航区“设计中心”</div>
                        <p>注：随权限的不同，以下所涉及到的某些菜单项可能不会在右键菜单中显示。</p>
                        <dl>
                            <dt>什么是模板？</dt>
                            <dd>
                                <p>任何要管理的事物都是以模板为基础的。模板定义了其各种属性，如名称、规格、重量之类，这些属性被称为“字段”。模板通常用于可用相同指标来描述的一类事物，如产品技术档案、产品出入库记录等。</p>
                                <p>系统所管理的数据都是依存于特定的模板的，其中的每一条信息称为一条“记录”，对多条记录也统称为“数据”。</p>
                                <p>对于要管理的信息，是应当用一个模板来管理，还是多个不同模板来管理，可参照如下原则：如果能在较高的层次上抽象出事物的共同属性，且能满足管理需求，那么应使用同一个模板来管理，否则应建立不同的模板。例如，牛和马，如果是需要管理身高、体重、数量等属性，那么可用同一模板；如果要具体到区分是奶牛还是水牛这一层次，就应该单独为“牛”建立一个模板。</p>
                            </dd>
                            <dt>如何创建一个模板？</dt>
                            <dd><p>在空白区域点击右键，选择“添加模板”，输入模板名称并回车，即可建立一个空的模板，并自动进入该模板的设计界面。</p></dd>
                            <dt>如何设置模板的权限？</dt>
                            <dd><p>在模板上点击右键，选“权限”，在弹出的对话框中，分别为不同角色设置适当的权限，之后点击“确定”即可。请参考：<a href="?subject=power&showpath=1" runat="server">用户、角色及权限</a>。</p></dd>
                            <dt>如何导入或导出模板？</dt>
                            <dd><p>
                                在要导出的模板上点击右键，选“导出”，或勾选要导出的模板，然后在空白处点右键，选“导出选中模板”，将会弹出文件下载对话框，点击“保存”即可将模板下载到本地电脑的指定位置；在页面空白处点右键，选“导入模板”，在弹出的对话框中点击“浏览”找到所需要导入的模板文件后，点击“导入”即可将该文件中包含的模板导入到系统中。</p></dd>
                            <dt>如何设置模板的标识字段？</dt>
                            <dd><p>标识字段是指作为标识的属性，如，人的姓名、产品的名称等，通常可以理解为就是作为对象的名称的字段，其作用主要在于可以直观地让人知道这个对象是哪一个对象。标识字段会在缩略视图中作为名称显示出来。在模板上点击右键 - 属性，即可设置标识字段。</p></dd>
                            <dt>什么是默认目录，如何设置？</dt>
                            <dd><p>默认目录是指在添加记录时，该记录默认将保存到哪个目录。如果设置为“不关联到目录”，则表明此模板类型的数据不需要放到某个目录中，也不能从任何目录中看到这些记录，这通常用于管理动态数据的模板，如各种流水帐记录、设备检修记录之类。</p></dd>
                            <dt>数据录入人员是否可以管理他人录入的数据？</dt>
                            <dd><p>这取决于对其权限设置中，是否选中了“禁止编辑或删除他人添加的记录”选项。</p></dd>
                            <dt>如何建立模板关系？</dt>
                            <dd>
                                <p>很多情况下，需要将管理对象用多个模板来分别管理其某个方面，例如对于“工程”项目，除了管理工程基本信息外，还有工程施工记录、工程收付款记录等等，这就需要将其分别用不同的模板来管理（因为一个工程可能会有多条施工记录等），并通过诸如项目名称或项目编号来关联起来，以便在录入或浏览时更容易处理相关的信息。</p>
                                <p>再如，订单模板与相应的订单商品明细模板，也是这样的一种主从关系，一个订单会对应有多条商品明细记录。建立主从关系的步骤如下：</p>
                                <p>进入设计中心，在主模板上点右键，选“属性”，在弹出的对话框中切换到“关系”标签页，在下面的“添加子模板”处选择作为子模板的模板，并设置关联字段。如，（订单商品明细的）订单编号关联到当前“订单编号”，其实质相当于是，某个订单的商品明细记录，就是订单商品明细中订单编号等于这个订单的编号的那些记录。</p>
                                <p>选项“同步更新关联字段”如果选中，则在上例中修改订单的编号时，“订单商品明细”中它所对应的那些记录的订单编号也会作相应的变更；“同步删除关联记录”选项用于在删除某条记录时，子模板中相关联的记录也同时自动删除，如删除一个订单，它对应的订单商品明细记录也会同时删除。</p>
                                <p>设置好关联和选项后，点击下面的“添加”按钮即可建立起该主从关系。这将为今后的录入、浏览和管理数据提供方便。</p>
                            </dd>
                            <dt>小技巧</dt>
                            <dd>
                                <ul class="decoration">
                                    <li>用鼠标拖动图标可以调整模板或文件夹的顺序，并自动记忆这种顺序。对于有系统管理权限的用户，这种调整结果是作为系统默认顺序的；非系统管理权限的用户，在默认顺序的基础上，可以自己调整顺序，但这种调整不会影响其他人。</li>
                                    <li>点模板图标右下角的复选框勾选后，可以在空白处点右键，对所选的多个模板进行导出或备份操作。双击空白处可以全选或全不选所有模板。</li>
                                </ul>
                            </dd>
                        </dl>
                    </asp:Panel>
                    
                    <asp:Panel ID="dataadmin" Visible="false" runat="server">
                        <div class="path">操作路径： 点左侧栏导航区“<%= ims.Comm.Vars.DataCenterText %>”</div>
                        <p>注：随权限的不同，以下所涉及到的某些菜单项可能不会在右键菜单中显示。</p>
                        <dl>
                            <dt>如何添加和管理过滤器？</dt>
                            <dd><p>在模板上点击右键，选“过滤器”，在打开的页面中即可查看、添加、编辑或删除过滤器。要查看过滤器的应用结果，可在模板的右键菜单的“打开”项子菜单中，点击要打开的过滤器。</p></dd>
                            <dt>如何批量更新基于某个模板的数据？</dt>
                            <dd>
                                <p>在模板上点击右键，选“数据管理”，在弹出的对话框中“批量更新”处选择要更新的字段，并设置更新的值后，点击右下方的“更新”按钮，即可一次性更新所有基于该模板的记录。</p>
                            </dd>
                            <dt>如何备份某一模板类型的数据？</dt>
                            <dd><p>在要备份的模板上点击右键，选“数据管理”，在弹出的对话框中点击“备份”按钮，即可将模板以及基于该模板的数据以压缩包的形式下载到本地电脑的指定位置。</p></dd>
                            <dt>如何备份多个模板的数据？</dt>
                            <dd><p>勾选要备份的模板，然后在页面空白处点右键，选“备份选中数据”，即可将所选模板的所有相关数据以压缩包的形式下载到本地电脑的指定位置</p></dd>
                            <dt>如何恢复数据？</dt>
                            <dd><p>在页面空白处点右键，选“从备份中恢复”，在弹出的对话框中点击“浏览”找到所需要恢复的备份文件后，点击“恢复”即可。恢复的记录全部被放置在根目录（如果不是设置为“不关联到目录”的话），可从右键菜单－“数据管理”－“移到指定目录”来将记录移动到合适的目录。</p></dd>
                            <dt>如何导出Excel数据？</dt>
                            <dd>
                                <p>在要导出的模板上点右键，选“数据管理”，在弹出的对话框中，点击“导出到Excel”即可将所有数据导出到一个Excel文件。如果有相关的图片或文件，则导出的将是一个包含了这些文件及Excel文件的ZIP格式压缩文件。</p>
                                <p>注：导出的Excel文件采用XML格式，因此Microsoft Office必须在XP以上版本才能打开和编辑。</p>
                            </dd>
                            <dt>如何通过Excel批量导入或更新数据？</dt>
                            <dd>
                                <p>在要导出的模板上点右键，选“数据管理”，在弹出的对话框中，点击“下载Excel表单”可以导出一个只有标题行的Excel文件，可用它来录入符合格式要求的数据；点击“从Excel导入”，可将已编辑好的符合格式要求的Excel文件或ZIP压缩文件导入进来，系统将分析并处理其中包含的数据。须注意的是：</p>
                                <ul class="decoration">
                                    <li>导入的Excel文件支持.xml和.xls两种格式，推荐使用Microsoft Excel 2003进行编辑。暂不支持Microsoft Office 2007/2010的文件格式；</li>
                                    <li>要导入的Excel表中，与图片或文件类型字段对应的列中，可按“我的照片（MyPicture.jpg）”或“MyPicture.jpg”两种方式指定文件名（不含路径），多个文件之间用“、”或“，”“,”或“|”分隔，文件名中不能包含这几个用作分隔符的字符。Excel文件要放在“Excel”文件夹中，相关的文件必须存在于与其同级的名为“Files”的文件夹中，将它们打包为.zip压缩文件即可用于导入。</li>
                                    <li>也可通过导入功能来更新已存在的记录，在导入时提示是更新还是追加记录的对话框中，点击“确定”即可。这种情况下，系统将根据Excel表中的“ID”来定位原始记录。</li>
                                    <li>公式、查询类型的字段，以及除保密级别外的其它通用属性（如更新人、更新时间、目录）不能从Excel导入，将会被忽略。</li>
                                    <li>导入时，仅处理工作簿中的第一个工作表，而忽略其它的工作表（如果有）。</li>
                                    <li>模板中定义的必填字段和不允许重复的字段，必须在表中存在并遵循字段定义的规则，否则无法导入数据。</li>
                                    <li>用于导入的工作表数据，各个单元格必须与所在列（对应于模板中的字段）一一对应，不允许合并单元格。</li>
                                    <li>执行导入时，系统根据Excel表中各列与模板中的字段名的对应关系来处理数据，如果是用于更新，将通过记录ID来查找对应的记录。</li>
                                </ul>
                            </dd>
                            <dt>小技巧</dt>
                            <dd>
                                <ul class="decoration">
                                    <li>用鼠标拖动图标可以调整模板或文件夹的顺序，并自动记忆这种顺序。对于有系统管理权限的用户，这种调整结果是作为系统默认顺序的；非系统管理权限的用户，在默认顺序的基础上，可以自己调整顺序，但这种调整不会影响其他人。</li>
                                    <li>点模板图标右下角的复选框勾选后，可以在空白处点右键，对所选的多个模板进行导出或备份操作。双击空白处可以全选或全不选所有模板。</li>
                                </ul>
                            </dd>
                            <dt>相关主题</dt>
                            <dd class="related">
                                <asp:HyperLink ID="HyperLink25" NavigateUrl="help.aspx?subject=fastfilter" runat="server">筛选</asp:HyperLink>
                                <asp:HyperLink ID="HyperLink24" NavigateUrl="help.aspx?subject=filters" runat="server">过滤器</asp:HyperLink>
                            </dd>
                        </dl>
                    </asp:Panel>
                    
                    <asp:Panel ID="table" Visible="false" runat="server">
                        <div class="path">操作路径： 鼠标移到左侧导航区“切换视图”（或显示为“最近浏览的数据”）处，点“表格视图”。默认视图设为“表格视图”的模板，直接打开数据即进入表格视图</div>
                        <dl>
                            <dt>如何只显示需要查看的字段？</dt>
                            <dd><p>表格视图默认会显示除了内容长度设定值大于300以外的所有字段，可以点击左下方省略号图标弹出操作菜单，点“显示/隐藏列”来选择需要显示在表格中的字段。</p></dd>
                            <dt>如何调整表格？</dt>
                            <dd><p>在表格的标题行中，将鼠标移到列标题单元格，可拖动调整列顺序；将鼠标移到列边界线上，可拖动调整列宽度。</p></dd>
                            <dt>如何让表格视图按某个字段的值来排序显示？</dt>
                            <dd><p>点击每一列的列标题链接，即可使表格视图按该列的值来排序显示。再次点击同一列的标题链接时，将会进行相反的排序。</p></dd>
                            <dt>如何对表格中的某一行执行编辑或删除等操作？</dt>
                            <dd><p>在要执行操作的行点右键，或单击<img src="images/r.gif" />图标（双击打开详情页），可弹出操作菜单；双击行可就地编辑，按住Ctrl键再双击可就地打开。</p></dd>
                            <dt>如何对表格中的数字或公式类型字段进行简单的统计？</dt>
                            <dd><p>表格左下方的下拉列表中，有“合计”、“平均值”等基本的统计功能，选择某一个统计功能后，会在数字或公式类型的字段所对应的列显示统计结果。此操作是针对当前所有数据，而不仅仅是表中当前页所显示的数据。</p></dd>
                            <dt>如何保存表格的显示设置？</dt>
                            <dd><p>如果有权限，会在表格下方看到一个按钮“保存版面”，点击即可将当前的表格显示设置保存下来，作为今后的默认显示方式。表格的显示设置包括：表格样式、列的顺序、宽度、可见性，以及每页显示数量和页脚统计功能设置。</p></dd>
                            <dt>小技巧</dt>
                            <dd>
                                <ul class="decoration">
                                    <li>在要操作的行任意空白处点右键，会弹出操作菜单；双击行，可执行指定操作（打开、就地编辑等）。</li>
                                    <li>在就地编辑时，可在任一输入元素上直接回车提交保存。</li>
                                    <li>表格视图中导出Excel功能只会导出当前所显示的列，因此可临时隐藏图片和文件类型的列之后再导出，从而避免因包含文件而体积较大难以下载。</li>
                                    <li>多条件组合筛选时，可直接设置筛选条件，系统会自动选中该条件；设置好条件之后，可直接在输入元素上回车执行筛选。</li>
                                </ul>
                            </dd>
                        </dl>
                    </asp:Panel>

                    <asp:Panel ID="report" Visible="false" runat="server">
                        <div class="path">操作路径： 鼠标移到左侧导航区“切换视图”（或显示为“最近浏览的数据”）处，点“报表视图”。默认视图设为“报表视图”的模板，直接打开数据即进入报表视图</div>
                        <dl>
                            <dt>如何设置报表？</dt>
                            <dd>
                                <p>点击“报表设置”按钮，弹出设置窗口后，按以下方法设置：</p>
                                <ul class="decoration">
                                    <li><span class="term">根据什么进行分组统计？</span>选择一个字段，报表将按该字段对记录进行分组，并分别计算各组的统计值。如果分组字段为数字类型或日期时间类型，还可以使用自动分段或手工指定段点值进行分组，如指定为“100,500”，将对该字段按小于100、100到500（不含500）、大于等于500三个组进行分组统计。还可以设置子分组（即组内再进行分组，可设置最多五级分组），并可分别指定组的排序方式。</li>
                                    <li><span class="term">使用什么统计方法？</span>设置对各个分组的各个统计字段的统计方法。如，求和、求平均值。</li>
                                    <li><span class="term">要在报表中查看哪些内容？</span>勾选要显示在报表中的字段。还可以设置一些选项，决定是否显示报表标题、各组的明细记录等。</li>
                                </ul>
                            </dd>
                            <dt>是否可调整报表各列的顺序和宽度？</dt>
                            <dd><p>可将鼠标移到报表标题行的列边界线处，拖动来调整列的宽度。目前暂不支持调整列顺序，但由于报表设置中的字段顺序是与表格视图同步的，因此可在表格视图中调整列顺序后再设置并保存报表设置。</p></dd>
                            <dt>如何将报表设置保存下来？</dt>
                            <dd><p>如果有权限，将会看到“管理报表”按钮，点击打开对话框后，可将当前的报表设置（及列的宽度调整结果）命名保存下来，以后打开该模板数据的报表视图时，就可以选择该报表。</p></dd>
                            <dt>分段分组的组边界值如何包含？</dt>
                            <dd><p>数字或日期时间类型的字段，可以设置自动分段分组或手动指定段点值进行分组，这种情况下，除了最大的一组外，每组均包含左边界值，不包含右边界值。如12～100，100～500，500～678，这三组中，第一组不包含100，第二组包含100但不包含500，第三组则包含了500和678这两个边界值。</p></dd>
                        </dl>
                    </asp:Panel>
                    
                    <asp:Panel ID="thumb" Visible="false" runat="server">
                        <div class="path">操作路径： 鼠标移到左侧导航区“切换视图”（或显示为“最近浏览的数据”）处，点“缩略视图”。默认视图设为“缩略视图”的模板，直接打开数据即进入缩略视图</div>
                        <dl>
                            <dt>如何修改一条记录的名称？</dt>
                            <dd><p>在要更名的记录上点击右键，选“重命名”，输入新的名称即可。该操作实际上是修改了记录的标识字段的值。</p></dd>
                            <dt>如何进行排序？</dt>
                            <dd><p>右键点击空白区域，在“排序”的下级菜单中点击要用作排序依据的字段即可。如果再次用同一字段来排序，则会以相反的顺序排序。在“排序”的下级菜单项中，带有图标<img src="images/asc.gif" />或<img src="images/desc.gif" />的项是当前的排序依据项，前一个图标表示顺序排序，后一个图标表示逆序排序。</p></dd>
                            <dt>小技巧</dt>
                            <dd>
                                <ul class="decoration">
                                    <li>在需要翻页浏览时，可以使用键盘进行快捷操作。方向键→或PageDown键可翻到下一页；方向键←或PageUp可翻到上一页；Home键到第一页；End键到最后一页。</li>
                                    <li>直接单击缩略图可打开其详细信息页面；单击缩略图中间的悬泘图标，可查看其较大尺寸的图片，并进入幻灯显示状态。</li>
                                </ul>
                            </dd>
                        </dl>
                    </asp:Panel>
                    <asp:Panel ID="detail" Visible="false" runat="server">
                        <div class="path">操作路径： 鼠标移到左侧导航区“切换视图”（或显示为“最近浏览的数据”）处，点“详情视图”。默认视图设为“详情视图”的模板，直接打开数据即进入详情视图</div>
                        <dl>
                            <dt>如何打印页面？</dt>
                            <dd><p>在打印之前，请先从浏览器的“文件”菜单进入“页面设置”，设置好页面边距及页眉页脚等信息后再点击页面上的“打印”按钮。</p></dd>
                            <dt>打印出来看不到表格线和缩略图？</dt>
                            <dd><p>这需要设置浏览器：打开“文件”菜单，在“页面设置”中勾选“打印背景颜色与图像”。如果没有该选项，请打开“工具”菜单下面的“Internet选项”，切换到“高级”，选中“打印背景颜色与图像”，点击“确定”。之后再重新打印即可。</p></dd>
                            <dt>小技巧</dt>
                            <dd>
                                <ul class="decoration">
                                    <li>如果有编辑权限，可以双击单元格，就地编辑对应的字段。</li>
                                    <li>如果是在一批记录中浏览详情视图，可使用键盘进行跳转：方向键→或PageDown键可翻到下一页；方向键←或PageUp可翻到上一页；Home键到第一页；End键到最后一页。</li>
                                    <li>导出页面时，如果弹出迅雷下载且下载失败，请设置迅雷，取消“监视浏览器”选项。</li>
                                </ul>
                            </dd>
                       </dl>
                    </asp:Panel>
                    <asp:Panel ID="jsplugin" Visible="false" runat="server">
                        <div class="path">操作路径： 系统管理 &rsaquo; 系统维护 &rsaquo; 其它操作，点“编辑外挂脚本”</div>
                        <dl>
                            <dt>什么是外挂脚本？</dt>
                            <dd>
                                <p>外挂脚本是一个Javascript脚本文件（js/plugin.js），用于对系统进行一些自定义的处理。它会被系统的每个页面加载运行。它不会被系统升级所覆盖。</p>
                                <p>系统采用了jQuery脚本框架，因此可在外挂脚本中使用jQuery语法，相关学习资料请参考：<a href="http://thinhunan.cnblogs.com/archive/2008/03/05/1091816.html" target="_blank">jQuery入门</a> 、 <a href="http://www.css88.com/jqapi-1.9" target="_blank">jQuery API文档</a>。</p>
                                <p>注：修改外挂脚本后，客户端必须清空浏览器缓存再打开才生效。</p>
                            </dd>
                            <dt>示例代码</dt>
                            <dd>
   <pre>
    <span class="green">//页面结构加载完毕后执行以下代码</span>
    $(function () {
        <span class="green">//如果当前是表格视图页面</span>
        if (getPage() == "table.aspx") {
            alert("当前是表格视图！");
            <span class="green">//页面加载完毕后的处理</span>
            $(window).load(function () {
                ShowMsgPop("页面已加载完毕！");
            })
        }
    });</pre>
                            </dd>
                            <dt>部分Javascript/jQuery函数/方法</dt>
                            <dd>
                                <ul class="decoration">
                                    <li><span class="term">getPage()</span>获取当前页面文件名</li>
                                    <li><span class="term">getUser()</span>获取当前操作者用户名</li>
                                    <li><span class="term">user(userName)</span>弹出给指定用户发送消息/短信/邮件的界面</li>
                                    <li><span class="term">toPopup(url)</span>弹出显示指定的页面/网址</li>
                                    <li><span class="term">toPrompt(title, onok)</span>提示用户输入。参数title指定对话框标题，onok指定当用户输入并点击确定按钮后执行的方法</li>
                                    <li><span class="term">toExportAs(selector, width, pageTitle, exclude)</span>弹出导出对话框。参数依次为：要导出的元素或jQuery选择器，文档宽度，标题，要排除的元素或jQuery选择器</li>
                                    <li><span class="term">$(selector).hide()</span>隐藏元素</li>
                                    <li><span class="term">$(selector).show()</span>显示元素</li>
                                    <li><span class="term">$(selector).printIt()</span>打印元素。示例：<span class="red">$("#msg").printIt({pageTitle: "通知", exclude: "div.footer"});</span>，打印id为msg的元素（排除其中class为footer的div元素）</li>
                                </ul>
                            </dd>
                       </dl>
                    </asp:Panel>
                    <asp:Panel ID="summary" Visible="false" runat="server">
                        <div class="path">操作路径： 鼠标移到左侧导航区“切换视图”（或显示为“最近浏览的数据”）处，点“概要视图”。默认视图设为“概要视图”的模板，直接打开数据即进入概要视图</div>
                        <dl>
                            <dt>如何设置概要视图的显示格式？</dt>
                            <dd>
                                <p>如果您有权限，那么当鼠标移到每一项的概要信息上面时，会在右边出现一个图标，点击这个图标，就可以设置该记录及其相同模板的所有记录的显示格式。</p>
                                <p>使用“自由格式”，可以实现非常灵活的显示格式。可以点击编辑器右下方的两个图标，用链接格式或详情视图格式初始化编辑器，再在此基础上作修改调整。</p>
                                <p>在“自由格式”的编辑器中，可通过插入字段代码来在指定的位置显示该字段的值，浏览时，这些代码会被替换为字段的实际值，这和详情视图的自由排版方式是相同的。</p>
                            </dd>
                            <dt>小技巧</dt>
                            <dd>
                                <ul class="decoration">
                                    <li>可使用键盘进行翻页浏览：方向键→或PageDown键可翻到下一页；方向键←或PageUp可翻到上一页；Home键到第一页；End键到最后一页。</li>
                                </ul>
                            </dd>
                       </dl>
                    </asp:Panel>
                    
                    <asp:Panel ID="editor" Visible="false" runat="server">
                        <dl>
                            <dt>编辑器介绍</dt>
                            <dd><p>编辑器是一个在使用上类似于Microsoft Word的在线文字编辑工具，它与普通的文本输入框最大的区别在于，它能够设置文本的格式和样式，并插入图片、链接（文件）等多种元素，以”所见即所得“的方式进行编辑。</p></dd>
                            <dt>编辑器使用要点</dt>
                            <dd>
                                <ul class="decoration">
                                    <li>如果还不熟悉编辑器的使用，请先将鼠标分别移到各个工具按钮上，通过其鼠标悬浮提示来了解它们的作用；分别在编辑区选中和未选中文本的情况下，点击鼠标右键来查看当前状态下可使用的快捷菜单。</li>
                                    <li>在输入文本时，直接回车将会另起一段，如果只是想要换行，请按住Shift键再按回车键。</li>
                                    <li>编辑器中的段落默认没有首行缩进。如果需要让段落首行缩进两个字符，请选中段落后，点“样式”下拉列表中的“段落首行缩进”。</li>
                                    <li>点击工具栏中 <img src="images/link.gif" align="absmiddle" /> 按钮可插入附件。</li>
                                    <li>点击工具栏中 <img src="images/tabs.gif" /> 按钮，可以插入多标签页（选项卡）组件，要添加或删除一组标签，建议切换到源代码模式来编辑代码。其中标签文字所在的a元素的href属性与标签页内容区div元素的id属性相关联。在源代码模式下，可以在该组件的div元素的class属性中追加“ border”，让其显示为带外框的样式；或追加“ noborder”，显示为无边框样式。</li>
                                    <li>如果需要控制打印时的分页，可使用工具栏的插入分页符按钮在适当位置插入分页符。</li>
                                </ul>
                            </dd>
                        </dl>
                    </asp:Panel>
                    
                    <asp:Panel ID="fastfilter" Visible="false" runat="server">
                        <div class="path">操作路径： <%= ims.Comm.Vars.DataCenterText %>，模板上点右键 - 筛选；或表格视图下，点“筛选”按钮</div>
                        <dl>
                            <dt>如何根据单一条件筛选？</dt>
                            <dd><p>在每一个带复选框的条件之后，有一个<img src="images/exe.gif" align="absMiddle" />图标，点击即可按该条件进行筛选（无须勾选前面的复选框）。</p></dd>
                            <dt>如何根据多个条件组合筛选？</dt>
                            <dd>
                                <p>勾选要组合应用的条件前面的复选框，设置好这些条件之后，点击“确定”按钮即可按这些条件执行筛选。</p>
                            </dd>
                            <dt>如何设置条件？</dt>
                            <dd>
                                <p>对于条件中的下拉列表或单选按钮，直接选择作为筛选条件的值即可；</p>
                                <p>对于日期时间类型字段，可以直接指定任意的时间段，也可以按类似“本月”、“上季度”之类的方式设置条件，还可以按“过去1月”、“未来2年”这种方式设置条件。后两种方式的区别在于，“上月”是相对于当前月份，而“过去1月”是相对于当前时间点。如，假设今天是5月18日，那么，上月是指整个4月份，而过去一月是指4月18日到今天这一时间段。其余类推；</p>
                                <p>对于数字类型字段，可以指定起始数值和/或截止数值来作为条件，例如，指定起始数值100，不指定截止数值，则表示筛选所有该字段值大于或等于100的记录；</p>
                                <p>对于文本类型字段，在条件的文本框中输入筛选关键字即可。</p>
                                <p>如果要搜索为空的字段，将条件输入框留空即可。</p>
                            </dd>
                        </dl>
                    </asp:Panel>

                    <asp:Panel ID="infoEdit" Visible="false" runat="server">
                        <div class="path">操作路径： 点顶部“<%= ims.Comm.Vars.InfoCenterText %>”图标，再点右上方“发布”图标；或鼠标移到左侧栏导航区“<%= ims.Comm.Vars.InfoCenterText %>”处，点“发布<%= ims.Comm.Vars.InfoType %>”</div>
                        <dl>
                            <dt>术语</dt>
                            <dd>
                                <p><span class="term">摘要</span>用于概述主要内容的一段文字。摘要内容将显示在“<%= ims.Comm.Vars.InfoCenterText %>”的<%= ims.Comm.Vars.InfoType %>列表中，方便浏览时了解大致的内容。</p>
                                <p><span class="term">标签</span>标签是一种开放式分类方式，可将自己发布的内容加上一个或多个标签，以便浏览者能方便地找到所关注的有关联的内容。</p>
                                <p><span class="term">保密级别</span>用于确定所发布内容的保密程度，只有浏览权限级别不低于该保密级别的用户，才能浏览。如果设为“仅本人可查看”，则其他任何人无论浏览权限高低，都看不到此内容。</p>
                                <p><span class="term">置顶</span>置顶，就是将所发布的内容显示在<%= ims.Comm.Vars.InfoType %>列表的前面。无论浏览时选择何种排序方式，置顶的<%= ims.Comm.Vars.InfoType %>都会排列在未置顶的前面。</p>
                           </dd>
				            <dt>相关主题</dt>
				            <dd class="related">
                                <asp:HyperLink ID="HyperLink26" NavigateUrl="help.aspx?subject=editor" runat="server">编辑器</asp:HyperLink>
                            </dd>
                        </dl>
                    </asp:Panel>

                    <asp:Panel ID="CondFormat" Visible="false" runat="server">
                        <div class="path">操作路径： 表格视图下，点“更多…”按钮 - 条件格式</div>
                        <dl>
                            <dd>
                                <p><span class="term">什么是条件格式？</span>所谓条件格式，是指为满足指定条件的记录使用指定的格式进行显示。条件格式设置后将会自动保存下来，所有人员在浏览时都会应用此设置。</p>
                                <p><span class="term">如何设置条件格式？</span>勾选条件格式下的“启用”复选框，点“条件”后面的“设置”，来设置需要用特殊样式进行显示的条件，再指定“格式”中的的背景色、前景色等选项。如果勾选了“置顶”，则满足条件的记录将在最前面列出来（该选项在各个视图中都有效）。</p>
                            </dd>
                        </dl>
                    </asp:Panel>

                    <asp:Panel ID="sidebar" Visible="false" runat="server">
                        <div class="path">操作路径： 首页 &rsaquo; 个性化设置 &rsaquo; 自定义左侧栏；或，在左侧栏右上角点"+"图标</div>
                        <dl>
                            <dt>如何自定义左侧栏？</dt>
                            <dd>
                                <p>可用鼠标将预览区的版块拖到候选区来隐藏之，也可添加新的版块，或调整版块的位置。</p>
                                <p><span class="term">如何添加新版块</span>在“添加版块”处，输入新版块的名称，并点击“添加元素”来添加内容到新版块的内容区，然后点“添加到候选区”将版块保存到候选区。这时，可将其拖到预览区的适当位置使之显示在左侧栏，或点击其左上方的红色“X”图标删除之。</p>
                                <p><span class="term">设为系统默认左侧栏</span>如果您有系统管理员权限，可点击“保存为系统默认状态”，将调整好的版面设为系统的默认左侧栏状态，此后，所有未自定义左侧栏的用户，将以该版面进行显示。</p>
                            </dd>
                        </dl>
                    </asp:Panel>

                    <asp:Panel ID="selectUser" Visible="false" runat="server">
                        <div class="path">操作路径： 在输入用户名的文本框中双击</div>
                        <dl>
                            <dt>如何选择用户？</dt>
                            <dd>
                                <p>方法一：在左侧点击选中要添加的用户或机构，再点击“>>”按钮。如果选中的是一个用户，会将该用户添加到右侧列表中；如果选中的是一个机构，则会将该机构下所有直属用户添加到右侧列表中。</p>
                                <p>方法二：直接双击要添加的用户或机构。</p>
                            </dd>
                            <dt>如何从已选取的用户列表中移除用户？</dt>
                            <dd>
                                <p>方法一：在右侧列表中选中要移除的一个或多个用户，再点击“<<”按钮即可移除。可用鼠标拖动选取多项，或按住Ctrl或Shift键来选取多项。</p>
                                <p>方法二：直接双击要移除的用户名。</p>
                            </dd>
                        </dl>
                    </asp:Panel>

                    <asp:Panel ID="FindTemplet" Visible="false" runat="server">
                        <div class="path">操作路径： 进入设计中心或<%= ims.Comm.Vars.DataCenterText %>，空白处点右键，查找</div>
                        <dl>
                            <dt>如何查找模板？</dt>
                            <dd>
                                <p>输入关键字并回车或点“查找”按钮，即可列出名称包含该关键字的模板。</p>
                            </dd>
                            <dt>说明</dt>
                            <dd>
                                <ul class="decoration">
                                    <li>该功能将从所有模板中查找，不论其位于哪个文件夹下；</li>
                                    <li>关键字留空执行查找，将列出所有模板。</li>
                                </ul>
                            </dd>
                        </dl>
                    </asp:Panel>

                    <asp:Panel ID="masterSlave" Visible="false" runat="server">
                        <div class="path">操作路径： 进入设计中心，空白处右键 - 添加主从模板</div>
                        <dl>
                            <dt>什么是主从模板？</dt>
                            <dd>
                                <p>以订单管理为例，它涉及到订单的基本信息和订单中的产品清单，我们也许会考虑用一个订单模板来管理，但实际上应该分为“订单”和“订单产品明细”两个模板，才便于对产品明细的管理和统计，这二者之间，即是一种一对多的主从（父子）关系，它们通过订单号关联起来。</p>
                                <p>建立起了这种模板关系之后，在订单录入和浏览时，就可以方便地对其相关的产品明细进行增删操作了，也可以在详情页面通过查询来获取并显示这些明细数据。</p>
                                <p>类似的例子还有：产品与产品投诉记录、病人与病历记录等。</p>
                            </dd>
                            <dt>如何建立主从模板？</dt>
                            <dd>
                                <p>方法一：分别建立主模板和子模板，并在主模板的“属性/关系”处添加子模板关系。</p>
                                <p>方法二：在设计中心右键菜单中点“添加主从模板”，可以一次性建立起主模板和子模板，以及它们的关联字段，并自动建立起模板关系、版式和查询定义。如果输入多个子模板名称（逗号分隔），还可以同时创建多个子模板。</p>
                            </dd>
                        </dl>
                    </asp:Panel>
                    <asp:Panel ID="autoBackup" Visible="false" runat="server">
                        <div class="path">操作路径： 系统管理 &rsaquo; 系统维护 &rsaquo; 系统备份和还原，点击“自动备份…”按钮</div>
                        <dl>
                            <dt>关于自动备份的几点说明</dt>
                            <dd>
                                <ul class="decoration">
                                    <li>指定备份文件存储位置时，可指定服务器电脑上的某个文件夹，或“\\abc\backup\”格式的网络共享文件夹路径。存储位置不能存放其它文件，否则可能被系统删除；</li>
                                    <li>须确保运行本系统的帐户对存储位置有“修改”或“完全控制”权限；</li>
                                    <li>将自动备份的开始时间设为小于当前时间，将立即触发自动备份功能；</li>
                                    <li>可查看系统运行日志，来了解备份计划的执行情况；</li>
                                    <li>如果系统因进程回收等原因停止运行，将无法自动备份；</li>
                                    <li>建议使用百度云盘或360云盘客户端的自动备份功能将存储位置设为自动备份（到云盘），从而实现异地备份，进一步保障数据安全。</li>
                                </ul>
                            </dd>
                        </dl>
                    </asp:Panel>
                    <asp:Panel ID="flow" Visible="false" runat="server">
                        <div class="path">操作路径： 设计中心，模板上点右键 - 属性，切换到“流程”标签，点“创建流程”</div>
                        <dl>
                            <dt>流程设计概述</dt>
                            <dd>
                                <p>流程设计，是一个把工作业务处理逻辑和顺序以图形化方式进行表达的过程。它基于预设的表单模板，规定了发起和参与流程的人员、权限、处理时间，以及该过程中的信息沟通等内容。</p>
                            </dd>
                            <dt>术语</dt>
                            <dd><p><span class="term">交办人</span>提交流程事项给本步骤的人，亦即上一个步骤的最终处理人（他让流程流转到本步骤）。</p></dd>
                            <dt>操作要点</dt>
                            <dd>
                                <ul class="decoration">
                                    <li>在任一步骤节点上点右键，可添加或指定其下一步骤；</li>
                                    <li>点击步骤节点，可对该步骤进行设置；</li>
                                    <li>点击步骤连接线，可设置该流转路径的流转条件。</li>
                                </ul>
                            </dd>
                            <dt>提示</dt>
                            <dd>
                                <ul class="decoration">
                                    <li><span class="red">被“开始”节点指定为处理者的人员，才能发起该流程。</span></li>
                                    <li>发起流程时，会保存当时的流程设计版本，并应用于整个流程。<span class="red">对流程设计的修改，不影响运行中的流程。</span></li>
                                    <li>节点权限中设置的表单编辑权限，仅在流程流转到当前步骤时有效；对流程的删除、评论等权限，则随时有效。</li>
                                    <li>如果流程需要填写子模板表单，则当子模板设置为引用流程表单模板权限时，按流程设计中的权限规定控制，否则按子模板的权限设置控制。</li>
                                </ul>
                            </dd>
                        </dl>
                    </asp:Panel>

                    <asp:Panel ID="faq" Visible="false" runat="server">
                        <dl>
                            <dt>如何通过网络访问本系统？</dt>
                            <dd>
                                <p style="margin:0">在同一网络中的客户端电脑上（无需安装该软件），可使用浏览器通过以下地址来访问：</p>
                                <ul style="margin:1px 0 3px 2em" runat="server" id="urls"></ul>
                                <p>注：可<a onclick="down('shortcut.url');" href="javascript:void(0);" target="_self">点此下载快捷方式</a>保存到桌面。</p>
                                <p>要允许其它电脑通过网络访问，需给主机防火墙开放<%= Request.Url.Port %>端口。<span runat="server" id="cmdprompt">可在“开始-运行”框中执行以下命令开启：</span>
                                <span runat="server" class="red" id="cmdtext"></span> <a href="###" title="将命令复制到剪贴板" onclick="return copy_clip();" style="display:none;display:inline\9">复制</a>
                                </p>
                                <p>如果系统安装在内网，想要从互联网进行访问，通常还需要设置内网路由器端口映射，并使用动态域名解析软件（如花生壳）。具体请联系技术支持。</p>
                            </dd>
                            <dt>如何将该软件安装在网站上，从而可以从互联网访问？</dt>
                            <dd>
                                <p>这需要先购买一个支持Asp.net 2.0的网站空间（虚拟主机），然后将软件安装目录整体上传到网站根目录下，并在虚拟主机后台管理中将该目录设置为虚拟目录，将网站的Asp.net版本为V2.0.50727。访问时，要在域名后加上目录路径，如：http://www.xxx.com/ims/default.aspx。</p>
                                <p>如果是将安装目录下的所有内容直接放置在网站根目录下，则无需设置虚拟目录，直接使用所绑定的域名即可访问。</p>
                            </dd>
                            <dt>一些基本技巧</dt>
                            <dd>
                                <ol style="margin-left:2em;list-style-type:square">
                                    <li>可以<a href="javascript:void(0);" onclick="to('sidebar.aspx?layout=true');" class="admin">自定义左侧栏</a>，加入常用的操作链接；</li>
                                    <li>首页“个性化设置”中可设置进入系统后默认打开的页面。如，可设置为登录后直接显示出现库存预警的产品；</li>
                                    <li>很多页面可以点击鼠标右键进行操作（如目录、数据中心等）；</li>
                                    <li>很多页面可以用鼠标拖动元素调整位置（如表格视图调整列顺序等）；</li>
                                    <li>很多页面可以调整显示版面和格式（如详情视图、概要视图、数据录入等）；</li>
                                    <li>很多地方可以在输入完毕时直接回车提交。比如，编辑、搜索、筛选等处。例：表格视图对某一行就地编辑时，修改后直接按回车键即可保存。</li>
                                    <li>在选择用户或机构的文本框，均可直接输入、从提示框中选择，或者双击从弹出窗口中选择，可输入逗号、分号或顿号来输入多项。</li>
                                    <li>部分链接在点击时，系统默认采用弹出方式打开，如果不希望这样，可以按住Shift键再点击链接。</li>
                                    <li>当系统右下方弹出气泡提示时，应仔细看看；在某些地方不知如何操作时，看看相关的按钮或右键菜单，或点左侧的“实时帮助”。</li>
                                </ol>
                            </dd>
                            <dt>输入密码点击登录后还是进入未登录状态？</dt>
                            <dd>
                                <p>这可能是由于浏览器的设置阻止了Cookie造成的。打开浏览器的“工具”-“Internet选项”，切换到“隐私”，点击“高级”，在弹出的窗口中，取消“覆盖自动Cookie处理”，将第一方Cookie和第三方Cookie都设为接受，并勾选“总是允许会话Cookie”。</p>
                                <p>如果上述方法无效，那么系统管理员可在服务器上用记事本打开程序目录下的web.config文件，搜索“InProc”并将其改为“StateServer”，保存后再将电脑的“ASP.NET State Service”服务启动并将“启动类型”设为“自动”。</p>
                            </dd>
                            <dt>如何在网站中嵌入本系统？</dt>
                            <dd><p>可以在网页中使用地址<asp:HyperLink ID="hyDatacenter" runat="server">DataCenter.aspx</asp:HyperLink>
                                调用本系统。这种调用方式与直接访问系统的区别在于，它不会显示主界面的顶栏部份，适合于以iframe的方式嵌入到网站中。示例代码如下：</p>
                                <p runat="server" id="iframecode"></p>
                                <p>在调用时，还可以加上参数style来指明要应用的风格，该风格将优先于用户的自选风格。如：<%= Regex.Replace(Request.Url.GetLeftPart(UriPartial.Path), "help\\.aspx", "DataCenter.aspx?style=gray", RegexOptions.IgnoreCase) %>。</p>
                                <p class="pCurrentUrl">下面是当前页面<select id="urlMode" onchange="showPageUrl();"><option value="Full">完整窗口模式</option><option value="Sidebar">含侧栏和内容页面</option><option value="Only">仅内容页面</option></select>的访问地址：</p>
                                <p class="pCurrentUrl"><a href="#" id="currentUrl" target="_blank"></a></p>
                            </dd>
                            <dt runat="server" class="admin">添加的新用户的密码是什么？</dt>
                            <dd runat="server" class="admin"><p>由管理员添加的用户的密码默认是“<asp:Literal runat="server" ID="lInitPwd"></asp:Literal>”。可以在用户管理页面点击“设置默认用户信息”，来修改默认密码，以及其它内容的默认值，之后再添加的用户将自动使用这些默认的用户信息。在新用户使用默认密码登录后，可以自己修改包括密码在内的所有个人信息。</p></dd>
                            <dt>为什么在缩略视图中看不到缩略图？</dt>
                            <dd><p>进入设计中心，在模板上点右键，属性，指定“缩略图字段”为需要显示的图片字段即可。</p></dd>
                            <dt>为什么在模板中添加字段后，录入或浏览时看不到该字段？</dt>
                            <dd><p>如果录入或浏览时的版式是自定义版式，而不是系统自动生成的版式（即录入时的"经典版式"、浏览时的"表格版式"），那么新增的字段不会自动出现在版式中，需要进入版式编辑页面手动添加。</p></dd>
                            <dt>系统操作或显示异常？</dt>
                            <dd><p>
                                有两种可能：一是由于系统升级后浏览器未清空缓存，则清除浏览历史中“缓存的文件或图片”即可（不要勾选“保留收藏夹网站数据”，清除的时间段设为“全部”）；二是由于浏览器安全设置，解决方法：打开“工具”菜单，点“Internet 选项”，切换到“安全”标签，选择“受信任的站点”，点“站点”按钮，在弹出的对话框中，取消左下方的复选框，再点“添加”按钮，将当前系统的地址加入浏览器的信任站点列表，若仍不能解决，尝试把信任站点的安全级别设为最低。</p></dd>
                            <dt>保密级别是什么意思，如何应用？</dt>
                            <dd>
                                <p>数据的保密级别和用户的浏览权限是相对应的，分别有0～10共11个级别。用户只能查看保密级别不高于其浏览权限级别的内容（有编辑权限或完全控制权限除外）。比如，某用户对某模板的浏览权限为5级，那么他只能看到该模板的保密级别为0～5的记录，而高于5级的记录，以及不高于5级的记录中保密级别高于5级的字段，都无权浏览。</p>
                            </dd>
                            <dt>如何启用电子商务功能？</dt>
                            <dd><p>首先，需要在系统设置的“功能选项”中勾选“启用电子商务功能”，再在要作为商品进行销售的模板的属性中勾选“启用电子商务功能”，并设置作为商品价格的字段。这样，客户在浏览时，就可以将其加入购物车并在线下单了。</p></dd>
                            <dt runat="server" id="dtMime">上传的.docx、.flv等格式的文件在浏览时点击链接打不开？</dt>
                            <dd runat="server" id="ddMime">
                                <p>在IIS中添加MIME类型即可解决，具体如下：在开始菜单“运行”处输入“inetmgr”回车，打开IIS界面后，在“网站”下找到本软件所属的网站，点右键，选“属性”，切换到“HTTP头”，点“MIME类型”-“新建”，输入文件扩展名，如“.docx”，在“MIME类型”处输入“application/octet-stream”，点确定即可。</p>
                            </dd>
                            <dt>导出或备份的文件，迅雷下载失败？</dt>
                            <dd>
                                <p>这种情况下，可打开迅雷设置界面，在“高级设置”-“监视对象”下，取消“监视浏览器”选项，从而避免使用迅雷下载。</p>
                            </dd>
                            <dt>如何批量更新某字段的值？</dt>
                            <dd><p>进入“<%= ims.Comm.Vars.DataCenterText %>”，在该模板上点右键，选“数据管理”，在“批量更新”处选择要更新的字段，并输入新的值，最后点“更新”按钮即可更新所有记录。如果只想更新一部分记录，可勾选“仅更新符合条件的记录”，并设置好条件之后再点“更新”。也可以进入表格视图，筛选或勾选出需要更新的记录后，点“批量操作”进行批量更新。</p></dd>
                            <dt>如何在录入某个字段时自动列出以前在该字段中输入过的内容供选择？</dt>
                            <dd><p>进入模板的设计界面，将该字段勾选“输入提示”选项，并设置数据来源为本模板的本字段。</p></dd>
                            <dt>如何实现具有输入提示功能的多级分类联动？</dt>
                            <dd>
                                <p>第一种方式：单独建立一个模板来保存分类数据。假设有A、B、C三级分类，则新建模板T，添加这三个字段，并录入所有分类的组合，如“a1,b1,c1;a1,b1,c2;a1,b2,c3;a1,b2,c4;a2,b3,c5...”。然后在要使用分类的模板中，分别添加A、B、C这三个分类字段，A字段勾选“输入提示”并设置数据来源为模板T，“取值”设为取A最小的前20项A；B字段也类似的设置，只不过需要在“筛选”下勾选并设置条件为“A等于当前A”，取值则取B最小的前20项B；C字段的筛选条件设为“A等于当前A”，并且“B等于当前B”，取值方法为取C最小的前20项C。这样设置之后，在录入B、C字段时，会自动根据当时所选择的父类来筛选出相应的结果产生列表供选择。</p>
                                <p>二级分类字段的设置可参考下图示例：</p>
                                <p><img src="images/help/acsetting.png" /></p>
                                <p>第二种方式：不用单独建立分类模板，而是把“数据来源”设为本模板，其它设置方法和原理与第一种方式类似。这样设置的效果是：在录入时，如果已经存在需要的分类项，则可以直接选择，如果还没有这个分类项，则手工填写，下次再录入时就会出现该项供选择了。</p>
                            </dd>
                            <dt>如何实现输入编号，自动取得对应的名称等属性？</dt>
                            <dd><p>为每个需要自动取值的字段，在“输入提示”设置中指定筛选条件为“编号等于当前编号”，并“取值”为编号最小的“第一项”名称（或其它字段），勾选“自动填充”。录入时，在输入编号后，这些字段将会自动获取到其对应的值。</p></dd>
                            <dt>如何能够快速打开类似“本周到期的合同”这类记录？</dt>
                            <dd><p>进入“<%= ims.Comm.Vars.DataCenterText %>”，在模板上点右键，选“筛选”，在筛选条件中，将类似“到期日期”这种字段设置为“本周”，然后点击窗口下方的“保存为快捷方式”，输入名称后保存即可。这样，以后就可以直接在搜索主页的“我的快捷方式”中点击该快捷方式来打开指定字段的时间值在本周内的记录了。</p></dd>
                            <dt>怎样设置让用户只能看到自己录入的数据？</dt>
                            <dd><p>进入设计中心，在模板上点右键，权限，为用户所属的角色设置浏览权限为适当的级别后，勾选“仅允许浏览符合条件的记录”，条件设置为“创建人”等于“$UserName$”。如果需要给予编辑权限，则再勾选“禁止编辑或删除他人添加的记录”。</p></dd>
                            <dt>如何建立主从关系的模板？</dt>
                            <dd>
                                <p>例如，订单模板与相应的订单商品明细模板，就是一种主从关系，一个订单会对应有多条商品明细记录。建立主从关系的步骤如下：</p>
                                <p>进入设计中心，在主模板上点右键，选“属性”，在弹出的对话框中切换到“关系”标签页，在下面的“添加子模板”处选择作为子模板的模板，并设置关联字段。如，（订单商品明细的）订单编号关联到当前“订单编号”，其实质相当于是，某个订单的商品明细记录，就是订单商品明细中订单编号等于这个订单的编号的那些记录。</p>
                                <p>选项“同步更新关联字段”如果选中，则在上例中修改订单的编号时，“订单商品明细”中它所对应的那些记录的订单编号也会作相应的变更；“同步删除关联记录”选项用于在删除某条记录时，子模板中相关联的记录也同时自动删除，如删除一个订单，它对应的订单商品明细记录也会同时删除；“同步添加关联记录”选项用于在添加主模板记录时自动在一对一关系的子模板中添加一条关联的记录。</p>
                                <p>设置好关联和选项后，点击下面的“添加”按钮即可建立起该关系。这将为今后的录入、浏览和管理数据提供方便。</p>
                                <p>说明：像订单与订单商品明细表的关系是“一对多”的关系；像员工与员工配偶信息表的关系是“一对一”关系。通常，只有一对一关系，才应该选中“同步添加关联记录”。</p>
                            </dd>
                            <dt>如何将一个表的某个字段的值复制到一个新表中？</dt>
                            <dd><p>只能对不允许重复的字段实现该功能，方法是：建立好新的模板（其中至少要有一个与源字段对应的字段），将其设为源模板的子模板（勾选“同步添加关联记录”选项），并执行同步操作即可。</p></dd>
                            <dt>如何为自动编号类型字段重置起始编号？</dt>
                            <dd><p>在记录删除后添加新的记录时，不会重复使用已删除记录的编号。只有当从“数据管理”对话框中清空所有记录时，自动编号的起始值才会重置，在有数据记录的情况下，想要从头开始编号，只能通过在模板设计界面中删除这个自动编号字段后重新建立一个相同规则的字段来实现，但这样会导致已存在的记录被重新编号，如果存在与其它模板中的记录的关联，将会使这种关联关系发生错乱。</p></dd>
                            <dt>如何批量导入图片或文件？</dt>
                            <dd>
                                <p>如果某个模板包含有图片或文件类型的字段并且已经上传了至少一个文件，那么导出Excel时将会得到一个zip格式的压缩文件，其中包含了Excel和Files两个文件夹，分别用于放置Excel表和所涉及的文件。</p>
                                <p>要批量导入，也是按这同样的文件夹结构来放置Excel和对应的文件，文件的名称和Excel表中对应字段中填写的名称(多个文件名用逗号分隔)相对应。在Excel数据录入完成且将相应文件放置到Files文件夹中后，将这两个文件夹选中并打包为zip格式压缩包，再在数据中心-模板图标右键菜单-数据管理-导入Excel，选择这个压缩文件即可开始导入。</p>
                            </dd>
                            <dt>导出Excel时，能否不导出图片或文件字段所包含的文件？</dt>
                            <dd><p>表格视图的“导出到Excel”功能，会只导出当前所显示的列的内容，因此，可以先隐藏图片和文件类型的字段，再执行导出操作。</p></dd>
                            <dt>为什么系统的访问地址经常变化？</dt>
                            <dd><p>这是由于安装本软件的电脑没有设置固定IP地址，而是“自动获取IP地址”。解决方法是：从控制面板中打开网络连接，在本地连接上点右键，属性，双击“TCP/IPv4”这一行，选中“使用下面的IP地址”，并依次填写IP地址、网关等设置。具体应设置的值，可在开始-运行中输入cmd打开命令提示符窗口，执行“ipconfig /all”来查看“本地连接”相关参数。</p></dd>
                            <dt>如何解决“存在无效的公式或查询字段…无法确定Double值”或“遇到被零除错误”的问题？</dt>
                            <dd>
                                <p>这通常是由于某个公式字段中作为分母的字段未填写数值或数值为0造成的。分母为0会导致公式计算时出错。解决方法有二：</p>
                                <p>一、将分母字段为空或为0的改为一个非0值。进入“<%= ims.Comm.Vars.DataCenterText %>”，在模板上点右键，选“数据管理”，在“批量更新”处选择作为分母的字段，填入一个非0值（比如1），再设置左下方的更新条件为该字段等于空（不填写条件值，留空）或等于0，最后点“更新”按钮即可。</p>
                                <p>二、将公式改为：<span class="red">iif(IsNull([xxx]) or [xxx] = 0, null, [yyy]/[xxx])</span>（该示例为Access语法），或：<span class="red">Case When [xxx] is null or [xxx] = 0 Then null Else [yyy]/[xxx] End</span>（该示例为SQL Server语法）。</p>
                                <p>以上公式的含义为：如果字段代码为[xxx]的字段（即作为分母的字段）为空或为0，则为空值（null），否则按正常的公式进行除法运算。</p>
                                <p>此外，也可考虑把作为分母的字段设为“必填字段”，以避免产生空值造成错误。</p>
                            </dd>
                            <dt>查询字段较多导致打开时很慢，怎么办？</dt>
                            <dd style="margin-left:1em">
                                查询字段是在浏览时取值，其数量和复杂度对执行性能有较明显的影响。可考虑以下方式改善：<br />
                                <span id="queryForAccess" runat="server">■ 切换为使用SQL Server数据库；<br /></span>
                                ■ 不使用查询字段，而是在详情视图使用自由排版来定义查询并显示查询结果；<br />
                                ■ 不使用查询类型，而是用文本等类型，配合输入提示的“自动填充”功能，在录入时取得结果并保存下来；<br />
                                ■ 尝试减少每页显示数量；<br />
                                ■ 考虑将模板拆分为两个或多个，以减少单个模板中的查询字段数量。
                            </dd>
                            <dt>查询字段和输入提示的“自动填充”功能有何区别？</dt>
                            <dd>
                                <p>查询字段是在浏览时执行查询计算来取值，因此其值会随源数据的变化而变化；输入提示功能是用于在录入时辅助输入，自动填充得到的结果保存后不受源数据变化的影响。</p>
                            </dd>
                            <dt>巧用输入提示功能</dt>
                            <dd>
                                <p>“允许多项输入”选项：可用指定分隔符来分隔多项值，并持续产生提示列表。如果在查询字段（或自由排版中定义的查询）的查询条件中对该字段使用“包含/不包含/包含于/不包含于”模式，则将按完整的某一项值来匹配，如“abc，def”，不会认为包含“ab”。这个特点，某些情况下可用来保存一对多的对应关系，从而不必使用子模板。</p>
                                <p>“只接受数据源范围内的值”选项：有时，希望用户只能从输入提示列表中选择值，而不允许输入其它无效的值，就可以使用这个选项，达到类似单选列表的效果，确保输入值的有效性。</p>
                            </dd>
                            <dt>如何在首页显示一个或多个图表/报表/目录等内容？</dt>
                            <dd>
                                <p>在首页点击右上角的 <img src="images/gear.png" align="absmiddle" /> 图标，可添加自定义版块、RSS版块或网页版块，利用添加网页版块的功能，可将系统中的某个页面或视图添加到首页：</p>
                                <p>在“添加网页版块”对话框中，点右下方的“获取内部页面地址”，选择一个页面或视图后，点“添加”按钮，即可将得到的地址填充到“网址”输入框中。勾选“尝试自适应高度”和“隐藏滚动条”选项，点确定按钮，即添加了一个版块，并显示出所指定的页面。</p>
                            </dd>
                       </dl>
                    </asp:Panel>

                    <asp:Panel ID="access" Visible="false" runat="server">
                        <dl>
                        <dt>日期/时间函数</dt>
                        <dd><ul>
                            <li><span class="term">Now()</span>返回当前时间(完整时间，包括年月日时分秒)</li>
                            <li><span class="term">Date()</span>返回当前日期</li>
                            <li><span class="term">Time()</span>返回当前时间(除去年/月/日的部份)</li>
                            <li><span class="term">Year(date)</span>返回日期的年份</li>
                            <li><span class="term">Month(date)</span>返回日期的月份</li>
                            <li><span class="term">Day(date)</span>返回日期的d部份,等同于DatePart使用d参数</li>
                            <li><span class="term">CDate(expression)</span>将字符串转化成为日期。如：CDate("2013/4/5")</li>
                            <li><span class="term">DateAdd(datepart, number, date)</span>将指定日期加上某个日期。如：DateAdd("d",1,Date())，将当前日期加上1天,其中d可以换为yyyy、m等</li>
                            <li><span class="term">DateDiff(datepart, date1, date2)</span>判断两个日期之间的间隔。如：DateDiff("d","2013-5-1",生日),其中d可以换为yyyy、m等</li>
                            <li><span class="term">DatePart(datepart, date)</span>返回日期的某个部份。如：DatePart("d","2013-5-1")返回1,即1号，d也可换为yyyy、m等</li>
                            <li><span class="term">IsDate(expression)</span>判断是否是日期值,是日期返回-1,否则返回0</li>
                            <li><span class="term">Weekday(date)</span>返回代表一星期中某天的整数(星期天为1,星期一为2...)。如：Weekday(Now())</li>
                        </ul></dd>
                        <dt>文本函数</dt>
                        <dd><ul>
                            <li><span class="term">Format(expression, format)</span>格式化字符串。如：Format(now(),'yyyy-mm-dd')返回类似于"2013-04-03"，Format(3/9,"0.00")返回0.33</li>
                            <li><span class="term">UCase(expression)</span>将字符串转换为大写形式</li>
                            <li><span class="term">LCase(expression)</span>将字符串转换为小写形式</li>
                            <li><span class="term">Left(expression, length)</span>取字符串左边指定数字的字符</li>
                            <li><span class="term">Mid(string, start, length)</span>取得子字符串。如：Mid("abc",1,2)返回“ab”</li>
                            <li><span class="term">Right(expression, length)</span>取字符串右边指定数字的字符</li>
                            <li><span class="term">Trim(expression)</span>去掉字符串两端的空格</li>
                            <li><span class="term">LTrim(expression)</span>去掉左边的空格</li>
                            <li><span class="term">RTrim(expression)</span>去掉右边的空格</li>
                            <li><span class="term">InStr(string1, string2)</span>查询子串在字符串中的位置。如：Instr("abc","a")返回1，Instr("abc","f")返回0</li>
                            <li><span class="term">StrComp(string1, string2)</span>比较两个字符串是否内容一致(不区分大小写)。如：StrComp("abc","ABC")返回0，StrComp("abc","123")返回-1</li>
                            <li><span class="term">Space(expression)</span>产生空格。如：Space(4)返回4个空格</li>
                        </ul></dd>
                        <dt>算术函数</dt>
                        <dd><ul>
                            <li><span class="term">Abs(expression)</span>返回绝对值</li>
                            <li><span class="term">Int(expression)</span>将数字向下取整到最接近的整数</li>
                            <li><span class="term">Rnd()</span>返回一个0到1之间的随机数值</li>
                            <li><span class="term">Sgn(expression)</span>返回数字的正负符号(正数返回1,负数返回-1,0值返回0)</li>
                            <li><span class="term">Sqr(expression)</span>返回平方根值</li>
                        </ul></dd>
                        <dt>聚集函数</dt>
                        <dd><ul>
                            <li><span class="term">Sum</span>计算字段的合计值</li>
                            <li><span class="term">Avg</span>取字段平均值</li>
                            <li><span class="term">Count</span>统计记录条数</li>
                            <li><span class="term">Max</span>取字段最大值</li>
                            <li><span class="term">Min</span>取字段最小值</li>
                        </ul></dd>
                        <dt>其它函数</dt>
                        <dd><ul>
                            <li><span class="term">IIF(expression1, expression2, expression3)</span>根据表达式返回特定的值。如：IIF(2>1,"True","False")，返回True</li>
                            <li><span class="term">Choose(expression1, expression2, ...)</span>根据第一参数，返回后面字符串组的值。Choose(1,"a","b","c")返回a,将1改成2后返回b(第一个参数也可以是某个字段)</li>
                            <li><span class="term">IsNull(expression)</span>检测是否为Null值，是null值返回-1，非null值返回0</li>
                            <li><span class="term">IsNumeric(expression)</span>检测是否为数字,是数字返回-1，否则返回0</li>
                        </ul></dd>
                        </dl>
                        <div style="text-align:right;margin-top:2em">更多函数及其用法，请下载参考<a href="http://landian.cc/download.aspx?file=access.exe" target="_blank">《Access函数大全》</a></div>
                    </asp:Panel>
                                        
                    <asp:Panel ID="sqlserver" Visible="false" runat="server">
                        <dl>
                        <dt>日期/时间函数</dt>
                        <dd><ul>
                            <li><span class="term">Getdate()</span>返回当前日期</li>
                            <li><span class="term">Year(date)</span>返回日期的年份</li>
                            <li><span class="term">Month(date)</span>返回日期的月份</li>
                            <li><span class="term">Day(date)</span>返回日期的d部份,等同于DatePart使用d参数</li>
                            <li><span class="term">DateAdd(datepart, number, date)</span>将指定日期加上某个日期。如：DateAdd(dd,1,Getdate())，将当前日期加上1天,其中dd可以换为yy、mm等</li>
                            <li><span class="term">DateDiff(datepart, date1, date2)</span>判断两个日期之间的间隔。如：DateDiff(dd,'2013-5-1',Getdate())返回2013-5-1到今天差多少天,其中dd可以换为yy、mm等</li>
                            <li><span class="term">DatePart(datepart, date)</span>返回日期的某个部份。如：DatePart('dd','2013-5-1')返回1,即1号，dd也可以换为yy、mm等</li>
                            <li><span class="term">IsDate(expression)</span>判断是否是日期值，是日期返回1，否则返回0</li>
                        </ul></dd>
                        <dt>文本函数</dt>
                        <dd><ul>
                            <li><span class="term">Upper(expression)</span>将字符串转换为大写形式</li>
                            <li><span class="term">Lower(expression)</span>将字符串转换为小写形式</li>
                            <li><span class="term">Left(expression, length)</span>取字符串左边指定数字的字符</li>
                            <li><span class="term">Right(expression, length)</span>取字符串右边指定数字的字符</li>
                            <li><span class="term">LTrim(expression)</span>去掉左边的空格</li>
                            <li><span class="term">RTrim(expression)</span>去掉右边的空格</li>
                            <li><span class="term">Space(expression)</span>产生空格。如：Space(4)返回4个空格</li>
                            <li><span class="term">Substring(expression, starting_position, length)</span>返回从字符串左边第starting_position个字符起length个字符的部分</li>
                            <li><span class="term">Replace(expression1, string_expression2, string_expression3)</span>用expression3替换在expression1中的子串expression2</li>
                            <li><span class="term">Patindex(expression1, expression2)</span>返回字符串expression1在expression2中出现的开始位置</li>
                        </ul></dd>
                        <dt>算术函数</dt>
                        <dd><ul>
                            <li><span class="term">Abs(expression)</span>返回绝对值</li>
                            <li><span class="term">Round(expression, length)</span>返回数字表达式并四舍五入为指定的精度</li>
                            <li><span class="term">Sign(expression)</span>返回给定表达式的正 (+1)、零 (0) 或负 (-1) 号</li>
                            <li><span class="term">Ceiling(expression)</span>回大于或等于所给数字表达式的最小整数</li>
                            <li><span class="term">Floor(expression)</span>返回小于或等于所给数字表达式的最大整数</li>
                        </ul></dd>
                        <dt>聚集函数</dt>
                        <dd><ul>
                            <li><span class="term">Sum</span>计算字段的合计值</li>
                            <li><span class="term">Avg</span>取字段平均值</li>
                            <li><span class="term">Count</span>统计记录条数</li>
                            <li><span class="term">Max</span>取字段最大值</li>
                            <li><span class="term">Min</span>取字段最小值</li>
                        </ul></dd>
                        <dt>其它函数</dt>
                        <dd><ul>
                            <li><span class="term">IsNull(expression, replacement)</span>如果给定表达式计算为Null，则返回指定的替换值，否则返回表达式结果</li>
                            <li><span class="term">IsNumeric(expression)</span>检测是否为数字,是数字返回1，否则返回0</li>
                            <li><span class="term">Case When ... Then ... Else ... End</span>根据不同情况来取不同的值。如：case when 2 > 1 then 'true' else 'false' end。</li>
                        </ul></dd>
                        </dl>
                        <div style="text-align:right;margin-top:2em">更多相关资料，请下载<a href="http://landian.cc/download.aspx?file=sqlserver.chm" target="_blank">《SQL语言参考》</a>查阅“函数”部分</div>
                    </asp:Panel>
                                        
                    <asp:Panel ID="three" Visible="false" runat="server">
                        <dl>
                            <dt>三分钟入门</dt>
                            <dd>
                                <p>本系统的数据管理功能都是基于模板来实现的。所谓模板，是用来规定要管理哪些内容的，比如，学生档案，有学生姓名、出生年月等内容。下面通过一个应用例子，来看看如何创建模板并进行管理。</p>
                                <p>假设，我们是一个服装经销商，需要管理服装的基本信息及其进销存数据，那么：</p>
                                <p>先进入“设计中心”，在空白处点右键“添加模板”，输入模板名称“服装”：</p>
                                <p><img src="images/help/addTemplet1.png" align="absBottom" />　　<img src="images/help/addTemplet2.png" align="absBottom" /><div style="width:340px" class="pictComment">　　（设计中心右键菜单）　　　　 （输入模板名称）</div></p>
                                <p>然后会自动转到模板设计界面，点击“添加字段”，在字段名称处输入“商品代号”，点确定，就添加了一个字段；接着继续添加名称、品牌（数据类型选“单选列表”，并预设好各品牌）、颜色、尺码、图片、类别等字段，这样，就完成了模板的设计。</p>
                                <p><img src="images/help/design.png" /><div style="width:550px" class="pictComment">（模板设计界面）</div></p>
                                <p>接着，创建模板“进销存记录”，加入商品代号、出入库数量（出库时填负数）、时间等字段。</p>
                                <p>后面的事情就更简单了。要添加服装？有如下两种方式：</p>
                                <p><img src="images/help/addData.png" />　　<img src="images/help/dataAdmin.png" /><div style="width:510px" class="pictComment">（从左侧栏导航区添加）　　　　　　　   （从<%= ims.Comm.Vars.DataCenterText %>菜单添加）</div></p>
                                <p style="text-align:center"><br /><img src="images/help/edit.png" /><div class="pictComment">（添加服装信息）</div></p>
                                <p>要浏览或搜索服装？同样可以从左侧栏的“浏览”标签下，或数据中心右键菜单中操作。下图是浏览时的缩略视图效果（可在左侧栏切换表格视图、报表视图等六种视图）：</p>
                                <p style="text-align:center"><br /><img src="images/help/viewObj.png" /><div class="pictComment">（缩略视图）</div></p>
                                <p>现在，您已经入门了。不过，为了管理起来更轻松愉快，我们还可以作些改进：</p>
                            </dd>
                            <dt>五分钟提高</dt>
                            <dd>
                                <ul class="decoration">
                                    <li>为进销存记录的“商品代号”字段添加“输入提示”功能，如下图所示。这样，在录入进销存记录时，可以从已有的服装代号中选择而不用输入。
                                        <div style="text-align:center"><img src="images/help/advance.png" /><div class="pictComment">（输入提示设置）</div></div>
                                    </li>
                                    <li>为服装模板添加一个“库存量”字段，数据类型为“查询”，如下图所示。这样，在浏览服装时，就可以看到实时的库存量。
                                        <div style="text-align:center"><img src="images/help/query.png" /><div class="pictComment">（查询设置）</div></div>
                                    </li>
                                    <li>打开左侧根目录，添加一个子目录“服装”，然后进入设计中心，在服装模板上点右键，选“属性”，设置默认目录为“服装”目录，再设置好默认视图、标识字段（显示在缩略图下方的名称）等属性。
                                        <div style="text-align:center"><img src="images/help/attribute.png" /><div class="pictComment">（模板属性设置）</div></div>
                                    </li>
                                </ul>
                                <br />
                                <p>最后，如果需要多人共同管理或查询数据，需要设置权限：</p>
                                <ul class="decoration">
                                    <li>先考虑一下要使用这套系统的人有哪几种，如，数据录入人员、只需要查询数据的人员。然后进入“系统管理”-“角色管理”，分别建立一个角色。再进入“用户管理”，添加需要的用户并设置为适当的角色。</li>
                                    <li>在设计中心的“服装”上点右键，选“权限”，分别为刚建立的角色设置权限，如，设置数据录入人员有完全控制权限，浏览人员只能浏览某个保密级别以下的内容。</li>
                                </ul>
                                <div style="text-align:center"><img src="images/help/templetPower.png" /><div class="pictComment">（模板权限设置）</div></div>
                                <p>至此，各个用户就可以通过浏览器登录系统来进行授权的工作了。当然，您可以继续发挥您的创造性思维，作更好的设计，来满足可能会经常变动的需求。至于系统中的自由排版、数据导入导出、备份和还原、统计图表等更多精彩功能，您应该很快就能应用和体验了。</p>
                                <p>现在，就<a href="#" onclick="to('templets.aspx');">进入设计中心</a>大胆尝试吧！</p>
                            </dd>
                        </dl>
                    </asp:Panel>
                    
				</div>
				</td>
			</tr>
			<tr id="footer"><td style="text-align: center;padding:2px;" colspan="2">
			    <input runat="server" id="fullWindow" type="button" value="全屏" />&nbsp;
			    <input onclick="window.close();" type="button" value="关闭" />
			</td></tr>
		</table>
	<script src="js/comm.js"></script><script src="js/help.js"></script>
    </form>
</body>
</html>