﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.web.guide, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" id="guide">
<head runat="server">
    <title>向导</title>
    <base target="_self" />
</head>
<body style="margin:1.5em 2.5em 2em">
    <form id="form1" runat="server">
        <asp:ScriptManager runat="server" ID="s1">
            <Scripts><asp:ScriptReference Name="MicrosoftAjax.js" ScriptMode="Auto" Path="~/js/MsAjax.js"/><asp:ScriptReference Name="MicrosoftAjaxWebForms.js" ScriptMode="Auto" Path="~/js/MsAjax.js"/></Scripts>
        </asp:ScriptManager>
        <table cellspacing="0" id="nav">
            <tr>
                <td style="width:10px">&nbsp;</td>
                <td runat="server" id="tdWwelcome" rel="welcome" style="width:40px"><div>欢迎</div></td>
                <td runat="server" id="tdTemplet" rel="templet" style="width:84px"><div><span>·</span>建立模板</div></td>
                <td rel="input" style="width:54px"><div><span>·</span>录入</div></td>
                <td rel="view" style="width:54px"><div><span>·</span>浏览</div></td>
                <td rel="search" style="width:54px"><div><span>·</span>搜索</div></td>
                <td runat="server" id="tdUserPower" rel="userpower" style="width:96px"><div><span>·</span>用户及权限</div></td>
                <td runat="server" id="tdAdvanced" rel="advanced" style="width:54px"><div><span>·</span>高级</div></td>
                <td>&nbsp;</td>
            </tr>
        </table>
        
        <div id="main">
            <div id="welcome" class="hide">
                <p>这是一个灵活易用的管理软件自定义平台，通过您简单的设计，它能满足您各种常见的管理需求，如，进行数据信息管理、OA办公等等。现在，您可通过以下途径来快速了解它：</p>
                <ul>
                    <li><a href="#" onclick="return showHelp('three');">阅读《三分钟入门》</a>；</li>
                    <li runat="server" id="crAbout1"><a href="http://landian.cc/download/ims_demo.exe">下载观看操作演示</a>；</li>
                    <li runat="server" id="crAbout2"><a href="http://landian.cc/demo" target="_blank">查看在线演示</a>；</li>
                    <li runat="server" id="crAbout3"><a href="http://landian.cc" target="_blank">进入软件官方网站或论坛，获取技术支持</a>；</li>
                    <li>跟随本向导，开始建立您自己的管理系统！</li>
                </ul>
                <br />
                <div class="zoneTitle"><img src="images/info.gif" /> 提示</div>
                <ul>
                    <li>任何时候，可点击左侧的“实时帮助”，查看与当前操作相关的帮助信息；</li>
                    <li>关于如何从其它电脑访问等问题，请查看<a href="#" onclick="return showHelp('faq');">常见问题解答</a>。</li>
                </ul>
            </div>
            <div id="templet" class="hide">
                <p>打开<asp:HyperLink
                    ID="HyperLink5" NavigateUrl="templets.aspx" runat="server">设计中心</asp:HyperLink>，点右键，选“添加模板”，输入名称后自动进入模板设计界面。然后，将需要的字段逐个添加到模板中，并为其选择适当的数据类型和选项。</p>
                <br />
                <div class="zoneTitle"><img src="images/what.gif" /> 术语</div>
                <ul>
                    <li><b>模板</b>任何要管理的事物都是以模板为基础的。模板定义了其各种属性，如名称、规格、重量等，这些属性被称为"字段"。系统所管理的数据都是依存于特定的模板的，其中的每一条信息称为一条"记录"。</li>
                </ul>
                <br />
                <div class="zoneTitle"><img src="images/info.gif" /> 提示</div>
                <ul>
                    <li runat="server" id="importTemplets">您也可以导入系统预置的应用模板组进行观摩或应用：
                    <asp:UpdatePanel runat="server" ID="up" RenderMode="Inline">
                        <ContentTemplate>
                            <asp:DropDownList AutoPostBack="true" OnSelectedIndexChanged="ApplySolution" runat="server" ID="ddlTemplets"></asp:DropDownList>
                        </ContentTemplate>
                    </asp:UpdatePanel>；
                    </li>
                </ul>
                <br />
                <div class="zoneTitle"><img src="images/link.gif" /> 参考</div>
                <p><a href="#" onclick="return showHelp('templets');">关于模板</a>&nbsp;&nbsp;&nbsp;<a href="#" onclick="return showHelp('templet');">模板设计</a></p>
            </div>
            <div id="input" class="hide">
                <p>建立模板后，可通过以下几种方式来录入数据：</p>
                <ul>
                    <li>从左侧栏顶部导航区的<img src="images/data_add.gif" />标签下点击要添加数据的模板名称；</li>
                    <li>进入“<%= ims.Comm.Vars.DataCenterText %>”，在模板上点右键，选“添加”；</li>
                    <li>在目录中点右键，从“新建”子菜单中点击模板名称。</li>
                </ul>
                <br />
                <div class="zoneTitle"><img src="images/info.gif" /> 提示</div>
                <ul>
                    <li>可通过Excel批量导入数据：在录入页面，点击“下载Excel表单”，再利用这个表单文件来录入数据后，点击“从Excel导入”，选定这个Excel文件即可导入其中数据；</li>
                    <li>也可以点击“导入类似记录”，来将某条相似的记录填充到编辑界面再作修改，以减轻工作量。</li>
                </ul>
            </div>
            <div id="view" class="hide">
                <p>录入数据后，可通过以下方式来浏览：</p>
                <ul>
                    <li>从左侧栏顶部导航区的<img src="images/data_browse.gif" />标签下点击要浏览的模板名称；</li>
                    <li>进入“<%= ims.Comm.Vars.DataCenterText %>”，直接点击要浏览的模板；</li>
                    <li>从左侧栏“目录”下打开某个目录来浏览存放于该目录下的数据记录。</li>
                </ul>
                <br />
                <div class="zoneTitle"><img src="images/what.gif" /> 术语</div>
                <ul>
                    <li><b>目录</b>目录是一种对数据记录进行分类存放的组织形式。同一模板的记录可能分布在不同的目录中，也可以不放到任何目录中（在模板属性中设置为“不关联到目录”，这通常用于流水帐之类的动态数据）。</li>
                    <li><b>视图</b>视图，是对正在浏览的一批数据的一种表现形式。不同的视图可以从不同的角度和方式来对同一批记录进行查看或统计。</li>
                </ul>
                <br />
                <div class="zoneTitle"><img src="images/info.gif" /> 提示</div>
                <ul>
                    <li>可在模板属性中设置默认视图。但无论怎样设置，打开一个目录时，都是以缩略图形式显示的；</li>
                    <li>系统会自动记录最近一次的浏览，所以任何时候都可以点击某个视图来查看最近浏览的数据；</li>
                    <li>在模板设计、数据录入、表格视图等很多地方，都可以拖动字段来调整字段位置或宽度，并能保存排版结果。</li>
                </ul>
            </div>
            <div id="search" class="hide">
                <p>可通过以下方式进行搜索：</p>
                <ul>
                    <li>点击顶栏的“搜索”图标，或左侧栏顶部导航区的<img src="images/data_find.gif" />图标；</li>
                    <li>从左侧栏顶部导航区的<img src="images/data_find.gif" />标签下点击要搜索的模板名称；</li>
                    <li>进入“<%= ims.Comm.Vars.DataCenterText %>”，在模板上点右键，选“搜索”或“筛选”；</li>
                    <li>在目录中点右键，选“搜索”，可以在该目录范围内进行搜索。</li>
                </ul>
                <br />
                <div class="zoneTitle"><img src="images/info.gif" /> 提示</div>
                <ul>
                    <li>在筛选或高级搜索界面，可以将设置好的搜索条件保存为快捷方式，以后可从左侧栏顶部导航区的<img src="images/data_shortcut.gif" />标签下打开。</li>
                    <li>也可进入“<%= ims.Comm.Vars.DataCenterText %>”，在模板上点右键，选“过滤器”，来设置一组筛选条件并保存为过滤器。以后在“<%= ims.Comm.Vars.DataCenterText %>”中可从模板右键菜单中打开来浏览符合条件的数据。</li>
                    <li>快捷方式仅本人可见，过滤器对所有用户都可见。</li>
                </ul>
                <br />
                <div class="zoneTitle"><img src="images/link.gif" /> 相关链接</div>
                <p><a href="dataHome.aspx">搜索</a>&nbsp;&nbsp;&nbsp;<a href="advSearch.aspx">高级搜索</a>&nbsp;&nbsp;&nbsp;<a href="templets.aspx?mode=data"><%= ims.Comm.Vars.DataCenterText %></a></p>
            </div>
            <div id="userpower" class="hide">
                <p>用户的权限是由其所属的角色决定的。根据用户类别建立相应的角色，再为角色设置权限，最后将用户分配到适当的角色，就完成了系统的权限设置。</p>
                <br />
                <div class="zoneTitle"><img src="images/what.gif" /> 术语</div>
                <ul>
                    <li><b>用户</b>指可以用于登录系统的一个帐户。用户可以由管理员添加，也可以通过注册页面自行注册（前提是系统开放了注册功能）。</li>
                    <li><b>角色</b>角色，是具有相同权限的一组或一类用户的统称，如公司领导、员工、供应商、客户等等。</li>
                </ul>
                <br />
                <div class="zoneTitle"><img src="images/info.gif" /> 提示</div>
                <ul>
                    <li>模板建立后，默认只有创建者或系统管理员才有权限。所以，如果要让其它人可浏览或编辑数据，需要对该模板为角色授权（设计中心，模板右键菜单中选“权限”）。</li>
                    <li>浏览权限和数据的保密级别是相对应的，分别有0～10共11个级别。用户只能查看保密级别不高于其浏览权限级别的内容（有编辑权限或完全控制权限除外）。</li>
                </ul>
                <br />
                <div class="zoneTitle"><img src="images/link.gif" /> 相关链接</div>
                <p><a href="users.aspx">用户管理</a>&nbsp;&nbsp;&nbsp;<a href="roles.aspx">角色管理</a>&nbsp;&nbsp;&nbsp;<a href="#" onclick="return showHelp('power');">更多帮助</a></p>
            </div>
            <div id="advanced" class="hide">
                <ul>
                    <li><b>输入提示功能</b>设置了输入提示功能的字段，在输入时，会从指定的数据来源提取数据产生一个列表供选择，类似于搜索引擎的自动完成效果；还可以做出像超市收银台那样输入编码自动填充产品名称的功能。</li>
                    <li><b>查询类型字段</b>查询类型的字段，在录入数据时不会出现，而是在浏览时自动按照所设定的查询条件，从目标数据中计算出一个结果，作为该字段的值。</li>
                    <li><b>建立主从关系的模板</b>例如，订单模板与相应的订单商品明细模板，就是一种主从关系，一个订单会对应有多条商品明细记录。建立了这种关系后，就可以方便地添加或查看关联数据。</li>
                    <li><b>详情视图自定义版式</b>在详情视图进入版式管理页面后，选“自由排版”模式，可以用类似Word的编辑方式来对页面进行灵活的版面设计，并可显示其它模板中的关联数据。请参考<a href="#" onclick="return showHelp('detaillayout');">详情页面排版</a>。</li>
                    <li><b>概要视图自定义格式</b>在概要视图任一项点击右上角的浮动图标，可灵活设置显示格式。请参考<a href="#" onclick="return showHelp('summary');">概要视图格式设置</a>。</li>
                    <li><b>拖动排版、右键操作、就地编辑、回车保存等特性</b>在使用过程中会逐渐了解。</li>
                    <li><b>工作流</b>通过为模板创建流程，可以规范业务处理逻辑、顺序和权限。请参考<a href="#" onclick="return showHelp('flow',true);">流程设计</a>。</li>
                </ul>
                <br />
                <div class="zoneTitle"><img src="images/info.gif" /> 提示</div>
                <ul>
                    <li>灵活运用以上几个特性，可以实现很多高级的功能，值得深入了解；</li>
                    <li>关于如何建立主从关系的模板等问题，请参考“<a href="#" onclick="return showHelp('faq');">FAQ（常见问题解答）</a>”。</li>
                </ul>
            </div>
        </div>
        <div id="btns">
            <input type="button" class="btn" value="上一步" style="width:54px;display:none" onclick="PreStep();" id="btnPre" />
            <input type="button" class="btn" value="下一步" style="width:54px" onclick="NextStep();" id="btnNext" />
            <input type="button" class="btn hide" value="开始设计" style="width:66px" onclick="location = 'templets.aspx';" id="btnStart" />
        </div>
    <script src="js/comm.js"></script>
    <script>
        $(function () {
            var txts = "⒈⒉⒊⒋⒌⒍⒎⒏";
            $("#nav td span").each(function (i) {
                this.innerHTML = txts.substr([i], 1);
            });
            SwitchTo("#nav td[rel]:first");
            $("#nav td[rel]").mouseover(function () {
                if (!$(this).is(".current")) $(this).addClass("on");
            }).mouseout(function () {
                $(this).removeClass("on");
            }).click(function () { SwitchTo(this); });
            var prm = Sys.WebForms.PageRequestManager.getInstance();
            prm.add_initializeRequest(function () { showLoading(); $("#ddlTemplets").prop("disabled", true); });
            prm.add_endRequest(function () { hideLoading(); $("#ddlTemplets").prop("disabled", false); });
        });
        function SwitchTo(tab) {
            $("#nav td.current").removeClass("current");
            $(tab).addClass("current").removeClass("on");
            $("#main > div:visible").addClass("hide");
            $("#" + $(tab).attr("rel")).removeClass("hide");
            SetBtnsStatus();
        }
        function PreStep() {
            var target = $("#nav td.current").prev("td[rel]");
            if (target.length > 0) SwitchTo(target);
        }
        function NextStep() {
            var target = $("#nav td.current").next("td[rel]");
            if (target.length > 0) SwitchTo(target);
        }
        function SetBtnsStatus() {
            $("#btnPre").css("display", $("#nav td.current").prev("td[rel]").length > 0 ? "" : "none");
            $("#btnNext").css("display", $("#nav td.current").next("td[rel]").length > 0 ? "" : "none");
            if ($("#advanced").is(":visible")) {
                $("#btnStart").removeClass("hide");
            } else {
                $("#btnStart").addClass("hide");
            }
        }
    </script>
    </form>
</body>
</html>