﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.web.chart, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" id="chart">
<head runat="server"><title></title><script src="js/comm.js"></script><script src="js/chart.js"></script></head>
<body>
    <form id="form1" runat="server">
        <asp:ScriptManager ID="sm" runat="server">
            <Scripts>
                <asp:ScriptReference Name="MicrosoftAjax.js" ScriptMode="Auto" Path="~/js/MsAjax.js"/>
                <asp:ScriptReference Name="MicrosoftAjaxWebForms.js" ScriptMode="Auto" Path="~/js/MsAjax.js"/>
            </Scripts>
        </asp:ScriptManager>
        <div runat="server" id="EmptyPrompt" visible="false" class="highlight corner"></div>
        <div id="loading"><img src="images/loading.gif" />正在生成图表，请稍候…</div>
        <asp:UpdatePanel ID="main" runat="server" UpdateMode="Conditional">
            <ContentTemplate>
		        <img runat="server" id="imgChart" style="display:none" /><br /><br />
            </ContentTemplate>
            <Triggers><asp:AsyncPostBackTrigger ControlID="btnBuild" EventName="Click" /></Triggers>
        </asp:UpdatePanel>

        <table cellspacing="0" class="fieldtab">
            <tr>
                <td class="lborder"></td><td class="headText">⊙ 图表设置</td>
                <td class="rpad right">
                    <asp:UpdatePanel ID="chartList" runat="server" UpdateMode="Conditional">
                        <ContentTemplate>
	                        <asp:DropDownList runat="server" ID="ddlCharts" AutoPostBack="true" OnSelectedIndexChanged="SwitchChart" onchange="showLoading();"></asp:DropDownList>
                        </ContentTemplate>
                    </asp:UpdatePanel>
                </td>
            </tr>
            <tr>
                <td colspan="3" class="content">
	                <table cellspacing="0"><tr><td style="width:49%">
	                    <ul>
	                        <li title="选择要生成的图表的类型">图表类型：<asp:RadioButtonList Runat="server" ID="rblType" RepeatLayout="Flow" RepeatColumns="2">
                            <asp:ListItem Selected="True" Value="0">柱状图</asp:ListItem>
                            <asp:ListItem Value="1">排列图</asp:ListItem>
                          </asp:RadioButtonList></li>
	                        <li title="要分析的，图表横坐标所代表的字段">统计字段： <asp:DropDownList Runat="server" ID="ddlXs"></asp:DropDownList></li>
	                        <li title="作为统计指标的，图表纵坐标所代表的字段">统计指标： <asp:DropDownList Runat="server" ID="ddlYs"></asp:DropDownList></li>
	                    </ul>
	                </td><td style="width:49%" valign="top">
	                    <ul>
	                        <li title="对于横坐标上的每一段，计算其纵坐标值的方法">统计方法： <asp:DropDownList Runat="server" ID="ddlStatMode" Width="74">
                            <asp:ListItem Value="sum">合计</asp:ListItem>
                            <asp:ListItem Value="avg">平均值</asp:ListItem>
                            <asp:ListItem Value="max">最大值</asp:ListItem>
                            <asp:ListItem Value="min">最小值</asp:ListItem>
                            <asp:ListItem Value="var">方差</asp:ListItem>
                            <asp:ListItem Value="stdev">标准偏差</asp:ListItem>
                            <asp:ListItem Value="count">计数</asp:ListItem>
                          </asp:DropDownList></li>
	                        <li id="liSeps" title="设置如何确定横坐标上的各个区段">分组方法： <asp:DropDownList runat="server" ID="ddlGroupby"><asp:ListItem Selected="True" Value="All">按所有值分组</asp:ListItem><asp:ListItem Value="Auto">自动分组</asp:ListItem><asp:ListItem Value="Specified">手动分组</asp:ListItem></asp:DropDownList>
                                <asp:DropDownList runat="server" ID="ddlTimeSpan"></asp:DropDownList>
                                <asp:TextBox ID="SepValues" Width="200" runat="server"></asp:TextBox></li>
	                        <li title="根据纵坐标的值，对横坐标上的字段进行排序的排序方向">排序方式： <asp:DropDownList Runat="server" ID="ddlSortMode">
                            <asp:ListItem Value="">无</asp:ListItem>
                            <asp:ListItem Value="ASC">纵坐标升序</asp:ListItem>
                            <asp:ListItem Selected="True" Value="DESC">纵坐标降序</asp:ListItem>
                            <asp:ListItem Value="_ASC">横坐标升序</asp:ListItem>
                            <asp:ListItem Value="_DESC">横坐标降序</asp:ListItem>
                          </asp:DropDownList></li>
	                    </ul>
	                </td></tr></table>
                </td>
            </tr>
        </table>

        <asp:UpdatePanel ID="upBtnArea" runat="server" UpdateMode="Conditional" ChildrenAsTriggers="false">
            <ContentTemplate>
	            <div class="footBtnArea">
	                <asp:Button ID="btnBuild" runat="server" Text="生成图表" OnClick="Build" OnClientClick="toggleLoading(false);" Width="66" CssClass="btn" />
	                <input type="button" runat="server" ID="btnManage" onclick="return toManage();" value="管理图表" onserverclick="ManageCharts" class="btn" style="width:66px" />
	                <input type="button" runat="server" id="btnPrint" class="btn" onclick="printPrompt();" value="打印" />
	                <input type="button" onclick="back();" value="返回" class="btn" />
	            </div>
            </ContentTemplate>
        </asp:UpdatePanel>

        <ims:Pop runat="server" ID="m" ShowOkButton="false" CanelButtonText="关闭" Title="管理图表" CustomCss="noline">
            <ContentTemplate>
                <fieldset><legend>保存当前设置</legend>
                    <div class="padcenter">名称：<asp:TextBox runat="server" ID="tbName" Width="240" onkeydown="return enterTo('m_btnSave');"></asp:TextBox><asp:Button runat="server" ID="btnSave" OnClick="SaveSetting" Text="保存" CssClass="btn" /></div>
                </fieldset>
                <div runat="server" id="allCharts">
                    <table class="normal" cellspacing="1">
                        <tr><th>图表名称</th><th style="width:60px">设为默认</th><th style="width:32px">更名</th><th style="width:32px">删除</th></tr>
                        <asp:PlaceHolder runat="server" ID="phCharts"></asp:PlaceHolder>
                    </table>
                </div>
            </ContentTemplate>
        </ims:Pop>
    </form>
</body>
</html>
