/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import javax.xml.namespace.QName;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.Whitespace;

public class StructuredQName {
    private char[] content;
    private int localNameStart;
    private int prefixStart;

    public StructuredQName(String prefix, String uri, String localName) {
        if (uri == null) {
            uri = "";
        }
        int plen = prefix.length();
        int ulen = uri.length();
        int llen = localName.length();
        this.localNameStart = ulen;
        this.prefixStart = ulen + llen;
        this.content = new char[ulen + llen + plen];
        uri.getChars(0, ulen, this.content, 0);
        localName.getChars(0, llen, this.content, ulen);
        prefix.getChars(0, plen, this.content, ulen + llen);
    }

    public static StructuredQName fromClarkName(String expandedName) {
        String localName;
        String namespace;
        if (expandedName.charAt(0) == '{') {
            int closeBrace = expandedName.indexOf(125);
            if (closeBrace < 0) {
                throw new IllegalArgumentException("No closing '}' in Clark name");
            }
            namespace = expandedName.substring(1, closeBrace);
            if (closeBrace == expandedName.length()) {
                throw new IllegalArgumentException("Missing local part in Clark name");
            }
            localName = expandedName.substring(closeBrace + 1);
        } else {
            namespace = "";
            localName = expandedName;
        }
        return new StructuredQName("", namespace, localName);
    }

    public static StructuredQName fromLexicalQName(CharSequence lexicalName, boolean useDefault, NameChecker checker, NamespaceResolver resolver) throws XPathException {
        try {
            String[] parts = checker.getQNameParts(Whitespace.trimWhitespace(lexicalName));
            String uri = resolver.getURIForPrefix(parts[0], useDefault);
            if (uri == null) {
                XPathException de = new XPathException("Namespace prefix '" + parts[0] + "' has not been declared");
                de.setErrorCode("FONS0004");
                throw de;
            }
            return new StructuredQName(parts[0], uri, parts[1]);
        }
        catch (QNameException e) {
            XPathException de = new XPathException(e.getMessage());
            de.setErrorCode("FOCA0002");
            throw de;
        }
    }

    public String getPrefix() {
        return new String(this.content, this.prefixStart, this.content.length - this.prefixStart);
    }

    public String getURI() {
        if (this.localNameStart == 0) {
            return "";
        }
        return new String(this.content, 0, this.localNameStart);
    }

    public String getLocalPart() {
        return new String(this.content, this.localNameStart, this.prefixStart - this.localNameStart);
    }

    public String getDisplayName() {
        if (this.prefixStart == this.content.length) {
            return this.getLocalPart();
        }
        FastStringBuffer buff = new FastStringBuffer(this.content.length - this.localNameStart + 1);
        buff.append(this.content, this.prefixStart, this.content.length - this.prefixStart);
        buff.append(':');
        buff.append(this.content, this.localNameStart, this.prefixStart - this.localNameStart);
        return buff.toString();
    }

    public StructuredQName getStructuredQName() {
        return this;
    }

    public String getClarkName() {
        FastStringBuffer buff = new FastStringBuffer(this.content.length - this.prefixStart + 2);
        if (this.localNameStart > 0) {
            buff.append('{');
            buff.append(this.content, 0, this.localNameStart);
            buff.append('}');
        }
        buff.append(this.content, this.localNameStart, this.prefixStart - this.localNameStart);
        return buff.toString();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object other) {
        if (other instanceof StructuredQName) {
            StructuredQName sq2 = (StructuredQName)other;
            if (this.localNameStart != sq2.localNameStart || this.prefixStart != sq2.prefixStart) {
                return false;
            }
            for (int i = this.prefixStart - 1; i >= 0; --i) {
                if (this.content[i] == sq2.content[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = -2147180533;
        h ^= this.prefixStart;
        h ^= this.localNameStart;
        for (int i = this.prefixStart - 1; i >= 0; --i) {
            h ^= this.content[i] << (i & 0x1F);
        }
        return h;
    }

    public static int computeHashCode(CharSequence uri, CharSequence local) {
        int i;
        int h = -2147180533;
        int localLen = local.length();
        int uriLen = uri.length();
        int totalLen = localLen + uriLen;
        h ^= totalLen;
        h ^= uriLen;
        for (i = 0; i < uriLen; ++i) {
            h ^= uri.charAt(i) << (i & 0x1F);
        }
        i = 0;
        int j = uriLen;
        while (i < localLen) {
            h ^= local.charAt(i) << (j & 0x1F);
            ++i;
            ++j;
        }
        return h;
    }

    public boolean isInSameNamespace(NodeName other) {
        if (this == other) {
            return true;
        }
        if (other instanceof StructuredQName) {
            StructuredQName q2 = (StructuredQName)((Object)other);
            if (this.localNameStart != q2.localNameStart) {
                return false;
            }
            for (int i = this.localNameStart - 1; i >= 0; --i) {
                if (this.content[i] == q2.content[i]) continue;
                return false;
            }
            return true;
        }
        return this.getURI().equals(other.getURI());
    }

    public boolean isInNamespace(String ns) {
        if (ns.length() == 0) {
            return this.localNameStart == 0;
        }
        return this.localNameStart == ns.length() && this.getURI().equals(ns);
    }

    public QName toJaxpQName() {
        return new QName(this.getURI(), this.getLocalPart(), this.getPrefix());
    }

    public NamespaceBinding getNamespaceBinding() {
        return NamespaceBinding.makeNamespaceBinding(new CharSlice(this.content, this.prefixStart, this.content.length - this.prefixStart), new CharSlice(this.content, 0, this.localNameStart));
    }

    public boolean hasFingerprint() {
        return false;
    }

    public int getFingerprint() {
        return -1;
    }

    public int getNameCode() {
        return -1;
    }
}

