/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.wmf2svg.util;

import com.google.appengine.api.images.Image;
import com.google.appengine.api.images.ImagesService;
import com.google.appengine.api.images.ImagesServiceFactory;
import com.google.appengine.api.images.Transform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBuffer;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageUtil {
    private static Converter converter;

    public static byte[] convert(byte[] image, String destType, boolean reverse) {
        if (converter == null) {
            throw new UnsupportedOperationException("Image Conversion API(Image IO or GAE Image API) is missing.");
        }
        return converter.convert(image, destType, reverse);
    }

    static {
        if ("Production".equals(System.getProperty("com.google.appengine.runtime.environment"))) {
            converter = new GAEConverter();
        } else {
            try {
                Class.forName("javax.imageio.ImageIO");
                converter = new ImageIOConverter();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private static class GAEConverter
    implements Converter {
        private GAEConverter() {
        }

        public byte[] convert(byte[] image, String destType, boolean reverse) {
            if (destType == null) {
                throw new IllegalArgumentException("dest type is null.");
            }
            destType = destType.toLowerCase();
            ImagesService.OutputEncoding encoding = null;
            if ("png".equals(destType)) {
                encoding = ImagesService.OutputEncoding.PNG;
            } else if ("jpeg".equals(destType)) {
                encoding = ImagesService.OutputEncoding.JPEG;
            } else {
                throw new UnsupportedOperationException("unsupported image encoding: " + destType);
            }
            ImagesService imagesService = ImagesServiceFactory.getImagesService();
            Image bmp = ImagesServiceFactory.makeImage((byte[])image);
            Transform t = reverse ? ImagesServiceFactory.makeVerticalFlip() : ImagesServiceFactory.makeCompositeTransform();
            return imagesService.applyTransform(t, bmp, encoding).getImageData();
        }
    }

    private static class ImageIOConverter
    implements Converter {
        private ImageIOConverter() {
        }

        public byte[] convert(byte[] image, String destType, boolean reverse) {
            if (destType == null) {
                throw new IllegalArgumentException("dest type is null.");
            }
            destType = destType.toLowerCase();
            byte[] outimage = null;
            try {
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(image));
                BufferedImage dst = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 5);
                ColorConvertOp colorConvert = new ColorConvertOp(dst.getColorModel().getColorSpace(), null);
                colorConvert.filter(bufferedImage, dst);
                bufferedImage = dst;
                if (reverse) {
                    DataBuffer srcData = bufferedImage.getRaster().getDataBuffer();
                    BufferedImage dstImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
                    DataBuffer dstData = dstImage.getRaster().getDataBuffer();
                    int lineSize = bufferedImage.getWidth() * bufferedImage.getColorModel().getPixelSize() / 8;
                    int h = 0;
                    int k = bufferedImage.getHeight() - 1;
                    while (h < bufferedImage.getHeight()) {
                        for (int j = 0; j < lineSize; ++j) {
                            dstData.setElem(h * lineSize + j, srcData.getElem(k * lineSize + j));
                        }
                        ++h;
                        --k;
                    }
                    bufferedImage = dstImage;
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, destType, out);
                outimage = out.toByteArray();
            }
            catch (IOException e) {
                // empty catch block
            }
            return outimage;
        }
    }

    private static interface Converter {
        public byte[] convert(byte[] var1, String var2, boolean var3);
    }
}

