/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.wmf2svg.gdi.wmf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.arnx.wmf2svg.gdi.Gdi;
import net.arnx.wmf2svg.gdi.GdiBrush;
import net.arnx.wmf2svg.gdi.GdiFont;
import net.arnx.wmf2svg.gdi.GdiObject;
import net.arnx.wmf2svg.gdi.GdiPalette;
import net.arnx.wmf2svg.gdi.GdiPatternBrush;
import net.arnx.wmf2svg.gdi.GdiPen;
import net.arnx.wmf2svg.gdi.GdiRegion;
import net.arnx.wmf2svg.gdi.Point;
import net.arnx.wmf2svg.gdi.Size;
import net.arnx.wmf2svg.gdi.wmf.WmfBrush;
import net.arnx.wmf2svg.gdi.wmf.WmfConstants;
import net.arnx.wmf2svg.gdi.wmf.WmfFont;
import net.arnx.wmf2svg.gdi.wmf.WmfObject;
import net.arnx.wmf2svg.gdi.wmf.WmfPalette;
import net.arnx.wmf2svg.gdi.wmf.WmfPatternBrush;
import net.arnx.wmf2svg.gdi.wmf.WmfPen;
import net.arnx.wmf2svg.gdi.wmf.WmfRectRegion;
import net.arnx.wmf2svg.gdi.wmf.WmfRegion;

public class WmfGdi
implements Gdi,
WmfConstants {
    private byte[] placeableHeader;
    private byte[] header;
    private List objects = new ArrayList();
    private List records = new ArrayList();

    public void write(OutputStream out) throws IOException {
        this.footer();
        if (this.placeableHeader != null) {
            out.write(this.placeableHeader);
        }
        if (this.header != null) {
            out.write(this.header);
        }
        Iterator i = this.records.iterator();
        while (i.hasNext()) {
            out.write((byte[])i.next());
        }
    }

    public void placeableHeader(int vsx, int vsy, int vex, int vey, int dpi) {
        byte[] record = new byte[22];
        int pos = 0;
        pos = this.setUint32(record, pos, -1698247209L);
        pos = this.setInt16(record, pos, 0);
        pos = this.setInt16(record, pos, vsx);
        pos = this.setInt16(record, pos, vsy);
        pos = this.setInt16(record, pos, vex);
        pos = this.setInt16(record, pos, vey);
        pos = this.setUint16(record, pos, dpi);
        pos = this.setUint32(record, pos, 0L);
        int checksum = 0;
        for (int i = 0; i < record.length - 2; i += 2) {
            checksum ^= 0xFF & record[i] | (0xFF & record[i + 1]) << 8;
        }
        pos = this.setUint16(record, pos, checksum);
        this.placeableHeader = record;
    }

    public void header() {
        byte[] record = new byte[18];
        int pos = 0;
        pos = this.setUint16(record, pos, 1);
        pos = this.setUint16(record, pos, 9);
        pos = this.setUint16(record, pos, 768);
        pos = this.setUint32(record, pos, 0L);
        pos = this.setUint16(record, pos, 0);
        pos = this.setUint32(record, pos, 0L);
        pos = this.setUint16(record, pos, 0);
        this.header = record;
    }

    public void animatePalette(GdiPalette palette, int startIndex, int[] entries) {
        byte[] record = new byte[22];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 1078);
        pos = this.setUint16(record, pos, entries.length);
        pos = this.setUint16(record, pos, startIndex);
        pos = this.setUint16(record, pos, ((WmfPalette)palette).getID());
        for (int i = 0; i < entries.length; ++i) {
            pos = this.setInt32(record, pos, entries[i]);
        }
        this.records.add(record);
    }

    public void arc(int sxr, int syr, int exr, int eyr, int sxa, int sya, int exa, int eya) {
        byte[] record = new byte[22];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 2071);
        pos = this.setInt16(record, pos, eya);
        pos = this.setInt16(record, pos, exa);
        pos = this.setInt16(record, pos, sya);
        pos = this.setInt16(record, pos, sxa);
        pos = this.setInt16(record, pos, eyr);
        pos = this.setInt16(record, pos, exr);
        pos = this.setInt16(record, pos, syr);
        pos = this.setInt16(record, pos, sxr);
        this.records.add(record);
    }

    public void bitBlt(byte[] image, int dx, int dy, int dw, int dh, int sx, int sy, long rop) {
        byte[] record = new byte[22 + (image.length + image.length % 2)];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 2338);
        pos = this.setUint32(record, pos, rop);
        pos = this.setInt16(record, pos, sy);
        pos = this.setInt16(record, pos, sx);
        pos = this.setInt16(record, pos, dw);
        pos = this.setInt16(record, pos, dh);
        pos = this.setInt16(record, pos, dy);
        pos = this.setInt16(record, pos, dx);
        pos = this.setBytes(record, pos, image);
        if (image.length % 2 == 1) {
            pos = this.setByte(record, pos, 0);
        }
        this.records.add(record);
    }

    public void chord(int sxr, int syr, int exr, int eyr, int sxa, int sya, int exa, int eya) {
        byte[] record = new byte[22];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 2096);
        pos = this.setInt16(record, pos, eya);
        pos = this.setInt16(record, pos, exa);
        pos = this.setInt16(record, pos, sya);
        pos = this.setInt16(record, pos, sxa);
        pos = this.setInt16(record, pos, eyr);
        pos = this.setInt16(record, pos, exr);
        pos = this.setInt16(record, pos, syr);
        pos = this.setInt16(record, pos, sxr);
        this.records.add(record);
    }

    public GdiBrush createBrushIndirect(int style, int color, int hatch) {
        byte[] record = new byte[14];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 764);
        pos = this.setUint16(record, pos, style);
        pos = this.setInt32(record, pos, color);
        pos = this.setUint16(record, pos, hatch);
        this.records.add(record);
        WmfBrush brush = new WmfBrush(this.objects.size(), style, color, hatch);
        this.objects.add(brush);
        return brush;
    }

    public GdiFont createFontIndirect(int height, int width, int escapement, int orientation, int weight, boolean italic, boolean underline, boolean strikeout, int charset, int outPrecision, int clipPrecision, int quality, int pitchAndFamily, byte[] faceName) {
        byte[] record = new byte[24 + (faceName.length + faceName.length % 2)];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 763);
        pos = this.setInt16(record, pos, height);
        pos = this.setInt16(record, pos, width);
        pos = this.setInt16(record, pos, escapement);
        pos = this.setInt16(record, pos, orientation);
        pos = this.setInt16(record, pos, weight);
        pos = this.setByte(record, pos, italic ? 1 : 0);
        pos = this.setByte(record, pos, underline ? 1 : 0);
        pos = this.setByte(record, pos, strikeout ? 1 : 0);
        pos = this.setByte(record, pos, charset);
        pos = this.setByte(record, pos, outPrecision);
        pos = this.setByte(record, pos, clipPrecision);
        pos = this.setByte(record, pos, quality);
        pos = this.setByte(record, pos, pitchAndFamily);
        pos = this.setBytes(record, pos, faceName);
        if (faceName.length % 2 == 1) {
            pos = this.setByte(record, pos, 0);
        }
        this.records.add(record);
        WmfFont font = new WmfFont(this.objects.size(), height, width, escapement, orientation, weight, italic, underline, strikeout, charset, outPrecision, clipPrecision, quality, pitchAndFamily, faceName);
        this.objects.add(font);
        return font;
    }

    public GdiPalette createPalette(int version, int[] entries) {
        byte[] record = new byte[10 + entries.length * 4];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 247);
        pos = this.setUint16(record, pos, version);
        pos = this.setUint16(record, pos, entries.length);
        for (int i = 0; i < entries.length; ++i) {
            pos = this.setInt32(record, pos, entries[i]);
        }
        this.records.add(record);
        WmfPalette palette = new WmfPalette(this.objects.size(), version, entries);
        this.objects.add(palette);
        return palette;
    }

    public GdiPatternBrush createPatternBrush(byte[] image) {
        byte[] record = new byte[6 + (image.length + image.length % 2)];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 505);
        pos = this.setBytes(record, pos, image);
        if (image.length % 2 == 1) {
            pos = this.setByte(record, pos, 0);
        }
        this.records.add(record);
        WmfPatternBrush brush = new WmfPatternBrush(this.objects.size(), image);
        this.objects.add(brush);
        return brush;
    }

    public GdiPen createPenIndirect(int style, int width, int color) {
        byte[] record = new byte[16];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 762);
        pos = this.setUint16(record, pos, style);
        pos = this.setInt16(record, pos, width);
        pos = this.setInt16(record, pos, 0);
        pos = this.setInt32(record, pos, color);
        this.records.add(record);
        WmfPen pen = new WmfPen(this.objects.size(), style, width, color);
        this.objects.add(pen);
        return pen;
    }

    public GdiRegion createRectRgn(int left, int top, int right, int bottom) {
        byte[] record = new byte[14];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 1791);
        pos = this.setInt16(record, pos, bottom);
        pos = this.setInt16(record, pos, right);
        pos = this.setInt16(record, pos, top);
        pos = this.setInt16(record, pos, left);
        this.records.add(record);
        WmfRectRegion rgn = new WmfRectRegion(this.objects.size(), left, top, right, bottom);
        this.objects.add(rgn);
        return rgn;
    }

    public void deleteObject(GdiObject obj) {
        byte[] record = new byte[8];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 496);
        pos = this.setUint16(record, pos, ((WmfObject)obj).getID());
        this.records.add(record);
        this.objects.set(((WmfObject)obj).getID(), null);
    }

    public void dibBitBlt(byte[] image, int dx, int dy, int dw, int dh, int sx, int sy, long rop) {
        byte[] record = new byte[22 + (image.length + image.length % 2)];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 2368);
        pos = this.setUint32(record, pos, rop);
        pos = this.setInt16(record, pos, sy);
        pos = this.setInt16(record, pos, sx);
        pos = this.setInt16(record, pos, dw);
        pos = this.setInt16(record, pos, dh);
        pos = this.setInt16(record, pos, dy);
        pos = this.setInt16(record, pos, dx);
        pos = this.setBytes(record, pos, image);
        if (image.length % 2 == 1) {
            pos = this.setByte(record, pos, 0);
        }
        this.records.add(record);
    }

    public GdiPatternBrush dibCreatePatternBrush(byte[] image, int usage) {
        byte[] record = new byte[10 + (image.length + image.length % 2)];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 322);
        pos = this.setInt32(record, pos, usage);
        pos = this.setBytes(record, pos, image);
        if (image.length % 2 == 1) {
            pos = this.setByte(record, pos, 0);
        }
        this.records.add(record);
        WmfPatternBrush brush = new WmfPatternBrush(this.objects.size(), image);
        this.objects.add(brush);
        return brush;
    }

    public void dibStretchBlt(byte[] image, int dx, int dy, int dw, int dh, int sx, int sy, int sw, int sh, long rop) {
        byte[] record = new byte[26 + (image.length + image.length % 2)];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 2881);
        pos = this.setUint32(record, pos, rop);
        pos = this.setInt16(record, pos, sh);
        pos = this.setInt16(record, pos, sw);
        pos = this.setInt16(record, pos, sy);
        pos = this.setInt16(record, pos, sx);
        pos = this.setInt16(record, pos, dw);
        pos = this.setInt16(record, pos, dh);
        pos = this.setInt16(record, pos, dy);
        pos = this.setInt16(record, pos, dx);
        pos = this.setBytes(record, pos, image);
        if (image.length % 2 == 1) {
            pos = this.setByte(record, pos, 0);
        }
        this.records.add(record);
    }

    public void ellipse(int sx, int sy, int ex, int ey) {
        byte[] record = new byte[14];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 1048);
        pos = this.setInt16(record, pos, ey);
        pos = this.setInt16(record, pos, ex);
        pos = this.setInt16(record, pos, sy);
        pos = this.setInt16(record, pos, sx);
        this.records.add(record);
    }

    public void escape(byte[] data) {
        byte[] record = new byte[10 + (data.length + data.length % 2)];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 1574);
        pos = this.setBytes(record, pos, data);
        if (data.length % 2 == 1) {
            pos = this.setByte(record, pos, 0);
        }
        this.records.add(record);
    }

    public int excludeClipRect(int left, int top, int right, int bottom) {
        byte[] record = new byte[14];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 1045);
        pos = this.setInt16(record, pos, bottom);
        pos = this.setInt16(record, pos, right);
        pos = this.setInt16(record, pos, top);
        pos = this.setInt16(record, pos, left);
        this.records.add(record);
        return 3;
    }

    public void extFloodFill(int x, int y, int color, int type) {
        byte[] record = new byte[16];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 1352);
        pos = this.setUint16(record, pos, type);
        pos = this.setInt32(record, pos, color);
        pos = this.setInt16(record, pos, y);
        pos = this.setInt16(record, pos, x);
        this.records.add(record);
    }

    public void extTextOut(int x, int y, int options, int[] rect, byte[] text, int[] lpdx) {
        if (rect != null && rect.length != 4) {
            throw new IllegalArgumentException("rect must be 4 length.");
        }
        byte[] record = new byte[14 + (rect != null ? 8 : 0) + (text.length + text.length % 2) + lpdx.length * 2];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 2610);
        pos = this.setInt16(record, pos, y);
        pos = this.setInt16(record, pos, x);
        pos = this.setInt16(record, pos, text.length);
        pos = this.setInt16(record, pos, options);
        if (rect != null) {
            pos = this.setInt16(record, pos, rect[0]);
            pos = this.setInt16(record, pos, rect[1]);
            pos = this.setInt16(record, pos, rect[2]);
            pos = this.setInt16(record, pos, rect[3]);
        }
        pos = this.setBytes(record, pos, text);
        if (text.length % 2 == 1) {
            pos = this.setByte(record, pos, 0);
        }
        for (int i = 0; i < lpdx.length; ++i) {
            pos = this.setInt16(record, pos, lpdx[i]);
        }
        this.records.add(record);
    }

    public void fillRgn(GdiRegion rgn, GdiBrush brush) {
        byte[] record = new byte[10];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 1049);
        pos = this.setUint16(record, pos, ((WmfBrush)brush).getID());
        pos = this.setUint16(record, pos, ((WmfRegion)rgn).getID());
        this.records.add(record);
    }

    public void floodFill(int x, int y, int color) {
        byte[] record = new byte[16];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 1049);
        pos = this.setInt32(record, pos, color);
        pos = this.setInt16(record, pos, y);
        pos = this.setInt16(record, pos, x);
        this.records.add(record);
    }

    public void frameRgn(GdiRegion rgn, GdiBrush brush, int w, int h) {
        byte[] record = new byte[14];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 1065);
        pos = this.setInt16(record, pos, h);
        pos = this.setInt16(record, pos, w);
        pos = this.setUint16(record, pos, ((WmfBrush)brush).getID());
        pos = this.setUint16(record, pos, ((WmfRegion)rgn).getID());
        this.records.add(record);
    }

    public void intersectClipRect(int left, int top, int right, int bottom) {
        byte[] record = new byte[16];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 1046);
        pos = this.setInt16(record, pos, bottom);
        pos = this.setInt16(record, pos, right);
        pos = this.setInt16(record, pos, top);
        pos = this.setInt16(record, pos, left);
        this.records.add(record);
    }

    public void invertRgn(GdiRegion rgn) {
        byte[] record = new byte[8];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 298);
        pos = this.setUint16(record, pos, ((WmfRegion)rgn).getID());
        this.records.add(record);
    }

    public void lineTo(int ex, int ey) {
        byte[] record = new byte[10];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 531);
        pos = this.setInt16(record, pos, ey);
        pos = this.setInt16(record, pos, ex);
        this.records.add(record);
    }

    public void moveToEx(int x, int y, Point old) {
        byte[] record = new byte[10];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 532);
        pos = this.setInt16(record, pos, y);
        pos = this.setInt16(record, pos, x);
        this.records.add(record);
    }

    public void offsetClipRgn(int x, int y) {
        byte[] record = new byte[10];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 544);
        pos = this.setInt16(record, pos, y);
        pos = this.setInt16(record, pos, x);
        this.records.add(record);
    }

    public void offsetViewportOrgEx(int x, int y, Point point) {
        byte[] record = new byte[10];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 529);
        pos = this.setInt16(record, pos, y);
        pos = this.setInt16(record, pos, x);
        this.records.add(record);
    }

    public void offsetWindowOrgEx(int x, int y, Point point) {
        byte[] record = new byte[10];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 527);
        pos = this.setInt16(record, pos, y);
        pos = this.setInt16(record, pos, x);
        this.records.add(record);
    }

    public void paintRgn(GdiRegion rgn) {
        byte[] record = new byte[8];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 299);
        pos = this.setUint16(record, pos, ((WmfRegion)rgn).getID());
        this.records.add(record);
    }

    public void patBlt(int x, int y, int width, int height, long rop) {
        byte[] record = new byte[18];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 1565);
        pos = this.setUint32(record, pos, rop);
        pos = this.setInt16(record, pos, height);
        pos = this.setInt16(record, pos, width);
        pos = this.setInt16(record, pos, y);
        pos = this.setInt16(record, pos, x);
        this.records.add(record);
    }

    public void pie(int sx, int sy, int ex, int ey, int sxr, int syr, int exr, int eyr) {
        byte[] record = new byte[22];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 2074);
        pos = this.setInt16(record, pos, eyr);
        pos = this.setInt16(record, pos, exr);
        pos = this.setInt16(record, pos, syr);
        pos = this.setInt16(record, pos, sxr);
        pos = this.setInt16(record, pos, ey);
        pos = this.setInt16(record, pos, ex);
        pos = this.setInt16(record, pos, sy);
        pos = this.setInt16(record, pos, sx);
        this.records.add(record);
    }

    public void polygon(Point[] points) {
        byte[] record = new byte[8 + points.length * 4];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 804);
        pos = this.setInt16(record, pos, points.length);
        for (int i = 0; i < points.length; ++i) {
            pos = this.setInt16(record, pos, points[i].x);
            pos = this.setInt16(record, pos, points[i].y);
        }
        this.records.add(record);
    }

    public void polyline(Point[] points) {
        byte[] record = new byte[8 + points.length * 4];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 805);
        pos = this.setInt16(record, pos, points.length);
        for (int i = 0; i < points.length; ++i) {
            pos = this.setInt16(record, pos, points[i].x);
            pos = this.setInt16(record, pos, points[i].y);
        }
        this.records.add(record);
    }

    public void polyPolygon(Point[][] points) {
        int i;
        int length = 8;
        for (int i2 = 0; i2 < points.length; ++i2) {
            length += 2 + points[i2].length * 4;
        }
        byte[] record = new byte[length];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 805);
        pos = this.setInt16(record, pos, points.length);
        for (i = 0; i < points.length; ++i) {
            pos = this.setInt16(record, pos, points[i].length);
        }
        for (i = 0; i < points.length; ++i) {
            for (int j = 0; j < points[i].length; ++j) {
                pos = this.setInt16(record, pos, points[i][j].x);
                pos = this.setInt16(record, pos, points[i][j].y);
            }
        }
        this.records.add(record);
    }

    public void realizePalette() {
        byte[] record = new byte[6];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 53);
        this.records.add(record);
    }

    public void restoreDC(int savedDC) {
        byte[] record = new byte[8];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 295);
        pos = this.setInt16(record, pos, savedDC);
        this.records.add(record);
    }

    public void rectangle(int sx, int sy, int ex, int ey) {
        byte[] record = new byte[14];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 1051);
        pos = this.setInt16(record, pos, ey);
        pos = this.setInt16(record, pos, ex);
        pos = this.setInt16(record, pos, sy);
        pos = this.setInt16(record, pos, sx);
        this.records.add(record);
    }

    public void resizePalette(GdiPalette palette) {
        byte[] record = new byte[8];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 53);
        pos = this.setUint16(record, pos, ((WmfPalette)palette).getID());
        this.records.add(record);
    }

    public void roundRect(int sx, int sy, int ex, int ey, int rw, int rh) {
        byte[] record = new byte[18];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 1564);
        pos = this.setInt16(record, pos, rh);
        pos = this.setInt16(record, pos, rw);
        pos = this.setInt16(record, pos, ey);
        pos = this.setInt16(record, pos, ex);
        pos = this.setInt16(record, pos, sy);
        pos = this.setInt16(record, pos, sx);
        this.records.add(record);
    }

    public void seveDC() {
        byte[] record = new byte[6];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 30);
        this.records.add(record);
    }

    public void scaleViewportExtEx(int x, int xd, int y, int yd, Size old) {
        byte[] record = new byte[14];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 1042);
        pos = this.setInt16(record, pos, yd);
        pos = this.setInt16(record, pos, y);
        pos = this.setInt16(record, pos, xd);
        pos = this.setInt16(record, pos, x);
        this.records.add(record);
    }

    public void scaleWindowExtEx(int x, int xd, int y, int yd, Size old) {
        byte[] record = new byte[14];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 1040);
        pos = this.setInt16(record, pos, yd);
        pos = this.setInt16(record, pos, y);
        pos = this.setInt16(record, pos, xd);
        pos = this.setInt16(record, pos, x);
        this.records.add(record);
    }

    public void selectClipRgn(GdiRegion rgn) {
        byte[] record = new byte[8];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 300);
        pos = this.setUint16(record, pos, ((WmfRegion)rgn).getID());
        this.records.add(record);
    }

    public void selectObject(GdiObject obj) {
        byte[] record = new byte[8];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 301);
        pos = this.setUint16(record, pos, ((WmfObject)obj).getID());
        this.records.add(record);
    }

    public void selectPalette(GdiPalette palette, boolean mode) {
        byte[] record = new byte[8];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 564);
        pos = this.setInt16(record, pos, mode ? 1 : 0);
        pos = this.setUint16(record, pos, ((WmfPalette)palette).getID());
        this.records.add(record);
    }

    public void setBkColor(int color) {
        byte[] record = new byte[10];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 513);
        pos = this.setInt32(record, pos, color);
        this.records.add(record);
    }

    public void setBkMode(int mode) {
        byte[] record = new byte[8];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 258);
        pos = this.setInt16(record, pos, mode);
        this.records.add(record);
    }

    public void setDIBitsToDevice(int dx, int dy, int dw, int dh, int sx, int sy, int startscan, int scanlines, byte[] image, int colorUse) {
        byte[] record = new byte[24 + (image.length + image.length % 2)];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 3379);
        pos = this.setUint16(record, pos, colorUse);
        pos = this.setUint16(record, pos, scanlines);
        pos = this.setUint16(record, pos, startscan);
        pos = this.setInt16(record, pos, sy);
        pos = this.setInt16(record, pos, sx);
        pos = this.setInt16(record, pos, dw);
        pos = this.setInt16(record, pos, dh);
        pos = this.setInt16(record, pos, dy);
        pos = this.setInt16(record, pos, dx);
        pos = this.setBytes(record, pos, image);
        if (image.length % 2 == 1) {
            pos = this.setByte(record, pos, 0);
        }
        this.records.add(record);
    }

    public void setLayout(long layout) {
        byte[] record = new byte[10];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 329);
        pos = this.setUint32(record, pos, layout);
        this.records.add(record);
    }

    public void setMapMode(int mode) {
        byte[] record = new byte[8];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 259);
        pos = this.setInt16(record, pos, mode);
        this.records.add(record);
    }

    public void setMapperFlags(long flags) {
        byte[] record = new byte[10];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 561);
        pos = this.setUint32(record, pos, flags);
        this.records.add(record);
    }

    public void setPaletteEntries(GdiPalette palette, int startIndex, int[] entries) {
        byte[] record = new byte[6 + entries.length * 4];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 55);
        pos = this.setUint16(record, pos, ((WmfPalette)palette).getID());
        pos = this.setUint16(record, pos, entries.length);
        pos = this.setUint16(record, pos, startIndex);
        for (int i = 0; i < entries.length; ++i) {
            pos = this.setInt32(record, pos, entries[i]);
        }
        this.records.add(record);
    }

    public void setPixel(int x, int y, int color) {
        byte[] record = new byte[14];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 1055);
        pos = this.setInt32(record, pos, color);
        pos = this.setInt16(record, pos, y);
        pos = this.setInt16(record, pos, x);
        this.records.add(record);
    }

    public void setPolyFillMode(int mode) {
        byte[] record = new byte[8];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 262);
        pos = this.setInt16(record, pos, mode);
        this.records.add(record);
    }

    public void setRelAbs(int mode) {
        byte[] record = new byte[8];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 261);
        pos = this.setInt16(record, pos, mode);
        this.records.add(record);
    }

    public void setROP2(int mode) {
        byte[] record = new byte[8];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 260);
        pos = this.setInt16(record, pos, mode);
        this.records.add(record);
    }

    public void setStretchBltMode(int mode) {
        byte[] record = new byte[8];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 263);
        pos = this.setInt16(record, pos, mode);
        this.records.add(record);
    }

    public void setTextAlign(int align) {
        byte[] record = new byte[8];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 302);
        pos = this.setInt16(record, pos, align);
        this.records.add(record);
    }

    public void setTextCharacterExtra(int extra) {
        byte[] record = new byte[8];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 264);
        pos = this.setInt16(record, pos, extra);
        this.records.add(record);
    }

    public void setTextColor(int color) {
        byte[] record = new byte[10];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 521);
        pos = this.setInt32(record, pos, color);
        this.records.add(record);
    }

    public void setTextJustification(int breakExtra, int breakCount) {
        byte[] record = new byte[10];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 521);
        pos = this.setInt16(record, pos, breakCount);
        pos = this.setInt16(record, pos, breakExtra);
        this.records.add(record);
    }

    public void setViewportExtEx(int x, int y, Size old) {
        byte[] record = new byte[10];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 526);
        pos = this.setInt16(record, pos, y);
        pos = this.setInt16(record, pos, x);
        this.records.add(record);
    }

    public void setViewportOrgEx(int x, int y, Point old) {
        byte[] record = new byte[10];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 525);
        pos = this.setInt16(record, pos, y);
        pos = this.setInt16(record, pos, x);
        this.records.add(record);
    }

    public void setWindowExtEx(int width, int height, Size old) {
        byte[] record = new byte[10];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 524);
        pos = this.setInt16(record, pos, height);
        pos = this.setInt16(record, pos, width);
        this.records.add(record);
    }

    public void setWindowOrgEx(int x, int y, Point old) {
        byte[] record = new byte[10];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 523);
        pos = this.setInt16(record, pos, y);
        pos = this.setInt16(record, pos, x);
        this.records.add(record);
    }

    public void stretchBlt(byte[] image, int dx, int dy, int dw, int dh, int sx, int sy, int sw, int sh, long rop) {
        byte[] record = new byte[26 + (image.length + image.length % 2)];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 2851);
        pos = this.setUint32(record, pos, rop);
        pos = this.setInt16(record, pos, sh);
        pos = this.setInt16(record, pos, sw);
        pos = this.setInt16(record, pos, sy);
        pos = this.setInt16(record, pos, sx);
        pos = this.setInt16(record, pos, dw);
        pos = this.setInt16(record, pos, dh);
        pos = this.setInt16(record, pos, dy);
        pos = this.setInt16(record, pos, dx);
        pos = this.setBytes(record, pos, image);
        if (image.length % 2 == 1) {
            pos = this.setByte(record, pos, 0);
        }
        this.records.add(record);
    }

    public void stretchDIBits(int dx, int dy, int dw, int dh, int sx, int sy, int sw, int sh, byte[] image, int usage, long rop) {
        byte[] record = new byte[26 + (image.length + image.length % 2)];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 3907);
        pos = this.setUint32(record, pos, rop);
        pos = this.setUint16(record, pos, usage);
        pos = this.setInt16(record, pos, sh);
        pos = this.setInt16(record, pos, sw);
        pos = this.setInt16(record, pos, sy);
        pos = this.setInt16(record, pos, sx);
        pos = this.setInt16(record, pos, dw);
        pos = this.setInt16(record, pos, dh);
        pos = this.setInt16(record, pos, dy);
        pos = this.setInt16(record, pos, dx);
        pos = this.setBytes(record, pos, image);
        if (image.length % 2 == 1) {
            pos = this.setByte(record, pos, 0);
        }
        this.records.add(record);
    }

    public void textOut(int x, int y, byte[] text) {
        byte[] record = new byte[10 + text.length + text.length % 2];
        int pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 1313);
        pos = this.setInt16(record, pos, text.length);
        pos = this.setBytes(record, pos, text);
        if (text.length % 2 == 1) {
            pos = this.setByte(record, pos, 0);
        }
        pos = this.setInt16(record, pos, y);
        pos = this.setInt16(record, pos, x);
        this.records.add(record);
    }

    public void footer() {
        int pos = 0;
        if (this.header != null) {
            long size = this.header.length;
            long maxRecordSize = 0L;
            Iterator i = this.records.iterator();
            while (i.hasNext()) {
                byte[] record = (byte[])i.next();
                size += (long)record.length;
                if ((long)record.length <= maxRecordSize) continue;
                maxRecordSize = record.length;
            }
            pos = this.setUint32(this.header, 6, size / 2L);
            pos = this.setUint16(this.header, pos, this.objects.size());
            pos = this.setUint32(this.header, pos, maxRecordSize / 2L);
        }
        byte[] record = new byte[6];
        pos = 0;
        pos = this.setUint32(record, pos, record.length / 2);
        pos = this.setUint16(record, pos, 0);
        this.records.add(record);
    }

    private int setByte(byte[] out, int pos, int value) {
        out[pos] = (byte)(0xFF & value);
        return pos + 1;
    }

    private int setBytes(byte[] out, int pos, byte[] data) {
        System.arraycopy(data, 0, out, pos, data.length);
        return pos + data.length;
    }

    private int setInt16(byte[] out, int pos, int value) {
        out[pos] = (byte)(0xFF & value);
        out[pos + 1] = (byte)(0xFF & value >> 8);
        return pos + 2;
    }

    private int setInt32(byte[] out, int pos, int value) {
        out[pos] = (byte)(0xFF & value);
        out[pos + 1] = (byte)(0xFF & value >> 8);
        out[pos + 2] = (byte)(0xFF & value >> 16);
        out[pos + 3] = (byte)(0xFF & value >> 24);
        return pos + 4;
    }

    private int setUint16(byte[] out, int pos, int value) {
        out[pos] = (byte)(0xFF & value);
        out[pos + 1] = (byte)(0xFF & value >> 8);
        return pos + 2;
    }

    private int setUint32(byte[] out, int pos, long value) {
        out[pos] = (byte)(0xFFL & value);
        out[pos + 1] = (byte)(0xFFL & value >> 8);
        out[pos + 2] = (byte)(0xFFL & value >> 16);
        out[pos + 3] = (byte)(0xFFL & value >> 24);
        return pos + 4;
    }
}

