/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.wmf2svg.gdi.svg;

import net.arnx.wmf2svg.gdi.GdiPen;
import net.arnx.wmf2svg.gdi.svg.SvgGdi;
import net.arnx.wmf2svg.gdi.svg.SvgObject;
import org.w3c.dom.Text;

class SvgPen
extends SvgObject
implements GdiPen {
    private int style;
    private int width;
    private int color;

    public SvgPen(SvgGdi gdi, int style, int width, int color) {
        super(gdi);
        this.style = style;
        this.width = width > 0 ? width : 1;
        this.color = color;
    }

    public int getStyle() {
        return this.style;
    }

    public int getWidth() {
        return this.width;
    }

    public int getColor() {
        return this.color;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.color;
        result = 31 * result + this.style;
        result = 31 * result + this.width;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SvgPen other = (SvgPen)obj;
        if (this.color != other.color) {
            return false;
        }
        if (this.style != other.style) {
            return false;
        }
        return this.width == other.width;
    }

    public Text createTextNode(String id) {
        return this.getGDI().getDocument().createTextNode("." + id + " { " + this.toString() + " }\n");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.style == 5) {
            buffer.append("stroke: none; ");
        } else {
            buffer.append("stroke: " + SvgPen.toColor(this.color) + "; ");
            buffer.append("stroke-width: " + this.width + "; ");
            buffer.append("stroke-linejoin: round; ");
            if (this.width == 1 && 1 <= this.style && this.style <= 4) {
                buffer.append("stroke-dasharray: ");
                switch (this.style) {
                    case 1: {
                        buffer.append("" + this.toRealSize(18) + "," + this.toRealSize(6));
                        break;
                    }
                    case 2: {
                        buffer.append("" + this.toRealSize(3) + "," + this.toRealSize(3));
                        break;
                    }
                    case 3: {
                        buffer.append("" + this.toRealSize(9) + "," + this.toRealSize(3) + "," + this.toRealSize(3) + "," + this.toRealSize(3));
                        break;
                    }
                    case 4: {
                        buffer.append("" + this.toRealSize(9) + "," + this.toRealSize(3) + "," + this.toRealSize(3) + "," + this.toRealSize(3) + "," + this.toRealSize(3) + "," + this.toRealSize(3));
                    }
                }
                buffer.append("; ");
            }
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }
}

