/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.wmf2svg;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.arnx.wmf2svg.gdi.Gdi;
import net.arnx.wmf2svg.gdi.svg.SvgGdi;
import net.arnx.wmf2svg.gdi.wmf.WmfParser;
import org.w3c.dom.Document;

public class Main {
    private static Logger log = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) {
        String src = null;
        String dest = null;
        boolean debug = false;
        boolean compatible = false;
        boolean replaceSymbolFont = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-debug")) {
                    debug = true;
                    continue;
                }
                if (args[i].equals("-compatible")) {
                    compatible = true;
                    continue;
                }
                if (args[i].equals("-replace-symbol-font")) {
                    replaceSymbolFont = true;
                    continue;
                }
                Main.usage();
                return;
            }
            if (i == args.length - 2) {
                src = args[i];
                continue;
            }
            if (i != args.length - 1) continue;
            dest = args[i];
        }
        if (src == null || dest == null) {
            Main.usage();
            return;
        }
        try {
            FileInputStream in = new FileInputStream(src);
            WmfParser parser = new WmfParser();
            final SvgGdi gdi = new SvgGdi(compatible);
            gdi.setReplaceSymbolFont(replaceSymbolFont);
            if (debug) {
                ClassLoader cl = gdi.getClass().getClassLoader();
                Class[] interfaces = new Class[]{Gdi.class};
                parser.parse(in, (Gdi)Proxy.newProxyInstance(cl, interfaces, new InvocationHandler(){
                    StringBuffer sb = new StringBuffer(1000);

                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        this.sb.setLength(0);
                        this.sb.append(method.getName()).append("(");
                        if (args != null) {
                            for (int i = 0; i < args.length; ++i) {
                                int j;
                                Object[] array;
                                if (i > 0) {
                                    this.sb.append(", ");
                                }
                                if (args[i] instanceof int[]) {
                                    array = (int[])args[i];
                                    this.sb.append("[");
                                    for (j = 0; j < array.length; ++j) {
                                        if (j > 0) {
                                            this.sb.append(", ");
                                        }
                                        this.sb.append(array[j]);
                                    }
                                    this.sb.append("]");
                                    continue;
                                }
                                if (args[i] instanceof byte[]) {
                                    array = (byte[])args[i];
                                    if (method.getName().equals("extTextOut") && i == 4) {
                                        this.sb.append('\"');
                                        this.sb.append(new String((byte[])array, System.getProperty("file.encoding")));
                                        this.sb.append('\"');
                                        continue;
                                    }
                                    this.sb.append("[");
                                    for (j = 0; j < array.length; ++j) {
                                        if (j > 0) {
                                            this.sb.append(", ");
                                        }
                                        this.sb.append(Integer.toHexString(array[j]));
                                    }
                                    this.sb.append("]");
                                    continue;
                                }
                                if (args[i] instanceof double[]) {
                                    array = (double[])args[i];
                                    this.sb.append("[");
                                    for (j = 0; j < array.length; ++j) {
                                        if (j > 0) {
                                            this.sb.append(", ");
                                        }
                                        this.sb.append((double)array[j]);
                                    }
                                    this.sb.append("]");
                                    continue;
                                }
                                if (args[i] instanceof Object[]) {
                                    array = (Object[])args[i];
                                    this.sb.append("[");
                                    for (j = 0; j < array.length; ++j) {
                                        if (j > 0) {
                                            this.sb.append(", ");
                                        }
                                        this.sb.append((Object)array[j]);
                                    }
                                    this.sb.append("]");
                                    continue;
                                }
                                this.sb.append(args[i]);
                            }
                        }
                        this.sb.append(")");
                        log.fine(this.sb.toString());
                        try {
                            return method.invoke((Object)gdi, args);
                        }
                        catch (InvocationTargetException e) {
                            throw e.getTargetException();
                        }
                    }
                }));
            } else {
                parser.parse(in, gdi);
            }
            Document doc = gdi.getDocument();
            OutputStream out = new FileOutputStream(dest);
            if (args[1].endsWith(".svgz")) {
                out = new GZIPOutputStream(out);
            }
            Main.output(doc, out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void output(Document doc, OutputStream out) throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-public", "-//W3C//DTD SVG 1.0//EN");
        transformer.setOutputProperty("doctype-system", "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd");
        transformer.transform(new DOMSource(doc), new StreamResult(out));
        out.flush();
        out.close();
    }

    private static void usage() {
        System.out.println("java -jar wmf2svg.jar [wmf filename] [svg filename(svg, xml, or .svgz)]");
        System.exit(-1);
    }
}

