/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mjsoft.framework.util.jdk14zip;

import cn.com.mjsoft.framework.util.jdk14zip.DeflaterOutputStream;
import cn.com.mjsoft.framework.util.jdk14zip.IIIllIIIIIIllIlI;
import cn.com.mjsoft.framework.util.jdk14zip.ZipEntry;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.ZipException;

public class ZipOutputStream
extends DeflaterOutputStream
implements IIIllIIIIIIllIlI {
    private ZipEntry _$14;
    private Vector _$13 = new Vector();
    private Hashtable _$12 = new Hashtable();
    private CRC32 _$11 = new CRC32();
    private long _$10;
    private long _$9 = 0L;
    private String _$8;
    private int _$7 = 8;
    private boolean _$6;
    private boolean _$5 = false;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    private void _$2() throws IOException {
        if (this._$5) {
            throw new IOException("Stream closed");
        }
    }

    public ZipOutputStream(OutputStream outputStream) {
        super(outputStream, new Deflater(-1, true));
        this._$1 = true;
    }

    public void setComment(String string) {
        if (string != null && string.length() > 21845 && ZipOutputStream._$2(string) > 65535) {
            throw new IllegalArgumentException("ZIP file comment too long.");
        }
        this._$8 = string;
    }

    public void setMethod(int n) {
        if (n != 8 && n != 0) {
            throw new IllegalArgumentException("invalid compression method");
        }
        this._$7 = n;
    }

    public void setLevel(int n) {
        this._$4.setLevel(n);
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        this._$2();
        if (this._$14 != null) {
            this.closeEntry();
        }
        if (zipEntry._$10 == -1L) {
            zipEntry.setTime(System.currentTimeMillis());
        }
        if (zipEntry._$6 == -1) {
            zipEntry._$6 = this._$7;
        }
        switch (zipEntry._$6) {
            case 8: {
                if (zipEntry._$8 == -1L || zipEntry._$7 == -1L || zipEntry._$9 == -1L) {
                    zipEntry._$3 = 8;
                } else if (zipEntry._$8 != -1L && zipEntry._$7 != -1L && zipEntry._$9 != -1L) {
                    zipEntry._$3 = 0;
                } else {
                    throw new ZipException("DEFLATED entry missing size, compressed size, or crc-32");
                }
                zipEntry._$2 = 20;
                break;
            }
            case 0: {
                if (zipEntry._$8 == -1L) {
                    zipEntry._$8 = zipEntry._$7;
                } else if (zipEntry._$7 == -1L) {
                    zipEntry._$7 = zipEntry._$8;
                } else if (zipEntry._$8 != zipEntry._$7) {
                    throw new ZipException("STORED entry where compressed != uncompressed size");
                }
                if (zipEntry._$8 == -1L || zipEntry._$9 == -1L) {
                    throw new ZipException("STORED entry missing size, compressed size, or crc-32");
                }
                zipEntry._$2 = 10;
                zipEntry._$3 = 0;
                break;
            }
            default: {
                throw new ZipException("unsupported compression method");
            }
        }
        zipEntry._$1 = this._$10;
        if (this._$12.put(zipEntry._$11, zipEntry) != null) {
            throw new ZipException("duplicate entry: " + zipEntry._$11);
        }
        this._$3(zipEntry);
        this._$13.addElement(zipEntry);
        this._$14 = zipEntry;
    }

    public void closeEntry() throws IOException {
        this._$2();
        ZipEntry zipEntry = this._$14;
        if (zipEntry != null) {
            switch (zipEntry._$6) {
                case 8: {
                    this._$4.finish();
                    while (!this._$4.finished()) {
                        this._$1();
                    }
                    if ((zipEntry._$3 & 8) == 0) {
                        if (zipEntry._$8 != (long)this._$4.getTotalIn()) {
                            throw new ZipException("invalid entry size (expected " + zipEntry._$8 + " but got " + this._$4.getTotalIn() + " bytes)");
                        }
                        if (zipEntry._$7 != (long)this._$4.getTotalOut()) {
                            throw new ZipException("invalid entry compressed size (expected " + zipEntry._$7 + " but got " + this._$4.getTotalOut() + " bytes)");
                        }
                        if (zipEntry._$9 != this._$11.getValue()) {
                            throw new ZipException("invalid entry CRC-32 (expected 0x" + Long.toHexString(zipEntry._$9) + " but got 0x" + Long.toHexString(this._$11.getValue()) + ")");
                        }
                    } else {
                        zipEntry._$8 = this._$4.getTotalIn();
                        zipEntry._$7 = this._$4.getTotalOut();
                        zipEntry._$9 = this._$11.getValue();
                        this._$2(zipEntry);
                    }
                    this._$4.reset();
                    this._$10 += zipEntry._$7;
                    break;
                }
                case 0: {
                    if (zipEntry._$8 != this._$10 - this._$9) {
                        throw new ZipException("invalid entry size (expected " + zipEntry._$8 + " but got " + (this._$10 - this._$9) + " bytes)");
                    }
                    if (zipEntry._$9 == this._$11.getValue()) break;
                    throw new ZipException("invalid entry crc-32 (expected 0x" + Long.toHexString(zipEntry._$9) + " but got 0x" + Long.toHexString(this._$11.getValue()) + ")");
                }
                default: {
                    throw new InternalError("invalid compression method");
                }
            }
            this._$11.reset();
            this._$14 = null;
        }
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this._$2();
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        if (this._$14 == null) {
            throw new ZipException("no current ZIP entry");
        }
        switch (this._$14._$6) {
            case 8: {
                super.write(byArray, n, n2);
                break;
            }
            case 0: {
                this._$10 += (long)n2;
                if (this._$10 - this._$9 > this._$14._$8) {
                    throw new ZipException("attempt to write past end of STORED entry");
                }
                this.out.write(byArray, n, n2);
                break;
            }
            default: {
                throw new InternalError("invalid compression method");
            }
        }
        this._$11.update(byArray, n, n2);
    }

    public void finish() throws IOException {
        this._$2();
        if (this._$6) {
            return;
        }
        if (this._$14 != null) {
            this.closeEntry();
        }
        if (this._$13.size() < 1) {
            throw new ZipException("ZIP file must have at least one entry");
        }
        long l = this._$10;
        Enumeration enumeration = this._$13.elements();
        while (enumeration.hasMoreElements()) {
            this._$1((ZipEntry)enumeration.nextElement());
        }
        this._$1(l, this._$10 - l);
        this._$6 = true;
    }

    public void close() throws IOException {
        if (!this._$5) {
            super.close();
            this._$5 = true;
        }
    }

    private void _$3(ZipEntry zipEntry) throws IOException {
        this._$1(67324752L);
        this._$1(zipEntry._$2);
        this._$1(zipEntry._$3);
        this._$1(zipEntry._$6);
        this._$1(zipEntry._$10);
        if ((zipEntry._$3 & 8) == 8) {
            this._$1(0L);
            this._$1(0L);
            this._$1(0L);
        } else {
            this._$1(zipEntry._$9);
            this._$1(zipEntry._$7);
            this._$1(zipEntry._$8);
        }
        byte[] byArray = ZipOutputStream._$1(zipEntry._$11);
        this._$1(byArray.length);
        this._$1(zipEntry._$5 != null ? zipEntry._$5.length : 0);
        this._$1(byArray, 0, byArray.length);
        if (zipEntry._$5 != null) {
            this._$1(zipEntry._$5, 0, zipEntry._$5.length);
        }
        this._$9 = this._$10;
    }

    private void _$2(ZipEntry zipEntry) throws IOException {
        this._$1(134695760L);
        this._$1(zipEntry._$9);
        this._$1(zipEntry._$7);
        this._$1(zipEntry._$8);
    }

    private void _$1(ZipEntry zipEntry) throws IOException {
        byte[] byArray;
        this._$1(33639248L);
        this._$1(zipEntry._$2);
        this._$1(zipEntry._$2);
        this._$1(zipEntry._$3);
        this._$1(zipEntry._$6);
        this._$1(zipEntry._$10);
        this._$1(zipEntry._$9);
        this._$1(zipEntry._$7);
        this._$1(zipEntry._$8);
        byte[] byArray2 = ZipOutputStream._$1(zipEntry._$11);
        this._$1(byArray2.length);
        this._$1(zipEntry._$5 != null ? zipEntry._$5.length : 0);
        if (zipEntry._$4 != null) {
            byArray = ZipOutputStream._$1(zipEntry._$4);
            this._$1(byArray.length);
        } else {
            byArray = null;
            this._$1(0);
        }
        this._$1(0);
        this._$1(0);
        this._$1(0L);
        this._$1(zipEntry._$1);
        this._$1(byArray2, 0, byArray2.length);
        if (zipEntry._$5 != null) {
            this._$1(zipEntry._$5, 0, zipEntry._$5.length);
        }
        if (byArray != null) {
            this._$1(byArray, 0, byArray.length);
        }
    }

    private void _$1(long l, long l2) throws IOException {
        this._$1(101010256L);
        this._$1(0);
        this._$1(0);
        this._$1(this._$13.size());
        this._$1(this._$13.size());
        this._$1(l2);
        this._$1(l);
        if (this._$8 != null) {
            byte[] byArray = ZipOutputStream._$1(this._$8);
            this._$1(byArray.length);
            this._$1(byArray, 0, byArray.length);
        } else {
            this._$1(0);
        }
    }

    private void _$1(int n) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write(n >>> 0 & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        this._$10 += 2L;
    }

    private void _$1(long l) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write((int)(l >>> 0 & 0xFFL));
        outputStream.write((int)(l >>> 8 & 0xFFL));
        outputStream.write((int)(l >>> 16 & 0xFFL));
        outputStream.write((int)(l >>> 24 & 0xFFL));
        this._$10 += 4L;
    }

    private void _$1(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this._$10 += (long)n2;
    }

    static int _$2(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') {
                ++n;
                continue;
            }
            if (c <= '\u07ff') {
                n += 2;
                continue;
            }
            n += 3;
        }
        return n;
    }

    private static byte[] _$1(String string) {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n = cArray[i];
            if (n <= 127) {
                ++n3;
                continue;
            }
            if (n <= 2047) {
                n3 += 2;
                continue;
            }
            n3 += 3;
        }
        byte[] byArray = new byte[n3];
        n = 0;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i];
            if (c <= '\u007f') {
                byArray[n++] = (byte)c;
                continue;
            }
            if (c <= '\u07ff') {
                byArray[n++] = (byte)(c >> 6 | 0xC0);
                byArray[n++] = (byte)(c & 0x3F | 0x80);
                continue;
            }
            byArray[n++] = (byte)(c >> 12 | 0xE0);
            byArray[n++] = (byte)(c >> 6 & 0x3F | 0x80);
            byArray[n++] = (byte)(c & 0x3F | 0x80);
        }
        return byArray;
    }
}

