/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mjsoft.framework.util;

import cn.com.mjsoft.framework.util.MathUtil;
import cn.com.mjsoft.framework.util.StringUtil;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateAndTimeUtil {
    public static final String DEAULT_FORMAT_MD = "MM-dd";
    public static final String DEAULT_FORMAT_YMD = "yyyy-MM-dd";
    public static final String DEAULT_FORMAT_HMS = "HH:mm:ss";
    public static final String DEAULT_FORMAT_YMD_HMS = "yyyy-MM-dd HH:mm:ss";
    public static final String DEAULT_FORMAT_NANO = "yyyy-MM-dd HH:mm:ss:SSS";

    public static String getFormatDate(long l, String string) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        return new SimpleDateFormat(string).format(calendar.getTime());
    }

    public static String getCunrrentDayAndTime(String string) {
        return new SimpleDateFormat(string).format(new Date());
    }

    public static String getCunrrentDayAndTime(SimpleDateFormat simpleDateFormat) {
        return simpleDateFormat.format(new Date());
    }

    public static boolean isToday(Timestamp timestamp) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DEAULT_FORMAT_YMD);
        return simpleDateFormat.format(timestamp).equals(simpleDateFormat.format(new Date()));
    }

    public static Timestamp getTodayTimestamp() {
        String string = DateAndTimeUtil.getCunrrentDayAndTime(DEAULT_FORMAT_YMD);
        Timestamp timestamp = null;
        try {
            timestamp = new Timestamp(new SimpleDateFormat(DEAULT_FORMAT_YMD).parse(string).getTime());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return timestamp;
    }

    public static Timestamp getTodayTimestampDayAndTime() {
        String string = DateAndTimeUtil.getCunrrentDayAndTime(DEAULT_FORMAT_YMD_HMS);
        Timestamp timestamp = null;
        try {
            timestamp = new Timestamp(new SimpleDateFormat(DEAULT_FORMAT_YMD_HMS).parse(string).getTime());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return timestamp;
    }

    public static String formatTimestamp(Timestamp timestamp, String string) {
        if (null == timestamp) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(timestamp);
    }

    public static int getDayInterval(String string, String string2, String string3) {
        long l;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
        try {
            Date date = simpleDateFormat.parse(string);
            Date date2 = simpleDateFormat.parse(string2);
            l = (date.getTime() - date2.getTime()) / 86400000L;
        }
        catch (ParseException parseException) {
            l = 0L;
        }
        return (int)l;
    }

    public static int getHourInterval(String string, String string2, String string3) {
        long l;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
        try {
            Date date = simpleDateFormat.parse(string);
            Date date2 = simpleDateFormat.parse(string2);
            l = (date.getTime() - date2.getTime()) / 3600000L;
        }
        catch (ParseException parseException) {
            l = 0L;
        }
        return (int)l;
    }

    public static int getSecInterval(String string, String string2, String string3) {
        long l;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
        try {
            Date date = simpleDateFormat.parse(string);
            Date date2 = simpleDateFormat.parse(string2);
            l = (date.getTime() - date2.getTime()) / 60000L;
        }
        catch (ParseException parseException) {
            l = 0L;
        }
        return (int)l;
    }

    public static int getSecInterval(Date date, Date date2) {
        long l = 0L;
        if (date == null || date2 == null) {
            return 0;
        }
        l = (date.getTime() - date2.getTime()) / 60000L;
        return (int)l;
    }

    public static Timestamp getNotNullTimestamp(String string, String string2) {
        Timestamp timestamp;
        if (StringUtil.isStringNull(string)) {
            timestamp = new Timestamp(System.currentTimeMillis());
        } else {
            try {
                timestamp = new Timestamp(new SimpleDateFormat(string2).parse(string).getTime());
            }
            catch (ParseException parseException) {
                timestamp = new Timestamp(System.currentTimeMillis());
            }
        }
        return timestamp;
    }

    public static Timestamp getTimestamp(String string, String string2) {
        Timestamp timestamp;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        if (StringUtil.isStringNull(string)) {
            timestamp = null;
        } else {
            try {
                timestamp = new Timestamp(simpleDateFormat.parse(string).getTime());
            }
            catch (ParseException parseException) {
                timestamp = null;
            }
        }
        return timestamp;
    }

    public static String getTheDayByNum(String string, int n) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DEAULT_FORMAT_YMD);
        try {
            calendar.setTime(new SimpleDateFormat(DEAULT_FORMAT_YMD).parse(string));
            calendar.add(5, n);
            String string2 = simpleDateFormat.format(calendar.getTime());
            return StringUtil.subString(string2, 0, 10);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return string;
        }
    }

    public static Date getTheHourByNum(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(10, n);
        return calendar.getTime();
    }

    public static String getTheHourByNum(Date date, int n, String string) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(10, n);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(calendar.getTime());
    }

    public static int getMondayPlus() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(7);
        if (n == 1) {
            return -6;
        }
        return 2 - n;
    }

    public static Calendar getCurrentMonday() {
        int n = DateAndTimeUtil.getMondayPlus();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, n);
        return calendar;
    }

    public static String getPreviousSunday() {
        int n = DateAndTimeUtil.getMondayPlus();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.add(5, n + 6);
        Date date = gregorianCalendar.getTime();
        DateFormat dateFormat = DateFormat.getDateInstance();
        String string = dateFormat.format(date);
        return string;
    }

    public static long startClock() {
        return System.currentTimeMillis();
    }

    public static long currentClock(long l) {
        return System.currentTimeMillis() - l;
    }

    public static void main(String[] stringArray) {
        System.out.println("sss" + DateAndTimeUtil.getCurrentMonday());
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        System.out.println(calendar.compareTo(calendar2));
        int n = calendar.get(5);
        System.out.println(n);
        if (n + 1 < 15) {
            calendar.add(5, 1);
            calendar2.set(5, 15);
        } else {
            calendar2.add(2, 1);
            calendar2.set(5, 15);
        }
        String string = DateAndTimeUtil.getFormatDate(calendar2.getTimeInMillis(), DEAULT_FORMAT_YMD);
        String string2 = DateAndTimeUtil.getFormatDate(calendar.getTimeInMillis(), DEAULT_FORMAT_YMD);
        System.out.println(string + " : " + string2);
        System.out.println(DateAndTimeUtil.getDayInterval("2014-09-12", "2014-03-14", DEAULT_FORMAT_YMD));
        double d = MathUtil.div(3000.0, 365.0, 2);
    }
}

