/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mjsoft.cms.stat.dao;

import cn.com.mjsoft.cms.stat.bean.StatContentVisitOrCommentDWMCount;
import cn.com.mjsoft.cms.stat.bean.StatVisitorDayAnalysisBean;
import cn.com.mjsoft.cms.stat.bean.StatVisitorHourAnalysisBean;
import cn.com.mjsoft.cms.stat.dao.StatVisitInfoBeanTransform;
import cn.com.mjsoft.cms.stat.dao.StatVisitorHourAnalysisBeanTransform;
import cn.com.mjsoft.cms.stat.dao.vo.StatVisitInfo;
import cn.com.mjsoft.cms.stat.dao.vo.StatVisitorDayAnalysis;
import cn.com.mjsoft.cms.stat.dao.vo.StatVisitorHourAnalysis;
import cn.com.mjsoft.framework.persistence.core.PersistenceEngine;
import cn.com.mjsoft.framework.persistence.core.support.UpdateState;
import cn.com.mjsoft.framework.util.MathUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class StatDao {
    public PersistenceEngine pe;

    public void setPe(PersistenceEngine persistenceEngine) {
        this.pe = persistenceEngine;
    }

    public StatDao() {
    }

    public StatDao(PersistenceEngine persistenceEngine) {
        this.pe = persistenceEngine;
    }

    public UpdateState save(StatVisitInfo statVisitInfo) {
        return this.pe.save(statVisitInfo);
    }

    public List queryVisitInfoByHour(Long l, Integer n, Integer n2, Integer n3, Integer n4) {
        String string = "select * from stat_visit_info where siteId=? and visitYear=? and visitMonth=? and visitDay=? and visitHour=?";
        return this.pe.query(string, new Object[]{l, n, n2, n3, n4}, new StatVisitInfoBeanTransform());
    }

    public List queryVisitIpInfoByHour(Long l, Integer n, Integer n2, Integer n3, Integer n4) {
        String string = "select siteId, count(distinct ip) as ipCount from stat_visit_info where visitYear=? and visitMonth=? and visitDay=? and visitHour=? group by siteId";
        return this.pe.queryResultMap(string, new Object[]{n, n2, n3, n4});
    }

    public List queryVisitInfoIPCountByHour(Integer n, Integer n2, Integer n3, Integer n4) {
        String string = "select siteId, count(distinct ip) as ipCount from stat_visit_info where visitYear=? and visitMonth=? and visitDay=? and visitHour=? group by siteId";
        return this.pe.queryResultMap(string, new Object[]{n, n2, n3, n4});
    }

    public List queryVisitInfoUVCountByHour(Integer n, Integer n2, Integer n3, Integer n4) {
        String string = "select siteId, count(distinct uvId) as uvCount from stat_visit_info where visitYear=? and visitMonth=? and visitDay=? and visitHour=? group by siteId";
        return this.pe.queryResultMap(string, new Object[]{n, n2, n3, n4});
    }

    public List queryVisitInfoPVCountByHour(Integer n, Integer n2, Integer n3, Integer n4) {
        String string = "select siteId, count(*) as pvCount from stat_visit_info where visitYear=? and visitMonth=? and visitDay=? and visitHour=? group by siteId";
        return this.pe.queryResultMap(string, new Object[]{n, n2, n3, n4});
    }

    public List queryAllRefferHostByDay(Long l, Integer n, Integer n2, Integer n3) {
        String string = "select distinct refferHost from stat_visit_info where siteId=? and visitYear=? and visitMonth=? and visitDay=? and refferType!=0";
        return this.pe.querySingleCloumn(string, new Object[]{l, n, n2, n3}, String.class);
    }

    public Long queryRefferHostUvidCountByDay(Long l, Integer n, Integer n2, Integer n3, String string) {
        String string2 = "select count(distinct uvid) from stat_visit_info where siteId=? and visitYear=? and visitMonth=? and visitDay=? and refferHost=?";
        return (Long)this.pe.querySingleObject(string2, new Object[]{l, n, n2, n3, string}, Long.class);
    }

    public void saveSiteUrlUvCount(Long l, Long l2, String string) {
        String string2 = "insert into stat_visitor_src_s_analysis (siteId, uvCount, siteUrl) values (?,?,?)";
        this.pe.update(string2, new Object[]{l, l2, string});
    }

    public void updateSiteUrlUvCount(Long l, Long l2, String string) {
        String string2 = "update stat_visitor_src_s_analysis set uvCount=uvCount+? where siteId=? and siteUrl=?";
        this.pe.update(string2, new Object[]{l2, l, string});
    }

    public List queryAllSearchHostByDay(Long l, Integer n, Integer n2, Integer n3) {
        String string = "select distinct refferHost from stat_visit_info where siteId=? and visitYear=? and visitMonth=? and visitDay=? and refferType!=0 and refferType!=6";
        return this.pe.querySingleCloumn(string, new Object[]{l, n, n2, n3}, String.class);
    }

    public void saveSearchUvCount(Long l, Long l2, String string) {
        String string2 = "insert into stat_visitor_search_analysis (siteId, uvCount, searchName) values (?,?,?)";
        this.pe.update(string2, new Object[]{l, l2, string});
    }

    public void updateSearchUvCount(Long l, Long l2, String string) {
        String string2 = "update stat_visitor_search_analysis set uvCount=uvCount+? where siteId=? and searchName=?";
        this.pe.update(string2, new Object[]{l2, l, string});
    }

    public List queryAllSearchKeyByDay(Long l, Integer n, Integer n2, Integer n3) {
        String string = "select distinct refferKey from stat_visit_info where siteId=? and visitYear=? and visitMonth=? and visitDay=? and refferType!=0 and refferType!=6";
        return this.pe.querySingleCloumn(string, new Object[]{l, n, n2, n3}, String.class);
    }

    public Long queryRefferKeyUvidCountByDay(Long l, Integer n, Integer n2, Integer n3, String string) {
        String string2 = "select count(distinct uvid) from stat_visit_info where siteId=? and visitYear=? and visitMonth=? and visitDay=? and refferKey=?";
        return (Long)this.pe.querySingleObject(string2, new Object[]{l, n, n2, n3, string}, Long.class);
    }

    public void saveSearchKeyUvCount(Long l, Long l2, String string) {
        String string2 = "insert into stat_visitor_seh_key_analysis (siteId, uvCount, keyVal) values (?,?,?)";
        this.pe.update(string2, new Object[]{l, l2, string});
    }

    public void updateSearchKeyUvCount(Long l, Long l2, String string) {
        String string2 = "update stat_visitor_search_analysis set uvCount=uvCount+? where siteId=? and searchName=?";
        this.pe.update(string2, new Object[]{l2, l, string});
    }

    public StatVisitorHourAnalysisBean queryVisitorHourAnalysisBeanByDate(Long l, Integer n, Integer n2, Integer n3, Integer n4) {
        String string = "select * from stat_visitor_hour_analysis where siteId=? and visitYear=? and visitMonth=? and visitDay=? and visitHour=?";
        return (StatVisitorHourAnalysisBean)this.pe.querySingleRow(string, new Object[]{l, n, n2, n3, n4}, new StatVisitorHourAnalysisBeanTransform());
    }

    public void updateVisitorHourAnalysisBeanByDate(StatVisitorHourAnalysisBean statVisitorHourAnalysisBean) {
        String string = "update stat_visitor_hour_analysis set uvCount=?, ipCount=?, pvCount=? where visitYear=? and visitMonth=? and visitDay=? and visitHour=?";
        this.pe.update(string, new Object[]{statVisitorHourAnalysisBean.getUvCount(), statVisitorHourAnalysisBean.getIpCount(), statVisitorHourAnalysisBean.getPvCount(), statVisitorHourAnalysisBean.getVisitYear(), statVisitorHourAnalysisBean.getVisitMonth(), statVisitorHourAnalysisBean.getVisitDay(), statVisitorHourAnalysisBean.getVisitHour()});
    }

    public UpdateState save(StatVisitorHourAnalysis statVisitorHourAnalysis) {
        return this.pe.save(statVisitorHourAnalysis);
    }

    public UpdateState save(StatVisitorDayAnalysis statVisitorDayAnalysis) {
        return this.pe.save(statVisitorDayAnalysis);
    }

    public void deleteVisitorInfoByBeforeDate(Date date) {
        String string = "delete from stat_visit_info where visitTimeIn<=?";
        this.pe.update(string, new Object[]{date});
    }

    public void deleteVisitorInfoByDate(Integer n, Integer n2, Integer n3, Integer n4) {
        String string = "delete from stat_visit_info where visitYear=? and visitMonth=? and visitDay=? and visitHour=?";
        this.pe.update(string, new Object[]{n, n2, n3, n4});
    }

    public void deleteVisitorInfoAnalysisBySiteId(Long l) {
        String string = "delete from stat_visitor_hour_analysis where siteId=?";
        this.pe.update(string, new Object[]{l});
    }

    public void deleteStatDateHelperAllDate() {
        String string = "delete from stat_date_helper";
        this.pe.update(string);
    }

    public void saveNewDateForStatDateHelper(Date date, Date date2) {
        String string = "insert into stat_date_helper (prevDay, currentDay) values (?, ?)";
        this.pe.update(string, new Object[]{date, date2});
    }

    public Map queryStatDateHelper() {
        String string = "select * from stat_date_helper";
        return this.pe.querySingleResultMap(string);
    }

    public void updateAllContentDayClickCountToZero() {
        String string = "update content_main_info set clickDayCount=0 where clickDayCount>0";
        this.pe.update(string);
    }

    public void updateAllContentDayCommCountToZero() {
        String string = "update content_main_info set commDayCount=0 where commDayCount>0";
        this.pe.update(string);
    }

    public void updateAllContentWeekClickCountToZero() {
        String string = "update content_main_info set clickWeekCount=0 where clickWeekCount>0";
        this.pe.update(string);
    }

    public void updateAllContentWeekCommCountToZero() {
        String string = "update content_main_info set commWeekCount=0 where commWeekCount>0";
        this.pe.update(string);
    }

    public void updateAllContentMonthClickCountToZero() {
        String string = "update content_main_info set clickMonthCount=0 where clickMonthCount>0";
        this.pe.update(string);
    }

    public void updateAllContentMonthCommCountToZero() {
        String string = "update content_main_info set commMonthCount=0 where commMonthCount>0";
        this.pe.update(string);
    }

    public void updateContentAllClickCount(StatContentVisitOrCommentDWMCount statContentVisitOrCommentDWMCount, Long l) {
        String string = "update content_main_info set clickDayCount=clickDayCount+?, clickWeekCount=clickWeekCount+?, clickMonthCount=clickMonthCount+?, clickCount=clickCount+? where contentId=?";
        this.pe.update(string, new Object[]{statContentVisitOrCommentDWMCount.getDayCount(), statContentVisitOrCommentDWMCount.getWeekCount(), statContentVisitOrCommentDWMCount.getMonthCount(), statContentVisitOrCommentDWMCount.getNoLimitCount(), l});
    }

    public void updateContentAllCommentAddOneCount(Long l) {
        String string = "update content_main_info set commDayCount=commDayCount+1, commWeekCount=commWeekCount+1, commMonthCount=commMonthCount+1, commCount=commCount+1 where contentId=?";
        this.pe.update(string, new Object[]{l});
    }

    public void updateContentAllCommentMinusOneCount(Long l) {
        String string = "update content_main_info set commDayCount=commDayCount-1, commWeekCount=commWeekCount-1, commMonthCount=commMonthCount-1, commCount=commCount-1 where contentId=?";
        this.pe.update(string, new Object[]{l});
    }

    public Map queryDayVisitCountInfo(Long l, Integer n, Integer n2, Integer n3) {
        String string = "select count(distinct uvid) as uvc, count(visitorId) as pvc, count(distinct ip) as ivc from stat_visit_info where siteId=? and visitYear=? and visitMonth=? and visitDay=?";
        return this.pe.querySingleResultMap(string, new Object[]{l, n, n2, n3});
    }

    public StatVisitorDayAnalysisBean queryDayVisitBeanByDayAndSiteId(Long l, Integer n, Integer n2, Integer n3) {
        String string = "select * from stat_visitor_day_analysis where siteId=? and visitYear=? and visitMonth=? and visitDay=?";
        return (StatVisitorDayAnalysisBean)this.pe.querySingleBean(string, new Object[]{l, n, n2, n3}, StatVisitorDayAnalysisBean.class);
    }

    public List queryDayVisitBeanListByDayAndSiteId(Long l, Date date, Date date2) {
        String string = "select * from stat_visitor_day_analysis where siteId=? and vdt>=? and vdt<=? order by vdt asc";
        return this.pe.queryBeanList(string, new Object[]{l, date, date2}, StatVisitorDayAnalysisBean.class);
    }

    public List queryDayVisitSumUvListByDayAndSiteId(Long l, Date date, Date date2) {
        String string = "select sum(newUv) as newUv, sum(oldUv) as oldUv from stat_visitor_day_analysis where siteId=? and vdt>=? and vdt<=? order by vdt asc";
        return this.pe.queryResultMap(string, new Object[]{l, date, date2});
    }

    public Long queryUrlConutBySiteId(Long l, String string) {
        String string2 = "select count(*) from stat_visitor_url_analysis where siteId=? and url=?";
        return (Long)this.pe.querySingleObject(string2, new Object[]{l, string}, Long.class);
    }

    public Long queryAllAUrlConutBySiteId(Long l) {
        String string = "select sum(clickCount) from stat_visitor_url_analysis where siteId=?";
        Object object = this.pe.querySingleObject(string, new Object[]{l});
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).longValue();
        }
        if (object instanceof Double) {
            return ((Double)object).longValue();
        }
        return Long.parseLong(object.toString());
    }

    public void saveUrl(Long l, String string, Long l2) {
        String string2 = "insert into stat_visitor_url_analysis (siteId, url, clickCount) values (?,?,?)";
        this.pe.update(string2, new Object[]{l, string, l2});
    }

    public void updateUrlOnePv(Long l, String string) {
        String string2 = "update stat_visitor_url_analysis set clickCount=clickCount+1 where siteId=? and url=?";
        this.pe.update(string2, new Object[]{l, string});
    }

    public Long queryCommonConutBySiteId(Long l, String string, String string2, String string3) {
        String string4 = "select count(*) from " + string2 + " where siteId=? and " + string3 + "=?";
        return (Long)this.pe.querySingleObject(string4, new Object[]{l, string}, Long.class);
    }

    public Long queryAllCommonConutBySiteId(Long l, String string) {
        String string2 = "select sum(pvCount) from " + string + " where siteId=?";
        Object object = this.pe.querySingleObject(string2, new Object[]{l});
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).longValue();
        }
        if (object instanceof Double) {
            return ((Double)object).longValue();
        }
        return Long.parseLong(object.toString());
    }

    public void saveCommonInfo(Long l, String string, Long l2, String string2, String string3) {
        String string4 = "insert into " + string2 + " (siteId, " + string3 + ", pvCount) values (?,?,?)";
        this.pe.update(string4, new Object[]{l, string, l2});
    }

    public void updateCommonOnePv(Long l, String string, String string2, String string3) {
        String string4 = "update " + string2 + " set pvCount=pvCount+1 where siteId=? and " + string3 + "=?";
        this.pe.update(string4, new Object[]{l, string});
    }

    public void updateCommonPv(Long l, String string, Integer n, String string2, String string3) {
        String string4 = "update " + string2 + " set pvCount=pvCount+\uff1f where siteId=? and " + string3 + "=?";
        this.pe.update(string4, new Object[]{n, l, string});
    }

    public Long queryAreaConutBySiteId(Long l, String string) {
        String string2 = "select count(*) from stat_visitor_area_analysis where siteId=? and area=?";
        return (Long)this.pe.querySingleObject(string2, new Object[]{l, string}, Long.class);
    }

    public Long queryAllAreaConutBySiteId(Long l) {
        String string = "select sum(pvCount) from stat_visitor_area_analysis where siteId=?";
        Object object = this.pe.querySingleObject(string, new Object[]{l});
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).longValue();
        }
        if (object instanceof Double) {
            return ((Double)object).longValue();
        }
        return Long.parseLong(object.toString());
    }

    public void saveArea(Long l, String string, Long l2) {
        String string2 = "insert into stat_visitor_area_analysis (siteId, area, pvCount) values (?,?,?)";
        this.pe.update(string2, new Object[]{l, string, l2});
    }

    public void updateAreaOnePv(Long l, String string) {
        String string2 = "update stat_visitor_area_analysis set pvCount=pvCount+1 where siteId=? and area=?";
        this.pe.update(string2, new Object[]{l, string});
    }

    public void updateDayVisitBeanByDayAndSiteId(Integer n, Integer n2, Integer n3, Integer n4, Integer n5, Long l, Integer n6, Integer n7, Integer n8) {
        String string = "update stat_visitor_day_analysis set uvCount=?, ipCount=?, pvCount=?, newUv=?, oldUv=? where siteId=? and visitYear=? and visitMonth=? and visitDay=?";
        this.pe.update(string, new Object[]{n, n2, n3, n4, n5, l, n6, n7, n8});
    }

    public List queryUvidInfoByDay(Long l, Integer n, Integer n2, Integer n3) {
        String string = "select distinct(uvId) from stat_visit_info where siteId=? and visitYear=? and visitMonth=? and visitDay=?";
        return this.pe.querySingleCloumn(string, new Object[]{l, n, n2, n3}, String.class);
    }

    public List queryUvidInfoByHour(Long l, Integer n, Integer n2, Integer n3, Integer n4) {
        String string = "select distinct(uvId) from stat_visit_info where siteId=? and visitYear=? and visitMonth=? and visitDay=? and visitHour=?";
        return this.pe.querySingleCloumn(string, new Object[]{l, n, n2, n3, n4}, String.class);
    }

    public Long queryNewUvidCountByHour(Long l, Integer n, Integer n2, Integer n3, Integer n4) {
        String string = "select count(distinct uvid) as newUv from stat_visit_info where siteId=? and visitYear=? and visitMonth=? and visitDay=? and visitHour=? and uvid not in (select uvid from stat_uvid_trace)";
        return (Long)this.pe.querySingleObject(string, new Object[]{l, n, n2, n3, n4}, Long.class);
    }

    public Long queryOldUvidCountByHour(Long l, Integer n, Integer n2, Integer n3, Integer n4) {
        String string = "select count(distinct uvid) as oldUv from stat_visit_info where siteId=? and visitYear=? and visitMonth=? and visitDay=? and visitHour=? and uvid in (select uvid from stat_uvid_trace)";
        return (Long)this.pe.querySingleObject(string, new Object[]{l, n, n2, n3, n4}, Long.class);
    }

    public Long queryNewUvidCountByDay(Long l, Integer n, Integer n2, Integer n3) {
        String string = "select count(distinct uvid) as newUv from stat_visit_info where siteId=? and visitYear=? and visitMonth=? and visitDay=? and uvid not in (select uvid from stat_uvid_trace)";
        return (Long)this.pe.querySingleObject(string, new Object[]{l, n, n2, n3}, Long.class);
    }

    public Long queryOldUvidCountByDay(Long l, Integer n, Integer n2, Integer n3) {
        String string = "select count(distinct uvid) as oldUv from stat_visit_info where siteId=? and visitYear=? and visitMonth=? and visitDay=? and uvid in (select uvid from stat_uvid_trace)";
        return (Long)this.pe.querySingleObject(string, new Object[]{l, n, n2, n3}, Long.class);
    }

    public void saveNewUvidByDay(Long l, Integer n, Integer n2, Integer n3) {
        String string = "insert into stat_uvid_trace (uvid) select distinct uvid as newUv from stat_visit_info where siteId=? and visitYear=? and visitMonth=? and visitDay=? and uvid not in (select uvid from stat_uvid_trace)";
        this.pe.update(string, new Object[]{l, n, n2, n3});
    }

    public Long queryUvidTarceExist(String string) {
        String string2 = "select count(uvid) from stat_uvid_trace where uvid=?";
        return (Long)this.pe.querySingleObject(string2, new Object[]{string}, Long.class);
    }

    public void saveUvidTarce(String string) {
        String string2 = "insert into stat_uvid_trace (uvid) values (?)";
        this.pe.update(string2, new Object[]{string});
    }

    public Integer queryNewUvidDayCountNotUse(Long l, Integer n, Integer n2, Integer n3) {
        String string = "select sum(newUv) from stat_visitor_hour_analysis where siteId=? and visitYear=? and visitMonth=? and visitDay=?";
        Object object = this.pe.querySingleObject(string, new Object[]{l, n, n2, n3});
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).intValue();
        }
        if (object instanceof Double) {
            return ((Double)object).intValue();
        }
        return Integer.parseInt(object.toString());
    }

    public Integer queryOldUvidDayCountNotUse(Long l, Integer n, Integer n2, Integer n3) {
        String string = "select sum(oldUv) from stat_visitor_hour_analysis where siteId=? and visitYear=? and visitMonth=? and visitDay=?";
        Object object = this.pe.querySingleObject(string, new Object[]{l, n, n2, n3});
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).intValue();
        }
        if (object instanceof Double) {
            return ((Double)object).intValue();
        }
        return Integer.parseInt(object.toString());
    }

    public Map queryUvidInfoFirstVisitGateUrlByDay(Long l, String string, Integer n, Integer n2, Integer n3) {
        String string2 = "select * from stat_visit_info where siteId=? and uvId=? and visitYear=? and visitMonth=? and visitDay=? order by visitTimeIn asc limit 1";
        return this.pe.querySingleResultMap(string2, new Object[]{l, string, n, n2, n3});
    }

    public Map queryUvidInfoLastVisitExitUrlByDay(Long l, String string, Integer n, Integer n2, Integer n3) {
        String string2 = "select * from stat_visit_info where siteId=? and uvId=? and visitYear=? and visitMonth=? and visitDay=? order by visitTimeIn desc limit 1";
        return this.pe.querySingleResultMap(string2, new Object[]{l, string, n, n2, n3});
    }

    public Long queryUvidInfoFirstVisitGateExist(Long l, Integer n, Integer n2, Integer n3, String string) {
        String string2 = "select count(*) from stat_visitor_day_gate_analysis where siteId=? and visitYear=? and visitMonth=? and visitDay=? and url=?";
        return (Long)this.pe.querySingleObject(string2, new Object[]{l, n, n2, n3, string});
    }

    public Long queryUvidInfoExitVisitGateExist(Long l, Integer n, Integer n2, Integer n3, String string) {
        String string2 = "select count(*) from stat_visitor_day_exit_analysis where siteId=? and visitYear=? and visitMonth=? and visitDay=? and url=?";
        return (Long)this.pe.querySingleObject(string2, new Object[]{l, n, n2, n3, string});
    }

    public void saveUvidVisitGate(Long l, Integer n, Integer n2, Integer n3, String string, Integer n4) {
        String string2 = "insert into stat_visitor_day_gate_analysis (siteId, visitYear, visitMonth, visitDay, url, count) values (?,?,?,?,?,?)";
        this.pe.update(string2, new Object[]{l, n, n2, n3, string, n4});
    }

    public void updateUvidVisitGate(Long l, Integer n, Integer n2, Integer n3, String string) {
        String string2 = "update stat_visitor_day_gate_analysis set count=count+1 where siteId=? and visitYear=? and visitMonth=? and visitDay=? and url=?";
        this.pe.update(string2, new Object[]{l, n, n2, n3, string});
    }

    public void updateUvidVisitExit(Long l, Integer n, Integer n2, Integer n3, String string) {
        String string2 = "update stat_visitor_day_exit_analysis set count=count+1 where siteId=? and visitYear=? and visitMonth=? and visitDay=? and url=?";
        this.pe.update(string2, new Object[]{l, n, n2, n3, string});
    }

    public void saveUvidVisitExit(Long l, Integer n, Integer n2, Integer n3, String string, Integer n4) {
        String string2 = "insert into stat_visitor_day_exit_analysis (siteId, visitYear, visitMonth, visitDay, url, count) values (?,?,?,?,?,?)";
        this.pe.update(string2, new Object[]{l, n, n2, n3, string, n4});
    }

    public Map querySiteAllPvUvIpCurrDayCount(Long l, Integer n, Integer n2, Integer n3) {
        String string = "select sum(pvCount) as pv, sum(uvCount) as uv, sum(ipCount) as ip, sum(newUv) as newUv, sum(oldUv) as oldUv from stat_visitor_day_analysis where siteId=? and visitYear=? and visitMonth=? and visitDay=?";
        return this.pe.querySingleResultMap(string, new Object[]{l, n, n2, n3});
    }

    public Map querySiteAllPvUvIpWeek7DayCount(Long l, Date date, Date date2) {
        String string = "select sum(pvCount) as pv, sum(uvCount) as uv, sum(ipCount) as ip, sum(newUv) as newUv, sum(oldUv) as oldUv from stat_visitor_day_analysis where siteId=? and vdt>=? and vdt<=?";
        return this.pe.querySingleResultMap(string, new Object[]{l, date, date2});
    }

    public Map querySiteAllPvUvIpMonthCount(Long l, Integer n, Integer n2) {
        String string = "select sum(pvCount) as pv, sum(uvCount) as uv, sum(ipCount) as ip, sum(newUv) as newUv, sum(oldUv) as oldUv from stat_visitor_day_analysis where siteId=? and visitYear=? and visitMonth=?";
        return this.pe.querySingleResultMap(string, new Object[]{l, n, n2});
    }

    public Map querySiteAllPvUvIpCount(Long l) {
        String string = "select sum(pvCount) as pv, sum(uvCount) as uv, sum(ipCount) as ip, sum(newUv) as newUv, sum(oldUv) as oldUv from stat_visitor_day_analysis where siteId=?";
        return this.pe.querySingleResultMap(string, new Object[]{l});
    }

    public Long querySiteAllDayCount(Long l) {
        String string = "select count(*) from stat_visitor_day_analysis where siteId=?";
        return (Long)this.pe.querySingleObject(string, new Object[]{l});
    }

    public Map querySiteMaxPvCount(Long l) {
        String string = "select pvCount, vdt from stat_visitor_day_analysis where siteId=? order by pvCount desc limit 1";
        return this.pe.querySingleResultMap(string, new Object[]{l});
    }

    public Map querySiteMaxUvCount(Long l) {
        String string = "select uvCount, vdt from stat_visitor_day_analysis where siteId=? order by uvCount desc limit 1";
        return this.pe.querySingleResultMap(string, new Object[]{l});
    }

    public Map querySiteMaxIpCount(Long l) {
        String string = "select ipCount, vdt from stat_visitor_day_analysis where siteId=? order by ipCount desc limit 1";
        return this.pe.querySingleResultMap(string, new Object[]{l});
    }

    public Long queryAllSiteHostPvCount() {
        String string = "select sum(pvCount) as pv from stat_visitor_host_analysis";
        return MathUtil.changeSUMResToLong(this.pe.querySingleObject(string));
    }

    public List querySiteAllHost() {
        String string = "select host from stat_visitor_host_analysis";
        return this.pe.querySingleCloumn(string);
    }

    public Long querySiteVisitorCount(Long l) {
        String string = "select count(*) from stat_visit_info where siteId=?";
        return (Long)this.pe.querySingleObject(string, new Object[]{l});
    }

    public Long querySiteVisitorContentCount(Long l) {
        String string = "select count(*) from stat_visitor_content_analysis vca inner join content_main_info ci on vca.contentId=ci.contentId where vca.siteId=?";
        return (Long)this.pe.querySingleObject(string, new Object[]{l});
    }

    public List querySiteVisitor(Long l, Long l2, Integer n) {
        String string = "select * from stat_visit_info where siteId=? order by visitorId desc limit ?,?";
        return this.pe.query(string, new Object[]{l, l2, n}, new StatVisitInfoBeanTransform());
    }

    public List querySiteVisitorContentPvInfo(Long l, Long l2, Integer n) {
        String string = "select * from stat_visitor_content_analysis vca inner join content_main_info ci on vca.contentId=ci.contentId where vca.siteId=? order by pvCount desc limit ?,?";
        return this.pe.queryResultMap(string, new Object[]{l, l2, n});
    }

    public Map querySiteVistorSumAllByHour(Long l, Integer n) {
        String string = "select sum(uvCount) as uvc, sum(pvCount) as pvc, sum(ipCount) as ivc from stat_visitor_hour_analysis where siteId=? and visitHour=?";
        return this.pe.querySingleResultMap(string, new Object[]{l, n});
    }

    public Map querySiteVistorSumUvByHour(Long l, Integer n) {
        String string = "select sum(newUv) as nuv, sum(oldUv) as ouv  from stat_visitor_hour_analysis where siteId=? and visitHour=?";
        return this.pe.querySingleResultMap(string, new Object[]{l, n});
    }

    public Map querySiteVistorHourSumUvBySite(Long l) {
        String string = "select sum(newUv) as nuv, sum(oldUv) as ouv  from stat_visitor_hour_analysis where siteId=?";
        return this.pe.querySingleResultMap(string, new Object[]{l});
    }

    public Map querySiteVistorDaySumUvBySite(Long l, Date date, Date date2) {
        String string = "select sum(newUv) as nuv, sum(oldUv) as ouv  from stat_visitor_day_analysis where siteId=? and vdt>=? and vdt<=?";
        return this.pe.querySingleResultMap(string, new Object[]{l, date, date2});
    }

    public List querySiteVistorAeraAllPvBySite(Long l) {
        String string = "select * from stat_visitor_area_analysis where siteId=? order by pvCount desc limit 100";
        return this.pe.queryResultMap(string, new Object[]{l});
    }

    public List querySiteVistorGateAllPvBySite(Long l) {
        String string = "select distinct ( url),sum(count) as count from stat_visitor_day_gate_analysis where siteId=? group by url order by count desc limit 100";
        return this.pe.queryResultMap(string, new Object[]{l});
    }

    public List querySiteVistorUrlAllPvBySite(Long l) {
        String string = "select * from stat_visitor_url_analysis where siteId=? order by clickCount desc limit 100";
        return this.pe.queryResultMap(string, new Object[]{l});
    }

    public List querySiteVistorClassAllPvBySite(Long l) {
        String string = "select * from stat_visitor_class_analysis where siteId=? order by pvCount desc";
        return this.pe.queryResultMap(string, new Object[]{l});
    }

    public List querySiteVistorExitAllPvBySite(Long l) {
        String string = "select * from stat_visitor_day_exit_analysis where siteId=? order by count desc limit 100";
        return this.pe.queryResultMap(string, new Object[]{l});
    }

    public Long querySiteVistorAeraSumPvBySite(Long l) {
        String string = "select sum(pvCount) as pvc from stat_visitor_area_analysis where siteId=?";
        return MathUtil.changeSUMResToLong(this.pe.querySingleObject(string, new Object[]{l}));
    }

    public Long querySiteVistorGateSumPvBySite(Long l) {
        String string = "select sum(count) as count from stat_visitor_day_gate_analysis where siteId=?";
        return MathUtil.changeSUMResToLong(this.pe.querySingleObject(string, new Object[]{l}));
    }

    public Long querySiteVistorUrlPvSumPvBySite(Long l) {
        String string = "select sum(clickCount) as count from stat_visitor_url_analysis where siteId=?";
        return MathUtil.changeSUMResToLong(this.pe.querySingleObject(string, new Object[]{l}));
    }

    public Long querySiteVistorClassPvSumPvBySite(Long l) {
        String string = "select sum(pvCount) as count from stat_visitor_class_analysis where siteId=?";
        return MathUtil.changeSUMResToLong(this.pe.querySingleObject(string, new Object[]{l}));
    }

    public Long querySiteVistorExitSumPvBySite(Long l) {
        String string = "select sum(count) as count from stat_visitor_day_exit_analysis where siteId=?";
        return MathUtil.changeSUMResToLong(this.pe.querySingleObject(string, new Object[]{l}));
    }

    public Long querySiteVistorReffHostSumUvBySite(Long l) {
        String string = "select sum(uvCount) as uvc from stat_visitor_src_s_analysis where siteId=?";
        return MathUtil.changeSUMResToLong(this.pe.querySingleObject(string, new Object[]{l}));
    }

    public Long querySiteVistorSearchHostSumUvBySite(Long l) {
        String string = "select sum(uvCount) as uvc from stat_visitor_search_analysis where siteId=?";
        return MathUtil.changeSUMResToLong(this.pe.querySingleObject(string, new Object[]{l}));
    }

    public Long querySiteVistorSearchKeySumUvBySite(Long l) {
        String string = "select sum(uvCount) as uvc from stat_visitor_seh_key_analysis where siteId=?";
        return MathUtil.changeSUMResToLong(this.pe.querySingleObject(string, new Object[]{l}));
    }

    public Long querySiteVistorOsSumPvBySite(Long l) {
        String string = "select sum(pvCount) as pvc from stat_visitor_os_analysis where siteId=?";
        return MathUtil.changeSUMResToLong(this.pe.querySingleObject(string, new Object[]{l}));
    }

    public Long querySiteVistorBrSumPvBySite(Long l) {
        String string = "select sum(pvCount) as pvc from stat_visitor_br_analysis where siteId=?";
        return MathUtil.changeSUMResToLong(this.pe.querySingleObject(string, new Object[]{l}));
    }

    public Long querySiteVistorLaSumPvBySite(Long l) {
        String string = "select sum(pvCount) as pvc from stat_visitor_la_analysis where siteId=?";
        return MathUtil.changeSUMResToLong(this.pe.querySingleObject(string, new Object[]{l}));
    }

    public Long querySiteVistorScSumPvBySite(Long l) {
        String string = "select sum(pvCount) as pvc from stat_visitor_resol_analysis where siteId=?";
        return MathUtil.changeSUMResToLong(this.pe.querySingleObject(string, new Object[]{l}));
    }

    public List querySiteVistorReffHostAllUvBySite(Long l) {
        String string = "select * from stat_visitor_src_s_analysis where siteId=?";
        return this.pe.queryResultMap(string, new Object[]{l});
    }

    public List querySiteVistorSearchHostAllUvBySite(Long l) {
        String string = "select * from stat_visitor_search_analysis where siteId=?";
        return this.pe.queryResultMap(string, new Object[]{l});
    }

    public List querySiteVistorSearchKeyAllUvBySite(Long l) {
        String string = "select * from stat_visitor_seh_key_analysis where siteId=? order by uvCount desc limit 100";
        return this.pe.queryResultMap(string, new Object[]{l});
    }

    public List querySiteVistorOsAllUvBySite(Long l) {
        String string = "select * from stat_visitor_os_analysis where siteId=? order by pvCount desc";
        return this.pe.queryResultMap(string, new Object[]{l});
    }

    public List querySiteVistorBrAllUvBySite(Long l) {
        String string = "select * from stat_visitor_br_analysis where siteId=? order by pvCount desc";
        return this.pe.queryResultMap(string, new Object[]{l});
    }

    public List querySiteVistorLaAllUvBySite(Long l) {
        String string = "select * from stat_visitor_la_analysis where siteId=?";
        return this.pe.queryResultMap(string, new Object[]{l});
    }

    public List querySiteVistorScAllUvBySite(Long l) {
        String string = "select * from stat_visitor_resol_analysis where siteId=? order by pvCount desc";
        return this.pe.queryResultMap(string, new Object[]{l});
    }

    public Long querySiteHostPvCount(String string) {
        String string2 = "select pvCount from stat_visitor_host_analysis where host=?";
        return (Long)this.pe.querySingleObject(string2, new Object[]{string});
    }

    public List queryBlackClientIpInfo() {
        String string = "select * from site_de_access";
        return this.pe.queryResultMap(string);
    }

    public List queryBlackClientIpStr() {
        String string = "select blackIp from site_de_access";
        return this.pe.querySingleCloumn(string, String.class);
    }

    public Long queryBlackClientIpCount(String string) {
        String string2 = "select count(blackIp) from site_de_access where blackIp=?";
        return (Long)this.pe.querySingleObject(string2, new Object[]{string}, Long.class);
    }

    public Map querySingleBlackClientIpInfo(String string) {
        String string2 = "select * from site_de_access where blackIp=?";
        return this.pe.querySingleResultMap(string2, new Object[]{string});
    }

    public void deleteBlackClientIp(String string) {
        String string2 = "delete from site_de_access where blackIp=?";
        this.pe.update(string2, new Object[]{string});
    }

    public void saveBlackIp(String string, Date date, Date date2, Integer n, Integer n2) {
        String string2 = "insert into site_de_access (blackIp, startDT, endDT, effectHour, isDeForever) values (?,?,?,?,?)";
        this.pe.update(string2, new Object[]{string, date, date2, n, n2});
    }

    public void saveBlackIpAccess(String string, String string2, String string3, String string4, Date date) {
        String string5 = "insert into site_de_access_trace (ip, targetUrl, dangerStr, queryStr, eventDT, eventDay) values (?,?,?,?,?,?)";
        this.pe.update(string5, new Object[]{string, string2, string3, string4, date, date});
    }

    public List queryBlackIpAccessInfoList(Long l, Integer n) {
        String string = "select *, (select count(*) from site_de_access where blackIp=ip) as ipCount from site_de_access_trace order by eventDT desc limit ?,?";
        return this.pe.queryResultMap(string, new Object[]{l, n});
    }

    public List queryBlackIpInfoList(Long l, Integer n) {
        String string = "select * from site_de_access order by infoId desc limit ?,?";
        return this.pe.queryResultMap(string, new Object[]{l, n});
    }

    public List queryBlackIpAccessInfoList(Timestamp timestamp, Long l, Integer n) {
        String string = "select *, (select count(*) from site_de_access where blackIp=ip) as ipCount from site_de_access_trace where eventDay=? order by eventDT desc limit ?,?";
        return this.pe.queryResultMap(string, new Object[]{timestamp, l, n});
    }

    public Map querySingleClientIpDangerAccessTrace(Long l) {
        String string = "select * from site_de_access_trace where trId=?";
        return this.pe.querySingleResultMap(string, new Object[]{l});
    }

    public Long queryClientIpDangerAccessTraceCount() {
        String string = "select count(*) from site_de_access_trace";
        return (Long)this.pe.querySingleObject(string, Long.class);
    }

    public Long queryClientIpDangerAccessTraceCount(Timestamp timestamp) {
        String string = "select count(*) from site_de_access_trace where eventDay=?";
        return (Long)this.pe.querySingleObject(string, new Object[]{timestamp}, Long.class);
    }

    public Long queryClientIpInfoCount() {
        String string = "select count(*) from site_de_access";
        return (Long)this.pe.querySingleObject(string, Long.class);
    }

    public List queryLiftBanBlackClientIpInfo(Timestamp timestamp) {
        String string = "select * from site_de_access where endDT<=? and isDeForever=0";
        return this.pe.queryResultMap(string, new Object[]{timestamp});
    }

    public void saveManagerLoginTrace(String string, String string2, Timestamp timestamp, Integer n) {
        String string3 = "insert into stat_manager_login_trace (ip, userName, eventDT, loginSuccess) values (?,?,?,?)";
        this.pe.update(string3, new Object[]{string, string2, timestamp, n});
    }

    public Long queryManagerLoginTraceCount() {
        String string = "select count(*) from stat_manager_login_trace";
        return (Long)this.pe.querySingleObject(string, Long.class);
    }

    public Long queryManagerLoginTraceCount(String string) {
        String string2 = "select count(*) from stat_manager_login_trace where userName=?";
        return (Long)this.pe.querySingleObject(string2, new Object[]{string}, Long.class);
    }

    public List queryManagerLoginTrace(Long l, Integer n) {
        String string = "select * from stat_manager_login_trace order by eventDT desc limit ?,?";
        return this.pe.queryResultMap(string, new Object[]{l, n});
    }

    public List queryManagerLoginTrace(String string, Long l, Integer n) {
        String string2 = "select * from stat_manager_login_trace where userName=? order by eventDT desc limit ?,?";
        return this.pe.queryResultMap(string2, new Object[]{string, l, n});
    }
}

