/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mjsoft.cms.interflow.service;

import cn.com.mjsoft.cms.common.Constant;
import cn.com.mjsoft.cms.common.ServiceUtil;
import cn.com.mjsoft.cms.common.datasource.MySqlDataSource;
import cn.com.mjsoft.cms.common.page.Page;
import cn.com.mjsoft.cms.interflow.bean.FriendSiteLinkBean;
import cn.com.mjsoft.cms.interflow.bean.SiteAnnounceBean;
import cn.com.mjsoft.cms.interflow.dao.InterflowDao;
import cn.com.mjsoft.cms.interflow.dao.vo.FriendSiteLink;
import cn.com.mjsoft.cms.interflow.dao.vo.SiteAnnounce;
import cn.com.mjsoft.cms.site.bean.SiteGroupBean;
import cn.com.mjsoft.framework.cache.Cache;
import cn.com.mjsoft.framework.cache.impl.LRUCache;
import cn.com.mjsoft.framework.persistence.core.PersistenceEngine;
import cn.com.mjsoft.framework.persistence.core.support.UpdateState;
import cn.com.mjsoft.framework.security.session.SecuritySessionKeeper;
import cn.com.mjsoft.framework.util.StringUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class InterflowService {
    private static Logger _$3 = Logger.getLogger(InterflowService.class);
    public static Cache interflowFlCache = new LRUCache(300);
    public static Cache interflowAnCache = new LRUCache(400);
    private static InterflowService _$2 = null;
    public PersistenceEngine mysqlEngine = new PersistenceEngine(new MySqlDataSource());
    private InterflowDao _$1 = new InterflowDao(this.mysqlEngine);

    private InterflowService() {
    }

    private static synchronized void _$1() {
        if (null == _$2) {
            _$2 = new InterflowService();
        }
    }

    public static InterflowService getInstance() {
        if (null == _$2) {
            InterflowService._$1();
        }
        return _$2;
    }

    public void addNewFriendSite(FriendSiteLink friendSiteLink) {
        String string = friendSiteLink.getSiteLogo();
        Long l = StringUtil.getLongValue(string, -1L);
        friendSiteLink.setSiteLogo(ServiceUtil.disposeSingleImageInfo(l));
        friendSiteLink.setOrderFlag(0);
        friendSiteLink.setSiteId(((SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo()).getSiteId());
        this._$1.saveFriendSiteLinkBean(friendSiteLink);
        this.clearFlCache();
    }

    public void editFriendSite(FriendSiteLink friendSiteLink, Map map) {
        String string = friendSiteLink.getSiteLogo();
        Long l = StringUtil.getLongValue(string, -1L);
        ServiceUtil.disposeOldImageInfo(l, "siteLogo", map);
        friendSiteLink.setSiteLogo(ServiceUtil.disposeSingleImageInfo(l));
        this._$1.updateFriendSiteLink(friendSiteLink);
        this.clearFlCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFriendSite(List list) {
        if (list == null) {
            return;
        }
        long l = -1L;
        try {
            this.mysqlEngine.beginTransaction();
            for (int i = 0; i < list.size(); ++i) {
                l = StringUtil.getLongValue((String)list.get(i), -1L);
                if (l < 1L) continue;
                this._$1.deleteFriendSiteLink(l);
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            this.clearFlCache();
        }
    }

    public void addNewFriendSiteType(Map map) {
        map.put("siteId", ((SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo()).getSiteId());
        this._$1.saveFriendSiteLinkType(map);
        this.clearFlCache();
    }

    public void editFriendSiteType(Map map) {
        this._$1.updateFriendSiteLinkType(map);
        this.clearFlCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFriendSiteType(List list) {
        if (list == null) {
            return;
        }
        long l = -1L;
        try {
            this.mysqlEngine.beginTransaction();
            for (int i = 0; i < list.size(); ++i) {
                l = list.get(i) instanceof String ? StringUtil.getLongValue((String)list.get(i), -1L) : (Long)list.get(i);
                if (l < 1L) continue;
                this._$1.deleteFriendSiteLinkType(l);
                this._$1.deleteFriendSiteLinkByType(l);
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            this.clearFlCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortFriendSite(Map map) {
        try {
            this.mysqlEngine.beginTransaction();
            SiteGroupBean siteGroupBean = (SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo();
            List list = this._$1.queryFriendSiteLinkBeanList(siteGroupBean.getSiteId(), Long.valueOf((String)map.get("typeId")));
            FriendSiteLinkBean friendSiteLinkBean = null;
            String string = null;
            for (int i = 0; i < list.size(); ++i) {
                friendSiteLinkBean = (FriendSiteLinkBean)list.get(i);
                string = (String)map.get("orderFlag-" + friendSiteLinkBean.getFlId());
                if (StringUtil.getIntValue(string, -1) <= 0) continue;
                this._$1.updateFriendSiteLinkOrder(Integer.valueOf(string), friendSiteLinkBean.getFlId());
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            this.clearFlCache();
        }
    }

    public Object getFriendSiteInfoTag(String string, String string2) {
        if (StringUtil.isStringNotNull(string)) {
            return this._$1.querySingleFriendSiteLinkBean(StringUtil.getLongValue(string, -1L));
        }
        SiteGroupBean siteGroupBean = (SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo();
        Long l = null;
        if (StringUtil.isStringNull(string2)) {
            List list = this._$1.queryFriendSiteLinkTypeList(siteGroupBean.getSiteId());
            if (!list.isEmpty()) {
                l = (Long)((Map)list.get(0)).get("ltId");
            }
        } else {
            l = StringUtil.getLongValue(string2, -1L);
        }
        return this._$1.queryFriendSiteLinkBeanList(siteGroupBean.getSiteId(), l);
    }

    public Object getFriendSiteTypeTag(String string) {
        if (StringUtil.isStringNotNull(string)) {
            return this._$1.querySingleFriendSiteLinkType(StringUtil.getLongValue(string, -1L));
        }
        SiteGroupBean siteGroupBean = (SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo();
        return this._$1.queryFriendSiteLinkTypeList(siteGroupBean.getSiteId());
    }

    public List retrieveSiteFriendLinkByType(Long l, String string) {
        String string2 = "retrieveSiteFriendLinkByType:" + l + "|" + string;
        List list = (List)interflowFlCache.getEntry(string2);
        if (list == null) {
            list = this._$1.queryFriendSiteLinkBeanList(l, string);
            interflowFlCache.putEntry(string2, list);
        }
        return list;
    }

    public void addNewSiteAnnounce(SiteAnnounce siteAnnounce) {
        Object object;
        if (siteAnnounce == null) {
            return;
        }
        siteAnnounce.setSiteId(((SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo()).getSiteId());
        if (siteAnnounce.getShowStartDate() == null) {
            object = Calendar.getInstance();
            ((Calendar)object).set(11, 0);
            ((Calendar)object).set(13, 0);
            ((Calendar)object).set(12, 0);
            siteAnnounce.setShowStartDate(((Calendar)object).getTime());
        }
        if (siteAnnounce.getShowEndDate() == null) {
            siteAnnounce.setShowEndDate(Constant.CONTENT.MAX_DATE);
        }
        if (((UpdateState)(object = this._$1.saveSiteAnnounce(siteAnnounce))).haveKey()) {
            this._$1.updateSiteAnnounceOrder(((UpdateState)object).getKey(), ((UpdateState)object).getKey());
        }
        this.clearAnCache();
    }

    public void editSiteAnnounce(SiteAnnounce siteAnnounce) {
        if (siteAnnounce == null) {
            return;
        }
        if (siteAnnounce.getShowStartDate() == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            siteAnnounce.setShowStartDate(calendar.getTime());
        }
        if (siteAnnounce.getShowEndDate() == null) {
            siteAnnounce.setShowEndDate(Constant.CONTENT.MAX_DATE);
        }
        this._$1.updateSiteAnnounce(siteAnnounce);
        this.clearAnCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortAnnounce(Map map) {
        try {
            this.mysqlEngine.beginTransaction();
            SiteGroupBean siteGroupBean = (SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo();
            List list = this._$1.querySiteAnnounceBeanList(siteGroupBean.getSiteId(), 0L, 100000);
            SiteAnnounceBean siteAnnounceBean = null;
            String string = null;
            for (int i = 0; i < list.size(); ++i) {
                siteAnnounceBean = (SiteAnnounceBean)list.get(i);
                string = (String)map.get("orderFlag-" + siteAnnounceBean.getAnId());
                if (StringUtil.getIntValue(string, -1) <= 0) continue;
                this._$1.updateSiteAnnounceOrder(siteAnnounceBean.getAnId(), Long.valueOf(string));
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            this.clearAnCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSiteAnnounceUseStatus(List list, Integer n) {
        if (list == null) {
            return;
        }
        long l = -1L;
        try {
            this.mysqlEngine.beginTransaction();
            for (int i = 0; i < list.size(); ++i) {
                l = StringUtil.getLongValue((String)list.get(i), -1L);
                if (l < 1L) continue;
                this._$1.updateSiteAnnounceUseStatus(l, n);
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            this.clearAnCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSiteAnnounce(List list) {
        if (list == null) {
            return;
        }
        long l = -1L;
        try {
            this.mysqlEngine.beginTransaction();
            for (int i = 0; i < list.size(); ++i) {
                l = StringUtil.getLongValue((String)list.get(i), -1L);
                if (l < 1L) continue;
                this._$1.deleteSiteAnnounce(l);
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            this.clearAnCache();
        }
    }

    public Long retrieveSiteAnnounceBeanCountByCurrDate(Long l, Date date) {
        return this._$1.querySiteAnnounceBeanCount(l, date);
    }

    public List retrieveSiteAnnounceBeanListByCurrDate(Long l, Date date, Long l2, Integer n) {
        String string = "retrieveSiteAnnounceBeanListByCurrDate:" + l + "|" + date + "|" + l2 + "|" + n;
        List list = (List)interflowAnCache.getEntry(string);
        if (list == null) {
            list = this._$1.querySiteAnnounceBeanList(l, date, l2, n);
            interflowAnCache.putEntry(string, list);
        }
        return list;
    }

    public Object getSiteAnnounceTag(String string, String string2, String string3) {
        if (StringUtil.isStringNotNull(string)) {
            return this._$1.querySingleSiteAnnounceBean(StringUtil.getLongValue(string, -1L));
        }
        int n = StringUtil.getIntValue(string2, 1);
        int n2 = StringUtil.getIntValue(string3, 15);
        Page page = null;
        SiteGroupBean siteGroupBean = (SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo();
        Long l = this._$1.querySiteAnnounceBeanCount(siteGroupBean.getSiteId());
        page = new Page(n2, l.intValue(), n);
        List list = this._$1.querySiteAnnounceBeanList(siteGroupBean.getSiteId(), page.getFirstResult(), n2);
        return new Object[]{list, page};
    }

    public void clearFlCache() {
        interflowFlCache.clearAllEntry();
    }

    public void clearAnCache() {
        interflowAnCache.clearAllEntry();
    }
}

