/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mjsoft.cms.common.datasource;

import cn.com.mjsoft.framework.persistence.core.PersistenceEngine;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolManager;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;

public class OracleDataSource
implements DataSource {
    public static final String CS_FILE_NAME = "config" + File.separator + "cs.properties";
    private static final String _$2 = "oracle";
    private static final String _$1 = "oracle.jdbc.driver.OracleDriver";

    public Connection getConnection() throws SQLException {
        ConnectionPool connectionPool = null;
        try {
            if (!ConnectionPoolManager.getInstance().isPoolExistsForBtf(_$2)) {
                OracleDataSource._$1();
            }
            connectionPool = ConnectionPoolManager.getInstance().getConnectionPoolForBtf(_$2);
            Connection connection = connectionPool.getConnectionForBtf();
            return connection;
        }
        catch (ProxoolException proxoolException) {
            throw new SQLException(proxoolException.toString());
        }
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException("getConnection( String username, String password )");
    }

    public PrintWriter getLogWriter() throws SQLException {
        throw new UnsupportedOperationException("getLogWriter");
    }

    public int getLoginTimeout() throws SQLException {
        throw new UnsupportedOperationException("setLogWriter");
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        throw new UnsupportedOperationException("setLogWriter");
    }

    public void setLoginTimeout(int n) throws SQLException {
        throw new UnsupportedOperationException("setLogWriter");
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return false;
    }

    public Object unwrap(Class clazz) throws SQLException {
        return null;
    }

    public static void main(String[] stringArray) throws Exception {
        OracleDataSource oracleDataSource = new OracleDataSource();
        String string = "select * from site_group where siteId=5";
        PersistenceEngine persistenceEngine = new PersistenceEngine(oracleDataSource);
        System.out.println("----->Start");
        List list = persistenceEngine.queryResultMap(string);
        System.out.println(list);
    }

    public static void test() throws Exception {
        OracleDataSource oracleDataSource = new OracleDataSource();
        PreparedStatement preparedStatement = oracleDataSource.getConnection().prepareStatement("select asdfrom \"cmsdev\".\"content_main_info\"");
        String string = "select csad from content_main_info";
        System.out.println("----->Start");
        PersistenceEngine persistenceEngine = new PersistenceEngine(oracleDataSource);
        List list = persistenceEngine.queryResultMap("select csad from content_main_info");
        System.out.println("----->end");
        System.out.println("----->" + list);
    }

    private static void _$1() {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(new File("E:/cs.properties")));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        String string = "jdbc:oracle:thin:@" + (String)properties.get("db_ip") + ":" + (String)properties.get("db_port") + ":" + (String)properties.get("db_name");
        System.out.println(properties.get("driverUrl"));
        try {
            Class.forName(_$1);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        Properties properties2 = new Properties();
        properties2.setProperty("proxool.maximum-connection-count", (String)properties.get("maximum-connection-count"));
        properties2.setProperty("proxool.minimum-connection-count", (String)properties.get("minimum-connection-count"));
        properties2.setProperty("proxool.simultaneous-build-throttle", (String)properties.get("simultaneous-build-throttle"));
        properties2.setProperty("proxool.house-keeping-test-sql", "select CURRENT_DATE from dual");
        properties2.setProperty("proxool.maximum-active-time", "9999000");
        properties2.setProperty("autoReconnect", "true");
        properties2.setProperty("proxool.house-keeping-sleep-time", "60000");
        properties2.setProperty("proxool.test-before-use", "true");
        properties2.setProperty("user", (String)properties.get("db_user"));
        properties2.setProperty("password", (String)properties.get("db_pw"));
        String string2 = "proxool.oracle:oracle.jdbc.driver.OracleDriver:" + string;
        try {
            ProxoolFacade.registerConnectionPool((String)string2, (Properties)properties2);
        }
        catch (ProxoolException proxoolException) {
            proxoolException.printStackTrace();
        }
    }

    public static void test1() throws Exception {
        OracleDataSource oracleDataSource = new OracleDataSource();
        PreparedStatement preparedStatement = oracleDataSource.getConnection().prepareStatement("select * from application");
        ResultSet resultSet = null;
        DatabaseMetaData databaseMetaData = oracleDataSource.getConnection().getMetaData();
        resultSet = databaseMetaData.getProcedures(null, "COMMON", null);
        String string = null;
        while (resultSet.next()) {
            System.out.println("################################################");
            System.out.println("PROCEDURE_SCHEM : [" + resultSet.getString("PROCEDURE_SCHEM") + "]");
            System.out.println("PROCEDURE_NAME : [" + resultSet.getString("PROCEDURE_NAME") + "]");
            string = resultSet.getString("PROCEDURE_NAME");
            System.out.println("################################################");
            ResultSet resultSet2 = null;
            resultSet2 = databaseMetaData.getProcedureColumns(null, null, string, "%");
            while (resultSet2.next()) {
                System.out.println("COLUMN_NAME  : " + resultSet2.getString("COLUMN_NAME"));
                System.out.println("TYPE_NAME  : " + resultSet2.getString("TYPE_NAME"));
                System.out.println("\n");
            }
            resultSet2.close();
        }
    }

    static {
        System.out.println("m2 : " + Runtime.getRuntime().freeMemory());
        OracleDataSource._$1();
        System.out.println("m3 : " + Runtime.getRuntime().freeMemory());
    }
}

