/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mjsoft.cms.comment.service;

import cn.com.mjsoft.cms.channel.bean.ContentClassBean;
import cn.com.mjsoft.cms.channel.service.ChannelService;
import cn.com.mjsoft.cms.comment.bean.CommentInfoBean;
import cn.com.mjsoft.cms.comment.bean.ContentMoodBean;
import cn.com.mjsoft.cms.comment.dao.CommentDao;
import cn.com.mjsoft.cms.comment.dao.vo.CommentInfo;
import cn.com.mjsoft.cms.common.Constant;
import cn.com.mjsoft.cms.common.ServiceUtil;
import cn.com.mjsoft.cms.common.datasource.MySqlDataSource;
import cn.com.mjsoft.cms.content.dao.ContentDao;
import cn.com.mjsoft.cms.content.service.ContentService;
import cn.com.mjsoft.cms.stat.dao.StatDao;
import cn.com.mjsoft.framework.cache.Cache;
import cn.com.mjsoft.framework.cache.impl.LRUCache;
import cn.com.mjsoft.framework.persistence.core.PersistenceEngine;
import cn.com.mjsoft.framework.persistence.core.support.UpdateState;
import cn.com.mjsoft.framework.security.session.SecuritySessionKeeper;
import cn.com.mjsoft.framework.util.StringUtil;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CommentService {
    private static Logger _$6 = Logger.getLogger(CommentService.class);
    public static final Integer ALL_MODE = 1;
    public static final Integer CLASS_MODE = 2;
    public static final Integer CONTENT_MODE = 3;
    public static Cache fastCommentCountCache = new LRUCache(2000);
    public static Cache fastCommentListCache = new LRUCache(3500);
    private static CommentService _$5 = null;
    private ChannelService _$4 = ChannelService.getInstance();
    public PersistenceEngine mysqlEngine = new PersistenceEngine(new MySqlDataSource());
    private CommentDao _$3 = new CommentDao(this.mysqlEngine);
    private ContentDao _$2 = new ContentDao(this.mysqlEngine);
    private StatDao _$1 = new StatDao(this.mysqlEngine);

    private CommentService() {
    }

    private static synchronized void _$1() {
        if (null == _$5) {
            _$5 = new CommentService();
        }
    }

    public static CommentService getInstance() {
        if (null == _$5) {
            CommentService._$1();
        }
        return _$5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addNewCommentAndInfo(CommentInfo commentInfo, Long l, String string, String string2) {
        if (commentInfo == null) {
            _$6.info((Object)"[addNewCommentAndInfo] \u4f20\u5165\u7684\u8bc4\u8bba\u5bf9\u8c61\u4e3a\u7a7a");
            return "-2";
        }
        if (commentInfo.getCommentText().length() < 10) {
            _$6.info((Object)"[addNewCommentAndInfo] \u8bc4\u8bba\u6587\u672c\u5c0f\u4e8e\u6700\u5c0f\u9650\u5ea6\u503c:10");
            return "-3";
        }
        try {
            Object object;
            Object object2;
            this.mysqlEngine.beginTransaction();
            ContentClassBean contentClassBean = this._$4.retrieveSingleClassBeanInfoByClassId(commentInfo.getClassId());
            if (Constant.COMMON.OFF.equals(contentClassBean.getOpenComment())) {
                String string3 = "-4";
                return string3;
            }
            if (Constant.COMMON.ON.equals(contentClassBean.getCommentCaptcha()) && (StringUtil.isStringNull(string) || !string.equalsIgnoreCase(string2))) {
                String string4 = "-1";
                return string4;
            }
            CommentInfoBean commentInfoBean = this._$3.querySingleCommentBeanByCommentId(l);
            if (commentInfoBean != null) {
                commentInfo.setReplyTrace(commentInfoBean.getCommentId() + "," + commentInfoBean.getReplyTrace());
                commentInfo.setReplyId(l);
            }
            commentInfo.setCommDT(new Date());
            if (Constant.COMMON.ON.equals(contentClassBean.getMustCommentCensor())) {
                commentInfo.setCensorState(Constant.WORKFLOW.CENSOR_STATUS_IN_FLOW);
            } else {
                commentInfo.setCensorState(Constant.WORKFLOW.CENSOR_STATUS_SUCCESS);
            }
            if (Constant.COMMON.OFF.equals(contentClassBean.getNotMemberComment()) && (object2 = (object = SecuritySessionKeeper.getSecuritySession()).getMember()) == null) {
                String string5 = "-5";
                return string5;
            }
            commentInfo.setCommentText(ServiceUtil.cleanBasicHtmlByWhiteRule(commentInfo.getCommentText()));
            commentInfo.setCommentText(this.replcaeContentTextSensitive(commentInfo.getCommentText()));
            object = this._$3.saveComment(commentInfo);
            if (((UpdateState)object).haveKey()) {
                this._$1.updateContentAllCommentAddOneCount(commentInfo.getContentId());
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
        ContentDao.releaseOrderFilterCountCache();
        ContentService.releaseFastListContentCache();
        CommentService.clearCommentCache();
        return "1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewDiggInfo(Long l, String string) {
        try {
            this.mysqlEngine.beginTransaction();
            if ("s".equals(string)) {
                this._$3.updateContentDiggSupportInfo(1L, l);
            } else if ("a".equals(string)) {
                this._$3.updateContentDiggAgainstInfo(1L, l);
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            ContentDao.releaseOrderFilterCountCache();
            ContentService.releaseFastListContentCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCommentDiggInfo(Long l, String string) {
        try {
            this.mysqlEngine.beginTransaction();
            if ("s".equals(string)) {
                this._$3.updateCommentDiggSupportInfo(1L, l);
            } else if ("a".equals(string)) {
                this._$3.updateCommentDiggAgainstInfo(1L, l);
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
        ContentDao.releaseOrderFilterCountCache();
        ContentService.releaseFastListContentCache();
        CommentService.clearCommentCache();
    }

    public String replcaeContentTextSensitive(String string) {
        List list = this._$2.querySensitiveWord();
        String string2 = null;
        String string3 = null;
        Map map = null;
        for (int i = 0; i < list.size(); ++i) {
            map = (Map)list.get(i);
            string2 = (String)map.get("sensitiveStr");
            string3 = (String)map.get("replaceStr");
            if (!StringUtil.isStringNotNull(string2)) continue;
            String[] stringArray = StringUtil.split(string2, ",");
            String string4 = null;
            for (int j = 0; j < stringArray.length; ++j) {
                string4 = stringArray[j];
                string = StringUtil.replaceString(string, string4, string3, false, false);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewMoodInfo(Long l, Integer n) {
        if (n < 1 || n > 10) {
            return;
        }
        try {
            this.mysqlEngine.beginTransaction();
            this._$3.updateContentMoodInfo(n, 1L, l);
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            ContentDao.releaseOrderFilterCountCache();
            ContentService.releaseFastListContentCache();
        }
    }

    public Long retrieveCommentCount(Long l, Integer n, Long l2, Integer n2) {
        String string = "retrieveCommentCount:" + l + "|" + n + "|" + l2 + "|" + n2;
        Long l3 = (Long)fastCommentCountCache.getEntry(string);
        if (l3 == null) {
            if (n2 < 0) {
                if (ALL_MODE.equals(n)) {
                    l3 = this._$3.queryCommentCount(l);
                } else if (CLASS_MODE.equals(n)) {
                    l3 = this._$3.queryCommentCountByClassId(l2);
                } else if (CONTENT_MODE.equals(n)) {
                    l3 = this._$3.queryCommentCountByContentId(l2);
                }
            } else if (ALL_MODE.equals(n)) {
                l3 = this._$3.queryCommentCount(l, n2);
            } else if (CLASS_MODE.equals(n)) {
                l3 = this._$3.queryCommentCountByClassId(l2, n2);
            } else if (CONTENT_MODE.equals(n)) {
                l3 = this._$3.queryCommentCountByContentId(l2, n2);
            }
            fastCommentCountCache.putEntry(string, l3);
        }
        return l3;
    }

    public Long retrieveCommentCountByUserName(Long l, String string) {
        return this._$3.queryCommentCountByUserName(l, string);
    }

    public List retrieveCommentBeanListByContentId(Long l, Long l2, Integer n, Integer n2) {
        String string = "retrieveCommentBeanListByContentId:" + l + "|" + l2 + "|" + n + "|" + n2;
        List list = (List)fastCommentListCache.getEntry(string);
        if (list == null) {
            list = n2 < 0 ? this._$3.queryCommentBeanListByContentId(l, l2, n) : this._$3.queryCommentBeanListByContentId(l, l2, n, n2);
            fastCommentListCache.putEntry(string, list);
        }
        return list;
    }

    public List retrieveCommentBeanListByClassId(Long l, Long l2, Integer n, Integer n2) {
        if (n2 < 0) {
            return this._$3.queryCommentBeanListByClassId(l, l2, n);
        }
        return this._$3.queryCommentBeanListByClassId(l, l2, n, n2);
    }

    public CommentInfoBean retrieveSingeleCommentBean(Long l) {
        return this._$3.querySingeleCommentBean(l);
    }

    public List retrieveAllCommentBeanList(Long l, Long l2, Integer n, Integer n2) {
        if (n2 < 0) {
            return this._$3.queryAllCommentBeanListBySiteId(l, l2, n);
        }
        return this._$3.queryAllCommentBeanListBySiteId(l, l2, n, n2);
    }

    public List retrieveAllCommentBeanListByUserName(Long l, String string, Long l2, Integer n) {
        return this._$3.queryAllCommentBeanListBySiteIdAndUserName(l, string, l2, n);
    }

    public List retrieveCommentBeanListByCommentIds(String string) {
        if (StringUtil.isStringNull(string)) {
            return Collections.EMPTY_LIST;
        }
        String[] stringArray = StringUtil.split(string, ",");
        if (stringArray == null || stringArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i + 1 == stringArray.length) {
                stringBuffer.append(stringArray[i]);
                continue;
            }
            stringBuffer.append(stringArray[i] + ", ");
        }
        return this._$3.queryCommentBeanListByIdInFlag(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List retrieveCommentBeanListByParentId(Long l) {
        List list = null;
        try {
            this.mysqlEngine.beginTransaction();
            list = this._$3.queryCommentBeanListByParentId(l);
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCommentAllInfoByIds(Long[] longArray, List list) {
        if (longArray == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < longArray.length; ++i) {
            stringBuffer.append(longArray[i]);
            if (i + 1 == longArray.length) continue;
            stringBuffer.append(", ");
        }
        try {
            this.mysqlEngine.beginTransaction();
            CommentInfoBean commentInfoBean = null;
            for (int i = 0; i < longArray.length; ++i) {
                commentInfoBean = this._$3.querySingeleCommentBean(longArray[i]);
                if (commentInfoBean.getMemberId() > 0L) {
                    list.add(commentInfoBean.getMemberId());
                }
                this._$1.updateContentAllCommentMinusOneCount(commentInfoBean.getContentId());
            }
            this._$3.deleteCommentAllInfoByIdFlag(stringBuffer.toString());
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
        ContentDao.releaseOrderFilterCountCache();
        ContentService.releaseFastListContentCache();
        CommentService.clearCommentCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void censorComment(Long[] longArray, Integer n) {
        try {
            this.mysqlEngine.beginTransaction();
            if (!(Constant.WORKFLOW.CENSOR_STATUS_DRAFT.equals(n) || Constant.WORKFLOW.CENSOR_STATUS_SUCCESS.equals(n) || Constant.WORKFLOW.CENSOR_STATUS_RETURN.equals(n))) {
                return;
            }
            if (longArray.length == 1) {
                this._$3.updateCommentBeanCensorState(longArray[0], n);
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < longArray.length; ++i) {
                    stringBuffer.append(longArray[i]);
                    if (i + 1 == longArray.length) continue;
                    stringBuffer.append(", ");
                }
                this._$3.updateCommentBeanCensorStateByIdFlag(stringBuffer.toString(), n);
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            CommentService.clearCommentCache();
        }
    }

    public static void clearCommentCache() {
        fastCommentCountCache.clearAllEntry();
        fastCommentListCache.clearAllEntry();
    }

    private Long _$1(Integer n, ContentMoodBean contentMoodBean) {
        if (n == 1) {
            return contentMoodBean.getMoodT1count();
        }
        if (n == 2) {
            return contentMoodBean.getMoodT2count();
        }
        if (n == 3) {
            return contentMoodBean.getMoodT3count();
        }
        if (n == 4) {
            return contentMoodBean.getMoodT4count();
        }
        if (n == 5) {
            return contentMoodBean.getMoodT5count();
        }
        if (n == 6) {
            return contentMoodBean.getMoodT6count();
        }
        if (n == 7) {
            return contentMoodBean.getMoodT7count();
        }
        if (n == 8) {
            return contentMoodBean.getMoodT8count();
        }
        if (n == 9) {
            return contentMoodBean.getMoodT9count();
        }
        if (n == 10) {
            return contentMoodBean.getMoodT10count();
        }
        return -1L;
    }
}

