/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.xmp;

import java.io.File;
import java.io.FileFilter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.lib.io.filefilter.FilenameIgnoreCaseFileFilter;
import org.openide.util.Lookup;

public final class XmpSidecarFileResolverImpl
implements XmpSidecarFileResolver {
    private boolean useLongXmpSidecarFilenames;

    public XmpSidecarFileResolverImpl() {
        this.setLongSidecarFilename();
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLongSidecarFilename() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        if (prefs != null && prefs.containsKey("XmpPreferences.UsingLongSidecarFilename")) {
            XmpSidecarFileResolverImpl xmpSidecarFileResolverImpl = this;
            synchronized (xmpSidecarFileResolverImpl) {
                this.useLongXmpSidecarFilenames = prefs.getBoolean("XmpPreferences.UsingLongSidecarFilename");
            }
        }
    }

    public synchronized File suggestXmpSidecarFile(File contentFile) {
        if (contentFile == null) {
            throw new NullPointerException("contentFile == null");
        }
        if (this.useLongXmpSidecarFilenames) {
            return this.suggestLongSidecarFile(contentFile);
        }
        return this.suggestDefaultSidecarFile(contentFile);
    }

    public File getXmpSidecarFileOrNullIfNotExists(File contentFile) {
        if (contentFile == null) {
            throw new NullPointerException("contentFile == null");
        }
        return this.useLongXmpSidecarFilenames ? this.getLongXmpSidecarFileOrNullIfNotExists(contentFile) : this.getDefaultXmpSidecarFileOrNullIfNotExists(contentFile);
    }

    public boolean hasXmpSidecarFile(File contentFile) {
        if (contentFile == null) {
            throw new NullPointerException("contentFile == null");
        }
        File sidecarFile = this.getXmpSidecarFileOrNullIfNotExists(contentFile);
        return sidecarFile != null;
    }

    public boolean isUseLongXmpSidecarFilenames() {
        return this.useLongXmpSidecarFilenames;
    }

    public File suggestDefaultSidecarFile(File contentFile) {
        if (contentFile == null) {
            throw new NullPointerException("contentFile == null");
        }
        String absolutePath = contentFile.getAbsolutePath();
        int indexExtension = absolutePath.lastIndexOf(46);
        File suggestedSidecarFile = indexExtension > 0 ? new File(absolutePath.substring(0, indexExtension + 1) + "xmp") : new File(absolutePath + ".xmp");
        File foundSidecarFile = this.findSidecarFile(suggestedSidecarFile);
        return foundSidecarFile == null ? suggestedSidecarFile : foundSidecarFile;
    }

    public File suggestLongSidecarFile(File contentFile) {
        if (contentFile == null) {
            throw new NullPointerException("contentFile == null");
        }
        File suggestedSidecarFile = new File(contentFile.getAbsolutePath() + ".xmp");
        File foundSidecarFile = this.findSidecarFile(suggestedSidecarFile);
        return foundSidecarFile == null ? suggestedSidecarFile : foundSidecarFile;
    }

    public File getDefaultXmpSidecarFileOrNullIfNotExists(File contentFile) {
        if (contentFile == null) {
            throw new NullPointerException("contentFile == null");
        }
        File sidecarFile = this.suggestDefaultSidecarFile(contentFile);
        return this.findSidecarFile(sidecarFile);
    }

    public File findSidecarFile(File sidecarFile) {
        if (sidecarFile.isFile()) {
            return sidecarFile;
        }
        File directory = sidecarFile.getParentFile();
        if (directory == null) {
            return null;
        }
        try {
            File[] sidecarFiles = directory.listFiles((FileFilter)new FilenameIgnoreCaseFileFilter(sidecarFile.getName()));
            if (sidecarFiles != null && sidecarFiles.length > 1) {
                Logger.getLogger(XmpSidecarFileResolverImpl.class.getName()).log(Level.WARNING, "Sidecar file ''{0}'' is ambigious: {1}", new Object[]{sidecarFile, sidecarFiles});
            }
            return sidecarFiles == null ? null : (sidecarFiles.length > 0 ? sidecarFiles[0] : null);
        }
        catch (Throwable t) {
            Logger.getLogger(XmpSidecarFileResolverImpl.class.getName()).log(Level.SEVERE, null, t);
            return null;
        }
    }

    public File getLongXmpSidecarFileOrNullIfNotExists(File contentFile) {
        if (contentFile == null) {
            throw new NullPointerException("contentFile == null");
        }
        File sidecarFile = this.suggestLongSidecarFile(contentFile);
        return this.findSidecarFile(sidecarFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void preferencesChanged(PreferencesChangedEvent evt) {
        String key = evt.getKey();
        if ("XmpPreferences.UsingLongSidecarFilename".equals(key)) {
            XmpSidecarFileResolverImpl xmpSidecarFileResolverImpl = this;
            synchronized (xmpSidecarFileResolverImpl) {
                this.useLongXmpSidecarFilenames = (Boolean)evt.getNewValue();
            }
        }
    }
}

