/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.xmp;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.options.PropertyOptions;
import com.adobe.xmp.properties.XMPPropertyInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class XmpProperties {
    public static File getSidecarfileOf(File imageFile) {
        File sidecarFile;
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        String imgFilename = imageFile.getAbsolutePath();
        int indexExtension = imgFilename.lastIndexOf(46);
        if (indexExtension > 0 && (sidecarFile = new File(imgFilename.substring(0, indexExtension + 1) + "xmp")).exists()) {
            return sidecarFile;
        }
        return null;
    }

    public static List<XMPPropertyInfo> getPropertyInfosOfXmpString(String xmpString) {
        try {
            if (xmpString == null) {
                throw new NullPointerException("xmpString == null");
            }
            ArrayList<XMPPropertyInfo> propertyInfos = new ArrayList<XMPPropertyInfo>();
            XMPMeta xmpMeta = XMPMetaFactory.parseFromString((String)xmpString);
            if (xmpMeta == null) {
                return null;
            }
            for (XMPPropertyInfo xmpPropertyInfo : xmpMeta) {
                propertyInfos.add(xmpPropertyInfo);
            }
            return propertyInfos;
        }
        catch (XMPException ex) {
            Logger.getLogger(XmpProperties.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<XMPPropertyInfo> getPropertyInfosOfSidecarFile(File sidecarFile) {
        if (sidecarFile == null) {
            throw new NullPointerException("sidecarFile == null");
        }
        if (!sidecarFile.exists()) {
            return null;
        }
        ArrayList<XMPPropertyInfo> propertyInfos = new ArrayList<XMPPropertyInfo>();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(sidecarFile);
            XMPMeta xmpMeta = XMPMetaFactory.parse((InputStream)fis);
            if (xmpMeta == null) {
                List<XMPPropertyInfo> list = null;
                return list;
            }
            for (XMPPropertyInfo xmpPropertyInfo : xmpMeta) {
                propertyInfos.add(xmpPropertyInfo);
            }
            ArrayList<XMPPropertyInfo> arrayList = propertyInfos;
            return arrayList;
        }
        catch (Throwable t) {
            Logger.getLogger(XmpProperties.class.getName()).log(Level.SEVERE, null, t);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(XmpProperties.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return null;
    }

    public static List<String> getPropertyValuesFrom(Collection<? extends XMPPropertyInfo> xmpPropertyInfos, PropertyValue propertyValue) {
        if (xmpPropertyInfos == null) {
            throw new NullPointerException("xmpPropertyInfos == null");
        }
        if (propertyValue == null) {
            throw new NullPointerException("propertyValue == null");
        }
        ArrayList<String> values = new ArrayList<String>();
        for (XMPPropertyInfo xMPPropertyInfo : xmpPropertyInfos) {
            String stringValue;
            Object value = xMPPropertyInfo.getValue();
            String string = stringValue = value == null ? null : value.toString().trim();
            if (xMPPropertyInfo.getNamespace() == null || xMPPropertyInfo.getPath() == null || xMPPropertyInfo.getOptions().isQualifier() || !xMPPropertyInfo.getNamespace().equals(propertyValue.getNamespace().getUri()) || !xMPPropertyInfo.getPath().startsWith(propertyValue.getPath()) || stringValue == null || stringValue.isEmpty()) continue;
            values.add(stringValue);
        }
        return values;
    }

    public static String getPropertyValueFrom(Collection<? extends XMPPropertyInfo> xmpPropertyInfos, PropertyValue propertyValue) {
        if (xmpPropertyInfos == null) {
            throw new NullPointerException("xmpPropertyInfos == null");
        }
        if (propertyValue == null) {
            throw new NullPointerException("propertyValue == null");
        }
        List<String> values = XmpProperties.getPropertyValuesFrom(xmpPropertyInfos, propertyValue);
        return values.isEmpty() ? "" : values.get(0);
    }

    private XmpProperties() {
    }

    static {
        try {
            XMPMetaFactory.getSchemaRegistry().registerNamespace(Namespace.LIGHTROOM.getUri(), Namespace.LIGHTROOM.getPrefix());
        }
        catch (Throwable t) {
            Logger.getLogger(XmpProperties.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    public static final class PropertyValue
    extends Enum<PropertyValue> {
        public static final /* enum */ PropertyValue DC_CREATOR = new PropertyValue(Namespace.DUBLIN_CORE, "dc:creator", PropertyValueType.SEQ_PROPER_NAME);
        public static final /* enum */ PropertyValue DC_DESCRIPTION = new PropertyValue(Namespace.DUBLIN_CORE, "dc:description", PropertyValueType.LANG_ALT);
        public static final /* enum */ PropertyValue DC_RIGHTS = new PropertyValue(Namespace.DUBLIN_CORE, "dc:rights", PropertyValueType.LANG_ALT);
        public static final /* enum */ PropertyValue DC_SUBJECT = new PropertyValue(Namespace.DUBLIN_CORE, "dc:subject", PropertyValueType.BAG_TEXT);
        public static final /* enum */ PropertyValue DC_TITLE = new PropertyValue(Namespace.DUBLIN_CORE, "dc:title", PropertyValueType.LANG_ALT);
        public static final /* enum */ PropertyValue IPTC4_XMP_CORE_COUNTRY_CODE = new PropertyValue(Namespace.IPTC_CORE, "Iptc4xmpCore:CountryCode", PropertyValueType.CLOSED_CHOICE);
        public static final /* enum */ PropertyValue IPTC4_XMP_CORE_DATE_CREATED = new PropertyValue(Namespace.IPTC_CORE, "Iptc4xmpCore:DateCreated", PropertyValueType.DATE);
        public static final /* enum */ PropertyValue IPTC4_XMP_CORE_LOCATION = new PropertyValue(Namespace.IPTC_CORE, "Iptc4xmpCore:Location", PropertyValueType.TEXT);
        public static final /* enum */ PropertyValue LR_HIERARCHICAL_SUBJECTS = new PropertyValue(Namespace.LIGHTROOM, "lr:hierarchicalSubject", PropertyValueType.BAG_TEXT);
        public static final /* enum */ PropertyValue PHOTOSHOP_AUTHORS_POSITION = new PropertyValue(Namespace.PHOTOSHOP, "photoshop:AuthorsPosition", PropertyValueType.TEXT);
        public static final /* enum */ PropertyValue PHOTOSHOP_CAPTION_WRITER = new PropertyValue(Namespace.PHOTOSHOP, "photoshop:CaptionWriter", PropertyValueType.PROPER_NAME);
        public static final /* enum */ PropertyValue PHOTOSHOP_CITY = new PropertyValue(Namespace.PHOTOSHOP, "photoshop:City", PropertyValueType.TEXT);
        public static final /* enum */ PropertyValue PHOTOSHOP_COUNTRY = new PropertyValue(Namespace.PHOTOSHOP, "photoshop:Country", PropertyValueType.TEXT);
        public static final /* enum */ PropertyValue PHOTOSHOP_CREDIT = new PropertyValue(Namespace.PHOTOSHOP, "photoshop:Credit", PropertyValueType.TEXT);
        public static final /* enum */ PropertyValue PHOTOSHOP_HEADLINE = new PropertyValue(Namespace.PHOTOSHOP, "photoshop:Headline", PropertyValueType.TEXT);
        public static final /* enum */ PropertyValue PHOTOSHOP_INSTRUCTIONS = new PropertyValue(Namespace.PHOTOSHOP, "photoshop:Instructions", PropertyValueType.TEXT);
        public static final /* enum */ PropertyValue PHOTOSHOP_SOURCE = new PropertyValue(Namespace.PHOTOSHOP, "photoshop:Source", PropertyValueType.TEXT);
        public static final /* enum */ PropertyValue PHOTOSHOP_STATE = new PropertyValue(Namespace.PHOTOSHOP, "photoshop:State", PropertyValueType.TEXT);
        public static final /* enum */ PropertyValue PHOTOSHOP_TRANSMISSION_REFERENCE = new PropertyValue(Namespace.PHOTOSHOP, "photoshop:TransmissionReference", PropertyValueType.TEXT);
        public static final /* enum */ PropertyValue XAP_RATING = new PropertyValue(Namespace.XMP_BASIC, "xap:Rating", PropertyValueType.CLOSED_CHOICE);
        private final String path;
        private final Namespace namesapce;
        private final PropertyValueType propertyValueType;
        private static final /* synthetic */ PropertyValue[] $VALUES;

        public static PropertyValue[] values() {
            return (PropertyValue[])$VALUES.clone();
        }

        public static PropertyValue valueOf(String name) {
            return Enum.valueOf(PropertyValue.class, name);
        }

        private PropertyValue(Namespace namesapce, String path, PropertyValueType propertyValueType) {
            this.path = path;
            this.namesapce = namesapce;
            this.propertyValueType = propertyValueType;
        }

        public String getPath() {
            return this.path;
        }

        public Namespace getNamespace() {
            return this.namesapce;
        }

        public PropertyValueType getPropertyValueType() {
            return this.propertyValueType;
        }

        public PropertyOptions getArrayPropertyOptions() {
            if (this.propertyValueType.equals((Object)PropertyValueType.BAG_TEXT)) {
                return new PropertyOptions().setArray(true);
            }
            if (this.propertyValueType.equals((Object)PropertyValueType.SEQ_PROPER_NAME)) {
                return new PropertyOptions().setArrayOrdered(true);
            }
            if (this.propertyValueType.equals((Object)PropertyValueType.LANG_ALT)) {
                return new PropertyOptions().setArrayAlternate(true);
            }
            assert (false) : "Unknown value type: " + (Object)((Object)this.propertyValueType);
            return null;
        }

        static {
            $VALUES = new PropertyValue[]{DC_CREATOR, DC_DESCRIPTION, DC_RIGHTS, DC_SUBJECT, DC_TITLE, IPTC4_XMP_CORE_COUNTRY_CODE, IPTC4_XMP_CORE_DATE_CREATED, IPTC4_XMP_CORE_LOCATION, LR_HIERARCHICAL_SUBJECTS, PHOTOSHOP_AUTHORS_POSITION, PHOTOSHOP_CAPTION_WRITER, PHOTOSHOP_CITY, PHOTOSHOP_COUNTRY, PHOTOSHOP_CREDIT, PHOTOSHOP_HEADLINE, PHOTOSHOP_INSTRUCTIONS, PHOTOSHOP_SOURCE, PHOTOSHOP_STATE, PHOTOSHOP_TRANSMISSION_REFERENCE, XAP_RATING};
        }
    }

    public static enum PropertyValueType {
        BAG_TEXT,
        BOOLEAN,
        CLOSED_CHOICE,
        COLORANT,
        DATE,
        DIMENSIONS,
        FONT,
        INTEGER,
        LANG_ALT,
        LOCALE,
        MIME_TYPE,
        PROPER_NAME,
        REAL,
        SEQ_PROPER_NAME,
        TEXT,
        THUMBNAIL,
        URI,
        URL,
        XPATH;


        public boolean isBagText() {
            return this.equals((Object)BAG_TEXT);
        }

        public boolean isLangAlt() {
            return this.equals((Object)LANG_ALT);
        }

        public boolean isProperName() {
            return this.equals((Object)PROPER_NAME);
        }

        public boolean isSeqProperName() {
            return this.equals((Object)SEQ_PROPER_NAME);
        }

        public boolean isText() {
            return this.equals((Object)TEXT);
        }

        public boolean isArray() {
            return this.equals((Object)BAG_TEXT) || this.equals((Object)SEQ_PROPER_NAME) || this.equals((Object)LANG_ALT);
        }

        public PropertyOptions getArrayPropertyOptions() {
            switch (this) {
                case BAG_TEXT: {
                    return new PropertyOptions().setArray(true);
                }
                case SEQ_PROPER_NAME: {
                    return new PropertyOptions().setArrayOrdered(true);
                }
                case LANG_ALT: {
                    return new PropertyOptions().setArrayAlternate(true);
                }
            }
            return null;
        }
    }

    public static enum Namespace {
        CAMERA_RAW("http://ns.adobe.com/camera-raw-settings/1.0/", "crs"),
        DUBLIN_CORE("http://purl.org/dc/elements/1.1/", "dc"),
        EXIF("http://ns.adobe.com/exif/1.0/", "exif"),
        IPTC_CORE("http://iptc.org/std/Iptc4xmpCore/1.0/xmlns/", "Iptc4xmpCore"),
        LIGHTROOM("http://ns.adobe.com/lightroom/1.0/", "lr"),
        PHOTOSHOP("http://ns.adobe.com/photoshop/1.0/", "photoshop"),
        TIFF("http://ns.adobe.com/tiff/1.0/", "tiff"),
        XMP_BASIC("http://ns.adobe.com/xap/1.0/", "xap");

        private final String uri;
        private final String prefix;

        private Namespace(String uri, String prefix) {
            this.uri = uri;
            this.prefix = prefix;
        }

        public String getUri() {
            return this.uri;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

