/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.xmp;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPIterator;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.options.IteratorOptions;
import com.adobe.xmp.options.PropertyOptions;
import com.adobe.xmp.options.SerializeOptions;
import com.adobe.xmp.properties.XMPPropertyInfo;
import com.imagero.reader.iptc.IPTCEntryMeta;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.mapping.IptcEntryXmpPathStartMapping;
import org.jphototagger.domain.metadata.mapping.XmpMetaDataValueXmpArrayNameMapping;
import org.jphototagger.domain.metadata.mapping.XmpMetaDataValueXmpValueTypeMapping;
import org.jphototagger.domain.metadata.mapping.XmpMetaDataValuesNamespaceUriMapping;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpLastModifiedMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.domain.repository.xmp.XmpToSaveInRepository;
import org.jphototagger.lib.io.FileLock;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.xmp.EditableMetaDataValues;
import org.jphototagger.xmp.EmbeddedXmpCache;
import org.jphototagger.xmp.ImageFileSidecarFile;
import org.jphototagger.xmp.XmpFileReader;
import org.openide.util.Lookup;

public final class XmpMetadata {
    private static final Logger LOGGER = Logger.getLogger(XmpMetadata.class.getName());
    private static final List<String> KNOWN_NAMESPACES = new ArrayList<String>();
    private static final XmpSidecarFileResolver XMP_SIDECAR_FILE_RESOLVER = (XmpSidecarFileResolver)Lookup.getDefault().lookup(XmpSidecarFileResolver.class);

    private XmpMetadata() {
    }

    public static List<XMPPropertyInfo> filterPropertyInfosOfNamespace(List<XMPPropertyInfo> propertyInfos, String namespace) {
        if (propertyInfos == null) {
            throw new NullPointerException("propertyInfos == null");
        }
        if (namespace == null) {
            throw new NullPointerException("namespace == null");
        }
        ArrayList<XMPPropertyInfo> propertyInfosNs = new ArrayList<XMPPropertyInfo>();
        for (XMPPropertyInfo propertyInfo : propertyInfos) {
            if (!propertyInfo.getNamespace().equals(namespace)) continue;
            propertyInfosNs.add(propertyInfo);
        }
        return propertyInfosNs;
    }

    static List<XMPPropertyInfo> getEmbeddedPropertyInfos(File imageFile) {
        if (imageFile == null || !imageFile.exists()) {
            return null;
        }
        String embeddedXmp = XmpMetadata.getEmbeddedXmpAsString(imageFile);
        return XmpMetadata.getPropertyInfosOfXmpString(embeddedXmp);
    }

    public static List<XMPPropertyInfo> getPropertyInfosOfSidecarFile(File sidecarFile) throws IOException {
        if (sidecarFile == null || !sidecarFile.exists()) {
            return null;
        }
        String xmpOfSidecarFile = XmpMetadata.getXmpAsStringOfSidecarFile(sidecarFile);
        if (xmpOfSidecarFile == null) {
            return null;
        }
        if (!xmpOfSidecarFile.startsWith("<")) {
            int firstStartTagIndex = xmpOfSidecarFile.indexOf(60);
            if (firstStartTagIndex < 0) {
                return null;
            }
            xmpOfSidecarFile = xmpOfSidecarFile.substring(firstStartTagIndex);
        }
        return XmpMetadata.getPropertyInfosOfXmpString(xmpOfSidecarFile);
    }

    public static List<XMPPropertyInfo> getPropertyInfosOfXmpString(String xmpAsString) {
        ArrayList<XMPPropertyInfo> propertyInfos = new ArrayList<XMPPropertyInfo>();
        try {
            XMPMeta xmpMeta;
            if (xmpAsString != null && xmpAsString.length() > 0 && (xmpMeta = XMPMetaFactory.parseFromString((String)xmpAsString)) != null) {
                XmpMetadata.addXmpPropertyInfosTo(xmpMeta, propertyInfos);
            }
        }
        catch (Throwable t) {
            propertyInfos = null;
            LOGGER.log(Level.SEVERE, null, t);
        }
        return propertyInfos;
    }

    private static void addXmpPropertyInfosTo(XMPMeta fromXmpMeta, List<XMPPropertyInfo> toXmpPropertyInfos) {
        try {
            for (XMPPropertyInfo xmpPropertyInfo : fromXmpMeta) {
                if (!XmpMetadata.hasContent(xmpPropertyInfo)) continue;
                toXmpPropertyInfos.add(xmpPropertyInfo);
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
    }

    private static boolean hasContent(XMPPropertyInfo xmpPropertyInfo) {
        return !xmpPropertyInfo.getOptions().isQualifier() && xmpPropertyInfo.getPath() != null && xmpPropertyInfo.getValue() != null && xmpPropertyInfo.getValue().toString().length() > 0;
    }

    public static String getEmbeddedXmpAsString(File imageFile) {
        if (imageFile == null || !imageFile.exists()) {
            return null;
        }
        LOGGER.log(Level.INFO, "Reading embedded XMP from image file ''{0}'', size {1} Bytes", new Object[]{imageFile, imageFile.length()});
        return XmpFileReader.readFile(imageFile);
    }

    public static String getXmpAsStringOfSidecarFile(File sidecarFile) throws IOException {
        if (sidecarFile == null || !sidecarFile.exists()) {
            return null;
        }
        LOGGER.log(Level.INFO, "Reading XMP metadata in sidecar file ''{0}''", sidecarFile);
        return FileUtil.getContentAsString((File)sidecarFile, (String)"UTF-8");
    }

    public static boolean isKnownNamespace(String string) {
        if (string == null) {
            throw new NullPointerException("string == null");
        }
        return KNOWN_NAMESPACES.contains(string);
    }

    public static List<XMPPropertyInfo> filterPropertyInfosOfIptcEntryMeta(List<XMPPropertyInfo> propertyInfos, IPTCEntryMeta matchingIptcEntryMeta) {
        if (propertyInfos == null) {
            throw new NullPointerException("propertyInfos == null");
        }
        if (matchingIptcEntryMeta == null) {
            throw new NullPointerException("matchingIptcEntryMeta == null");
        }
        ArrayList<XMPPropertyInfo> filteredPropertyInfos = new ArrayList<XMPPropertyInfo>();
        String startsWith = IptcEntryXmpPathStartMapping.getXmpPathStartOfIptcEntryMeta((IPTCEntryMeta)matchingIptcEntryMeta);
        for (XMPPropertyInfo propertyInfo : propertyInfos) {
            if (!propertyInfo.getPath().startsWith(startsWith)) continue;
            filteredPropertyInfos.add(propertyInfo);
        }
        return filteredPropertyInfos;
    }

    public static boolean canWriteSidecarFileForImageFile(File imageFile) {
        if (imageFile != null) {
            File directory = imageFile.getParentFile();
            File sidecarFile = XMP_SIDECAR_FILE_RESOLVER.getXmpSidecarFileOrNullIfNotExists(imageFile);
            if (sidecarFile != null) {
                return sidecarFile.canWrite();
            }
            if (directory != null) {
                return directory.canWrite();
            }
        }
        return false;
    }

    public static boolean writeXmpToSidecarFile(Xmp fromXmp, File toSidecarFile) {
        if (fromXmp == null) {
            throw new NullPointerException("fromXmp == null");
        }
        if (toSidecarFile == null) {
            throw new NullPointerException("toSidecarFile == null");
        }
        try {
            XMPMeta toXmpMeta = XmpMetadata.getXmpMetaOfSidecarFile(toSidecarFile);
            XmpMetadata.deleteAllEditableMetadataFrom(toXmpMeta);
            XmpMetadata.setMetadata(fromXmp, toXmpMeta);
            return XmpMetadata.writeSidecarFile(toXmpMeta, toSidecarFile);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
            return false;
        }
    }

    private static void setMetadata(Xmp fromXmp, XMPMeta toXmpMeta) throws XMPException {
        for (MetaDataValue metaDataValue : EditableMetaDataValues.get()) {
            String namespaceUri = XmpMetaDataValuesNamespaceUriMapping.getNamespaceUriOfXmpMetaDataValue((MetaDataValue)metaDataValue);
            String arrayName = XmpMetaDataValueXmpArrayNameMapping.getXmpArrayNameOfXmpMetaDataValue((MetaDataValue)metaDataValue);
            XmpMetadata.copyMetadata(fromXmp, toXmpMeta, metaDataValue, namespaceUri, arrayName);
        }
    }

    private static XMPMeta getXmpMetaOfSidecarFile(File sidecarFile) throws XMPException, IOException {
        String xmp;
        if (sidecarFile.exists() && (xmp = FileUtil.getContentAsString((File)sidecarFile, (String)"UTF-8")) != null && !xmp.trim().isEmpty()) {
            if (xmp.startsWith("<")) {
                return XMPMetaFactory.parseFromString((String)xmp);
            }
            int index = xmp.indexOf(60);
            if (index > 0 && !(xmp = xmp.substring(index)).isEmpty()) {
                return XMPMetaFactory.parseFromString((String)xmp);
            }
        }
        return XMPMetaFactory.create();
    }

    private static void deleteAllEditableMetadataFrom(XMPMeta xmpMeta) {
        List<MetaDataValue> editableXmpMetaDataValues = EditableMetaDataValues.get();
        for (MetaDataValue editableValue : editableXmpMetaDataValues) {
            String namespaceUri = XmpMetaDataValuesNamespaceUriMapping.getNamespaceUriOfXmpMetaDataValue((MetaDataValue)editableValue);
            String propertyName = XmpMetaDataValueXmpArrayNameMapping.getXmpArrayNameOfXmpMetaDataValue((MetaDataValue)editableValue);
            xmpMeta.deleteProperty(namespaceUri, propertyName);
        }
    }

    private static void copyMetadata(Xmp fromXmp, XMPMeta toXmpMeta, MetaDataValue mdValue, String namespaceUri, String arrayName) throws XMPException {
        Object xmpValue = fromXmp.getValue(mdValue);
        if (xmpValue != null) {
            if (xmpValue instanceof String) {
                String value = (String)xmpValue;
                if (XmpMetaDataValueXmpValueTypeMapping.isText((MetaDataValue)mdValue) && !value.trim().isEmpty()) {
                    toXmpMeta.setProperty(namespaceUri, arrayName, (Object)value);
                } else if (XmpMetaDataValueXmpValueTypeMapping.isLanguageAlternative((MetaDataValue)mdValue)) {
                    toXmpMeta.setLocalizedText(namespaceUri, arrayName, "", "x-default", value);
                }
            } else if (xmpValue instanceof List) {
                List values = (List)xmpValue;
                Collections.sort(values);
                for (String value : values) {
                    String trimmedValue = value.trim();
                    if (XmpMetadata.doesArrayItemExist(toXmpMeta, namespaceUri, arrayName, trimmedValue)) continue;
                    toXmpMeta.appendArrayItem(namespaceUri, arrayName, XmpMetadata.getArrayPropertyOptionsOf(mdValue), trimmedValue, null);
                }
            } else if (xmpValue instanceof Long) {
                Long value = (Long)xmpValue;
                toXmpMeta.setProperty(namespaceUri, arrayName, (Object)Long.toString(value));
            } else {
                LOGGER.log(Level.INFO, "No rule to write ''{0}''", xmpValue.getClass());
            }
        }
    }

    private static boolean doesArrayItemExist(XMPMeta xmpMeta, String namespaceUri, String propertyName, String item) throws XMPException {
        if (xmpMeta.doesPropertyExist(namespaceUri, propertyName)) {
            XMPIterator it = xmpMeta.iterator(namespaceUri, propertyName, new IteratorOptions());
            while (it.hasNext()) {
                String itemValue;
                Object value;
                XMPPropertyInfo xmpPropertyInfo = (XMPPropertyInfo)it.next();
                if (xmpPropertyInfo == null || (value = xmpPropertyInfo.getValue()) == null || !(itemValue = value.toString().trim()).equals(item)) continue;
                return true;
            }
        }
        return false;
    }

    private static PropertyOptions getArrayPropertyOptionsOf(MetaDataValue mdValue) {
        XmpMetaDataValueXmpValueTypeMapping.XmpValueType valueType = XmpMetaDataValueXmpValueTypeMapping.getXmpValueType((MetaDataValue)mdValue);
        if (valueType.equals((Object)XmpMetaDataValueXmpValueTypeMapping.XmpValueType.BAG_TEXT)) {
            return new PropertyOptions().setArray(true);
        }
        if (valueType.equals((Object)XmpMetaDataValueXmpValueTypeMapping.XmpValueType.SEQ_PROPER_NAME)) {
            return new PropertyOptions().setArrayOrdered(true);
        }
        if (valueType.equals((Object)XmpMetaDataValueXmpValueTypeMapping.XmpValueType.LANG_ALT)) {
            return new PropertyOptions().setArrayAlternate(true);
        }
        assert (false) : valueType;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeSidecarFile(XMPMeta fromXmpMeta, File toSidecarFile) {
        FileOutputStream out = null;
        if (!FileLock.INSTANCE.lockLogWarning(toSidecarFile, XmpMetadata.class)) {
            return false;
        }
        try {
            out = new FileOutputStream(toSidecarFile);
            out.getChannel().lock();
            XMPMetaFactory.serialize((XMPMeta)fromXmpMeta, (OutputStream)out, (SerializeOptions)new SerializeOptions().setPadding(10).setOmitPacketWrapper(true));
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
            boolean bl = false;
            return bl;
        }
        finally {
            FileLock.INSTANCE.unlock(toSidecarFile, XmpMetadata.class);
            if (out != null) {
                try {
                    out.close();
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, null, t);
                }
            }
        }
    }

    public static Xmp getXmpFromSidecarFileOf(File imageFile) throws IOException {
        if (imageFile == null || !XMP_SIDECAR_FILE_RESOLVER.hasXmpSidecarFile(imageFile)) {
            return null;
        }
        File sidecarFile = XMP_SIDECAR_FILE_RESOLVER.getXmpSidecarFileOrNullIfNotExists(imageFile);
        List<XMPPropertyInfo> propertyInfosOfSidecarFile = XmpMetadata.getPropertyInfosOfSidecarFile(sidecarFile);
        return XmpMetadata.getXmp(propertyInfosOfSidecarFile, imageFile, XmpLocation.SIDECAR_FILE);
    }

    public static Xmp getEmbeddedXmp(File imageFile) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        String cachedXmpString = EmbeddedXmpCache.INSTANCE.getCachedXmp(imageFile);
        return cachedXmpString == null ? null : XmpMetadata.getXmp(XmpMetadata.getPropertyInfosOfXmpString(cachedXmpString), imageFile, XmpLocation.EMBEDDED);
    }

    public static Map<String, List<XMPPropertyInfo>> getOrderedPropertyInfos(List<XMPPropertyInfo> xmpPropertyInfos) {
        if (xmpPropertyInfos == null) {
            throw new NullPointerException("xmpPropertyInfos == null");
        }
        HashMap<String, List<XMPPropertyInfo>> propertyInfoWithPathStart = new HashMap<String, List<XMPPropertyInfo>>();
        Set pathPrefixes = XmpToSaveInRepository.getPathPrefixes();
        for (String pathPrefix : pathPrefixes) {
            for (XMPPropertyInfo propertyInfo : xmpPropertyInfos) {
                if (!propertyInfo.getPath().startsWith(pathPrefix)) continue;
                ArrayList<XMPPropertyInfo> infos = (ArrayList<XMPPropertyInfo>)propertyInfoWithPathStart.get(pathPrefix);
                if (infos == null) {
                    infos = new ArrayList<XMPPropertyInfo>();
                    infos.add(propertyInfo);
                    propertyInfoWithPathStart.put(pathPrefix, infos);
                    continue;
                }
                infos.add(propertyInfo);
            }
        }
        return propertyInfoWithPathStart;
    }

    private static Xmp getXmp(List<XMPPropertyInfo> xmpPropertyInfos, File areFromXmpImageFile, XmpLocation xmpLocation) {
        Xmp xmp = null;
        if (xmpPropertyInfos != null) {
            xmp = new Xmp();
            for (XMPPropertyInfo xmpPropertyInfo : xmpPropertyInfos) {
                String path = xmpPropertyInfo.getPath();
                Object value = xmpPropertyInfo.getValue();
                MetaDataValue mdValue = XmpMetaDataValueXmpArrayNameMapping.findXmpMetaDataValue((String)path);
                if (value == null || mdValue == null || mdValue.getValueType() == null) continue;
                try {
                    xmp.setValue(mdValue, mdValue.getValueType().parseString(value.toString()));
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, null, t);
                }
            }
            XmpMetadata.setLastModified(xmpLocation, xmp, areFromXmpImageFile);
        }
        return xmp;
    }

    private static void setLastModified(XmpLocation xmpType, Xmp xmp, File imageFile) {
        File sidecarFile = XMP_SIDECAR_FILE_RESOLVER.getXmpSidecarFileOrNullIfNotExists(imageFile);
        if (xmpType.equals((Object)XmpLocation.SIDECAR_FILE) && sidecarFile != null) {
            xmp.setValue((MetaDataValue)XmpLastModifiedMetaDataValue.INSTANCE, (Object)sidecarFile.lastModified());
        } else if (xmpType.equals((Object)XmpLocation.EMBEDDED) && imageFile.exists()) {
            xmp.setValue((MetaDataValue)XmpLastModifiedMetaDataValue.INSTANCE, (Object)imageFile.lastModified());
        }
    }

    public static List<ImageFileSidecarFile> getImageFilesWithSidecarFiles(List<File> imageFiles) {
        if (imageFiles == null) {
            throw new NullPointerException("imageFiles == null");
        }
        ArrayList<ImageFileSidecarFile> imageFilesSidecarFiles = new ArrayList<ImageFileSidecarFile>();
        Iterator<File> i$ = imageFiles.iterator();
        while (i$.hasNext()) {
            File imageFile;
            File sidecarFile = XMP_SIDECAR_FILE_RESOLVER.getXmpSidecarFileOrNullIfNotExists(imageFile = i$.next());
            imageFilesSidecarFiles.add(new ImageFileSidecarFile(imageFile, sidecarFile == null ? null : sidecarFile));
        }
        return imageFilesSidecarFiles;
    }

    static {
        KNOWN_NAMESPACES.add("Iptc4xmpCore");
        KNOWN_NAMESPACES.add("aux");
        KNOWN_NAMESPACES.add("crs");
        KNOWN_NAMESPACES.add("dc");
        KNOWN_NAMESPACES.add("exif");
        KNOWN_NAMESPACES.add("lr");
        KNOWN_NAMESPACES.add("photoshop");
        KNOWN_NAMESPACES.add("tiff");
        KNOWN_NAMESPACES.add("xap");
        KNOWN_NAMESPACES.add("xapRights");
    }

    private static enum XmpLocation {
        EMBEDDED,
        SIDECAR_FILE;

    }
}

