/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.xmp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class XmpFileReader {
    private static final byte[] XMP_BEGIN_MARKER = new byte[]{60, 120, 58, 120, 109, 112, 109, 101, 116, 97};
    private static final byte[] XMP_END_MARKER = new byte[]{60, 47, 120, 58, 120, 109, 112, 109, 101, 116, 97, 62};
    private static final byte[] XMP_PACKET_MARKER = new byte[]{60, 63, 120, 112, 97, 99, 107, 101, 116, 32, 98, 101, 103, 105, 110, 61};

    private XmpFileReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) {
        RandomAccessFile raf;
        block5: {
            String string;
            if (file == null) {
                throw new NullPointerException("file == null");
            }
            raf = null;
            try {
                int xmpEndIndex;
                int xmpStartIndex;
                raf = new RandomAccessFile(file, "r");
                raf.getChannel().lock(0L, Long.MAX_VALUE, true);
                int xmpPacketStartIndex = XmpFileReader.getMatchIndex(raf, 0, XMP_PACKET_MARKER);
                if (xmpPacketStartIndex < 0 || (xmpStartIndex = XmpFileReader.getMatchIndex(raf, xmpPacketStartIndex + XMP_PACKET_MARKER.length, XMP_BEGIN_MARKER)) <= 0 || (xmpEndIndex = XmpFileReader.getMatchIndex(raf, xmpStartIndex + XMP_BEGIN_MARKER.length, XMP_END_MARKER)) <= 0) break block5;
                string = XmpFileReader.getXmp(file, xmpStartIndex, xmpEndIndex);
            }
            catch (Throwable t) {
                try {
                    Logger.getLogger(XmpFileReader.class.getName()).log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    XmpFileReader.closeFile(raf);
                    throw throwable;
                }
                XmpFileReader.closeFile(raf);
            }
            XmpFileReader.closeFile(raf);
            return string;
        }
        XmpFileReader.closeFile(raf);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getXmp(File file, int xmpStartIndex, int xmpEndIndex) {
        String string;
        assert (xmpStartIndex >= 0 && xmpStartIndex <= xmpEndIndex) : xmpStartIndex;
        assert (xmpEndIndex >= xmpStartIndex) : xmpEndIndex;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "r");
            raf.seek(xmpStartIndex);
            int count = xmpEndIndex - xmpStartIndex + XMP_END_MARKER.length;
            byte[] bytes = new byte[count];
            int bytesRead = raf.read(bytes, 0, count);
            string = new String(bytes, 0, bytesRead, "UTF-8");
        }
        catch (Throwable t) {
            try {
                Logger.getLogger(XmpFileReader.class.getName()).log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                XmpFileReader.closeFile(raf);
                throw throwable;
            }
            XmpFileReader.closeFile(raf);
            return null;
        }
        XmpFileReader.closeFile(raf);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean existsXmp(File file) {
        if (file == null) {
            throw new NullPointerException("filename == null");
        }
        bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            while (true) {
                line = bufferedReader.readLine();
                if (line == null || line.indexOf("<?xpacket begin") < 0) continue;
                var3_4 = true;
                ** GOTO lbl18
                break;
            }
        }
        catch (Throwable t) {
            try {
                Logger.getLogger(XmpFileReader.class.getName()).log(Level.SEVERE, null, t);
            }
            catch (Throwable var4_5) {
                XmpFileReader.closeReader(bufferedReader);
                throw var4_5;
            }
lbl18:
            // 1 sources

            XmpFileReader.closeReader(bufferedReader);
            return var3_4;
            {
                if (line != null) ** continue;
            }
            XmpFileReader.closeReader(bufferedReader);
            return false;
            XmpFileReader.closeReader(bufferedReader);
            return false;
        }
    }

    private static int getMatchIndex(RandomAccessFile raf, int startAtOffset, byte[] pattern) throws IOException {
        assert (startAtOffset >= 0);
        long fileLength = raf.length();
        byte byteRead = 0;
        int startOffset = -1;
        int matchCount = 0;
        boolean patternMatches = false;
        int bufferSize = 524288;
        byte[] buffer = new byte[bufferSize];
        long bytesToRead = fileLength - (long)startAtOffset + 1L;
        int offset = startAtOffset;
        while ((long)offset < fileLength) {
            bytesToRead = (long)(offset + bufferSize) > fileLength ? fileLength - (long)offset + 1L : (long)bufferSize;
            raf.seek(offset);
            int bytesRead = raf.read(buffer, 0, (int)bytesToRead);
            for (int index = 0; index < bytesRead; ++index) {
                byteRead = buffer[index];
                if (!patternMatches && matchCount <= 0 && byteRead == pattern[0]) {
                    matchCount = 1;
                    startOffset = offset;
                    boolean bl = patternMatches = matchCount == pattern.length;
                }
                if (!patternMatches && matchCount > 0 && offset > startOffset) {
                    if (byteRead == pattern[matchCount]) {
                        patternMatches = ++matchCount == pattern.length;
                    } else {
                        matchCount = -1;
                        startOffset = -1;
                    }
                }
                if (patternMatches) {
                    return startOffset;
                }
                ++offset;
            }
        }
        return -1;
    }

    private static void closeFile(RandomAccessFile file) {
        if (file != null) {
            try {
                file.close();
            }
            catch (Throwable t) {
                Logger.getLogger(XmpFileReader.class.getName()).log(Level.SEVERE, null, t);
            }
        }
    }

    private static void closeReader(BufferedReader bufferedReader) {
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (Throwable t) {
                Logger.getLogger(XmpFileReader.class.getName()).log(Level.SEVERE, null, t);
            }
        }
    }
}

