/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.xmp;

import com.adobe.xmp.properties.XMPPropertyInfo;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.storage.CacheDirectoryProvider;
import org.jphototagger.domain.repository.event.imagefiles.ImageFileDeletedEvent;
import org.jphototagger.domain.repository.event.imagefiles.ImageFileMovedEvent;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.io.IoUtil;
import org.jphototagger.lib.util.StringUtil;
import org.jphototagger.xmp.XmpMetadata;
import org.openide.util.Lookup;

public final class EmbeddedXmpCache {
    private final File CACHE_DIR;
    private static final Logger LOGGER = Logger.getLogger(EmbeddedXmpCache.class.getName());
    private final String EMPTY_XMP = this.getEmptyXmp();
    public static final EmbeddedXmpCache INSTANCE = new EmbeddedXmpCache();

    public void cacheXmp(File imageFile, String xmpAsString) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        if (xmpAsString == null) {
            throw new NullPointerException("xmpAsString == null");
        }
        File cacheFile = this.getCacheFile(imageFile);
        try {
            LOGGER.log(Level.FINE, "Embedded Xmp Cache: Caching embedded XMP of image file ''{0}'' into ''{1}''", new Object[]{imageFile, cacheFile});
            FileUtil.writeStringAsFile((String)xmpAsString, (File)cacheFile);
            FileUtil.touch((File)cacheFile, (File)imageFile);
        }
        catch (Throwable ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            cacheFile.delete();
        }
    }

    public void cacheXmpIfNotUpToDate(File imageFile, String xmpAsString) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        if (xmpAsString == null) {
            throw new NullPointerException("xmpAsString == null");
        }
        if (!this.containsUpToDateXmp(imageFile)) {
            LOGGER.log(Level.FINEST, "Embedded Xmp Cache: Updating embedded XMP cache file of image file ''{0}''", new Object[]{imageFile});
            this.cacheXmp(imageFile, xmpAsString);
        }
    }

    public boolean containsXmp(File imageFile) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        return this.getCacheFile(imageFile).isFile();
    }

    public boolean containsUpToDateXmp(File imageFile) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        if (!this.containsXmp(imageFile)) {
            return false;
        }
        File cacheFile = this.getCacheFile(imageFile);
        long timestampImageFile = imageFile.lastModified();
        long timestampCachedFile = cacheFile.lastModified();
        return timestampCachedFile == timestampImageFile;
    }

    public String getCachedXmp(File imageFile) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        File cacheFile = this.getCacheFile(imageFile);
        if (!cacheFile.isFile()) {
            return null;
        }
        try {
            LOGGER.log(Level.FINEST, "Embedded Xmp Cache: Reading embedded XMP cache of image file ''{0}'' from cache file ''{1}''", new Object[]{imageFile, cacheFile});
            return FileUtil.getContentAsString((File)cacheFile, (String)"UTF-8");
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.SEVERE, null, throwable);
            return null;
        }
    }

    public void deleteCachedXmp(File imageFile) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        File cacheFile = this.getCacheFile(imageFile);
        if (cacheFile.isFile()) {
            LOGGER.log(Level.FINEST, "Embedded Xmp Cache: Deleting embedded XMP cache file ''{0}'' of image file ''{1}''", new Object[]{cacheFile, imageFile});
            cacheFile.delete();
        }
    }

    public void renameCachedXmp(File oldImageFile, File newImageFile) {
        if (!this.containsXmp(oldImageFile)) {
            return;
        }
        File oldCacheFile = this.getCacheFile(oldImageFile);
        File newCacheFile = this.getCacheFile(newImageFile);
        LOGGER.log(Level.FINEST, "Embedded Xmp Cache: Renaming embedded XMP cache file ''{0}'' of renamed image file ''{1}'' to cache file ''{2}'' of new image file ''{3}''", new Object[]{oldCacheFile, oldImageFile, newCacheFile, newImageFile});
        if (newCacheFile.isFile()) {
            newCacheFile.delete();
        }
        oldCacheFile.renameTo(newCacheFile);
    }

    public List<XMPPropertyInfo> getXmpPropertyInfos(File imageFile) {
        String xmpAsString;
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        if (this.containsUpToDateXmp(imageFile)) {
            xmpAsString = this.getCachedXmp(imageFile);
        } else {
            xmpAsString = XmpMetadata.getEmbeddedXmpAsString(imageFile);
            if (xmpAsString == null) {
                this.cacheXmp(imageFile, this.EMPTY_XMP);
            } else {
                this.cacheXmp(imageFile, xmpAsString);
            }
        }
        return XmpMetadata.getPropertyInfosOfXmpString(xmpAsString);
    }

    private File getCacheFile(File imageFile) {
        return new File(this.CACHE_DIR + File.separator + FileUtil.getMd5FilenameOfAbsolutePath((File)imageFile) + ".xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEmptyXmp() {
        InputStream is = null;
        try {
            is = EmbeddedXmpCache.class.getResourceAsStream("Empty.xmp");
            String string = StringUtil.convertStreamToString((InputStream)is, (String)"UTF-8");
            return string;
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.SEVERE, null, throwable);
        }
        finally {
            IoUtil.close((Closeable)is);
        }
        return "";
    }

    @EventSubscriber(eventClass=ImageFileMovedEvent.class)
    public void imageFileMoved(ImageFileMovedEvent event) {
        File oldImageFile = event.getOldImageFile();
        File newImageFile = event.getNewImageFile();
        this.renameCachedXmp(oldImageFile, newImageFile);
    }

    @EventSubscriber(eventClass=ImageFileDeletedEvent.class)
    public void imageFileRemoved(ImageFileDeletedEvent event) {
        File deletedImageFile = event.getImageFile();
        this.deleteCachedXmp(deletedImageFile);
    }

    public void init() {
        AnnotationProcessor.process((Object)this);
    }

    private EmbeddedXmpCache() {
        this.CACHE_DIR = this.lookupCacheDirectory();
        this.ensureCacheDiretoryExists();
    }

    private File lookupCacheDirectory() {
        CacheDirectoryProvider provider = (CacheDirectoryProvider)Lookup.getDefault().lookup(CacheDirectoryProvider.class);
        return provider.getCacheDirectory("EmbeddedXmpCache");
    }

    private void ensureCacheDiretoryExists() {
        if (!this.CACHE_DIR.isDirectory()) {
            try {
                LOGGER.log(Level.FINEST, "Embedded Xmp Cache: Creating cache directory ''{0}''", this.CACHE_DIR);
                FileUtil.ensureDirectoryExists((File)this.CACHE_DIR);
            }
            catch (Throwable ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
    }
}

