/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beansbinding;

import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.PropertyHelper;
import org.jdesktop.beansbinding.PropertyPath;
import org.jdesktop.beansbinding.PropertyResolutionException;
import org.jdesktop.beansbinding.PropertyStateEvent;
import org.jdesktop.beansbinding.PropertyStateListener;
import org.jdesktop.beansbinding.ext.BeanAdapterFactory;
import org.jdesktop.observablecollections.ObservableMap;
import org.jdesktop.observablecollections.ObservableMapListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanProperty<S, V>
extends PropertyHelper<S, V> {
    private Property<S, ?> baseProperty;
    private final PropertyPath path;
    private IdentityHashMap<S, SourceEntry> map = new IdentityHashMap();
    private static final Object NOREAD = new Object();
    private static final boolean LOG = false;

    public static final <S, V> BeanProperty<S, V> create(String path) {
        return new BeanProperty<S, V>(null, path);
    }

    public static final <S, V> BeanProperty<S, V> create(Property<S, ?> baseProperty, String path) {
        return new BeanProperty<S, V>(baseProperty, path);
    }

    private BeanProperty(Property<S, ?> baseProperty, String path) {
        this.path = PropertyPath.createPropertyPath(path);
        this.baseProperty = baseProperty;
    }

    private Object getLastSource(S source) {
        Object src = this.getBeanFromSource(source);
        if (src == null || src == NOREAD) {
            return src;
        }
        for (int i = 0; i < this.path.length() - 1; ++i) {
            if ((src = this.getProperty(src, this.path.get(i))) == null) {
                BeanProperty.log("getLastSource()", "missing source");
                return null;
            }
            if (src != NOREAD) continue;
            BeanProperty.log("getLastSource()", "missing read method");
            return NOREAD;
        }
        return src;
    }

    @Override
    public Class<? extends V> getWriteType(S source) {
        SourceEntry entry = this.map.get(source);
        if (entry != null) {
            entry.validateCache(-1);
            if (entry.cachedWriter == null) {
                throw new UnsupportedOperationException("Unwriteable");
            }
            return this.getType(entry.cache[this.path.length() - 1], this.path.getLast());
        }
        return this.getType(this.getLastSource(source), this.path.getLast());
    }

    @Override
    public V getValue(S source) {
        SourceEntry entry = this.map.get(source);
        if (entry != null) {
            entry.validateCache(-1);
            if (entry.cachedValue == NOREAD) {
                throw new UnsupportedOperationException("Unreadable");
            }
            return (V)entry.cachedValue;
        }
        Object src = this.getLastSource(source);
        if (src == null || src == NOREAD) {
            throw new UnsupportedOperationException("Unreadable");
        }
        if ((src = this.getProperty(src, this.path.getLast())) == NOREAD) {
            BeanProperty.log("getValue()", "missing read method");
            throw new UnsupportedOperationException("Unreadable");
        }
        return (V)src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(S source, V value) {
        SourceEntry entry = this.map.get(source);
        if (entry != null) {
            entry.validateCache(-1);
            if (entry.cachedWriter == null) {
                throw new UnsupportedOperationException("Unwritable");
            }
            try {
                entry.ignoreChange = true;
                this.write(entry.cachedWriter, entry.cache[this.path.length() - 1], this.path.getLast(), value);
            }
            finally {
                entry.ignoreChange = false;
            }
            Object oldValue = entry.cachedValue;
            entry.updateCachedValue();
            this.notifyListeners(entry.cachedIsWriteable(), oldValue, entry);
        } else {
            this.setProperty(this.getLastSource(source), this.path.getLast(), value);
        }
    }

    @Override
    public boolean isReadable(S source) {
        SourceEntry entry = this.map.get(source);
        if (entry != null) {
            entry.validateCache(-1);
            return entry.cachedIsReadable();
        }
        Object src = this.getLastSource(source);
        if (src == null || src == NOREAD) {
            return false;
        }
        Object reader = this.getReader(src, this.path.getLast());
        if (reader == null) {
            BeanProperty.log("isReadable()", "missing read method");
            return false;
        }
        return true;
    }

    @Override
    public boolean isWriteable(S source) {
        SourceEntry entry = this.map.get(source);
        if (entry != null) {
            entry.validateCache(-1);
            return entry.cachedIsWriteable();
        }
        Object src = this.getLastSource(source);
        if (src == null || src == NOREAD) {
            return false;
        }
        Object writer = this.getWriter(src, this.path.getLast());
        if (writer == null) {
            BeanProperty.log("isWritable()", "missing write method");
            return false;
        }
        return true;
    }

    private Object getBeanFromSource(S source) {
        if (this.baseProperty == null) {
            if (source == null) {
                BeanProperty.log("getBeanFromSource()", "source is null");
            }
            return source;
        }
        if (!this.baseProperty.isReadable(source)) {
            BeanProperty.log("getBeanFromSource()", "unreadable source property");
            return NOREAD;
        }
        Object bean = this.baseProperty.getValue(source);
        if (bean == null) {
            BeanProperty.log("getBeanFromSource()", "source property returned null");
            return null;
        }
        return bean;
    }

    @Override
    protected final void listeningStarted(S source) {
        SourceEntry entry = this.map.get(source);
        if (entry == null) {
            entry = new SourceEntry(source);
            this.map.put(source, entry);
        }
    }

    @Override
    protected final void listeningStopped(S source) {
        SourceEntry entry = this.map.remove(source);
        if (entry != null) {
            entry.cleanup();
        }
    }

    private static boolean didValueChange(Object oldValue, Object newValue) {
        return oldValue == null || newValue == null || !oldValue.equals(newValue);
    }

    private void notifyListeners(boolean wasWriteable, Object oldValue, SourceEntry entry) {
        boolean writeableChanged;
        PropertyStateListener[] listeners = this.getPropertyStateListeners(entry.source);
        if (listeners == null || listeners.length == 0) {
            return;
        }
        oldValue = BeanProperty.toUNREADABLE(oldValue);
        Object newValue = BeanProperty.toUNREADABLE(entry.cachedValue);
        boolean valueChanged = BeanProperty.didValueChange(oldValue, newValue);
        boolean bl = writeableChanged = wasWriteable != entry.cachedIsWriteable();
        if (!valueChanged && !writeableChanged) {
            return;
        }
        PropertyStateEvent pse = new PropertyStateEvent(this, entry.source, valueChanged, oldValue, newValue, writeableChanged, entry.cachedIsWriteable());
        this.firePropertyStateChange(pse);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.path + "]";
    }

    private static BeanInfo getBeanInfo(Object object) {
        assert (object != null);
        try {
            return Introspector.getBeanInfo(object.getClass());
        }
        catch (IntrospectionException ie) {
            throw new PropertyResolutionException("Exception while introspecting " + object.getClass().getName(), ie);
        }
    }

    private static Method getPublicForm(Class cl, Method method) {
        if (method == null) {
            return null;
        }
        if (Modifier.isPublic(cl.getModifiers())) {
            return method;
        }
        for (Class<?> c : cl.getInterfaces()) {
            Method m = null;
            try {
                m = c.getMethod(method.getName(), method.getParameterTypes());
                c = m.getDeclaringClass();
                m = BeanProperty.getPublicForm(c, m);
                if (m == null) continue;
                return m;
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        Class<Object> c = cl.getSuperclass();
        if (c != null) {
            Method m = null;
            try {
                m = c.getMethod(method.getName(), method.getParameterTypes());
                c = m.getDeclaringClass();
                m = BeanProperty.getPublicForm(c, m);
                if (m != null) {
                    return m;
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private static PropertyDescriptor getPropertyDescriptor(Object object, String string) {
        assert (object != null);
        PropertyDescriptor[] pds = BeanProperty.getBeanInfo(object).getPropertyDescriptors();
        if (pds == null) {
            return null;
        }
        for (PropertyDescriptor pd : pds) {
            if (pd instanceof IndexedPropertyDescriptor || !pd.getName().equals(string)) continue;
            return pd;
        }
        return null;
    }

    private static EventSetDescriptor getEventSetDescriptor(Object object) {
        EventSetDescriptor[] eds;
        assert (object != null);
        for (EventSetDescriptor ed : eds = BeanProperty.getBeanInfo(object).getEventSetDescriptors()) {
            if (ed.getListenerType() != PropertyChangeListener.class) continue;
            return ed;
        }
        return null;
    }

    private static Object invokeMethod(Method method, Object object, Object ... args) {
        Exception reason = null;
        try {
            return method.invoke(object, args);
        }
        catch (IllegalArgumentException ex) {
            reason = ex;
        }
        catch (IllegalAccessException ex) {
            reason = ex;
        }
        catch (InvocationTargetException ex) {
            reason = ex;
        }
        throw new PropertyResolutionException("Exception invoking method " + method + " on " + object, reason);
    }

    private Object getReader(Object object, String string) {
        assert (object != null);
        if (object instanceof Map) {
            return object;
        }
        PropertyDescriptor pd = BeanProperty.getPropertyDescriptor(object = this.getAdapter(object, string), string);
        return pd == null ? null : BeanProperty.getPublicForm(object.getClass(), pd.getReadMethod());
    }

    private Object read(Object reader, Object object, String string) {
        assert (reader != null);
        if (reader instanceof Map) {
            assert (reader == object);
            return ((Map)reader).get(string);
        }
        object = this.getAdapter(object, string);
        return BeanProperty.invokeMethod((Method)reader, object, new Object[0]);
    }

    private Object getProperty(Object object, String string) {
        if (object == null || object == NOREAD) {
            return NOREAD;
        }
        Object reader = this.getReader(object, string);
        if (reader == null) {
            return NOREAD;
        }
        return this.read(reader, object, string);
    }

    private Class<?> getType(Object object, String string) {
        if (object == null || object == NOREAD) {
            throw new UnsupportedOperationException("Unwritable");
        }
        if (object instanceof Map) {
            return Object.class;
        }
        PropertyDescriptor pd = BeanProperty.getPropertyDescriptor(object = this.getAdapter(object, string), string);
        if (pd == null || BeanProperty.getPublicForm(object.getClass(), pd.getWriteMethod()) == null) {
            BeanProperty.log("getType()", "missing write method");
            throw new UnsupportedOperationException("Unwritable");
        }
        return pd.getPropertyType();
    }

    private Object getWriter(Object object, String string) {
        assert (object != null);
        if (object instanceof Map) {
            return object;
        }
        PropertyDescriptor pd = BeanProperty.getPropertyDescriptor(object = this.getAdapter(object, string), string);
        return pd == null ? null : BeanProperty.getPublicForm(object.getClass(), pd.getWriteMethod());
    }

    private void write(Object writer, Object object, String string, Object value) {
        assert (writer != null);
        if (writer instanceof Map) {
            assert (writer == object);
            ((Map)writer).put(string, value);
            return;
        }
        object = this.getAdapter(object, string);
        BeanProperty.invokeMethod((Method)writer, object, value);
    }

    private void setProperty(Object object, String string, Object value) {
        if (object == null || object == NOREAD) {
            throw new UnsupportedOperationException("Unwritable");
        }
        Object writer = this.getWriter(object, string);
        if (writer == null) {
            BeanProperty.log("setProperty()", "missing write method");
            throw new UnsupportedOperationException("Unwritable");
        }
        this.write(writer, object, string, value);
    }

    private static Object toUNREADABLE(Object src) {
        return src == NOREAD ? PropertyStateEvent.UNREADABLE : src;
    }

    private void registerListener(Object object, String property, SourceEntry entry) {
        assert (object != null);
        if (object != NOREAD) {
            if (object instanceof ObservableMap) {
                ((ObservableMap)object).addObservableMapListener(entry);
            } else if (!(object instanceof Map)) {
                object = this.getAdapter(object, property);
                BeanProperty.addPropertyChangeListener(object, entry);
            }
        }
    }

    private void unregisterListener(Object object, String property, SourceEntry entry) {
        if (object != null && object != NOREAD) {
            if (object instanceof ObservableMap) {
                ((ObservableMap)object).removeObservableMapListener(entry);
            } else if (!(object instanceof Map)) {
                object = this.getAdapter(object, property);
                BeanProperty.removePropertyChangeListener(object, entry);
            }
        }
    }

    private static void addPropertyChangeListener(Object object, PropertyChangeListener listener) {
        EventSetDescriptor ed = BeanProperty.getEventSetDescriptor(object);
        Method addPCMethod = null;
        if (ed == null || (addPCMethod = BeanProperty.getPublicForm(object.getClass(), ed.getAddListenerMethod())) == null) {
            BeanProperty.log("addPropertyChangeListener()", "can't add listener");
            return;
        }
        BeanProperty.invokeMethod(addPCMethod, object, listener);
    }

    private static void removePropertyChangeListener(Object object, PropertyChangeListener listener) {
        EventSetDescriptor ed = BeanProperty.getEventSetDescriptor(object);
        Method removePCMethod = null;
        if (ed == null || (removePCMethod = BeanProperty.getPublicForm(object.getClass(), ed.getRemoveListenerMethod())) == null) {
            BeanProperty.log("removePropertyChangeListener()", "can't remove listener from source");
            return;
        }
        BeanProperty.invokeMethod(removePCMethod, object, listener);
    }

    private static boolean wrapsLiteral(Object o) {
        assert (o != null);
        return o instanceof String || o instanceof Byte || o instanceof Character || o instanceof Boolean || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof Float || o instanceof Double;
    }

    private static boolean match(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (BeanProperty.wrapsLiteral(a)) {
            return a.equals(b);
        }
        return false;
    }

    private Object getAdapter(Object o, String property) {
        Object adapter = null;
        adapter = BeanAdapterFactory.getAdapter(o, property);
        return adapter == null ? o : adapter;
    }

    private static void log(String method, String message) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SourceEntry
    implements PropertyChangeListener,
    ObservableMapListener,
    PropertyStateListener {
        private S source;
        private Object cachedBean;
        private Object[] cache;
        private Object cachedValue;
        private Object cachedWriter;
        private boolean ignoreChange;

        private SourceEntry(S source) {
            this.source = source;
            this.cache = new Object[BeanProperty.this.path.length()];
            this.cache[0] = NOREAD;
            if (BeanProperty.this.baseProperty != null) {
                BeanProperty.this.baseProperty.addPropertyStateListener(source, this);
            }
            this.updateCachedBean();
            this.updateCachedSources(0);
            this.updateCachedValue();
            this.updateCachedWriter();
        }

        private void cleanup() {
            for (int i = 0; i < BeanProperty.this.path.length(); ++i) {
                BeanProperty.this.unregisterListener(this.cache[i], BeanProperty.this.path.get(i), this);
            }
            if (BeanProperty.this.baseProperty != null) {
                BeanProperty.this.baseProperty.removePropertyStateListener(this.source, this);
            }
            this.cachedBean = null;
            this.cache = null;
            this.cachedValue = null;
            this.cachedWriter = null;
        }

        private boolean cachedIsReadable() {
            return this.cachedValue != NOREAD;
        }

        private boolean cachedIsWriteable() {
            return this.cachedWriter != null;
        }

        private int getSourceIndex(Object object) {
            int i;
            for (i = 0; i < this.cache.length; ++i) {
                if (this.cache[i] != object) continue;
                return i;
            }
            if (object instanceof Map) {
                return -1;
            }
            for (i = 0; i < this.cache.length; ++i) {
                Object adapter;
                if (this.cache[i] == null || (adapter = BeanProperty.this.getAdapter(this.cache[i], BeanProperty.this.path.get(i))) != object) continue;
                return i;
            }
            return -1;
        }

        private void updateCachedBean() {
            this.cachedBean = BeanProperty.this.getBeanFromSource(this.source);
        }

        private void updateCachedSources(int index) {
            Object src;
            boolean loggedYet = false;
            if (index == 0) {
                src = this.cachedBean;
                if (this.cache[0] != src) {
                    BeanProperty.this.unregisterListener(this.cache[0], BeanProperty.this.path.get(0), this);
                    this.cache[0] = src;
                    if (src == null) {
                        loggedYet = true;
                        BeanProperty.log("updateCachedSources()", "source is null");
                    } else {
                        BeanProperty.this.registerListener(src, BeanProperty.this.path.get(0), this);
                    }
                }
                ++index;
            }
            for (int i = index; i < BeanProperty.this.path.length(); ++i) {
                Object old = this.cache[i];
                src = BeanProperty.this.getProperty(this.cache[i - 1], BeanProperty.this.path.get(i - 1));
                if (src == old) continue;
                BeanProperty.this.unregisterListener(old, BeanProperty.this.path.get(i), this);
                this.cache[i] = src;
                if (src == null) {
                    if (loggedYet) continue;
                    loggedYet = true;
                    BeanProperty.log("updateCachedSources()", "missing source");
                    continue;
                }
                if (src == NOREAD) {
                    if (loggedYet) continue;
                    loggedYet = true;
                    BeanProperty.log("updateCachedSources()", "missing read method");
                    continue;
                }
                BeanProperty.this.registerListener(src, BeanProperty.this.path.get(i), this);
            }
        }

        private void validateCache(int ignore) {
        }

        private void updateCachedWriter() {
            Object src = this.cache[BeanProperty.this.path.length() - 1];
            if (src == null || src == NOREAD) {
                this.cachedWriter = null;
            } else {
                this.cachedWriter = BeanProperty.this.getWriter(src, BeanProperty.this.path.getLast());
                if (this.cachedWriter == null) {
                    BeanProperty.log("updateCachedWriter()", "missing write method");
                }
            }
        }

        private void updateCachedValue() {
            Object src = this.cache[BeanProperty.this.path.length() - 1];
            if (src == null || src == NOREAD) {
                this.cachedValue = NOREAD;
            } else {
                this.cachedValue = BeanProperty.this.getProperty(this.cache[BeanProperty.this.path.length() - 1], BeanProperty.this.path.getLast());
                if (this.cachedValue == NOREAD) {
                    BeanProperty.log("updateCachedValue()", "missing read method");
                }
            }
        }

        private void bindingPropertyChanged(PropertyStateEvent pse) {
            this.validateCache(0);
            Object oldValue = this.cachedValue;
            boolean wasWriteable = this.cachedIsWriteable();
            this.updateCachedBean();
            this.updateCachedSources(0);
            this.updateCachedValue();
            this.updateCachedWriter();
            BeanProperty.this.notifyListeners(wasWriteable, oldValue, this);
        }

        private void cachedValueChanged(int index) {
            this.validateCache(index);
            boolean wasWriteable = this.cachedIsWriteable();
            Object oldValue = this.cachedValue;
            this.updateCachedSources(index);
            this.updateCachedValue();
            if (index != BeanProperty.this.path.length()) {
                this.updateCachedWriter();
            }
            BeanProperty.this.notifyListeners(wasWriteable, oldValue, this);
        }

        private void mapValueChanged(ObservableMap map, Object key) {
            if (this.ignoreChange) {
                return;
            }
            int index = this.getSourceIndex(map);
            if (index == -1) {
                throw new AssertionError();
            }
            if (key.equals(BeanProperty.this.path.get(index))) {
                this.cachedValueChanged(index + 1);
            }
        }

        @Override
        public void propertyStateChanged(PropertyStateEvent pe) {
            if (!pe.getValueChanged()) {
                return;
            }
            this.bindingPropertyChanged(pe);
        }

        private void propertyValueChanged(PropertyChangeEvent pce) {
            if (this.ignoreChange) {
                return;
            }
            int index = this.getSourceIndex(pce.getSource());
            if (index == -1) {
                throw new AssertionError();
            }
            String propertyName = pce.getPropertyName();
            if (propertyName == null || BeanProperty.this.path.get(index).equals(propertyName)) {
                this.cachedValueChanged(index + 1);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            this.propertyValueChanged(e);
        }

        @Override
        public void mapKeyValueChanged(ObservableMap map, Object key, Object lastValue) {
            this.mapValueChanged(map, key);
        }

        @Override
        public void mapKeyAdded(ObservableMap map, Object key) {
            this.mapValueChanged(map, key);
        }

        @Override
        public void mapKeyRemoved(ObservableMap map, Object key, Object value) {
            this.mapValueChanged(map, key);
        }
    }
}

