/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.image.util;

import java.awt.Image;
import java.io.File;
import java.util.List;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.thumbnails.ThumbnailCreator;
import org.jphototagger.domain.thumbnails.ThumbnailCreatorPriorityComparator;
import org.openide.util.Lookup;

public final class ThumbnailCreatorService {
    public static final ThumbnailCreatorService INSTANCE = new ThumbnailCreatorService();
    private final List<ThumbnailCreator> thumbnailCreators = ThumbnailCreatorPriorityComparator.lookupSorted();

    public Image createThumbnail(File file) {
        if (file == null) {
            return null;
        }
        for (ThumbnailCreator creator : this.thumbnailCreators) {
            Image thumbnail;
            if (!creator.canCreateThumbnail(file) || (thumbnail = creator.createThumbnail(file)) == null) continue;
            return thumbnail;
        }
        return null;
    }

    public static int readMaxThumbnailWidthFromPreferences() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        int width = prefs.getInt("UserSettings.MaxThumbnailWidth");
        return width != Integer.MIN_VALUE ? width : 150;
    }

    private ThumbnailCreatorService() {
    }
}

