/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.image.util;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.jphototagger.lib.io.IoUtil;

public final class ImageUtil {
    public static ByteArrayInputStream getByteArrayInputStream(Image image, String formatName) {
        if (image == null) {
            throw new NullPointerException("image == null");
        }
        if (formatName == null) {
            throw new NullPointerException("formatName == null");
        }
        ByteArrayInputStream stream = null;
        try {
            BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(image, 0, 0, null);
            graphics.dispose();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, formatName, outputStream);
            byte[] byteArray = outputStream.toByteArray();
            stream = new ByteArrayInputStream(byteArray);
        }
        catch (Throwable t) {
            Logger.getLogger(ImageUtil.class.getName()).log(Level.SEVERE, null, t);
        }
        return stream;
    }

    public static byte[] getByteArray(Image image, String formatName) {
        if (image == null) {
            throw new NullPointerException("image == null");
        }
        if (formatName == null) {
            throw new NullPointerException("formatName == null");
        }
        try {
            BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(image, 0, 0, null);
            graphics.dispose();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, formatName, outputStream);
            return outputStream.toByteArray();
        }
        catch (Throwable t) {
            Logger.getLogger(ImageUtil.class.getName()).log(Level.SEVERE, null, t);
            return null;
        }
    }

    public static Dimension getNewDimensions(BufferedImage img, int maxWidth) {
        int newHeight;
        if (img == null) {
            throw new NullPointerException("img == null");
        }
        if (maxWidth < 0) {
            throw new IllegalArgumentException("Negative width: " + maxWidth);
        }
        int width = img.getWidth();
        int height = img.getHeight();
        assert (width > 0 && height > 0) : "Width " + width + " height " + height + " have to be > 0!";
        if (width <= 0 || height <= 0) {
            return null;
        }
        boolean isLandscape = width > height;
        double aspectRatio = (double)width / (double)height;
        int lenOtherSide = isLandscape ? (int)((double)maxWidth / aspectRatio + 0.5) : (int)((double)maxWidth * aspectRatio + 0.5);
        int newWidth = isLandscape ? maxWidth : lenOtherSide;
        int n = newHeight = isLandscape ? lenOtherSide : maxWidth;
        assert (newWidth > 0 && newHeight > 0) : "Width " + newWidth + " height " + newHeight + " have to be > 0!";
        if (newWidth <= 0 || newHeight <= 0) {
            return null;
        }
        return new Dimension(newWidth, newHeight);
    }

    public static Image getScaledInstance(Image image, int maxLength) {
        int height;
        if (image == null) {
            throw new NullPointerException("image == null");
        }
        if (maxLength <= 0) {
            throw new IllegalArgumentException("Illegal length: " + maxLength);
        }
        int width = image.getWidth(null);
        double scaleFactor = ImageUtil.getScaleFactor(width, height = image.getHeight(null), maxLength);
        if (scaleFactor == 1.0 || scaleFactor == 0.0) {
            return image;
        }
        return image.getScaledInstance((int)((double)width / scaleFactor + 0.5), (int)((double)height / scaleFactor + 0.5), 1);
    }

    public static Image getThumbnail(File imageFile, int maxLength) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        if (maxLength <= 0) {
            throw new IllegalArgumentException("Illegal length: " + maxLength);
        }
        BufferedImage image = ImageUtil.loadImage(imageFile);
        BufferedImage scaledImage = null;
        if (image != null) {
            scaledImage = ImageUtil.stepScaleImage(image, maxLength, 0.5);
        }
        return scaledImage;
    }

    private static BufferedImage stepScaleImage(BufferedImage image, int minWidth, double qfactor) {
        assert (qfactor < 1.0) : "qfactor must be < 1.0";
        BufferedImage scaledImage = null;
        try {
            int origHeight = image.getHeight();
            int origWidth = image.getWidth();
            double factor = ImageUtil.getScaleFactor(origWidth, origHeight, minWidth);
            int scaledWidth = (int)((double)origWidth / factor);
            int scaledHeight = (int)((double)origHeight / factor);
            int pass = 1;
            BufferedImage img = image;
            while ((double)origWidth * qfactor > (double)scaledWidth || (double)origHeight * qfactor > (double)scaledHeight) {
                int width = (int)((double)origWidth * qfactor);
                int height = (int)((double)origHeight * qfactor);
                img = ImageUtil.scaleImage(width, height, img);
                origWidth = img.getWidth();
                origHeight = img.getHeight();
                ++pass;
            }
            scaledImage = ImageUtil.scaleImage(scaledWidth, scaledHeight, img);
        }
        catch (Throwable t) {
            Logger.getLogger(ImageUtil.class.getName()).log(Level.SEVERE, null, t);
        }
        return scaledImage;
    }

    private static double getScaleFactor(int width, int height, int maxWidth) {
        double longer = width > height ? (double)width : (double)height;
        return longer / (double)maxWidth;
    }

    private static BufferedImage scaleImage(int scaledWidth, int scaledHeight, BufferedImage image) {
        BufferedImage scaledImage = new BufferedImage(scaledWidth, scaledHeight, 1);
        Graphics2D graphics2D = scaledImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.drawImage(image, 0, 0, scaledWidth, scaledHeight, null);
        return scaledImage;
    }

    private static BufferedImage loadImage(File file) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(file);
            MediaTracker mediaTracker = new MediaTracker(new Container());
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
        }
        catch (Throwable t) {
            Logger.getLogger(ImageUtil.class.getName()).log(Level.SEVERE, null, t);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJpegImage(Image jpegImage, File toFile) throws IOException {
        if (jpegImage == null) {
            throw new NullPointerException("jpegImage == null");
        }
        if (toFile == null) {
            throw new NullPointerException("toFile == null");
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(toFile);
            fos.getChannel().lock();
            ByteArrayInputStream is = ImageUtil.getByteArrayInputStream(jpegImage, "jpeg");
            if (is != null) {
                int nextByte;
                while ((nextByte = is.read()) != -1) {
                    fos.write(nextByte);
                }
            }
        }
        catch (Throwable throwable) {
            IoUtil.close(fos);
            throw throwable;
        }
        IoUtil.close((Closeable)fos);
    }

    public static BufferedImage imageToBufferedImage(Image im) {
        if (im == null) {
            throw new NullPointerException("im == null");
        }
        BufferedImage bi = new BufferedImage(im.getWidth(null), im.getHeight(null), 1);
        Graphics bg = bi.getGraphics();
        bg.drawImage(im, 0, 0, null);
        bg.dispose();
        return bi;
    }

    private ImageUtil() {
    }
}

