/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.image.tiff;

import java.nio.ByteOrder;

public final class TiffUtil {
    public static byte[] tiffHeader(ByteOrder byteOrder) {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        if (byteOrder == null) {
            throw new NullPointerException("byteOrder == null");
        }
        boolean littleEndian = byteOrder.equals(ByteOrder.LITTLE_ENDIAN);
        byte[] header = new byte[8];
        if (littleEndian) {
            byte[] byArray4 = new byte[2];
            byArray4[0] = 73;
            byArray3 = byArray4;
            byArray4[1] = 73;
        } else {
            byte[] byArray5 = new byte[2];
            byArray5[0] = 77;
            byArray3 = byArray5;
            byArray5[1] = 77;
        }
        byte[] bo = byArray3;
        if (littleEndian) {
            byte[] byArray6 = new byte[2];
            byArray6[0] = 42;
            byArray2 = byArray6;
            byArray6[1] = 0;
        } else {
            byte[] byArray7 = new byte[2];
            byArray7[0] = 0;
            byArray2 = byArray7;
            byArray7[1] = 42;
        }
        byte[] magic = byArray2;
        if (littleEndian) {
            byte[] byArray8 = new byte[4];
            byArray8[0] = 8;
            byArray8[1] = 0;
            byArray8[2] = 0;
            byArray = byArray8;
            byArray8[3] = 0;
        } else {
            byte[] byArray9 = new byte[4];
            byArray9[0] = 0;
            byArray9[1] = 0;
            byArray9[2] = 0;
            byArray = byArray9;
            byArray9[3] = 8;
        }
        byte[] ifdOffset = byArray;
        System.arraycopy(bo, 0, header, 0, 2);
        System.arraycopy(magic, 0, header, 2, 2);
        System.arraycopy(ifdOffset, 0, header, 4, 4);
        return header;
    }

    private TiffUtil() {
    }
}

