/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.image.thumbnail;

import com.imagero.reader.IOParameterBlock;
import com.imagero.reader.ImageProcOptions;
import com.imagero.reader.ImageReader;
import com.imagero.reader.Imagero;
import com.imagero.reader.ReaderFactory;
import com.imagero.reader.tiff.TiffReader;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.jphototagger.domain.metadata.exif.ExifInfo;
import org.jphototagger.image.util.ImageTransform;
import org.openide.util.Lookup;

final class ThumbnailUtil {
    private static final Logger LOGGER = Logger.getLogger(ThumbnailUtil.class.getName());

    static Image getEmbeddedThumbnail(File file) {
        Image thumbnail;
        ImageAndReader imageAndReader = ThumbnailUtil.getEmbeddedThumbnailWithReader(file);
        Image rotatedThumbnail = thumbnail = imageAndReader.image;
        if (thumbnail != null) {
            ExifInfo exifInfo = (ExifInfo)Lookup.getDefault().lookup(ExifInfo.class);
            double rotateAngle = exifInfo.getRotationAngleOfEmbeddedThumbnail(file);
            LOGGER.log(Level.INFO, "Rotating extracted thumbnail that was embedded file ''{0}''", file);
            rotatedThumbnail = ImageTransform.rotate(thumbnail, rotateAngle);
        }
        ThumbnailUtil.closeReader(imageAndReader.imageReader);
        return rotatedThumbnail;
    }

    private static ImageAndReader getEmbeddedThumbnailWithReader(File file) {
        Image thumbnail = null;
        ImageReader reader = null;
        try {
            LOGGER.log(Level.INFO, "Reading embedded thumbnail from image file ''{0}'', size {1} Bytes", new Object[]{file, file.length()});
            reader = ReaderFactory.createReader((File)file);
            if (reader instanceof TiffReader) {
                TiffReader tiffReader = (TiffReader)reader;
                if (tiffReader.getThumbnailCount() > 0) {
                    ImageProducer thumbnailProducer = tiffReader.getThumbnail(0);
                    thumbnail = Toolkit.getDefaultToolkit().createImage(thumbnailProducer);
                }
            } else {
                IOParameterBlock ioParamBlock = new IOParameterBlock();
                ioParamBlock.setSource(file);
                thumbnail = Imagero.getThumbnail((IOParameterBlock)ioParamBlock, (int)0);
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
            return new ImageAndReader(null, null);
        }
        return new ImageAndReader(thumbnail, reader);
    }

    static Image createThumbnailWithImagero(File file, int maxLength) {
        try {
            LOGGER.log(Level.INFO, "Creating thumbnail from image file ''{0}'', size of image file is {1} Bytes", new Object[]{file, file.length()});
            IOParameterBlock ioParamBlock = new IOParameterBlock();
            ImageProcOptions procOptions = new ImageProcOptions();
            ioParamBlock.setSource(file);
            procOptions.setSource(ioParamBlock);
            procOptions.setScale(maxLength);
            Image image = Imagero.readImage((ImageProcOptions)procOptions);
            ThumbnailUtil.closeReader(procOptions.getImageReader());
            return image;
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
            return null;
        }
    }

    static Image createThumbnailWithJavaImageIO(File file, int maxLength) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Invalid length: " + maxLength);
        }
        LOGGER.log(Level.INFO, "Creating thumbnail from image file ''{0}'', size {1} Bytes", new Object[]{file, file.length()});
        BufferedImage image = ThumbnailUtil.loadImage(file);
        BufferedImage scaledImage = null;
        if (image != null) {
            scaledImage = ThumbnailUtil.stepScaleImage(image, maxLength, 0.5);
        }
        return scaledImage;
    }

    private static BufferedImage stepScaleImage(BufferedImage image, int minWidth, double qfactor) {
        assert (qfactor < 1.0) : "qfactor must be < 1.0";
        BufferedImage scaledImage = null;
        try {
            int origHeight = image.getHeight();
            int origWidth = image.getWidth();
            double factor = ThumbnailUtil.getScaleFactor(origWidth, origHeight, minWidth);
            int scaledWidth = (int)((double)origWidth / factor);
            int scaledHeight = (int)((double)origHeight / factor);
            int pass = 1;
            BufferedImage img = image;
            while ((double)origWidth * qfactor > (double)scaledWidth || (double)origHeight * qfactor > (double)scaledHeight) {
                int width = (int)((double)origWidth * qfactor);
                int height = (int)((double)origHeight * qfactor);
                img = ThumbnailUtil.scaleImage(width, height, img);
                origWidth = img.getWidth();
                origHeight = img.getHeight();
                ++pass;
            }
            scaledImage = ThumbnailUtil.scaleImage(scaledWidth, scaledHeight, img);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
        return scaledImage;
    }

    private static double getScaleFactor(int width, int height, int maxWidth) {
        double longer = width > height ? (double)width : (double)height;
        return longer / (double)maxWidth;
    }

    private static BufferedImage scaleImage(int scaledWidth, int scaledHeight, BufferedImage image) {
        BufferedImage scaledImage = new BufferedImage(scaledWidth, scaledHeight, 1);
        Graphics2D graphics2D = scaledImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.drawImage(image, 0, 0, scaledWidth, scaledHeight, null);
        return scaledImage;
    }

    private static BufferedImage loadImage(File file) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(file);
            MediaTracker mediaTracker = new MediaTracker(new Container());
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
        return image;
    }

    private static void closeReader(ImageReader reader) {
        if (reader != null) {
            reader.close();
        }
    }

    private ThumbnailUtil() {
    }

    private static class ImageAndReader {
        private final Image image;
        private final ImageReader imageReader;

        private ImageAndReader(Image image, ImageReader imageReader) {
            this.image = image;
            this.imageReader = imageReader;
        }
    }
}

