/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.image.thumbnail;

import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jphototagger.domain.thumbnails.ThumbnailCreator;
import org.jphototagger.image.thumbnail.ThumbnailUtil;
import org.jphototagger.image.util.ThumbnailCreatorService;
import org.jphototagger.lib.util.Bundle;

public final class PngThumbnailCreator
implements ThumbnailCreator {
    private static final Set<String> SUPPORTED_FILE_TYPES = new HashSet<String>(Arrays.asList("png"));

    public Image createThumbnail(File file) {
        int maxLength = ThumbnailCreatorService.readMaxThumbnailWidthFromPreferences();
        return ThumbnailUtil.createThumbnailWithJavaImageIO(file, maxLength);
    }

    public boolean canCreateThumbnail(File file) {
        return file.getName().toLowerCase().endsWith(".png");
    }

    public Set<String> getAllSupportedFileTypeSuffixes() {
        return Collections.unmodifiableSet(SUPPORTED_FILE_TYPES);
    }

    public Set<String> getSupportedRawFormatFileTypeSuffixes() {
        return Collections.emptySet();
    }

    public Component getSettingsComponent() {
        return null;
    }

    public String getDisplayName() {
        return Bundle.getString(PngThumbnailCreator.class, (String)"PngThumbnailCreator.Displayname", (Object[])new Object[0]);
    }

    public int getPriority() {
        return 50;
    }

    public int getPosition() {
        return 500;
    }
}

