/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.image.thumbnail;

import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.filetypes.UserDefinedFileType;
import org.jphototagger.domain.repository.UserDefinedFileTypesRepository;
import org.jphototagger.domain.thumbnails.ThumbnailCreator;
import org.jphototagger.image.ImageFileType;
import org.jphototagger.image.thumbnail.ThumbnailCreationStrategy;
import org.jphototagger.image.thumbnail.ThumbnailCreationStrategyProvider;
import org.jphototagger.image.thumbnail.ThumbnailUtil;
import org.jphototagger.image.util.ThumbnailCreatorService;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.runtime.External;
import org.jphototagger.lib.runtime.ProcessResult;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class DefaultThumbnailCreator
implements ThumbnailCreator {
    private static final Logger LOGGER = Logger.getLogger(DefaultThumbnailCreator.class.getName());
    private static final Set<String> SUPPORTED_SUFFIXES_LOWERCASE = new HashSet<String>();
    private static final Set<String> RGB_IMAGE_SUFFIXES_LOWERCASE = new HashSet<String>();
    private static final Set<String> RAW_FORMAT_SUFFIXES_LOWERCASE = new HashSet<String>();
    private final Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
    private final UserDefinedFileTypesRepository userDefinedFileTypesRepository = (UserDefinedFileTypesRepository)Lookup.getDefault().lookup(UserDefinedFileTypesRepository.class);
    private final ThumbnailCreationStrategyProvider thumbnailCreationStrategyProvider = (ThumbnailCreationStrategyProvider)Lookup.getDefault().lookup(ThumbnailCreationStrategyProvider.class);

    public Image createThumbnail(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (!file.exists()) {
            return null;
        }
        if (this.isUserDefinedFileType(file)) {
            return this.createUserDefinedThumbnail(file);
        }
        if (!this.canCreateThumbnail(file)) {
            return null;
        }
        Image thumbnail = null;
        int maxLength = ThumbnailCreatorService.readMaxThumbnailWidthFromPreferences();
        if (this.isCreateThumbnailWithExternalApplication()) {
            String createCommand = this.prefs.getString("UserSettings.ExternalThumbnailCreationCommand");
            thumbnail = this.createThumbnailWithExternalApplication(file, createCommand, maxLength);
        }
        if (thumbnail == null && ImageFileType.isJpegFile(file.getName())) {
            thumbnail = ThumbnailUtil.createThumbnailWithJavaImageIO(file, maxLength);
        }
        if (thumbnail == null && !this.isRawFile(file)) {
            thumbnail = ThumbnailUtil.createThumbnailWithImagero(file, maxLength);
        }
        return thumbnail;
    }

    private Image createUserDefinedThumbnail(File file) {
        String suffix = FileUtil.getSuffix((File)file);
        UserDefinedFileType fileType = this.userDefinedFileTypesRepository.findUserDefinedFileTypeBySuffix(suffix);
        if (fileType == null || !fileType.isExternalThumbnailCreator()) {
            return IconUtil.getIconImage((String)"/org/jphototagger/program/resource/images/user_defined_file_type.jpg");
        }
        int maxLength = ThumbnailCreatorService.readMaxThumbnailWidthFromPreferences();
        String createCommand = this.prefs.getString("UserSettings.ExternalThumbnailCreationCommand");
        return this.createThumbnailWithExternalApplication(file, createCommand, maxLength);
    }

    private Image createThumbnailWithExternalApplication(File file, String command, int maxLength) {
        LOGGER.log(Level.INFO, "Creating thumbnail of file ''{0}'' with external program. The length of the thumbnail''s width will be{1} pixels", new Object[]{file, maxLength});
        String cmd = command.replace("%s", file.getAbsolutePath()).replace("%i", Integer.toString(maxLength));
        BufferedImage image = null;
        LOGGER.log(Level.FINEST, "Creating thumbnail with external application. Command: ''{0}''", cmd);
        ProcessResult output = External.executeWaitForTermination((String)cmd, (long)(this.getMaxSecondsToTerminateExternalPrograms() * 1000));
        if (output == null) {
            return null;
        }
        byte[] stdout = output.getStdOutBytes();
        if (stdout != null) {
            try {
                image = ImageIO.read(new ByteArrayInputStream(stdout));
            }
            catch (Throwable t) {
                Logger.getLogger(ThumbnailUtil.class.getName()).log(Level.SEVERE, null, t);
            }
        }
        if (output.getStdErrBytes() != null) {
            DefaultThumbnailCreator.logErrorStream(file, output);
        }
        return image;
    }

    private int getMaxSecondsToTerminateExternalPrograms() {
        int seconds = this.prefs.containsKey("UserSettings.MaximumSecondsToTerminateExternalPrograms") ? this.prefs.getInt("UserSettings.MaximumSecondsToTerminateExternalPrograms") : 60;
        int minSeconds = 10;
        return seconds > minSeconds ? seconds : minSeconds;
    }

    private static void logErrorStream(File imageFile, ProcessResult output) {
        String errorMessage;
        byte[] errorStreamBytes = output.getStdErrBytes();
        String string = errorMessage = errorStreamBytes == null ? "" : new String(errorStreamBytes).trim();
        if (!errorMessage.isEmpty()) {
            LOGGER.log(Level.WARNING, "Program error message while creating a thumbnail of file ''{0}'': ''{1}''", new Object[]{imageFile, errorMessage});
        }
    }

    private boolean isUserDefinedFileType(File file) {
        String suffix = FileUtil.getSuffix((File)file);
        return this.userDefinedFileTypesRepository.existsUserDefinedFileTypeWithSuffix(suffix);
    }

    private boolean isRawFile(File file) {
        String suffix = FileUtil.getSuffix((File)file).toLowerCase();
        return RAW_FORMAT_SUFFIXES_LOWERCASE.contains(suffix);
    }

    private boolean isCreateThumbnailWithExternalApplication() {
        ThumbnailCreationStrategy strategy = this.thumbnailCreationStrategyProvider.getThumbnailCreationStrategy();
        return ThumbnailCreationStrategy.EXTERNAL_APP.equals((Object)strategy);
    }

    public boolean canCreateThumbnail(File file) {
        return this.externalAppCreatesThumbnails() || this.suffixIsSupported(file) || this.isUserDefinedFileType(file);
    }

    private boolean externalAppCreatesThumbnails() {
        ThumbnailCreationStrategy strategy = this.thumbnailCreationStrategyProvider.getThumbnailCreationStrategy();
        return ThumbnailCreationStrategy.EXTERNAL_APP.equals((Object)strategy);
    }

    private boolean suffixIsSupported(File file) {
        String suffix = FileUtil.getSuffix((File)file);
        String suffixLowerCase = suffix.toLowerCase();
        return RGB_IMAGE_SUFFIXES_LOWERCASE.contains(suffixLowerCase);
    }

    public Set<String> getAllSupportedFileTypeSuffixes() {
        return Collections.unmodifiableSet(SUPPORTED_SUFFIXES_LOWERCASE);
    }

    public Set<String> getSupportedRawFormatFileTypeSuffixes() {
        return Collections.unmodifiableSet(RAW_FORMAT_SUFFIXES_LOWERCASE);
    }

    public Component getSettingsComponent() {
        return null;
    }

    public int getPosition() {
        return 0;
    }

    public String getDisplayName() {
        return Bundle.getString(DefaultThumbnailCreator.class, (String)"ThumbnailCreatorImpl.DisplayName", (Object[])new Object[0]);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public String toString() {
        return this.getDisplayName();
    }

    static {
        RGB_IMAGE_SUFFIXES_LOWERCASE.add("jpeg");
        RGB_IMAGE_SUFFIXES_LOWERCASE.add("jpg");
        RGB_IMAGE_SUFFIXES_LOWERCASE.add("tif");
        RGB_IMAGE_SUFFIXES_LOWERCASE.add("tiff");
        RAW_FORMAT_SUFFIXES_LOWERCASE.add("arw");
        RAW_FORMAT_SUFFIXES_LOWERCASE.add("cr2");
        RAW_FORMAT_SUFFIXES_LOWERCASE.add("crw");
        RAW_FORMAT_SUFFIXES_LOWERCASE.add("dcr");
        RAW_FORMAT_SUFFIXES_LOWERCASE.add("dng");
        RAW_FORMAT_SUFFIXES_LOWERCASE.add("mrw");
        RAW_FORMAT_SUFFIXES_LOWERCASE.add("nef");
        RAW_FORMAT_SUFFIXES_LOWERCASE.add("srw");
        SUPPORTED_SUFFIXES_LOWERCASE.addAll(RGB_IMAGE_SUFFIXES_LOWERCASE);
        SUPPORTED_SUFFIXES_LOWERCASE.addAll(RAW_FORMAT_SUFFIXES_LOWERCASE);
    }
}

