/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.image.thumbnail;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.lib.swing.FileChooserHelper;
import org.jphototagger.lib.swing.FileChooserProperties;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.StringUtil;
import org.openide.util.Lookup;

public class DcrawThumbnailCreatorSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton buttonChooseFile;
    private JButton buttonRemoveFile;
    private JLabel labelFile;
    private JLabel labelInfo;
    private JPanel panelChooseFile;

    public DcrawThumbnailCreatorSettingsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        MnemonicUtil.setMnemonics((Container)this);
        this.readPreferences();
        this.buttonRemoveFile.setEnabled(StringUtil.hasContent((String)this.labelFile.getText()));
    }

    private void chooseFile() {
        FileChooserProperties props = this.createFileChooserProperties();
        File dcraw = FileChooserHelper.chooseFile((FileChooserProperties)props);
        if (dcraw != null) {
            this.labelFile.setText(dcraw.getAbsolutePath());
            this.labelFile.setIcon(IconUtil.getSystemIcon((File)dcraw));
            this.buttonRemoveFile.setEnabled(true);
            this.persistFile();
        }
    }

    private FileChooserProperties createFileChooserProperties() {
        FileChooserProperties props = new FileChooserProperties();
        props.currentDirectoryPath(this.getDirectoryPath());
        props.dialogTitle(Bundle.getString(DcrawThumbnailCreatorSettingsPanel.class, (String)"DcrawThumbnailCreatorSettingsPanel.FileChooser.Title", (Object[])new Object[0]));
        props.multiSelectionEnabled(false);
        props.fileSelectionMode(0);
        props.propertyKeyPrefix("DcrawThumbnailCreatorPanel.FileChooser");
        return props;
    }

    private String getDirectoryPath() {
        File file = new File(this.labelFile.getText());
        if (file.isFile()) {
            String parent = file.getParent();
            return parent == null ? "" : parent;
        }
        return "";
    }

    private void removeFile() {
        this.labelFile.setText("");
        this.buttonRemoveFile.setEnabled(false);
        this.persistFile();
    }

    private void persistFile() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        String filepath = this.labelFile.getText();
        if (StringUtil.hasContent((String)filepath)) {
            prefs.setString("DCRawThumbnailCreator.DCRawFilePath", filepath);
        } else {
            prefs.removeKey("DCRawThumbnailCreator.DCRawFilePath");
        }
    }

    private void readPreferences() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        if (prefs.containsKey("DCRawThumbnailCreator.DCRawFilePath")) {
            File file = new File(prefs.getString("DCRawThumbnailCreator.DCRawFilePath"));
            this.labelFile.setText(file.getAbsolutePath());
            this.labelFile.setIcon(file.isFile() ? IconUtil.getSystemIcon((File)file) : IconUtil.getImageIcon(DcrawThumbnailCreatorSettingsPanel.class, (String)"error.png"));
        }
    }

    private void initComponents() {
        this.labelInfo = new JLabel();
        this.panelChooseFile = new JPanel();
        this.labelFile = new JLabel();
        this.buttonChooseFile = new JButton();
        this.buttonRemoveFile = new JButton();
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/image/thumbnail/Bundle");
        this.setBorder(BorderFactory.createTitledBorder(bundle.getString("DcrawThumbnailCreatorSettingsPanel.border.title")));
        this.setLayout(new GridBagLayout());
        this.labelInfo.setText(bundle.getString("DcrawThumbnailCreatorSettingsPanel.labelInfo.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.labelInfo, gridBagConstraints);
        this.panelChooseFile.setLayout(new GridBagLayout());
        this.labelFile.setText(" ");
        this.labelFile.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelChooseFile.add((Component)this.labelFile, gridBagConstraints);
        this.buttonChooseFile.setText(bundle.getString("DcrawThumbnailCreatorSettingsPanel.buttonChooseFile.text"));
        this.buttonChooseFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DcrawThumbnailCreatorSettingsPanel.this.buttonChooseFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelChooseFile.add((Component)this.buttonChooseFile, gridBagConstraints);
        this.buttonRemoveFile.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/image/thumbnail/delete.png")));
        this.buttonRemoveFile.setEnabled(false);
        this.buttonRemoveFile.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveFile.setPreferredSize(new Dimension(18, 18));
        this.buttonRemoveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DcrawThumbnailCreatorSettingsPanel.this.buttonRemoveFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelChooseFile.add((Component)this.buttonRemoveFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.add((Component)this.panelChooseFile, gridBagConstraints);
    }

    private void buttonChooseFileActionPerformed(ActionEvent evt) {
        this.chooseFile();
    }

    private void buttonRemoveFileActionPerformed(ActionEvent evt) {
        this.removeFile();
    }
}

