/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.image.thumbnail;

import com.imagero.reader.IOParameterBlock;
import com.imagero.reader.ImageProcOptions;
import com.imagero.reader.ImageReader;
import com.imagero.reader.Imagero;
import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.domain.thumbnails.ExternalThumbnailCreationCommand;
import org.jphototagger.domain.thumbnails.ThumbnailCreator;
import org.jphototagger.image.thumbnail.DcrawThumbnailCreatorSettingsPanel;
import org.jphototagger.image.util.ThumbnailCreatorService;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.runtime.External;
import org.jphototagger.lib.runtime.ProcessResult;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.SystemUtil;
import org.openide.util.Lookup;

public final class DcrawThumbnailCreator
implements ThumbnailCreator,
ExternalThumbnailCreationCommand {
    private static final Set<String> SUPPORTED_SUFFIXES_LOWERCASE = new HashSet<String>();
    private static final Logger LOGGER = Logger.getLogger(DcrawThumbnailCreator.class.getName());
    private final Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
    private boolean dcrawResolved;
    private File dcraw;

    public DcrawThumbnailCreator() {
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process((Object)this);
    }

    public Image createThumbnail(File file) {
        if (!this.canCreateThumbnail(file) || !file.exists()) {
            return null;
        }
        this.resolveDcraw();
        if (this.dcraw == null) {
            return null;
        }
        ProcessResult output = this.getExternalOutput(file);
        if (output != null && !output.hasStdErrBytes() && output.hasStdOutBytes()) {
            try {
                int maxLength = ThumbnailCreatorService.readMaxThumbnailWidthFromPreferences();
                IOParameterBlock ioParamBlock = new IOParameterBlock();
                ImageProcOptions procOptions = new ImageProcOptions();
                ioParamBlock.setSource(output.getStdOutBytes());
                procOptions.setSource(ioParamBlock);
                procOptions.setScale(maxLength);
                Image image = Imagero.readImage((ImageProcOptions)procOptions);
                ImageReader reader = procOptions.getImageReader();
                if (reader != null) {
                    reader.close();
                }
                return image;
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, null, t);
            }
        }
        return null;
    }

    private ProcessResult getExternalOutput(File file) {
        String command = "\"" + this.dcraw.getAbsolutePath() + "\" -c -h -T \"" + file.getAbsolutePath() + "\"";
        LOGGER.log(Level.INFO, "Creating thumbnail with dcraw; command: {0}", command);
        return External.executeWaitForTermination((String)command, (long)this.getMaxMillisecondsToTerminate());
    }

    public String getThumbnailCreationCommand() {
        if (this.dcraw == null) {
            return null;
        }
        return "\"" + this.dcraw.getAbsolutePath() + "\" \"%s\" %i";
    }

    public boolean isEnabled() {
        this.resolveDcraw();
        return this.dcraw != null;
    }

    private long getMaxMillisecondsToTerminate() {
        int maxSeconds = this.prefs.getInt("UserSettings.MaximumSecondsToTerminateExternalPrograms");
        if (maxSeconds < 60) {
            maxSeconds = 60;
        }
        return maxSeconds * 1000;
    }

    private void resolveDcraw() {
        if (this.dcraw != null || this.dcrawResolved) {
            return;
        }
        LOGGER.info("Trying to resolve dcraw...");
        this.resolveDcrawFromPreferences();
        if (this.dcraw == null) {
            this.resolveDcrawFromFileJptDir();
        }
        this.dcrawResolved = true;
    }

    private void resolveDcrawFromPreferences() {
        LOGGER.info("Looking for dcraw path in preferences key 'DCRawThumbnailCreator.DCRawFilePath'");
        String path = this.prefs.getString("DCRawThumbnailCreator.DCRawFilePath").trim();
        if (path.isEmpty()) {
            LOGGER.info("Preferences do not contain a key named 'DCRawThumbnailCreator.DCRawFilePath'");
        } else {
            File candidate = new File(path);
            if (candidate.isFile()) {
                this.dcraw = candidate;
                LOGGER.log(Level.INFO, "Using dcraw ''{0}''", candidate);
            } else {
                LOGGER.log(Level.INFO, "''{0}'' is not a file", candidate);
            }
        }
    }

    private void resolveDcrawFromFileJptDir() {
        LOGGER.info("Looking for dcraw within JPhotoTagger's directory");
        File jarDir = FileUtil.getJarDirectory(DcrawThumbnailCreator.class);
        if (jarDir != null) {
            String architecture = SystemUtil.guessVmArchitecture();
            if (!architecture.isEmpty()) {
                String dcrawSuffix = this.getSupportedOsDcrawSuffix(architecture);
                if (!dcrawSuffix.isEmpty()) {
                    File candidate = new File(jarDir.getAbsolutePath() + File.separator + dcrawSuffix);
                    if (candidate.isFile()) {
                        this.dcraw = candidate;
                        LOGGER.log(Level.INFO, "Using dcraw ''{0}''", candidate);
                    } else {
                        LOGGER.log(Level.INFO, "''{0}'' is not a file", candidate);
                    }
                } else {
                    LOGGER.log(Level.INFO, "JPhotoTagger does not have a dcraw executable for {0}", System.getProperty("os.name"));
                }
            } else {
                LOGGER.info("Can't resolve Architecture of the Java Virtual Machine to get dcraw subdirectory");
            }
        } else {
            LOGGER.info("Can't resolve directory of this JAR");
        }
    }

    private String getSupportedOsDcrawSuffix(String architecture) {
        String osNameLc = System.getProperty("os.name").toLowerCase();
        String dcrawSubdir = "dcraw" + File.separator;
        if (osNameLc.contains("windows")) {
            return dcrawSubdir + "win" + architecture + File.separator + "dcraw.exe";
        }
        if (osNameLc.contains("linux")) {
            return dcrawSubdir + "linux" + architecture + File.separator + "dcraw";
        }
        if (osNameLc.contains("mac")) {
            return dcrawSubdir + "mac" + architecture + File.separator + "dcraw";
        }
        return "";
    }

    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void preferencesChanged(PreferencesChangedEvent evt) {
        if ("DCRawThumbnailCreator.DCRawFilePath".equals(evt.getKey())) {
            this.dcraw = null;
            this.resolveDcraw();
        }
    }

    public boolean canCreateThumbnail(File file) {
        String suffix = FileUtil.getSuffix((File)file);
        return !suffix.isEmpty() && SUPPORTED_SUFFIXES_LOWERCASE.contains(suffix.toLowerCase());
    }

    public Set<String> getAllSupportedFileTypeSuffixes() {
        return this.getSupportedRawFormatFileTypeSuffixes();
    }

    public Set<String> getSupportedRawFormatFileTypeSuffixes() {
        return Collections.unmodifiableSet(SUPPORTED_SUFFIXES_LOWERCASE);
    }

    public Component getSettingsComponent() {
        return new DcrawThumbnailCreatorSettingsPanel();
    }

    public int getPosition() {
        return 100;
    }

    public String getDisplayName() {
        return Bundle.getString(DcrawThumbnailCreator.class, (String)"DcrawThumbnailCreator.DisplayName", (Object[])new Object[0]);
    }

    public int getPriority() {
        return 100;
    }

    public String toString() {
        return this.getDisplayName();
    }

    static {
        SUPPORTED_SUFFIXES_LOWERCASE.addAll(Arrays.asList("arw", "cr2", "crw", "dcr", "dng", "mrw", "nef", "raw", "rw2", "srw"));
    }
}

