/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.iptcmodule;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.concurrent.CancelRequest;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.api.preferences.PreferencesHints;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.domain.filefilter.FileFilterUtil;
import org.jphototagger.iptcmodule.ConvertIptcToXmp;
import org.jphototagger.iptcmodule.IptcCharsetComboBoxModel;
import org.jphototagger.lib.api.LookAndFeelChangedEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.io.filefilter.DirectoryFilter;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.DirectoryChooser;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.SelectRootFilesPanel;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class IptcToXmpDialog
extends Dialog
implements ProgressListener {
    private static final String KEY_DIRECTORY_NAME = "org.jphototagger.program.view.dialogs.IptcToXmpDialog.LastDirectory";
    private static final String KEY_INCLUDE_SUBDIRS = "org.jphototagger.program.view.dialogs.IptcToXmpDialog.IncludeSubdirectories";
    private static final long serialVersionUID = 1L;
    private final transient CancelChooseRequest cancelChooseRequest = new CancelChooseRequest();
    private File directory = new File("");
    private boolean cancel = true;
    private List<File> files;
    private JButton buttonCancel;
    private JButton buttonChooseDirectory;
    private JButton buttonStart;
    private JCheckBox checkBoxIncludeSubdirectories;
    private JComboBox<Object> comboBoxIptcCharset;
    private JLabel labelDirectoryName;
    private JLabel labelDirectoryPrompt;
    private JLabel labelInfo;
    private JLabel labelIptcCharset;
    private JProgressBar progressBar;

    public IptcToXmpDialog() {
        super(ComponentUtil.findFrameWithIcon(), false);
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.setHelpPage();
        MnemonicUtil.setMnemonics((Container)((Object)this));
        AnnotationProcessor.process((Object)((Object)this));
    }

    private void setHelpPage() {
        this.setHelpPageUrl(Bundle.getString(IptcToXmpDialog.class, (String)"IptcToXmpDialog.HelpPage", (Object[])new Object[0]));
    }

    public synchronized void setFiles(List<File> files) {
        if (files == null) {
            throw new NullPointerException("files == null");
        }
        this.files = new ArrayList<File>(files);
    }

    private void checkClose() {
        if (this.cancel) {
            this.setVisible(false);
        } else {
            this.errorMessageWaitBeforeClose();
        }
    }

    private void chooseDirectory() {
        List hideRootFiles = SelectRootFilesPanel.readPersistentRootFiles((String)"UserSettings.HideRootFilesFromDirectoriesTab");
        DirectoryChooser.Option options = this.getDirChooserOptionShowHiddenDirs();
        DirectoryChooser dlg = new DirectoryChooser(ComponentUtil.findFrameWithIcon(), this.directory, (Collection)hideRootFiles, new DirectoryChooser.Option[]{options});
        dlg.setPreferencesKey("IptcToXmpDialog.DirChooser");
        dlg.setVisible(true);
        this.toFront();
        if (dlg.isAccepted()) {
            this.directory = (File)dlg.getSelectedDirectories().get(0);
            this.labelDirectoryName.setText(this.directory.getAbsolutePath());
            this.setIconToDirectoryLabel();
            this.progressBar.setValue(0);
            this.buttonStart.setEnabled(true);
        }
    }

    private DirectoryChooser.Option getDirChooserOptionShowHiddenDirs() {
        return this.isAcceptHiddenDirectories() ? DirectoryChooser.Option.DISPLAY_HIDDEN_DIRECTORIES : DirectoryChooser.Option.NO_OPTION;
    }

    private boolean isAcceptHiddenDirectories() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.IsAcceptHiddenDirectories") ? prefs.getBoolean("UserSettings.IsAcceptHiddenDirectories") : false;
    }

    private void errorMessageWaitBeforeClose() {
        String message = Bundle.getString(IptcToXmpDialog.class, (String)"IptcToXmpDialog.Error.CancelBeforeClose", (Object[])new Object[0]);
        MessageDisplayer.error((Component)((Object)this), (String)message);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.readProperties();
            if (this.files == null) {
                this.init();
            } else {
                this.start();
            }
        } else {
            this.writeProperties();
            this.dispose();
        }
        super.setVisible(visible);
    }

    private void setIptcCharsetFromUserSettings() {
        this.comboBoxIptcCharset.getModel().setSelectedItem(this.getIptcCharset());
    }

    private String getIptcCharset() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        String charset = prefs.getString("UserSettings.IptcCharset");
        return charset.isEmpty() ? "ISO-8859-1" : charset;
    }

    private void readProperties() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        prefs.applyComponentSettings((Component)((Object)this), new PreferencesHints(new PreferencesHints.Option[]{PreferencesHints.Option.SET_TABBED_PANE_CONTENT}));
        this.checkBoxIncludeSubdirectories.setSelected(prefs.getBoolean(KEY_INCLUDE_SUBDIRS));
        this.setIptcCharsetFromUserSettings();
        this.directory = new File(prefs.getString(KEY_DIRECTORY_NAME));
        this.setIconToDirectoryLabel();
    }

    private void writeProperties() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        prefs.setComponent((Component)((Object)this), new PreferencesHints(new PreferencesHints.Option[]{PreferencesHints.Option.SET_TABBED_PANE_CONTENT}));
        prefs.setString(KEY_DIRECTORY_NAME, this.directory.getAbsolutePath());
        prefs.setBoolean(KEY_INCLUDE_SUBDIRS, this.checkBoxIncludeSubdirectories.isSelected());
    }

    private void setIconToDirectoryLabel() {
        if (this.directory != null && this.directory.isDirectory()) {
            this.labelDirectoryName.setIcon(FileSystemView.getFileSystemView().getSystemIcon(this.directory));
        }
    }

    private void init() {
        boolean directoryExists = this.directory.exists() && this.directory.isDirectory();
        this.buttonStart.setEnabled(directoryExists);
        if (directoryExists) {
            this.labelDirectoryName.setText(this.directory.getAbsolutePath());
            this.setIconToDirectoryLabel();
        }
    }

    private void start() {
        new ConvertThread(this).start();
    }

    private void setIptcCharset() {
        this.setIptcCharset(this.comboBoxIptcCharset.getSelectedItem().toString());
    }

    private void setIptcCharset(String charset) {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        prefs.setString("UserSettings.IptcCharset", charset);
    }

    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void applySettings(PreferencesChangedEvent evt) {
        if ("UserSettings.IptcCharset".equals(evt.getKey())) {
            this.setIptcCharsetFromUserSettings();
        }
    }

    private void cancel() {
        this.cancel = true;
        this.cancelChooseRequest.cancel = true;
        this.setVisible(false);
    }

    private List<File> getFiles() {
        if (this.files == null) {
            ArrayList<File> directories = new ArrayList<File>();
            directories.add(this.directory);
            if (this.checkBoxIncludeSubdirectories.isSelected()) {
                DirectoryFilter.Option showHiddenFiles = this.getDirFilterOptionShowHiddenFiles();
                directories.addAll(FileUtil.getSubDirectoriesRecursive((File)this.directory, (CancelRequest)this.cancelChooseRequest, (DirectoryFilter.Option[])new DirectoryFilter.Option[]{showHiddenFiles}));
            }
            return FileFilterUtil.getImageFilesOfDirectories(directories);
        }
        return Collections.unmodifiableList(this.files);
    }

    private DirectoryFilter.Option getDirFilterOptionShowHiddenFiles() {
        return this.isAcceptHiddenDirectories() ? DirectoryFilter.Option.ACCEPT_HIDDEN_FILES : DirectoryFilter.Option.NO_OPTION;
    }

    private void setEnabledButtons() {
        this.buttonStart.setEnabled(this.cancel);
        this.buttonCancel.setEnabled(!this.cancel);
        this.cancelChooseRequest.cancel = this.cancel;
        this.buttonChooseDirectory.setEnabled(this.cancel);
    }

    private void checkCancel(ProgressEvent evt) {
        if (this.cancel) {
            evt.setCancel(true);
        }
    }

    public void progressStarted(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                IptcToXmpDialog.this.progressBar.setMinimum(evt.getMinimum());
                IptcToXmpDialog.this.progressBar.setMaximum(evt.getMaximum());
                IptcToXmpDialog.this.progressBar.setValue(evt.getValue());
                IptcToXmpDialog.this.checkCancel(evt);
            }
        });
    }

    public void progressPerformed(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                IptcToXmpDialog.this.progressBar.setValue(evt.getValue());
                IptcToXmpDialog.this.checkCancel(evt);
            }
        });
    }

    public void progressEnded(final ProgressEvent evt) {
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                IptcToXmpDialog.this.progressBar.setValue(evt.getValue());
                IptcToXmpDialog.this.cancel = true;
                IptcToXmpDialog.this.setEnabledButtons();
                IptcToXmpDialog.this.setVisible(false);
            }
        });
    }

    protected void escape() {
        this.checkClose();
    }

    @EventSubscriber(eventClass=LookAndFeelChangedEvent.class)
    public void lookAndFeelChanged(LookAndFeelChangedEvent evt) {
        SwingUtilities.updateComponentTreeUI((Component)((Object)this));
    }

    private void initComponents() {
        this.labelInfo = new JLabel();
        this.labelDirectoryPrompt = new JLabel();
        this.buttonChooseDirectory = new JButton();
        this.labelDirectoryName = new JLabel();
        this.checkBoxIncludeSubdirectories = new JCheckBox();
        this.labelIptcCharset = new JLabel();
        this.comboBoxIptcCharset = new JComboBox();
        this.progressBar = new JProgressBar();
        this.buttonCancel = new JButton();
        this.buttonStart = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/iptcmodule/Bundle");
        this.setTitle(bundle.getString("IptcToXmpDialog.title"));
        this.setName("Form");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                IptcToXmpDialog.this.formWindowClosing(evt);
            }
        });
        this.labelInfo.setText(bundle.getString("IptcToXmpDialog.labelInfo.text"));
        this.labelInfo.setName("labelInfo");
        this.labelDirectoryPrompt.setText(bundle.getString("IptcToXmpDialog.labelDirectoryPrompt.text"));
        this.labelDirectoryPrompt.setName("labelDirectoryPrompt");
        this.buttonChooseDirectory.setText(bundle.getString("IptcToXmpDialog.buttonChooseDirectory.text"));
        this.buttonChooseDirectory.setName("buttonChooseDirectory");
        this.buttonChooseDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IptcToXmpDialog.this.buttonChooseDirectoryActionPerformed(evt);
            }
        });
        this.labelDirectoryName.setBorder(BorderFactory.createEtchedBorder());
        this.labelDirectoryName.setName("labelDirectoryName");
        this.checkBoxIncludeSubdirectories.setText(bundle.getString("IptcToXmpDialog.checkBoxIncludeSubdirectories.text"));
        this.checkBoxIncludeSubdirectories.setName("checkBoxIncludeSubdirectories");
        this.labelIptcCharset.setLabelFor(this.comboBoxIptcCharset);
        this.labelIptcCharset.setText(bundle.getString("IptcToXmpDialog.labelIptcCharset.text"));
        this.labelIptcCharset.setName("labelIptcCharset");
        this.comboBoxIptcCharset.setModel(new IptcCharsetComboBoxModel());
        this.comboBoxIptcCharset.setName("comboBoxIptcCharset");
        this.comboBoxIptcCharset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IptcToXmpDialog.this.comboBoxIptcCharsetActionPerformed(evt);
            }
        });
        this.progressBar.setName("progressBar");
        this.buttonCancel.setText(bundle.getString("IptcToXmpDialog.buttonCancel.text"));
        this.buttonCancel.setEnabled(false);
        this.buttonCancel.setName("buttonCancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IptcToXmpDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonStart.setText(bundle.getString("IptcToXmpDialog.buttonStart.text"));
        this.buttonStart.setEnabled(false);
        this.buttonStart.setName("buttonStart");
        this.buttonStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IptcToXmpDialog.this.buttonStartActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelInfo, -1, 768, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.labelDirectoryPrompt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 591, Short.MAX_VALUE).addComponent(this.buttonChooseDirectory)).addComponent(this.labelDirectoryName, GroupLayout.Alignment.TRAILING, -1, 768, Short.MAX_VALUE)).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.buttonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonStart)).addComponent(this.progressBar, -1, 762, Short.MAX_VALUE)).addGap(16, 16, 16)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxIncludeSubdirectories).addGroup(layout.createSequentialGroup().addComponent(this.labelIptcCharset).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxIptcCharset, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.labelInfo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelDirectoryPrompt).addComponent(this.buttonChooseDirectory)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelDirectoryName, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxIncludeSubdirectories).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelIptcCharset, -2, 12, -2).addComponent(this.comboBoxIptcCharset, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.progressBar, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonStart).addComponent(this.buttonCancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.checkClose();
    }

    private void buttonStartActionPerformed(ActionEvent evt) {
        this.start();
    }

    private void buttonChooseDirectoryActionPerformed(ActionEvent evt) {
        this.chooseDirectory();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.cancel();
    }

    private void comboBoxIptcCharsetActionPerformed(ActionEvent evt) {
        this.setIptcCharset();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                IptcToXmpDialog dialog = new IptcToXmpDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private static class CancelChooseRequest
    implements CancelRequest {
        boolean cancel;

        private CancelChooseRequest() {
        }

        public boolean isCancel() {
            return this.cancel;
        }
    }

    private class ConvertThread
    extends Thread {
        private final ProgressListener progressListener;

        ConvertThread(ProgressListener progressListener) {
            super("JPhotoTagger: Writing IPTC to XMP sidecar files");
            this.progressListener = progressListener;
        }

        @Override
        public void run() {
            IptcToXmpDialog.this.cancel = false;
            IptcToXmpDialog.this.setEnabledButtons();
            ConvertIptcToXmp convertIptcToXmp = new ConvertIptcToXmp(IptcToXmpDialog.this.getFiles());
            convertIptcToXmp.addProgressListener(this.progressListener);
            Thread thread = new Thread((Runnable)convertIptcToXmp, "JPhotoTagger: Writing IPTC to XMP sidecar files");
            thread.start();
        }
    }
}

