/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.iptcmodule;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jphototagger.domain.repository.UserDefinedFileTypesRepository;
import org.jphototagger.iptc.IptcEntry;
import org.jphototagger.iptc.IptcEntryComparator;
import org.jphototagger.iptc.IptcIgnoreCache;
import org.jphototagger.iptc.IptcMetadata;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.swing.TableModelExt;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class IptcTableModel
extends TableModelExt {
    private static final long serialVersionUID = 1L;
    private File file;
    private List<IptcEntry> iptcEntries = new ArrayList<IptcEntry>();

    public IptcTableModel() {
        this.addColumnHeaders();
    }

    public void setFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        this.removeAllRows();
        if (IptcIgnoreCache.INSTANCE.isIgnore(file) || this.isUserDefinedFileType(file)) {
            return;
        }
        this.file = file;
        this.iptcEntries = IptcMetadata.getIptcEntries((File)file);
        IptcIgnoreCache.INSTANCE.setIgnore(file, this.iptcEntries.isEmpty());
        this.addRows();
    }

    private boolean isUserDefinedFileType(File file) {
        UserDefinedFileTypesRepository repo = (UserDefinedFileTypesRepository)Lookup.getDefault().lookup(UserDefinedFileTypesRepository.class);
        String fileSuffix = FileUtil.getSuffix((File)file);
        return repo.existsUserDefinedFileTypeWithSuffix(fileSuffix);
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    private void addRows() {
        Collections.sort(this.iptcEntries, IptcEntryComparator.INSTANCE);
        for (IptcEntry entry : this.iptcEntries) {
            super.addRow(this.getTableRow(entry));
        }
    }

    private Object[] getTableRow(IptcEntry entry) {
        return new Object[]{entry, entry, entry};
    }

    private void addColumnHeaders() {
        this.addColumn(Bundle.getString(IptcTableModel.class, (String)"IptcTableModel.HeaderColumn.1", (Object[])new Object[0]));
        this.addColumn(Bundle.getString(IptcTableModel.class, (String)"IptcTableModel.HeaderColumn.2", (Object[])new Object[0]));
        this.addColumn(Bundle.getString(IptcTableModel.class, (String)"IptcTableModel.HeaderColumn.3", (Object[])new Object[0]));
    }
}

