/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.iptcmodule;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.api.windows.OptionPageProvider;
import org.jphototagger.iptcmodule.IptcCharsetComboBoxModel;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public class IptcSettingsPanel
extends JPanel
implements OptionPageProvider {
    private static final long serialVersionUID = 1L;
    private JCheckBox checkBoxDisplayIptc;
    private JComboBox<Object> comboBoxIptcCharset;
    private JLabel labelIptcCharset;

    public IptcSettingsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.setIptcCharsetFromPreferences();
        this.setDisplayIptcFromPreferences();
        AnnotationProcessor.process((Object)this);
    }

    private void setSelectedIptcCharsetToPreferences() {
        String charset = this.comboBoxIptcCharset.getSelectedItem().toString();
        Preferences preferences = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        preferences.setString("UserSettings.IptcCharset", charset);
    }

    private void setIptcCharsetFromPreferences() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        String charset = prefs.getString("UserSettings.IptcCharset");
        String iptcCharSet = charset.isEmpty() ? "ISO-8859-1" : charset;
        this.comboBoxIptcCharset.getModel().setSelectedItem(iptcCharSet);
    }

    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void preferencesChanged(PreferencesChangedEvent evt) {
        if ("UserSettings.IptcCharset".equals(evt.getKey())) {
            this.setIptcCharsetFromPreferences();
        } else if ("UserSettings.DisplayIptc".equals(evt.getKey())) {
            this.setDisplayIptcFromPreferences();
        }
    }

    private void setDisplayIptcToPreferences() {
        boolean display = this.checkBoxDisplayIptc.isSelected();
        Preferences preferences = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        preferences.setBoolean("UserSettings.DisplayIptc", display);
    }

    private void setDisplayIptcFromPreferences() {
        Preferences preferences = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        boolean isPreferred = preferences.containsKey("UserSettings.DisplayIptc") ? preferences.getBoolean("UserSettings.DisplayIptc") : false;
        this.checkBoxDisplayIptc.setSelected(isPreferred);
    }

    public Component getComponent() {
        return this;
    }

    public String getTitle() {
        return Bundle.getString(IptcSettingsPanel.class, (String)"IptcSettingsPanel.Title", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return null;
    }

    public boolean isMiscOptionPage() {
        return true;
    }

    public int getPosition() {
        return 100;
    }

    private void initComponents() {
        this.comboBoxIptcCharset = new JComboBox();
        this.labelIptcCharset = new JLabel();
        this.checkBoxDisplayIptc = new JCheckBox();
        this.setName("Form");
        this.comboBoxIptcCharset.setModel(new IptcCharsetComboBoxModel());
        this.comboBoxIptcCharset.setName("comboBoxIptcCharset");
        this.comboBoxIptcCharset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IptcSettingsPanel.this.comboBoxIptcCharsetActionPerformed(evt);
            }
        });
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/iptcmodule/Bundle");
        this.labelIptcCharset.setText(bundle.getString("IptcSettingsPanel.labelIptcCharset.text"));
        this.labelIptcCharset.setName("labelIptcCharset");
        this.checkBoxDisplayIptc.setText(bundle.getString("IptcSettingsPanel.checkBoxDisplayIptc.text"));
        this.checkBoxDisplayIptc.setName("checkBoxDisplayIptc");
        this.checkBoxDisplayIptc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IptcSettingsPanel.this.checkBoxDisplayIptcActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labelIptcCharset).addGap(5, 5, 5).addComponent(this.comboBoxIptcCharset, -2, -1, -2)).addComponent(this.checkBoxDisplayIptc)).addContainerGap(94, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.labelIptcCharset)).addComponent(this.comboBoxIptcCharset, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.checkBoxDisplayIptc).addContainerGap(148, Short.MAX_VALUE)));
    }

    private void comboBoxIptcCharsetActionPerformed(ActionEvent evt) {
        this.setSelectedIptcCharsetToPreferences();
    }

    private void checkBoxDisplayIptcActionPerformed(ActionEvent evt) {
        this.setDisplayIptcToPreferences();
    }
}

