/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.iptcmodule;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import javax.swing.text.Document;
import org.jphototagger.api.branding.TableLookAndFeel;
import org.jphototagger.iptc.IptcEntry;
import org.jphototagger.iptcmodule.ExportIptcToXmpOfSelectedFilesAction;
import org.jphototagger.iptcmodule.IptcTableModel;
import org.jphototagger.lib.swing.TableTextFilter;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.swing.util.TableUtil;
import org.jphototagger.lib.util.StringUtil;
import org.jphototagger.lib.util.Translation;
import org.openide.util.Lookup;

public class IptcPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final IptcTableModel iptcTableModel = new IptcTableModel();
    private final IptcTableCellRenderer iptcTableCellRenderer = new IptcTableCellRenderer();
    private JButton buttonIptcToXmp;
    private JLabel labeTTableIptcFilter;
    private JPanel panelTableIptcFilter;
    private JScrollPane scrollPaneIptc;
    private JTable tableIptc;
    private JTextField textFieldTableIptcFilter;

    public IptcPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.tableIptc.setDefaultRenderer(Object.class, this.iptcTableCellRenderer);
        this.setIptcTableTextFilter();
        this.setIptcTableComparator();
        MnemonicUtil.setMnemonics((Container)this);
    }

    private void setIptcTableTextFilter() {
        TableRowSorter rowSorter = (TableRowSorter)this.tableIptc.getRowSorter();
        TableStringConverter stringConverter = this.iptcTableCellRenderer.createTableStringConverter();
        Document document = this.textFieldTableIptcFilter.getDocument();
        TableTextFilter tableTextFilter = new TableTextFilter(this.tableIptc, stringConverter);
        rowSorter.setStringConverter(stringConverter);
        document.addDocumentListener((DocumentListener)tableTextFilter);
    }

    private void setIptcTableComparator() {
        TableRowSorter rowSorter = (TableRowSorter)this.tableIptc.getRowSorter();
        Comparator column0Comparator = this.iptcTableCellRenderer.createColumn0Comparator();
        Comparator column1Comparator = this.iptcTableCellRenderer.createColumn1Comparator();
        Comparator column2Comparator = this.iptcTableCellRenderer.createColumn2Comparator();
        rowSorter.setComparator(0, column0Comparator);
        rowSorter.setComparator(1, column1Comparator);
        rowSorter.setComparator(2, column2Comparator);
    }

    private void resizeTable() {
        TableUtil.resizeColumnWidthsToFit((JTable)this.tableIptc);
        ComponentUtil.forceRepaint((Component)this.tableIptc);
    }

    void removeAllRows() {
        this.iptcTableModel.removeAllRows();
    }

    void setFile(File file) {
        this.iptcTableModel.setFile(file);
        this.resizeTable();
    }

    private void initComponents() {
        this.panelTableIptcFilter = new JPanel();
        this.labeTTableIptcFilter = new JLabel();
        this.textFieldTableIptcFilter = new JTextField();
        this.scrollPaneIptc = new JScrollPane();
        this.tableIptc = new JTable();
        this.buttonIptcToXmp = new JButton();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.panelTableIptcFilter.setName("panelTableIptcFilter");
        this.panelTableIptcFilter.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/iptcmodule/Bundle");
        this.labeTTableIptcFilter.setText(bundle.getString("IptcPanel.labeTTableIptcFilter.text"));
        this.labeTTableIptcFilter.setName("labeTTableIptcFilter");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelTableIptcFilter.add((Component)this.labeTTableIptcFilter, gridBagConstraints);
        this.textFieldTableIptcFilter.setName("textFieldTableIptcFilter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelTableIptcFilter.add((Component)this.textFieldTableIptcFilter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.panelTableIptcFilter, gridBagConstraints);
        this.scrollPaneIptc.setName("scrollPaneIptc");
        this.tableIptc.setAutoCreateRowSorter(true);
        this.tableIptc.setModel((TableModel)((Object)this.iptcTableModel));
        this.tableIptc.setAutoResizeMode(0);
        this.tableIptc.setName("tableIptc");
        this.scrollPaneIptc.setViewportView(this.tableIptc);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scrollPaneIptc, gridBagConstraints);
        this.buttonIptcToXmp.setAction(new ExportIptcToXmpOfSelectedFilesAction());
        this.buttonIptcToXmp.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_xmp.png")));
        this.buttonIptcToXmp.setText(bundle.getString("IptcPanel.buttonIptcToXmp.text"));
        this.buttonIptcToXmp.setToolTipText(bundle.getString("IptcPanel.buttonIptcToXmp.toolTipText"));
        this.buttonIptcToXmp.setMargin(new Insets(2, 2, 2, 2));
        this.buttonIptcToXmp.setName("buttonIptcToXmp");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        this.add((Component)this.buttonIptcToXmp, gridBagConstraints);
    }

    private final class IptcTableCellRenderer
    implements TableCellRenderer {
        private final Translation TRANSLATION = new Translation(IptcPanel.class, "IptcRecordDataSetNumberTranslations");
        private final TableLookAndFeel lookAndFeel = (TableLookAndFeel)Lookup.getDefault().lookup(TableLookAndFeel.class);
        private final JLabel cellLabel = new JLabel();

        private IptcTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String css;
            if (this.lookAndFeel == null) {
                return new JLabel(StringUtil.toStringNullToEmptyString((Object)value));
            }
            this.lookAndFeel.setTableCellColor((JComponent)this.cellLabel, isSelected);
            IptcEntry iptcEntry = (IptcEntry)value;
            String entryNumber = this.getIptcEntryNumber(iptcEntry);
            boolean isRowHeader = column == 0;
            int maxChars = isRowHeader ? this.lookAndFeel.getRowHeaderMaxChars() : this.lookAndFeel.getCellMaxChars();
            String string = css = isRowHeader ? this.lookAndFeel.getRowHeaderCss() : this.lookAndFeel.getCellCss();
            if (column == 0) {
                this.lookAndFeel.setTableCellFont((JComponent)this.cellLabel);
                TableUtil.embedTableCellTextInHtml((JTable)table, (int)row, (JLabel)this.cellLabel, (String)entryNumber, (int)maxChars, (String)css);
            } else if (column == 1) {
                this.lookAndFeel.setTableRowHeaderFont((JComponent)this.cellLabel);
                String text = this.TRANSLATION.translate(entryNumber, entryNumber);
                TableUtil.embedTableCellTextInHtml((JTable)table, (int)row, (JLabel)this.cellLabel, (String)text, (int)maxChars, (String)css);
            } else {
                this.lookAndFeel.setTableCellFont((JComponent)this.cellLabel);
                TableUtil.embedTableCellTextInHtml((JTable)table, (int)row, (JLabel)this.cellLabel, (String)iptcEntry.getData(), (int)maxChars, (String)css);
            }
            return this.cellLabel;
        }

        private String getIptcEntryNumber(IptcEntry iptcEntry) {
            if (iptcEntry == null) {
                return "";
            }
            int recordNumber = iptcEntry.getRecordNumber();
            int dataSetNumber = iptcEntry.getDataSetNumber();
            return Integer.toString(recordNumber) + ":" + Integer.toString(dataSetNumber);
        }

        private Comparator<?> createColumn0Comparator() {
            return new Column0Comparator();
        }

        private Comparator<?> createColumn1Comparator() {
            return new Column1Comparator();
        }

        private Comparator<?> createColumn2Comparator() {
            return new Column2Comparator();
        }

        public TableStringConverter createTableStringConverter() {
            return new IptcTableStringConverter();
        }

        private class IptcTableStringConverter
        extends TableStringConverter {
            private IptcTableStringConverter() {
            }

            @Override
            public String toString(TableModel model, int row, int column) {
                Object value = model.getValueAt(row, column);
                if (value instanceof IptcEntry) {
                    IptcEntry iptcEntry = (IptcEntry)value;
                    String entryNumber = IptcTableCellRenderer.this.getIptcEntryNumber(iptcEntry);
                    return column == 0 ? entryNumber : (column == 1 ? IptcTableCellRenderer.this.TRANSLATION.translate(entryNumber, entryNumber) : iptcEntry.getData());
                }
                return StringUtil.toStringNullToEmptyString((Object)value);
            }
        }

        private class Column2Comparator
        implements Comparator<Object> {
            private Column2Comparator() {
            }

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof IptcEntry && o2 instanceof IptcEntry) {
                    IptcEntry iptcEntry1 = (IptcEntry)o1;
                    IptcEntry iptcEntry2 = (IptcEntry)o2;
                    String o1String = iptcEntry1.getData();
                    String o2String = iptcEntry2.getData();
                    return o1String.compareToIgnoreCase(o2String);
                }
                return 0;
            }
        }

        private class Column1Comparator
        implements Comparator<Object> {
            private Column1Comparator() {
            }

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof IptcEntry && o2 instanceof IptcEntry) {
                    IptcEntry iptcEntry1 = (IptcEntry)o1;
                    IptcEntry iptcEntry2 = (IptcEntry)o2;
                    String entryNumber1 = IptcTableCellRenderer.this.getIptcEntryNumber(iptcEntry1);
                    String entryNumber2 = IptcTableCellRenderer.this.getIptcEntryNumber(iptcEntry2);
                    String o1String = IptcTableCellRenderer.this.TRANSLATION.translate(entryNumber1, entryNumber1);
                    String o2String = IptcTableCellRenderer.this.TRANSLATION.translate(entryNumber2, entryNumber2);
                    return o1String.compareToIgnoreCase(o2String);
                }
                return 0;
            }
        }

        private class Column0Comparator
        implements Comparator<Object> {
            private Column0Comparator() {
            }

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof IptcEntry && o2 instanceof IptcEntry) {
                    IptcEntry iptcEntry1 = (IptcEntry)o1;
                    IptcEntry iptcEntry2 = (IptcEntry)o2;
                    String o1String = IptcTableCellRenderer.this.getIptcEntryNumber(iptcEntry1);
                    String o2String = IptcTableCellRenderer.this.getIptcEntryNumber(iptcEntry2);
                    return o1String.compareToIgnoreCase(o2String);
                }
                return 0;
            }
        }
    }
}

